<?php
/**
 * Gamify plugin functions
 *
 * @package BoomBox_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! boombox_plugin_management_service()->is_plugin_active( 'gamify/gamify.php' ) ) {
	return;
}

if ( ! class_exists( 'Boombox_Gamify' ) ) {

	final class Boombox_Gamify {

		/**
		 * Holds class single instance
		 * @var null
		 */
		private static $_instance = null;

		/**
		 * Get instance
		 * @return Boombox_Gamify|null
		 */
		public static function get_instance() {

			if ( null == static::$_instance ) {
				static::$_instance = new Boombox_Gamify();
			}

			return static::$_instance;

		}

		/**
		 * Boombox_Gamify constructor.
		 */
		private function __construct() {
			$this->hooks();
		}

		/**
		 * A dummy magic method to prevent Boombox_Gamify from being cloned.
		 *
		 */
		public function __clone() {
			throw new Exception( 'Cloning ' . __CLASS__ . ' is forbidden' );
		}

		/**
		 * Setup Hooks
		 */
		public function hooks() {
			add_filter( 'boombox/author/name_row', array( $this, 'add_ranks_to_author_extended_profile' ), 10, 2 );
		}

		/**
		 * Render user rank in single post author extended profile
		 * @param string $html Current HRML
		 * @param int $user_id User ID
		 *
		 * @return string
		 */
		public function add_ranks_to_author_extended_profile( $html, $user_id ) {
			$ranks = mycred_get_module( 'ranks' );
			if( $ranks ) {
				$ranks_html = '';
				$mycred_types = mycred_get_usable_types( $user_id );
				foreach ( $mycred_types as $type_id ) {
					$users_rank = mycred_get_users_rank_id( $user_id, $type_id );
					if ( $users_rank === false ) {
						continue;
					}

					$rank_title = get_the_title( $users_rank );
					$rank_logo = mycred_get_rank_logo( $users_rank, 'full', array(
						'title' => $rank_title,
						'alt' => $rank_title,
						'class' => 'mycred-badge-image'
					) );
					if( $rank_logo ) {
						$ranks_html .= sprintf( '<span class="gfy-badge">%s</span>', $rank_logo );
					}
				}

				if( $ranks_html ) {
					$html .= '<div class="gfy-bp-component gfy-badge-list">' . $ranks_html . '</div>';
				}
			}

			return $html;
		}

	}

	Boombox_Gamify::get_instance();

}