<?php
/**
 * Boombox migration functions
 *
 * @package BoomBox_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

/**
 * Run required migrations
 */
function boombox_migrate() {
	
	// do not run migration if CRON or AJAX is processing
	if( ( defined( 'DOING_CRON' ) && DOING_CRON ) || ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {
		return;
	}
	
	$db_version = get_option( 'boombox_db_version', 0 );
	$latest_version = 5;
	
	// do nothing if is up to date ( latest 'case' in 'switch' below )
	if( ( $db_version + 1 ) > $latest_version ) {
		return;
	}

	switch( $db_version + 1 ) {
		case 1:
			require_once( BOOMBOX_INCLUDES_PATH . 'migration/migrations/migration_25092016.php' );
			$status = migration_25092016::up();
			
			if( $status ){
				$version = 1;
				do_action( 'boombox/migrated', $version );
				update_option( 'boombox_db_version', $version );
			} else {
				break;
			}
		case 2:
			require_once( BOOMBOX_INCLUDES_PATH . 'migration/migrations/migration_12062017.php' );
			$status = migration_12062017::up();
			
			if( $status ){
				$version = 2;
				do_action( 'boombox/migrated', $version );
				update_option( 'boombox_db_version', $version );
			} else{
				break;
			}
		case 3:
			require_once( BOOMBOX_INCLUDES_PATH . 'migration/migrations/migration_15082017.php' );
			$status = migration_15082017::up();

			if( $status ){
				$version = 3;
				do_action( 'boombox/migrated', $version );
				update_option( 'boombox_db_version', $version );
			} else{
				break;
			}
		case 4:
			require_once( BOOMBOX_INCLUDES_PATH . 'migration/migrations/migration_13092017.php' );
			$status = migration_13092017::up();
			
			if( $status ){
				$version = 4;
				do_action( 'boombox/migrated', $version );
				update_option( 'boombox_db_version', $version );
			} else{
				break;
			}
		case 5:
			require_once( BOOMBOX_INCLUDES_PATH . 'migration/migrations/migration_13112017.php' );
			$status = migration_13112017::up();

			if( $status ){
				$version = 5;
				do_action( 'boombox/migrated', $version );
				update_option( 'boombox_db_version', $version );
			} else{
				break;
			}
	}
	
	do_action( 'boombox/after_migration' );

}
boombox_migrate();