<?php

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}


if (  ! class_exists( 'Boombox_Walker_Featured_Labels_Nav_Menu' ) ) {
	/**
	* Custom walker class.
	 */
	class Boombox_Walker_Featured_Labels_Nav_Menu extends Walker_Nav_Menu {
		/**
		 * Start the element output.
		 *
		 * Adds main/sub-classes to the list items and links.
		 *
		 * @param string $output Passed by reference. Used to append additional content.
		 * @param object $item   Menu item data object.
		 * @param int    $depth  Depth of menu item. Used for padding.
		 * @param array  $args   An array of arguments. @see wp_nav_menu()
		 * @param int    $id     Current item ID.
		 */
		function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {

			// Link attributes.
			$attributes = ! empty( $item->title ) ? ' title="' . esc_attr( $item->title ) . '"' : '';
			$attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : '';
			$attributes .= ! empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) . '"' : '';
			$attributes .= ! empty( $item->url ) ? ' href="' . esc_attr( $item->url ) . '"' : '';

			$args_before = '';
			$args_after = '';
			$args_link_before = '';
			$args_link_after = '';
			if( is_object( $args ) ){
				$args_before = $args->before;
				$args_after = $args->after;
				$args_link_before = $args->link_before;
				$args_link_after = $args->link_after;
			}elseif( is_array( $args ) ){
				$args_before = $args['before'];
				$args_after = $args['after'];
				$args_link_before = $args['link_before'];
				$args_link_after = $args['link_after'];
			}

			// Build HTML output and pass through the proper filter.
			$item_output = sprintf( '<li>%1$s<a%2$s>%3$s%4$s%5$s</a>%6$s</li>',
				$args_before,
				$attributes,
				$args_link_before,
				apply_filters( 'the_title', $item->title, $item->ID ),
				$args_link_after,
				$args_after
			);

			$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		}

		/**
		 * End the element output.
		 *
		 * @param string $output
		 * @param object $item
		 * @param int $depth
		 * @param array $args
		 */
		function end_el(&$output, $item, $depth = 0, $args = array())
		{
			$output .= "";
		}
	}
}
