<?php
/**
 * Boombox Choices Helper
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_Fonts_Helper' ) ) {

	final class Boombox_Fonts_Helper {

		/**
		 * Holds class single instance
		 * @var null
		 */
		private static $_instance = NULL;

		/**
		 * Get instance
		 * @return Boombox_Fonts_Helper|null
		 */
		public static function get_instance() {

			if ( NULL == static::$_instance ) {
				static::$_instance = new self();
			}

			return static::$_instance;

		}

		/**
		 * Boombox_Fonts_Helper constructor.
		 */
		private function __construct() {}

		/**
		 * A dummy magic method to prevent Boombox_Fonts_Helper from being cloned.
		 *
		 */
		public function __clone() {
			throw new Exception( 'Cloning ' . __CLASS__ . ' is forbidden' );
		}

		/**
		 * Get standard fonts
		 * @return array Standard websafe fonts.
		 */
		public function get_standard_fonts() {
			$choices = Kirki_Fonts::get_standard_fonts();

			return apply_filters( 'boombox/standard_font_choices', $choices );
		}

		/**
		 * Generate google webfont request URL
		 * @return string
		 */
		public function get_google_url() {
			$standard_fonts = $this->get_standard_fonts();
			$standard_fonts = wp_list_pluck( $standard_fonts, 'stack' );

			$fonts = array();
			$subsets = array();
			$set = boombox_get_theme_options_set( array(
				'design_logo_font_family',
				'design_primary_font_family',
				'design_secondary_font_family',
				'design_post_titles_font_family'
			) );

			/***** Logo Font Family */
			if ( ! in_array( $set['design_logo_font_family']['font-family'], $standard_fonts ) ) {
				$tmp_fonts = array();
				if( isset( $set['design_logo_font_family']['font-family'] ) && $set['design_logo_font_family']['font-family'] ) {
					$tmp_fonts[] = $set['design_logo_font_family']['font-family'];
				}

				if( isset( $set['design_logo_font_family']['variant'] ) && $set['design_logo_font_family']['variant'] ) {
					$tmp_fonts[] = '300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
				}
				$fonts[] = implode( ':', $tmp_fonts );

				if( isset( $set['design_logo_font_family']['subsets'] ) && ! empty( $set['design_logo_font_family']['subsets'] ) ) {
					$subsets = array_merge( $subsets, (array)$set['design_logo_font_family']['subsets'] );
				}
			}

			/***** Primary Font Family */
			if ( ! in_array( $set['design_primary_font_family']['font-family'], $standard_fonts ) ) {
				$tmp_fonts = array();
				if( isset( $set['design_primary_font_family']['font-family'] ) && $set['design_primary_font_family']['font-family'] ) {
					$tmp_fonts[] = $set['design_primary_font_family']['font-family'];
				}

				if( isset( $set['design_primary_font_family']['variant'] ) && $set['design_primary_font_family']['variant'] ) {
					$tmp_fonts[] = '300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
				}
				$fonts[] = implode( ':', $tmp_fonts );

				if( isset( $set['design_primary_font_family']['subsets'] ) && ! empty( $set['design_primary_font_family']['subsets'] ) ) {
					$subsets = array_merge( $subsets, (array)$set['design_primary_font_family']['subsets'] );
				}
			}

			/***** Secondary Font Family */
			if ( ! in_array( $set['design_secondary_font_family']['font-family'], $standard_fonts ) ) {
				$tmp_fonts = array();
				if( isset( $set['design_secondary_font_family']['font-family'] ) && $set['design_secondary_font_family']['font-family'] ) {
					$tmp_fonts[] = $set['design_secondary_font_family']['font-family'];
				}

				if( isset( $set['design_secondary_font_family']['variant'] ) && $set['design_secondary_font_family']['variant'] ) {
					$tmp_fonts[] = '300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
				}
				$fonts[] = implode( ':', $tmp_fonts );

				if( isset( $set['design_secondary_font_family']['subsets'] ) && ! empty( $set['design_secondary_font_family']['subsets'] ) ) {
					$subsets = array_merge( $subsets, (array)$set['design_secondary_font_family']['subsets'] );
				}
			}

			/***** Post Titles Font Family */
			if ( ! in_array( $set['design_post_titles_font_family']['font-family'], $standard_fonts ) ) {
				$tmp_fonts = array();
				if( isset( $set['design_post_titles_font_family']['font-family'] ) && $set['design_post_titles_font_family']['font-family'] ) {
					$tmp_fonts[] = $set['design_post_titles_font_family']['font-family'];
				}

				if( isset( $set['design_post_titles_font_family']['variant'] ) && $set['design_post_titles_font_family']['variant'] ) {
					$tmp_fonts[] = '300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
				}
				$fonts[] = implode( ':', $tmp_fonts );

				if( isset( $set['design_post_titles_font_family']['subsets'] ) && ! empty( $set['design_post_titles_font_family']['subsets'] ) ) {
					$subsets = array_merge( $subsets, (array)$set['design_post_titles_font_family']['subsets'] );
				}
			}

			$fonts_url = '';
			if ( ! empty( $fonts ) ) {

				$fonts = implode( '|', array_filter( array_unique( $fonts ) ) );
				if( ! empty( $subsets ) ) {
					$subsets = array( 'latin', 'latin-ext' );
				}
				$subsets = implode( ',', array_filter( array_unique( $subsets ) ) );

				$fonts_url = add_query_arg( array(
					'family' => urlencode( $fonts ),
					'subset' => urlencode( $subsets ),
				), 'https://fonts.googleapis.com/css' );

			}

			return $fonts_url;
		}

	}

}