<?php
/**
 * Boombox global functions
 *
 * @package BoomBox_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

/**
 * Edit archive template settings
 *
 * @param $settings
 *
 * @return mixed
 */
function boombox_edit_archive_template_settings( $settings ) {
	if ( is_category() && $settings[ 'featured_area' ] ) {
		$settings[ 'featured_area' ] = ! boombox_get_term_meta( get_queried_object_id(), 'hide_featured_area' );
	}

	return $settings;
}

add_filter( 'boombox/archive_template_settings', 'boombox_edit_archive_template_settings', 10, 1 );

/**
 * Share text for single page
 */
function boombox_edit_single_before_share_text(){
	$share_text = apply_filters( 'boombox_share_box_text', esc_html__('Like it? Share with your friends!', 'boombox') );
	if( $share_text ) {
		printf( '<h2>%s</h2>', $share_text );
	}
}
add_action( 'boombox/single/text_before_share', 'boombox_edit_single_before_share_text' );

/**
 * Change theme pagination html
 *
 * @param array $args Current args
 * @return array
 */
function boombox_edit_wp_link_pages_args( $args ){
	$args = array_merge(
		$args,
		array(
			'before'           => '<nav class="navigation page-links" role="navigation"><div class="nav-links">',
			'after'            => '</div></nav>',
			'link_before'      => '<span>',
			'link_after'       => '</span>',
			'next_or_number'   => 'number',
			'previouspagelink' => esc_html__( 'Previous', 'boombox' ),
			'nextpagelink'     => esc_html__( 'Next', 'boombox' )
		)
	);

	return $args;
}
add_filter( 'wp_link_pages_args', 'boombox_edit_wp_link_pages_args' );

/**
 * Wrap embeds in wrapper
 *
 * @param $html
 * @param $url
 * @param $attr
 *
 * @return string
 */
function boombox_wrapper_embed_oembed_html( $html, $url, $attr ) {
	$is_video = false;
	$is_vine_video = false;

	$domains = array(
		'youtube.com',
		'youtu.be',
		'vimeo.com',
		'dailymotion.com',
		'vine.co'
	);
	foreach ( $domains as $domain ) {
		if ( strpos( $url, $domain ) !== false ) {
			if( 'vine.co' == $domain ){
				$is_vine_video = true;
			}
			$is_video = true;
			break;
		}
	}

	if ( $is_video ) {
		$classes = $is_vine_video ? esc_attr( 'vine-embed' ) : '';

		return boombox_wrap_embed_within_responsive_container( $html, $classes );
	}
	return $html;
}
add_filter( 'embed_oembed_html', 'boombox_wrapper_embed_oembed_html', 10, 999 );

/**
 * Set 'posts_per_page' params to archive
 *
 * @param WP_Query $query
 * @since 1.0.0
 * @verion 2.0.0
 */
function boombox_edit_archive_template_query( $query ) {
	if ( is_admin() || ! $query->is_main_query() ) {
		return;
	}

	if ( ! is_archive() ) {
		return;
	}

	if( ! apply_filters( 'boombox/allow_archive_query_modification', true ) ) {
		return;
	}

	$options_set = boombox_get_theme_options_set( array(
		'archive_main_posts_posts_per_page',
		'archive_main_posts_inject_ad',
		'archive_main_posts_inject_newsletter',
		'archive_main_posts_inject_products',
		'archive_main_posts_injected_products_count',
		'archive_main_posts_injected_products_position',
		'archive_featured_area_exclude_from_main_loop',
		'mobile_global_enable_featured_area',
		'archive_featured_area_type',
		'archive_header_filters',
		'archive_main_posts_default_order',
		'archive_main_posts_listing_type',
		'archive_main_posts_injected_ad_position',
		'archive_main_posts_injected_newsletter_position'
	) );

	$paged = boombox_get_paged();
	$offset = $query->get('offset');
	$query->set( 'posts_per_page', $options_set['archive_main_posts_posts_per_page'] );

	if( $options_set['archive_featured_area_exclude_from_main_loop'] ) {
		if ( boombox_is_fragment_cache_enabled() ) {
			?>
			<!-- mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?>
                $featured_area = wp_is_mobile() ?
                    (
                        boombox_get_theme_option( 'mobile_global_enable_featured_area' )
                        && ( boombox_get_theme_option( 'archive_featured_area_type' ) != 'disable' )
                        && ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
                    )
                    :
                    (
                        ( boombox_get_theme_option( 'archive_featured_area_type' ) != 'disable' )
                        && ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
                    );
		    -->
			<?php
			$featured_area = wp_is_mobile() ?
				(
					$options_set['mobile_global_enable_featured_area']
					&& ( $options_set['archive_featured_area_type'] != 'disable' )
					&& ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
				)
				:
				(
					( $options_set['archive_featured_area_type'] != 'disable' )
					&& ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
				);
			?>
			<!-- /mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?> -->
			<?php
		} elseif ( boombox_is_page_cache_enabled() ) {
			$featured_area = (
				( $options_set['archive_featured_area_type'] != 'disable' )
				&& ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
			);
		} else {
			$featured_area = wp_is_mobile() ?
				(
					$options_set['mobile_global_enable_featured_area']
					&& ( $options_set['archive_featured_area_type'] != 'disable' )
					&& ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
				)
				:
				(
					( $options_set['archive_featured_area_type'] != 'disable' )
					&& ! boombox_get_term_meta( get_queried_object()->term_id, 'hide_featured_area' )
				);
		}

		/**
		 * Exclude featured area posts
		 */
		if ( $featured_area ) {
			$excluded_posts = array();
			$boombox_featured_query = Boombox_Template::init( 'featured-area' )->get_query();
			if ( null != $boombox_featured_query && $boombox_featured_query->found_posts ) {
				$excluded_posts = array_merge( $excluded_posts, wp_list_pluck( $boombox_featured_query->get_posts(), 'ID' ) );
			}

			if ( ! empty( $excluded_posts ) ) {
				$query->set( 'post__not_in', $excluded_posts );
			}
		}
	}

	if ( ( is_category() || is_tag() || is_tax( 'reaction' ) ) && $options_set['archive_header_filters'] ) {

		$listing_conditions = Boombox_Choices_Helper::get_instance()->get_conditions();
		$default_condition = $options_set['archive_main_posts_default_order'];
		$current_condition = ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] ) ?
			esc_sql( $_GET[ 'order' ] ) : $default_condition;
		if ( ! array_key_exists( $current_condition, $listing_conditions ) ) {
			$current_condition = $default_condition;
		}

		if ( $current_condition != $default_condition ) {

			$categories = array();
			$tags = array();
			$reactions = array();
			if ( is_category() ) {
				$categories[] = get_queried_object()->slug;
			} else if ( is_tag() ) {
				$tags[] = get_queried_object()->slug;
			} else if ( is_tax( 'reaction' ) ) {
				$reactions[] = get_queried_object()->slug;
			}

			$posts_query = boombox_get_posts_query(
				$current_condition,
				'all',
				array(
					'category' => $categories,
					'tag'      => $tags,
					'reaction' => $reactions,
				),
				array(
					'posts_per_page' => $query->get( 'posts_per_page' ),
					'paged'          => $paged,
					'excluded_posts' => $query->get( 'post__not_in' ),
					'is_page_query'  => false,
				) );

			$query->set( 'meta_key', $posts_query->get( 'meta_key' ) );
			$query->set( 'meta_query', $posts_query->get( 'meta_query' ) );
			$query->set( 'orderby', $posts_query->get( 'orderby' ) );
		}
	}

	$is_adv_enabled = boombox_is_adv_enabled( $options_set['archive_main_posts_inject_ad'] );
	$is_newsletter_enabled = boombox_is_newsletter_enabled( $options_set['archive_main_posts_inject_newsletter'] );
	$is_product_enabled = boombox_is_product_enabled( $options_set['archive_main_posts_inject_products'] );

	if( $is_adv_enabled || $is_newsletter_enabled || $is_product_enabled ){
		Boombox_Loop_Helper::init( array(
			'is_adv_enabled' 			=> $is_adv_enabled,
			'instead_adv' 				=> $options_set['archive_main_posts_injected_ad_position'],
			'is_newsletter_enabled' 	=> $is_newsletter_enabled,
			'instead_newsletter'		=> $options_set['archive_main_posts_injected_newsletter_position'],
			'is_product_enabled' 		=> $is_product_enabled,
			'page_product_position' 	=> $options_set['archive_main_posts_injected_products_position'],
			'page_product_count' 		=> $options_set['archive_main_posts_injected_products_count'],
			'skip' 						=> ( 'grid' == $options_set['archive_main_posts_listing_type'] ),
			'posts_per_page' 			=> $options_set['archive_main_posts_posts_per_page'],
			'paged' 					=> $paged,
			'offset'					=> $offset
		) );
	}
}
add_action( 'pre_get_posts', 'boombox_edit_archive_template_query', 1 );

/**
 * Edit index template query
 * @param WP_Query $query Current query
 *
 * @since 2.0.0
 * @version 2.0.0
 */
function boombox_edit_index_template_query( $query ) {
	if ( is_admin() || ! $query->is_main_query() ) {
		return;
	}

	if( ! is_home() ) {
		return;
	}

	$options_set = boombox_get_theme_options_set( array(
		'home_main_posts_condition',
		'home_main_posts_posts_per_page',
		'home_main_posts_inject_ad',
		'home_main_posts_inject_newsletter',
		'home_main_posts_inject_products',
		'home_main_posts_injected_products_count',
		'home_main_posts_injected_products_position',
		'home_featured_area_exclude_from_main_loop',
		'mobile_global_enable_featured_area',
		'home_featured_area_type',
		'home_main_posts_listing_type',
		'home_main_posts_injected_ad_position',
		'home_main_posts_injected_newsletter_position'
	) );

	$paged = boombox_get_paged();
	$offset = $query->get('offset');
	$query->set( 'posts_per_page', $options_set['home_main_posts_posts_per_page'] );

	if( $options_set['home_featured_area_exclude_from_main_loop'] ) {
		if ( boombox_is_fragment_cache_enabled() ) {
			?>
			<!-- mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?>
                $featured_area = wp_is_mobile() ? ( boombox_get_theme_option(
                'mobile_global_enable_featured_area' ) && ( boombox_get_theme_option( 'home_featured_area_type' ) !=
                'disable' ) ) :
                 ( boombox_get_theme_option( 'home_featured_area_type' ) != 'disable' );
		    -->
			<?php
			$featured_area = wp_is_mobile() ? ( $options_set['mobile_global_enable_featured_area'] &&
				( $options_set['home_featured_area_type'] != 'disable' ) ) : ( $options_set['home_featured_area_type'] != 'disable' );
			?>
			<!-- /mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?> -->
			<?php
		} elseif ( boombox_is_page_cache_enabled() ) {
			$featured_area = ( $options_set['home_featured_area_type'] != 'disable' );
		} else {
			$featured_area = wp_is_mobile() ? ( $options_set['mobile_global_enable_featured_area'] &&
				( $options_set['home_featured_area_type'] != 'disable' ) ) : ( $options_set['home_featured_area_type'] != 'disable' );
		}

		/**
		 * Exclude featured area posts
		 */
		if ( $featured_area ) {
			$excluded_posts = array();
			$boombox_featured_query = Boombox_Template::init( 'featured-area' )->get_query();
			if ( null != $boombox_featured_query && $boombox_featured_query->found_posts ) {
				$excluded_posts = array_merge( $excluded_posts, wp_list_pluck( $boombox_featured_query->get_posts(), 'ID' ) );
			}

			if ( ! empty( $excluded_posts ) ) {
				$query->set( 'post__not_in', $excluded_posts );
			}
		}
	}

	if ( ! apply_filters( 'boombox/index/disable_filters', false ) ) {

		$listing_conditions = Boombox_Choices_Helper::get_instance()->get_conditions();
		$default_condition = 'recent';
		$current_condition = ( isset( $_GET[ 'order' ] ) && $_GET[ 'order' ] ) ?
			esc_sql( $_GET[ 'order' ] ) : $options_set['home_main_posts_condition'];
		if ( !array_key_exists( $current_condition, $listing_conditions ) ) {
			$current_condition = $default_condition;
		}

		if ( $current_condition != $default_condition ) {

			$posts_query = boombox_get_posts_query(
				$current_condition,
				'all',
				array(
					'category' => array(),
					'tag'      => array(),
					'reaction' => array(),
				),
				array(
					'posts_per_page' => $query->get( 'posts_per_page' ),
					'paged'          => $paged,
					'excluded_posts' => $query->get( 'post__not_in' ),
					'is_page_query'  => false,
				) );

			$query->set( 'meta_key', $posts_query->get( 'meta_key' ) );
			$query->set( 'meta_query', $posts_query->get( 'meta_query' ) );
			$query->set( 'orderby', $posts_query->get( 'orderby' ) );
		}

	}

	$is_adv_enabled = boombox_is_adv_enabled( $options_set['home_main_posts_inject_ad'] );
	$is_newsletter_enabled = boombox_is_newsletter_enabled( $options_set['home_main_posts_inject_newsletter'] );
	$is_product_enabled = boombox_is_product_enabled( $options_set['home_main_posts_inject_products'] );

	if( $is_adv_enabled || $is_newsletter_enabled || $is_product_enabled ){
		$archive_listing_type = $options_set['home_main_posts_listing_type'];
		$instead_ad           = $options_set['home_main_posts_injected_ad_position'];
		$instead_newsletter   = $options_set['home_main_posts_injected_newsletter_position'];

		Boombox_Loop_Helper::init( array(
			'is_adv_enabled' 			=> $is_adv_enabled,
			'instead_adv' 				=> $instead_ad,
			'is_newsletter_enabled' 	=> $is_newsletter_enabled,
			'instead_newsletter'		=> $instead_newsletter,
			'is_product_enabled' 		=> $is_product_enabled,
			'page_product_position' 	=> $options_set['home_main_posts_injected_products_position'],
			'page_product_count' 		=> $options_set['home_main_posts_injected_products_count'],
			'skip' 						=> ( 'grid' == $archive_listing_type ),
			'posts_per_page' 			=> $options_set['home_main_posts_posts_per_page'],
			'paged' 					=> $paged,
			'offset'					=> $offset
		) );
	}
}
add_action( 'pre_get_posts', 'boombox_edit_index_template_query', 1 );

/**
 * Remove Admin Bar
 */
function boombox_remove_admin_bar() {
	if( ! is_super_admin() && ! current_user_can( 'administrator' ) ) {
		add_filter( 'show_admin_bar', '__return_false' );
	}
}
add_action( 'wp', 'boombox_remove_admin_bar' );

/**
 * Hide featured media on specific posts that are assigned to categories or tags which prevent media showing
 */
function boombox_single_post_show_media_taxonomy_restriction( $show ) {

	if( $show ) {
		$categories = wp_get_post_categories( get_the_ID(), array(
			'fields' => 'ids',
			'meta_query' => array(
				array(
					'key'       => 'hide_attached_posts_featured_media',
					'value'     => 1,
					'compare'   => '='
				)
			),
		) );

		$tags = wp_get_post_tags( get_the_ID(), array(
			'fields' => 'ids',
			'meta_query' => array(
				array(
					'key'       => 'hide_attached_posts_featured_media',
					'value'     => 1,
					'compare'   => '='
				)
			),
		) );

		$show = ( empty( $categories ) && empty( $tags ) );
	}

	return $show;
}
add_filter( 'boombox/single/show_media', 'boombox_single_post_show_media_taxonomy_restriction', 10, 1 );

/**
 * Override video player dimensions
 *
 * @param $out
 * @param $pairs
 * @param $atts
 *
 * @return mixed
 */
function boombox_shortcode_atts_video( $out, $pairs, $atts ){
	global $content_width;
	$out['width']  = $content_width;
	$out['height'] = round( $content_width * $out['height'] / $out['width'] );

	return $out;
}
add_filter( 'shortcode_atts_video', 'boombox_shortcode_atts_video', 10, 4 );