<?php
/**
 * Boombox customizer functions
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

/**
 * Get Theme Options
 *
 * @param string $name          Option name
 * @param bool   $force_default Force load default value
 *
 * @return mixed
 */
function boombox_get_theme_option( $name, $force_default = false ) {
	return Boombox_Customizer::get_instance()->get_option( $name, $force_default );
}

/**
 * Get theme options set values
 * @param array $options Options
 *
 * @return array
 */
function boombox_get_theme_options_set( $options = array() ) {
	return Boombox_Customizer::get_instance()->get_options_set( $options );
}

/**
 * Check if customizer value is changed
 *
 * @param $name
 *
 * @return bool
 */
function boombox_is_theme_option_changed( $name ) {
	return boombox_get_theme_option( $name ) != boombox_get_theme_option( $name, true );
}

/**
 * Get logo data
 * @return array
 */
function boombox_get_logo() {

	$key = 'logo_data';
	$data = boombox_cache_get( $key );

	if ( ! $data ) {
		$set = boombox_get_theme_options_set( array(
			'branding_logo',
			'branding_logo_hdpi',
			'branding_logo_width',
			'branding_logo_height'
		) );

		if ( ! empty ( $set['branding_logo'] ) || ! empty ( $set['branding_logo_hdpi'] ) ) {

			$data[ 'width' ] = $set['branding_logo_width'];
			$data[ 'height' ] = $set['branding_logo_height'];
			$data[ 'src_2x' ] = array();

			if ( ! empty ( $set['branding_logo_hdpi'] ) ) {
				$data[ 'src_2x' ][] = $set['branding_logo_hdpi'] . ' 2x';
			}

			if ( ! empty ( $set['branding_logo'] ) ) {
				$data[ 'src' ] = $set['branding_logo'];
				$data[ 'src_2x' ][] = $set['branding_logo'] . ' 1x';
			} else {
				$data[ 'src' ] = $set['branding_logo_hdpi'];
			}

			$data[ 'src_2x' ] = implode( ',', $data[ 'src_2x' ] );

			boombox_cache_set( $key, $data );
		}
	}

	return $data;
}