<?php
/**
 * Register a category meta box using a class.
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_Category_Custom_Meta_Box' ) ) {

	if( ! class_exists( 'Boombox_Category_Custom_Meta_Box' ) ) {
		require_once ( 'all-in-one-meta' . DIRECTORY_SEPARATOR . 'class-aiom-base.php' );
	}

	/**
	 * Class Boombox_Category_Custom_Meta_Box
	 */
	final class Boombox_Category_Custom_Meta_Box extends AIOM_Base {

		/**
		 * Hold post type config
		 * @var string
		 */
		protected $post_type = 'post';

		/**
		 * Holds class single instance
		 * @var null
		 */
		private static $_instance = null;

		/**
		 * Get instance
		 * @return Boombox_Category_Custom_Meta_Box|null
		 */
		public static function get_instance() {

			if (null == static::$_instance) {
				static::$_instance = new self();
			}

			return static::$_instance;

		}

		/**
		 * Boombox_Category_Custom_Meta_Box constructor.
		 */
		private function __construct() {
			$this->hooks();
		}

		/**
		 * A dummy magic method to prevent Boombox_Category_Custom_Meta_Box from being cloned.
		 *
		 */
		public function __clone() {
			throw new Exception('Cloning ' . __CLASS__ . ' is forbidden');
		}

		/**
		 * Setup Hooks
		 */
		public function hooks() {
			add_action( 'category_edit_form', array( $this, 'render_metabox' ), 10, 1 );
			//add_action( 'category_add_form', array( $this, 'render_metabox' ), 10, 1 );
			add_action( 'edit_term', array( $this, 'save_category_fields' ), 10, 1 );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
		}

		/**
		 * Setup structure
		 * @return array
		 */
		public function get_structure() {
			$structure = array(
				'tab_global' => array(
					'title' 	=> esc_html__( 'Global', 'boombox' ),
					'active'	=> true,
					'icon'      => false,
					'fields' => array(
						// Hide Featured Image
						'boombox_hide_featured_image' => array(
							'name'      => 'boombox_hide_featured_image',
							'type'		=> 'select',
							'label'		=> esc_html__( 'Hide Featured Image', 'boombox' ),
							'priority'  => 20,
							'choices' 	=> Boombox_Choices_Helper::get_instance()->get_post_featured_image_appearance(),
							'default'	=> 'customizer',
							'callback'  => 'sanitize_text_field'
						),
						// Layout
						'boombox_layout' => array(
							'name'		=> 'boombox_layout',
							'type'		=> 'select',
							'label'		=> esc_html__( 'Layout', 'boombox' ),
							'priority'  => 30,
							'choices' 	=> array(
								'inherit' => __( 'Inherit', 'boombox' ),
								'custom'  => __( 'Custom', 'boombox' )
							),
							'default'	=> '1-sidebar-1_3',
							'callback'  => 'sanitize_text_field'
						),
						// Sidebar Type
						'boombox_sidebar_type' => array(
							'name'		=> 'boombox_sidebar_type',
							'type'		=> 'radio-image',
							'label'		=> esc_html__( 'Sidebar Type', 'boombox' ),
							'priority'  => 40,
							'choices' 	=> Boombox_Choices_Helper::get_instance()->get_sidebar_types(),
							'default'	=> '1-sidebar-1_3',
							'active_callback'=> array(
								array(
									'field_id' => 'boombox_layout',
									'value' => 'custom',
									'compare' => '='
								)
							),
							'callback'  => 'sanitize_text_field'
						),
						// Sidebar Orientation
						'boombox_sidebar_orientation' => array(
							'name'		=> 'boombox_sidebar_orientation',
							'type'		=> 'radio',
							'label'		=> esc_html__( 'Sidebar Orientation', 'boombox' ),
							'priority'  => 50,
							'choices' 	=> array(
								'right' => __( 'Right', 'boombox' ),
								'left'  => __( 'Left', 'boombox' )
							),
							'config'      => array( 'axis' => 'vertical' ),
							'default'	=> 'right',
							'active_callback'=> array(
								array(
									'field_id' => 'boombox_layout',
									'value' => 'custom',
									'compare' => 'IN'
								)
							),
							'callback'  => 'sanitize_text_field'
						),
						// Video URL
						'boombox_video_url' => array(
							'name'		    => 'boombox_video_url',
							'type'		    => 'text',
							'label'		    => esc_html__( 'Video URL', 'boombox' ),
							'priority'      => 60,
							'description'   => esc_html__( 'Supported Videos: MP4, Youtube, Vimeo, Dailymotion, Vine, Odnoklassniki, Facebook, Vidme, Vkontakte, Twitch, Coub, Twitter', 'boombox' ),
							'default'	    => '',
							'callback'      => array( $this, 'sanitize_video_url' ),
							'class'         => 'regular-text',
							'id'            => 'boombox_video_url',
						)
						// other fields go here
					)
				),
				'tab_affiliate' => array(
					'title' => esc_html__( 'Affiliate', 'boombox' ),
					'active'	=> false,
					'icon'      => false,
					'fields' => array(
						// Regular Price
						'boombox_post_regular_price' => array(
							'name'      => 'boombox_post_regular_price',
							'type'		=> 'text',
							'label'		=> esc_html__( 'Regular Price', 'boombox' ),
							'priority'  => 20,
							'default'	=> '',
							'callback'  => 'sanitize_text_field',
							'class'     => 'regular-text',
						),
						// Discount Price
						'boombox_post_discount_price' => array(
							'name'		=> 'boombox_post_discount_price',
							'type'		=> 'text',
							'label'		=> esc_html__( 'Discount Price', 'boombox' ),
							'priority'  => 30,
							'default'	=> '',
							'callback'  => 'sanitize_text_field',
							'class'     => 'regular-text',
						),
						// Affiliate Link
						'boombox_post_affiliate_link' => array(
							'name'		=> 'boombox_post_affiliate_link',
							'type'		=> 'text',
							'label'		=> esc_html__( 'Affiliate Link', 'boombox' ),
							'priority'  => 40,
							'default'	=> '',
							'callback'  => 'sanitize_text_field',
							'class'     => 'regular-text',
						),
						// Post Link
						'boombox_post_affiliate_link_use_as_post_link' => array(
							'name'		=> 'boombox_post_affiliate_link_use_as_post_link',
							'type'		=> 'checkbox',
							'label'		=> '',
							'priority'  => 50,
							'text'		=> esc_html__( 'Use as post link', 'boombox' ),
							'default'	=> '0',
							'callback'  => array( $this, 'sanitize_checkbox' )
						),
						// other fields go here
					)
				),
				// other tabs go here
			);

			return apply_filters( 'boombox/admin/post/meta-boxes/structure', $structure, $this );
		}

		/**
		 * Enqueue Scripts and Styles
		 */
		public function admin_enqueue_scripts() {
			$screen = get_current_screen();

			if ( $screen && 'edit-category' === $screen->id ) {
				wp_enqueue_style( 'boombox-admin-meta-style', BOOMBOX_ADMIN_URL . 'metaboxes/assets/css/boombox-metabox-style.css', array(), boombox_get_assets_version() );
				wp_enqueue_script( 'boombox-admin-meta-script', BOOMBOX_ADMIN_URL . 'metaboxes/assets/js/boombox-metabox-script.js', array( 'jquery' ), boombox_get_assets_version(), true );
			}

		}

		/**
		 * Handles saving the meta box.
		 *
		 * @param int $post_id Post ID.
		 * @param WP_Post $post Post object.
		 *
		 * @return null
		 */
		public function save_metabox( $post_id, $post ) {

			if( $post->post_type != $this->post_type ) {
				return;
			}

			parent::save_data( $post_id, $post );

			/* OK, it's safe for us to save the data now. */
			if ( isset( $_POST['boombox_is_featured'] ) ) {
				$boombox_is_featured = $_POST['boombox_is_featured'] ? 1 : 0;
				update_post_meta( $post_id, 'boombox_is_featured', (int) $boombox_is_featured );
			}

			if ( isset( $_POST['boombox_is_featured_frontpage'] ) ) {
				$boombox_is_featured_frontpage = $_POST['boombox_is_featured_frontpage'] ? $_POST['boombox_is_featured_frontpage'] : 0;
				update_post_meta( $post_id, 'boombox_is_featured_frontpage', (int) $boombox_is_featured_frontpage );
			}

			if ( isset( $_POST['boombox_keep_trending'] ) ) {
				$boombox_keep_trending = $_POST['boombox_keep_trending'] ? PHP_INT_MAX : false;
				update_post_meta( $post_id, 'boombox_keep_trending', $boombox_keep_trending );
			}

			if ( isset( $_POST['boombox_keep_hot'] ) ) {
				$boombox_keep_hot = $_POST['boombox_keep_hot'] ? PHP_INT_MAX : false;
				update_post_meta( $post_id, 'boombox_keep_hot', $boombox_keep_hot );
			}

			if ( isset( $_POST['boombox_keep_popular'] ) ) {
				$boombox_keep_popular = $_POST['boombox_keep_popular'] ? PHP_INT_MAX : false;
				update_post_meta( $post_id, 'boombox_keep_popular', $boombox_keep_popular );
			}

			do_action( 'boombox/admin/post/meta-boxes/save', $post_id, $post );

		}

		/**
		 * Render the advanced fields meta box.
		 *
		 * @param $post
		 */
		function render_metabox( $post ){

			$this->data = boombox_get_post_meta( 104 );

			?>
			<div class="postbox">
				<h2><span>Boombox Advanced Fields</span></h2>
				<div class="inside"><?php $this->render(); ?></div>
			</div>
			<?php
		}

	}

	Boombox_Category_Custom_Meta_Box::get_instance();
}