<?php
/**
 * Textarea field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Textarea_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Textarea_Field
	 */
	class AIOM_Textarea_Field extends AIOM_Base_Field {

		/**
		 * Render field
		 */
		public function render() { ?>
			<div class="boombox-form-row boombox-form-row-textarea <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>

				<div class="control-col">
					<textarea
							id="<?php echo $this->get_id(); ?>"
							name="<?php echo $this->get_name(); ?>"
							class="<?php echo $this->get_class() ?>"
							<?php echo $this->get_attributes(); ?>><?php echo $this->get_value(); ?></textarea>
					<?php if( $description = $this->get_description() ) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}