<?php
/**
 * Radio field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Radio_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Radio_Field
	 */
	class AIOM_Radio_Field extends AIOM_Base_Field {

		/**
		 * Holds field choices
		 * @var array
		 */
		private $choices;

		/**
		 * Get field choices
		 * @return array
		 */
		private function get_choices() {
			return $this->choices;
		}

		/**
		 * Holds form field config
		 * @var string
		 */
		private $config;

		/**
		 * Get form field config
		 * @return string
		 */
		private function get_config() {
			return $this->config;
		}

		/**
		 * AIOM_Radio_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field choices */
			$choices = isset( $args['choices'] ) && is_array( $args['choices'] ) ? $args['choices'] : array();
			$this->choices = $choices;

			/***** Field custom config */
			$config = isset( $args['config'] ) && is_array( $args['config'] ) ? $args['config'] : array();
			$this->config = $config;
		}

		/**
		 * Render field
		 */
		public function render() {
			$config = $this->get_config();
			$axis = isset( $config[ 'axis' ] ) && in_array( $config[ 'axis' ], array( 'horizontal', 'vertical' ) ) ?
				$config[ 'axis' ] : 'horizontal';
			$tag = $axis == 'horizontal' ? 'span' : 'div'; ?>
			<div class="boombox-form-row boombox-form-row-radio <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>

				<div class="control-col">
					<div class="field-list field-list-<?php echo $axis; ?>">
						<?php foreach( $this->get_choices() as $key => $value ) { ?>
							<<?php echo $tag; ?> class="field-list-item">
								<label>
									<input type="radio"
									       id="<?php echo $this->get_id(); ?>"
									       name="<?php echo $this->get_name(); ?>"
									       value="<?php echo esc_html( esc_attr( $key ) ); ?>"
									       class="<?php echo $this->get_class(); ?>"
											<?php checked( $this->get_value(), esc_html( esc_attr( $key ) ), true ); ?>
				                             <?php echo $this->get_attributes(); ?> />
									<strong><?php echo $value; ?></strong>
								</label>
							</<?php echo $tag; ?>>
						<?php } ?>
					</div>
				</div>
				<?php if( $description = $this->get_description() ) { ?>
					<p class="description"><?php echo $description; ?></p>
				<?php } ?>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}