<?php
/**
 * Checkbox field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( !defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( !class_exists( 'AIOM_Base_Field' ) ) {
	require_once( 'base-field.php' );
}

if ( !class_exists( 'AIOM_Multicheck_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Multicheck_Field
	 */
	class AIOM_Multicheck_Field extends AIOM_Base_Field {

		/**
		 * Holds field choices
		 * @var array
		 */
		private $choices;

		/**
		 * Get field choices
		 * @return array
		 */
		private function get_choices() {
			return $this->choices;
		}

		/**
		 * AIOM_Multicheck_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field choices */
			$choices = isset( $args['choices'] ) && is_array( $args['choices'] ) ? $args['choices'] : array();
			$this->choices = $choices;
		}

		/**
		 * Render field
		 */
		public function render () { ?>
			<div class="boombox-form-row boombox-form-row-checkbox <?php echo $this->get_wrapper_class(); ?>" <?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<?php
					foreach( $this->get_choices() as $key => $value ) {
						$checked = checked( in_array( esc_html( esc_attr( $key ) ), (array)$this->get_value() ), true,
						false
						); ?>
						<div class="field-list-item <?php echo $checked ? 'selected' : ''; ?>">
							<label>
								<input type="checkbox"
								       id="<?php echo $this->get_id(); ?>"
								       name="<?php echo $this->get_name(); ?>[]"
								       value="<?php echo esc_html( esc_attr( $key ) ); ?>"
								       class="<?php echo $this->get_class(); ?>"
									<?php echo $checked; ?>
									<?php echo $this->get_attributes(); ?> />
								<?php echo $value; ?>
							</label>
						</div>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}