<?php
/**
 * Text field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Image_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Image_Field
	 */
	class AIOM_Image_Field extends AIOM_Base_Field {

		/**
		 * Render field
		 */
		public function render() {
			$value = $this->get_value(); ?>
			<div class="boombox-form-row boombox-form-row-image <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<div class="upload-wrapper <?php echo $value ? 'has-image' : ''; ?>">
						<div class="image-wrapper">

							<div class="placeholder">
								<?php esc_html_e( 'No file selected', 'boombox' ); ?>
							</div>

							<div class="image-holder">
							<?php if( $value ) {
								echo wp_get_attachment_image( $value, 'medium' );
							} ?>
							</div>
						</div>
						<div class="buttons-wrapper">
							<button type="button" class="button button-upload">
								<?php esc_html_e( 'Select File', 'boombox' ); ?>
							</button>
							<button type="button" class="button button-remove">
								<?php esc_html_e( 'Remove', 'boombox' ); ?>
							</button>
						</div>
						<input type="hidden"
						       class="image_id <?php echo $this->get_class() ?>"
						       name="<?php echo $this->get_name(); ?>"
						       value="<?php echo $this->get_value(); ?>" />
					</div>
					<?php if ($description = $this->get_description()) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}