<?php
/**
 * Custom HTML field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Custom_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Custom_Field
	 */
	class AIOM_Custom_Field extends AIOM_Base_Field {

		/**
		 * Holds field custom HTML
		 * @var string
		 */
		private $custom_html;

		/**
		 * Get field custom HTMl
		 */
		protected function get_custom_html() {
			return $this->custom_html;
		}

		/**
		 * AIOM_Custom_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field custom HTML */
			$custom_html = isset( $args['html'] ) ? $args['html'] : '';
			$this->custom_html = $custom_html;
		}

		/**
		 * Render field
		 */
		public function render() {
			$label = $this->get_label(); ?>
			<div class="boombox-form-row boombox-form-row-custom <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>

				<?php if( $label ) { ?>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<?php }
					echo $this->get_custom_html();
					if( $label ) {
				?></div>
				<?php } ?>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}