<?php
/**
 * Color Picker field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( !defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( !class_exists( 'AIOM_Base_Field' ) ) {
	require_once( 'base-field.php' );
}

if ( !class_exists( 'AIOM_Color_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Color_Field
	 */
	class AIOM_Color_Field extends AIOM_Base_Field {

		/**
		 * Get form field attributes
		 * @return string
		 */
		protected function get_attributes() {
			$attributes = parent::get_attributes();
			if( $this->get_default() ) {
				$attributes .= ' data-default-color="' . $this->get_default() . '"';
			}

			return $attributes;
		}

		/**
		 * Enqueue color picker assets
		 */
		public function enqueue() {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker' );
		}

		/**
		 * Render field
		 */
		public function render () { ?>
			<div class="boombox-form-row boombox-form-row-color <?php echo $this->get_wrapper_class(); ?>"
				<?php echo$this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<input type="text"
					       id="<?php echo $this->get_id(); ?>"
					       name="<?php echo $this->get_name(); ?>"
					       class="<?php echo $this->get_class(); ?>"
						<?php echo $this->get_attributes(); ?>
						   value="<?php echo $this->get_value(); ?>"/>
					<?php if ($description = $this->get_description()) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}