<?php
/**
 * Checkbox field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( !defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( !class_exists( 'AIOM_Base_Field' ) ) {
	require_once( 'base-field.php' );
}

if ( !class_exists( 'AIOM_Checkbox_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Checkbox_Field
	 */
	class AIOM_Checkbox_Field extends AIOM_Base_Field {

		/**
		 * Render field
		 */
		public function render () { ?>
			<div class="boombox-form-row boombox-form-row-checkbox <?php echo $this->get_wrapper_class(); ?>" <?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<input type="hidden" name="<?php echo $this->get_name(); ?>" value="0"/>
					<input type="checkbox"
					       id="<?php echo $this->get_id(); ?>"
					       name="<?php echo $this->get_name(); ?>"
					       value="1"
					       class="<?php echo $this->get_class() ?>"
						<?php checked( $this->get_value(), true, true ); ?>
						<?php echo $this->get_attributes(); ?> />
					<?php if ( $text = $this->get_text() ) { ?>
						<label for="<?php echo $this->get_id(); ?>"><strong><?php echo $text; ?></strong></label>
					<?php } ?>
					<?php if ( $description = $this->get_description() ) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}