<?php
/**
 * Boombox admin functions
 *
 * @package BoomBox_Theme
 * @since 1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

/**
 * Check whether theme is activated
 * @return bool
 */
function boombox_is_registered() {

	$is_registered = get_transient( 'boombox_theme_registration' );

	// Verified, access granted.
	if ( ! ! $is_registered ) {
		return true;
	}

	// Check if required plugin for activation is installed and active
	if ( ! boombox_plugin_management_service()->is_plugin_active( 'envato-market/envato-market.php' ) ) {
		return false;
	}

	$is_registered = false;
	$purchased_themes = envato_market()->api()->themes();
	foreach ( $purchased_themes as $purchased_theme ) {
		if ( strtolower( boombox_get_theme_data()->get( "Name" ) ) === strtolower( $purchased_theme[ 'name' ] )
			&& strtolower( boombox_get_theme_data()->get( "Author" ) ) === strtolower( $purchased_theme[ 'author' ] ) ) {
			$is_registered = true;
		}
	}

	if ( $is_registered ) {
		$expire_in_one_day = 1 * DAY_IN_SECONDS;
		set_transient( 'boombox_theme_registration', true, $expire_in_one_day );
	}

	return $is_registered;
}