<?php
/**
 * Register the required plugins for BoomBox theme.
 * @since 1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

function boombox_register_plugins() {

	$protected_plugins = array();
	if( boombox_is_registered() ) {

		$protected_plugins = array(
			// BoomBox Theme Extensions
			array(
				'name'               => esc_html__( 'BoomBox Theme Extensions', 'boombox' ),
				'slug'               => 'boombox-theme-extensions',
				'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/boombox-theme-extensions.zip',   // The plugin source.
				'required'           => true,
				'version'            => '1.4.2', // bbte-version: 1.4.2
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => '',
				'is_callable'        => ''
			),
			// Zombify
			array(
				'name'               => esc_html__( 'Zombify', 'boombox' ),
				'slug'               => 'zombify',
				'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/zombify.zip',
				'required'           => false,
				'version'            => '1.3.9', // zf-version: 1.3.9
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => '',
				'is_callable'        => ''
			),
			// Easy Social Share Buttons
			array(
				'name'               => esc_html__( 'Easy Social Share Buttons', 'boombox' ),
				'slug'               => 'easy-social-share-buttons3',
				'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/easy-social-share-buttons3.zip',
				'required'           => false,
				'version'            => '5.2.1',
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => '',
				'is_callable'        => ''
			),
			// WPBakery Page Builder
			array(
				'name'               => esc_html__( 'WPBakery Page Builder', 'boombox' ),
				'slug'               => 'js_composer',
				'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/js_composer.zip',
				'required'           => false,
				'version'            => '5.4.5',
				'force_activation'   => false,
				'force_deactivation' => false,
				'external_url'       => '',
				'is_callable'        => ''
			),
			// One Click Demo Import
			array(
				'name'     => esc_html__( 'One Click Demo Import', 'boombox' ),
				'slug'     => 'one-click-demo-import',
				'required' => false
			),
		);

		// depended plugins
		if ( function_exists( 'boombox_plugin_management_service' ) ) {

			if ( boombox_plugin_management_service()->is_plugin_active( 'mycred/mycred.php' ) ) {
				// Gamify
				$protected_plugins[] = array(
					'name'               => esc_html__( 'Gamify', 'boombox' ),
					'slug'               => 'gamify',
					'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/gamify.zip',
					'required'           => false,
					'version'            => '1.0.7', // gfy-version: 1.0.7
					'force_activation'   => false,
					'force_deactivation' => false,
					'external_url'       => '',
					'is_callable'        => ''
				);
			}

			if ( boombox_plugin_management_service()->is_plugin_active( 'quick-adsense-reloaded/quick-adsense-reloaded.php' ) ) {
				// AdSense Integration WP QUADS PRO
				$protected_plugins[] = array(
					'name'               => esc_html__( 'AdSense Integration WP QUADS PRO', 'boombox' ),
					'slug'               => 'wp-quads-pro',
					'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/wp-quads-pro.zip',
					'required'           => false,
					'version'            => '1.4.0',
					'force_activation'   => false,
					'force_deactivation' => false,
					'external_url'       => '',
					'is_callable'        => ''
				);
			}
		}

	}
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$free_plugins = array(
		// Envato Market
		array(
			'name'               => esc_html__( 'Envato Market', 'boombox' ),
			'slug'               => 'envato-market',
			'source'             => BOOMBOX_ADMIN_PATH . 'activation/plugins/envato-market.zip',
			'required'           => true,
			'version'            => '1.0.0-RC2',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
		),
		// MailChimp for WordPress
		array(
			'name'     => esc_html__( 'MailChimp for WordPress', 'boombox' ),
			'slug'     => 'mailchimp-for-wp',
			'required' => false
		),
		// AdSense Integration WP QUADS
		array(
			'name'     => esc_html__( 'AdSense Integration WP QUADS', 'boombox' ),
			'slug'     => 'quick-adsense-reloaded',
			'required' => false
		),
		// BuddyPress
		array(
			'name'     => esc_html__( 'BuddyPress', 'boombox' ),
			'slug'     => 'buddypress',
			'required' => false
		),
		// Wordpress Social Login
		array(
			'name'     => esc_html__( 'Wordpress Social Login', 'boombox' ),
			'slug'     => 'wordpress-social-login',
			'required' => false
		)
	);

	/**
	 * Combine all together
	 */
	$plugins = array_merge( $free_plugins, $protected_plugins );

	/*
	 * Array of configuration settings.
	 */
	$config = array(
		'id'           => 'boombox',                    // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                           // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins',      // Menu slug.
		'has_notices'  => true,                         // Show admin notices or not.
		'dismissable'  => false,                        // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                           // If 'dismissible' is false, this message will be output at top of nag.
		'is_automatic' => false,                        // Automatically activate plugins after installation or not.
		'message'      => '',                           // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'boombox_register_plugins' );