<?php
/**
 * The template part for displaying the footer.
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 *
 * @var $template_helper Boombox_Footer_Template_Helper Template Helper
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$template_helper = Boombox_Template::init( 'footer' );
$template_options = $template_helper->get_options(); ?>
			<!--Div for sticky elements -->
			<div id="sticky-border"></div>
			</main>

			<?php
			/* Footer */
			if( $template_options[ 'footer_top' ] || $template_options[ 'footer_bottom' ] ) { ?>
				<footer id="footer" class="footer <?php echo esc_attr( $template_options['classes'] ); ?>">
					<?php
					if( $template_options[ 'footer_top' ] ) {
						get_template_part( 'template-parts/footer/footer', 'top' );
					}
					if( $template_options[ 'footer_bottom' ] ) {
						get_template_part( 'template-parts/footer/footer', 'bottom' );
					} ?>
				</footer>
			<?php } ?>

        <span id="go-top" class="go-top"><i class="icon icon-arrow-up"></i></span>
		</div>

		<?php
		do_action( 'boombox/after-footer' );

		wp_footer(); ?>
	</body>
</html>