<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class bwp_authors_WC_Admin_Taxonomies {


	public function __construct() {

		add_action( 'woocommerce_register_taxonomy', array( $this, 'create_taxonomies' ) );
		add_action( "delete_term", array( $this, 'delete_term' ), 5 );
		/* Add Custom field to author product */
		add_action( 'product_author_add_form_fields', array( $this, 'add_category_fields' ), 100 );
		add_action( 'product_author_edit_form_fields', array( $this, 'edit_category_fields' ), 100 );
		add_action( 'created_term', array( $this, 'save_category_fields' ), 10, 3 );
		add_action( 'edit_term', array( $this, 'save_category_fields' ), 10, 3 );
		
		// Add author columns
		add_filter( 'manage_edit-product_author_columns', array( $this, 'product_author_columns' ) );
		add_filter( 'manage_product_author_custom_column', array( $this, 'product_author_column' ), 10, 3 );
	}

	public function bwp_woocommerce_authors_metabox( $post ) {
		$taxonomy = 'product_author';	 
		$tax = get_taxonomy($taxonomy);
		$terms = get_terms($taxonomy,array('hide_empty' => 0));	 
		$name = 'tax_input[' . $taxonomy . ']';
		$popular = get_terms( $taxonomy, array( 'orderby' => 'count', 'order' => 'DESC', 'number' => 10, 'hierarchical' => false ) );
		$postterms = get_the_terms( $post->ID,$taxonomy );
		$current = ($postterms ? array_pop($postterms) : false);
		$current = ($current ? $current->term_id : 0);
		?>
	 
		<div id="taxonomy-<?php echo $taxonomy; ?>" class="bwp_authors">
	 
			<ul id="<?php echo $taxonomy; ?>-tabs" class="authors-tabs">
				<li class="tabs"><a href="#<?php echo $taxonomy; ?>-all" tabindex="3"><?php echo $tax->labels->all_items; ?></a></li>
				<li class="hide-if-no-js"><a href="#<?php echo $taxonomy; ?>-pop" tabindex="3"><?php _e( 'Most Used','wpbingo' ); ?></a></li>
			</ul>
	 
			<div id="<?php echo $taxonomy; ?>-all" class="tabs-panel">
				<ul id="<?php echo $taxonomy; ?>checklist" class="list:<?php echo $taxonomy?> authorschecklist form-no-clear">
					<?php   foreach($terms as $term){
						$id = $taxonomy.'-'.$term->term_id;
						echo "<li id='$id'><label class='selectit'>";
						echo "<input type='radio' id='in-$id' name='{$name}'".checked($current,$term->term_id,false)."value='$term->term_id' />$term->name<br />";
					   echo "</label></li>";
					}?>
			   </ul>
			</div>
	 
			<div id="<?php echo $taxonomy; ?>-pop" class="tabs-panel" style="display: none;">
				<ul id="<?php echo $taxonomy; ?>checklist-pop" class="authorschecklist form-no-clear" >
					<?php   foreach($popular as $term){
						$id = 'popular-'.$taxonomy.'-'.$term->term_id;
						echo "<li id='$id'><label class='selectit'>";
						echo "<input type='radio' id='in-$id'".checked($current,$term->term_id,false)."value='$term->term_id' />$term->name<br />";
						echo "</label></li>";
					}?>
			   </ul>
		   </div>
	 
		</div>
		<?php
	}

	public function create_taxonomies() {
		$shop_page_id = wc_get_page_id( 'shop' );

		$base_slug = $shop_page_id > 0 && get_page( $shop_page_id ) ? get_page_uri( $shop_page_id ) : 'shop';

		$authors_base = get_option('woocommerce_prepend_shop_page_to_urls') == "yes" ? trailingslashit( $base_slug ) : '';

		$cap = version_compare( WOOCOMMERCE_VERSION, '2.0', '<' ) ? 'manage_woocommerce_products' : 'edit_products';		
		$labels = array(
			'name'              => __( 'Authors', 'wpbingo' ),
			'singular_name'     => __( 'Authors', 'wpbingo' ),
			'search_items'      => __( 'Search Genres', 'wpbingo' ),
			'all_items'         => __( 'All Authors', 'wpbingo' ),
			'parent_item'       => __( 'Parent Authors', 'wpbingo'),
			'parent_item_colon' => __( 'Parent Authors:', 'wpbingo' ),
			'edit_item'         => __( 'Edit Authors', 'wpbingo'),
			'update_item'       => __( 'Update Authors', 'wpbingo'),
			'add_new_item'      => __( 'Add New Authors', 'wpbingo'),
			'new_item_name'     => __( 'New Authors Name', 'wpbingo'),
			'menu_name'         => 'Author',
		);
	
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui' 				=> true,
			'show_in_nav_menus' 	=> true,
			'capabilities'			=> array(
				'manage_terms' 		=> $cap,
				'edit_terms' 		=> $cap,
				'delete_terms' 		=> $cap,
				'assign_terms' 		=> $cap
			),
			'rewrite' 				=> array( 'slug' => $authors_base . __( 'product_author', 'wpbingo' ), 'with_front' => false, 'hierarchical' => true )
		);
		register_taxonomy( 'product_author', array('product'), apply_filters( 'register_taxonomy_product_author',$args ));	
	}  

	public function delete_term( $term_id ) {

		$term_id = (int) $term_id;

		if ( ! $term_id )
			return;

		global $wpdb;
		$wpdb->query( "DELETE FROM {$wpdb->woocommerce_termmeta} WHERE `woocommerce_term_id` = " . $term_id );
	}
	/**
	*	Add Custom field on category product
	**/
	public function add_category_fields() {
		?>
		<div class="form-field">
			<label><?php _e( 'Thumbnail', 'wpbingo' ); ?></label>
			<div id="product_author_thumbnail" style="float: left; margin-right: 10px;">
				<img class="product_author_thumbnail_id" src="" style="display: none; width:60px;height:auto;">
			</div>				
			<div style="line-height: 60px;">
				<input type="hidden" id="product_author_thumbnail_id" name="product_author_thumbnail_id" value="">
				<input type="button" class="bwp_upload_image_button button" data-image_id="product_author_thumbnail_id"  value="<?php _e( 'Browse', 'wpbingo' ); ?>">
				<input type="button" class="bwp_remove_image_button button" data-image_id="product_author_thumbnail_id" value="<?php _e( 'Remove', 'wpbingo' ); ?>">
			</div>
			<div class="clear"></div>
		</div>
		<div class="form-field">
			<label><?php _e( 'Image', 'wpbingo' ); ?></label>
			<div id="product_author_image" style="float: left; margin-right: 10px;">
				<img class="product_author_image_id" src="" style="display: none; width:60px;height:auto;">
			</div>				
			<div style="line-height: 60px;">
				<input type="hidden" id="product_author_image_id" name="product_author_image_id" value="">
				<input type="button" class="bwp_upload_image_button button" data-image_id="product_author_image_id"  value="<?php _e( 'Browse', 'wpbingo' ); ?>">
				<input type="button" class="bwp_remove_image_button button" data-image_id="product_author_image_id" value="<?php _e( 'Remove', 'wpbingo' ); ?>">
			</div>
			<div class="clear"></div>
		</div>
		<div class="form-field term-author-style-wrap">
			<label for="product_author_style"><?php _e( 'Style', 'wpbingo' ); ?></label>
			<input name="product_author_style" id="product_author_style" type="text" value="" size="40">
		</div>		
		<div class="form-field term-author-address-wrap">
			<label for="product_author_address"><?php _e( 'Address', 'wpbingo' ); ?></label>
			<input name="product_author_address" id="product_author_address" type="text" value="" size="40">
		</div>
		<div class="form-field term-author-birth-wrap">
			<label for="product_author_birth"><?php _e( 'Year of Birth', 'wpbingo' ); ?></label>
			<input name="product_author_birth" id="product_author_birth" type="text" value="" size="40">
		</div>
		<div class="form-field term-gender-wrap">
			<label for="product_author_gender"><?php _e( 'Gender', 'wpbingo' ); ?></label>
			<select name="product_author_gender" id="product_author_gender" class="postform">
				<option class="author-male" value="male"><?php _e( 'Male', 'wpbingo' ); ?></option>
				<option class="author-female" value="female"><?php _e( 'Female', 'wpbingo' ); ?></option>
			</select>
		</div>
		<div class="form-field term-author-position-wrap">
			<label for="product_author_position"><?php _e( 'Position', 'wpbingo' ); ?></label>
			<input name="product_author_position" id="product_author_position" type="text" value="" size="40">
		</div>
		<div class="form-field term-author-facebook-wrap">
			<label for="product_author_facebook"><?php _e( 'Facebook', 'wpbingo' ); ?></label>
			<input name="product_author_facebook" id="product_author_facebook" type="text" value="" size="40">
		</div>
		<div class="form-field term-author-twitter-wrap">
			<label for="product_author_twitter"><?php _e( 'Twitter', 'wpbingo' ); ?></label>
			<input name="product_author_twitter" id="product_author_twitter" type="text" value="" size="40">
		</div>
		<div class="form-field term-author-google-wrap">
			<label for="product_author_google"><?php _e( 'Google Plus', 'wpbingo' ); ?></label>
			<input name="product_author_google" id="product_author_google" type="text" value="" size="40">
		</div>
		<div class="form-field term-author-google-wrap">
			<label for="product_author_instagram"><?php _e( 'Instagram', 'wpbingo' ); ?></label>
			<input name="product_author_instagram" id="product_author_instagram" type="text" value="" size="40">
		</div>			
		<?php
	}
	
	public function edit_category_fields( $term ) {

		$image = ( get_term_meta( $term->term_id, 'thumbnail_bid', true ) );
		$image2 = ( get_term_meta( $term->term_id, 'image_bid', true ) );
		$author_style = ( get_term_meta( $term->term_id, 'author_style', true ) );
		$author_address = ( get_term_meta( $term->term_id, 'author_address', true ) );
		$author_birth = ( get_term_meta( $term->term_id, 'author_birth', true ) );
		$author_gender = ( get_term_meta( $term->term_id, 'author_gender', true ) );
		$author_position = ( get_term_meta( $term->term_id, 'author_position', true ) );
		$author_facebook = ( get_term_meta( $term->term_id, 'author_facebook', true ) );
		$author_twitter = ( get_term_meta( $term->term_id, 'author_twitter', true ) );
		$author_google = ( get_term_meta( $term->term_id, 'author_google', true ) );
		$author_instagram = ( get_term_meta( $term->term_id, 'author_instagram', true ) );
		?>
		<tr class="form-field">
			<th scope="row" valign="top"><label><?php _e( 'Thumbnail', 'wpbingo' ); ?></label></th>
			<td>
				<div id="product_author_thumbnail" style="float: left; margin-right: 10px;">
					<?php if($image){?>
						<img class="product_author_thumbnail_id" src="<?php echo esc_url( $image ); ?>" style="display: block; width:60px;height:auto;">
					<?php }else{ ?>
						<img class="product_author_thumbnail_id" src="<?php echo esc_url( $image ); ?>" style="display: none; width:60px;height:auto;">
					<?php } ?>
				</div>
				<div style="line-height: 60px;">
					<input type="hidden" id="product_author_thumbnail_id" name="product_author_thumbnail_id" value="<?php echo esc_url( $image ); ?>">
					<input type="button" class="bwp_upload_image_button button" data-image_id="product_author_thumbnail_id"  value="<?php _e( 'Browse', 'wpbingo' ); ?>">
					<input type="button" class="bwp_remove_image_button button" data-image_id="product_author_thumbnail_id" value="<?php _e( 'Remove image', 'wpbingo' ); ?>">
				</div>
				<div class="clear"></div>
			</td>
		</tr>
		<tr class="form-field">
			<th scope="row" valign="top"><label><?php _e( 'Image', 'wpbingo' ); ?></label></th>
			<td>
				<div id="product_author_image" style="float: left; margin-right: 10px;">
					<?php if($image2){?>
						<img class="product_author_image_id" src="<?php echo esc_url( $image2 ); ?>" style="display: block; width:60px;height:auto;">
					<?php }else{ ?>
						<img class="product_author_image_id" src="<?php echo esc_url( $image2 ); ?>" style="display: none; width:60px;height:auto;">
					<?php } ?>
				</div>
				<div style="line-height: 60px;">
					<input type="hidden" id="product_author_image_id" name="product_author_image_id" value="<?php echo esc_url( $image2 ); ?>">
					<input type="button" class="bwp_upload_image_button button" data-image_id="product_author_image_id"  value="<?php _e( 'Browse', 'wpbingo' ); ?>">
					<input type="button" class="bwp_remove_image_button button" data-image_id="product_author_image_id" value="<?php _e( 'Remove image', 'wpbingo' ); ?>">
				</div>
				<div class="clear"></div>
			</td>
		</tr>
		<tr class="form-field term-author-address-wrap">
			<th scope="row"><label for="product_author_style"><?php _e( 'Style', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_style" id="product_author_style" type="text" value="<?php echo esc_attr( $author_style ); ?>" size="40"></td>
		</tr>		
		<tr class="form-field term-author-address-wrap">
			<th scope="row"><label for="product_author_address"><?php _e( 'Address', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_address" id="product_author_address" type="text" value="<?php echo esc_attr( $author_address ); ?>" size="40"></td>
		</tr>		
		<tr class="form-field term-author-birth-wrap">
			<th scope="row"><label for="product_author_birth"><?php _e( 'Year of Birth', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_birth" id="product_author_birth" type="text" value="<?php echo esc_attr( $author_birth ); ?>" size="40"></td>
		</tr>
		<tr class="form-field term-gender-wrap">
			<th scope="row"><label for="gender"><?php _e( 'Gender', 'wpbingo' ); ?></label></th>
			<td>
				<select name="product_author_gender" id="product_author_gender" class="postform">
					<option class="author-male" value="male" <?php if($author_gender == 'male'){ echo 'selected="selected"';} ?> ><?php _e( 'Male', 'wpbingo' ); ?></option>
					<option class="author-female" value="female" <?php if($author_gender == 'female'){ echo 'selected="selected"';} ?>><?php _e( 'Female', 'wpbingo' ); ?></option>
				</select>
			</td>
		</tr>
		<tr class="form-field term-author-position-wrap">
			<th scope="row"><label for="product_author_position"><?php _e( 'Position', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_position" id="product_author_position" type="text" value="<?php echo esc_attr( $author_position ); ?>" size="40"></td>
		</tr>
		<tr class="form-field term-author-facebook-wrap">
			<th scope="row"><label for="product_author_facebook"><?php _e( 'Facebook', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_facebook" id="product_author_facebook" type="text" value="<?php echo esc_url( $author_facebook ); ?>" size="40">
		</tr>
		<tr class="form-field term-author-twitter-wrap">
			<th scope="row"><label for="product_author_twitter"><?php _e( 'Twitter', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_twitter" id="product_author_twitter" type="text" value="<?php echo esc_url( $author_twitter ); ?>" size="40">
		</tr>
		<tr class="form-field term-author-google-wrap">
			<th scope="row"><label for="product_author_google"><?php _e( 'Google Plus', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_google" id="product_author_google" type="text" value="<?php echo esc_url( $author_google ); ?>" size="40">
		</tr>
		<tr class="form-field term-author-google-wrap">
			<th scope="row"><label for="product_author_instagram"><?php _e( 'Instagram', 'wpbingo' ); ?></label></th>
			<td><input name="product_author_instagram" id="product_author_instagram" type="text" value="<?php echo esc_url( $author_instagram ); ?>" size="40">
		</tr>		
		<?php
	}
	public function save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {
		if ( isset( $_POST['product_author_thumbnail_id'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'thumbnail_bid', ( $_POST['product_author_thumbnail_id'] ) );
		}
		if ( isset( $_POST['product_author_image_id'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'image_bid', ( $_POST['product_author_image_id'] ) );
		}
		if ( isset( $_POST['product_author_style'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_style', ( $_POST['product_author_style'] ) );
		}		
		if ( isset( $_POST['product_author_address'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_address', ( $_POST['product_author_address'] ) );
		}		
		if ( isset( $_POST['product_author_birth'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_birth', ( $_POST['product_author_birth'] ) );
		}
		if ( isset( $_POST['product_author_gender'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_gender', ( $_POST['product_author_gender'] ) );
		}
		if ( isset( $_POST['product_author_position'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_position', ( $_POST['product_author_position'] ) );
		}			
		if ( isset( $_POST['product_author_facebook'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_facebook', ( $_POST['product_author_facebook'] ) );
		}
		if ( isset( $_POST['product_author_twitter'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_twitter', ( $_POST['product_author_twitter'] ) );
		}
		if ( isset( $_POST['product_author_google'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_google', ( $_POST['product_author_google'] ) );
		}
		if ( isset( $_POST['product_author_instagram'] ) && 'product_author' === $taxonomy ) {
			update_woocommerce_term_meta( $term_id, 'author_instagram', ( $_POST['product_author_instagram'] ) );
		}
	}
	
	/**
	 * Thumbnail column added to category admin.
	 *
	 * @param mixed $columns
	 * @return array
	 */
	public function product_author_columns( $columns ) {
		$new_columns          = array();
		$new_columns['cb']    = $columns['cb'];
		$new_columns['thumb'] = __( 'Image', 'wpbingo' );

		unset( $columns['cb'] );

		return array_merge( $new_columns, $columns );
	}

	/**
	 * Thumbnail column value added to category admin.
	 *
	 * @param string $columns
	 * @param string $column
	 * @param int $id
	 * @return array
	 */
	public function product_author_column( $columns, $column, $id ) {

		if ( 'thumb' == $column ) {

			$image = get_term_meta( $id, 'thumbnail_bid', true );
			if (!$image)
				$image = wc_placeholder_img_src();
			$image = str_replace( ' ', '%20', $image );

			$columns .= '<img src="' . esc_url( $image ) . '" alt="' . esc_attr__( 'Thumbnail', 'wpbingo' ) . '" class="wp-post-image" height="48" width="48" />';

		}

		return $columns;
	}
}
new bwp_authors_WC_Admin_Taxonomies();
?>