<?php
namespace ElementorWpbingo\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/**
 * Elementor Bwp Policy
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Bwp_Find_Book extends Widget_Base {
	public function get_name() {
		return 'bwp_find_book';
	}
	public function get_title() {
		return __( 'Wpbingo Find Book', 'wpbingo' );
	}
	public function get_icon() {
		return 'eicon-site-search';
	}	
	public function get_categories() {
		return [ 'general' ];
	}
	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'wpbingo' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'wpbingo' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => __( 'Default', 'wpbingo' ),
					'layout1'  => __( 'Layout 1', 'wpbingo' ),
				],
			]
		);		
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		$layout		 = 	( $settings['layout'] ) ? $settings['layout'] : 'default';
		if( $layout == 'default' || $layout == 'layout1' ){
			include( WPBINGO_ELEMENTOR_TEMPLATE_PATH.'bwp-find-book/default.php' );
		}
	}
}