<?php  
	$query_string = wpbingo_get_query_string();
	parse_str($query_string, $params);
	$category_slug = isset( $params['product_cat'] ) ? $params['product_cat'] : '';
	$terms =	get_terms( 'product_cat', 
		array(  
			'hide_empty' => true,	
			'parent' => 0	
		)
	);
	$author_slug = isset( $params['product_author'] ) ? $params['product_author'] : '';
	$terms_author = get_terms( 'product_author', array( 'parent' => '', 'hide_empty' => 0 ) ); 
?>
<form role="search" method="get" class="search-from-book shop <?php echo esc_attr($layout); ?>" action="<?php echo esc_url(home_url( "/" )); ?>">
	<input type="hidden" name="post_type" value="product"/>
	<div class="form-search">
		<?php if($terms){ ?>
		<div class="select_categorys">
			<div class="select_category pwb-dropdown dropdown">
				<span class="pwb-dropdown-toggle dropdown-toggle" data-toggle="dropdown"><?php  echo esc_html__("Category","wpbingo"); ?></span>
				<span class="caret"></span>
				<ul class="pwb-dropdown-menu dropdown-menu category-search">
					<li data-value="" class="<?php  echo (empty($category_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html__("All Category","wpbingo"); ?></li>
						<?php foreach($terms as $term){?>
						<li data-value="<?php echo esc_attr($term->slug); ?>" class="<?php  echo (($term->slug == $category_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html($term->name); ?></li>
						<?php
							$terms_vl1 =	get_terms( 'product_cat', 
							array( 
									'parent' => '', 
									'hide_empty' => false,
									'parent' 		=> $term->term_id, 
							));						
						?>	
						
						<?php foreach ($terms_vl1 as $term_vl1) { ?>
							<li data-value="<?php echo esc_attr($term_vl1->slug); ?>" class="children <?php  echo (($term_vl1->slug == $category_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html($term_vl1->name); ?></li>
							<?php
								$terms_vl2 =	get_terms( 'product_cat', 
								array( 
										'parent' => '', 
										'hide_empty' => false,
										'parent' 		=> $term_vl1->term_id, 
							));	?>					
							<?php foreach ($terms_vl2 as $term_vl2) { ?>
							<li data-value="<?php echo esc_attr($term_vl2->slug); ?>" class="children <?php  echo (($term_vl2->slug == $category_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html($term_vl2->name); ?></li>
							<?php } ?>
						<?php } ?>
					<?php } ?>
				</ul>	
				<input type="hidden" name="product_cat" class="product-cat" value="<?php echo esc_attr($category_slug); ?>"/>
			</div>
		</div>
		<?php } ?>
		<?php if($terms_author){ ?>
			<div class="select_authors">
				<div class="select_author pwb-dropdown dropdown">
					<span class="pwb-dropdown-toggle dropdown-toggle" data-toggle="dropdown"><?php echo esc_html__("Author","wpbingo"); ?></span>
					<span class="caret"></span>
					<ul class="pwb-dropdown-menu dropdown-menu author-search">
						<li data-value="" class="<?php  echo (($term->slug == $author_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html__("All Author","wpbingo"); ?></li>
						<?php foreach($terms_author as $term_author){ ?>
							<li data-value="<?php echo esc_attr($term_author->slug) ?>" class="<?php echo (($term_author->slug == $author_slug) ?  esc_attr("active") : ""); ?>"><?php echo esc_html($term_author->name); ?></li>
						<?php } ?>
					</ul>
					<input type="hidden" name="product_author" class="product-author" value="<?php echo esc_attr($author_slug); ?>"/>
				</div>
			</div>
		<?php } ?>
		<div class="btnsearchsubmit">
			<button id="searchbook" class="btn" type="submit">
				<span><i class="icon-loupe"></i></span>
				<?php echo esc_html__("Find Book","wpbingo"); ?>
			</button>
		</div>
	</div>
</form>