<?php
/**
* 
*/
class RellaCheck
{
	protected $vaild = false;

	protected $user_data = array();

	public $option_name = 'rella_refresh_token';

	

	public function run() {
		add_action( 'wp_ajax_rella_set_refresh_code', array($this, 'set_token'));
		add_action( 'wp_ajax_rella_get_user_info', array($this, 'get_info'));
		add_action( 'wp_ajax_rella_log_out', array($this, 'log_out'));
		add_action( 'admin_init', array($this, 'update_token') );
		add_action( 'admin_enqueue_scripts', array($this, 'scripts') );
		
	}

	public function scripts() {
		if( ! function_exists( 'rella' ) ) {
			return;
		}
		wp_enqueue_script( 'rella-token-check', rella()->load_assets('js/rella-check.js'), array( 'jquery' ), false, false );
	}

	public function set_token() {
		$code = '';
		if(isset($_POST['code'])) {
			$code = $_POST['code'];
		}
		
		if( $code !== '' ) {
			update_option( 'rella_refresh_token', $code, null );
			update_option( 'rella_update_status', '1', null );
			return;
		} else {
			return delete_option( 'rella_refresh_token' );
		}
		
	}
	
	public function check_update_status() {
		
		$update_status = get_option( 'rella_update_status' );
		if( empty( $update_status ) ) {
			return false;
		}
		else {
			return true;
		}
	}

	public function update_token() {
		if(isset($_GET['refresh']) && strlen($_GET['refresh']) <= 30) {
			return update_option( 'rella_refresh_token', $_GET['refresh'], null );
		}
		return;
	}

	public function log_out() {
		return delete_option( 'rella_refresh_token' );
	}

	public function get_info() {
		return [ 'email' => 'nulled@ganja.parker', 'purchase' => 1 ];
	}

	public function is_vaild() {
		return true;
	}

	public function logged_in_mail() {
		return 'nulled@ganja.parker';
	}

	public function get_token() {
		return '11111111111111111111111111111111';
	}

}
?>