<?php
$output = $color = $size = $icon = $target = $href = $el_class = $title = $align = '';
extract(shortcode_atts(array(
    'color' => 'default',
    'size' => '',
    'icon' => '',
    'target' => '_self',
    'href' => '',
    'title' => 'Click!',
	'icon_mode' => 'enable',
	'el_class' => '',
	'align' => 'left'
), $atts));
$a_class = '';

$el_class = $this->getExtraClass( $el_class );

$centered_div = false;

if ( $align == 'right' ) {
	$align = ' pull-right';
} elseif ( $align == 'left' ) {
	$align = ' pull-left';
} else {
	$align = '';
	$centered_div = true;
}

if ( $target == 'same' || $target == '_self' ) { $target = ''; }
$target = ( $target != '' ) ? ' target="'.$target.'"' : '';

$color = ( $color != '' ) ? ' '.$color : '';
$size = ( $size != '' && $size != 'wpb_regularsize' ) ? ' btn-'.$size : ' '.$size;
$icon = ( $icon != '' && $icon != 'none' ) ? ' '.$icon : '';
$i_icon = ( $icon != '' ) ? ' <i class="icon"> </i>' : '';

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'btn btn-primary'.$color.$size.$el_class.$align, $this->settings['base']);

$output = '';

if ( $centered_div ) {
	$output .= '<div class="text-center">';
}

if ( $icon_mode == 'enable' ) {
    $output .= '<a class="'.esc_attr($css_class).'" title="'.esc_attr($title).'" href="'.esc_url($href).'"'.$target.'><i class="fa' . esc_attr($icon) . '"></i><span>' . $title . '</span></a>';
} else {
    $output .= '<a class="'.esc_attr($css_class).'" title="'.esc_attr($title).'" href="'.esc_url($href).'"'.$target.'>' . $title . '</a>';
}

if ( $centered_div ) {
	$output .= '</div>';
}

echo html_entity_decode( $output . $this->endBlockComment('button') . "\n" );