<?php
/**
 * BOKEH
 * ==================================================
 * This is the single post page
 *
 */
get_header();

/* ======================================================
// Get Page Meta Data and Options
====================================================== */
if ( have_posts() ) {
	the_post();
									
	// *** BREADCRUMB ***
	if ( is_front_page() ) {
		// We don't need it on frontpage
		$tmq_brcr = 'tmq_hide';
	} else {
		$tmq_brcr = ot_get_option( 'tmq_brcr' );
		if ( empty( $tmq_brcr ) ) {
			$tmq_brcr = 'tmq_show';
		}
	}
	// *** COMMENTS ***
	if ( function_exists( 'ot_get_option' ) ) {
		$tmq_blog_comments = ot_get_option( 'tmq_portfolio_comments' );
	} else {
		// fallback
		$tmq_blog_comments = 'off';
	}
	// Is it still empty? Set a default value - fallback
	if ( $tmq_blog_comments == '' || empty( $tmq_blog_comments ) ) {
		$tmq_blog_comments = 'off';
	}

	// *** FEATURED IMAGE ***
	$tmq_featured_image = get_post_meta( $post->ID, 'tmq_featured_image', true);
	if ( empty( $tmq_featured_image ) ) {
		$tmq_featured_image = 'on';
	}
	
	// *** TAGS BOX ***
	$tmq_tags_box = get_post_meta( $post->ID, 'tmq_portfolio_tags_box', true);
	if ( empty( $tmq_tags_box ) || $tmq_tags_box == 'tmq_default' ) {
		// Set to default theme options if nothing is set or it says to read from default
		if ( function_exists( 'ot_get_option' ) ) {
			$tmq_tags_box = ot_get_option( 'tmq_portfolio_tags_box' );
		} else {
			// fallback
			$tmq_tags_box = 'tmq_hide';
		}
	}
	// Is it still empty? Set a default value - fallback
	if ( $tmq_tags_box == '' || empty( $tmq_tags_box ) ) {
		$tmq_tags_box = 'tmq_hide';
	}
	
	// *** SOCIAL NETWORK BOX ***
	$tmq_social_box = get_post_meta( $post->ID, 'tmq_portfolio_social_box', true);
	if ( empty( $tmq_social_box ) || $tmq_social_box == 'tmq_default' ) {
		// Set to default theme options if nothing is set or it says to read from default
		if ( function_exists( 'ot_get_option' ) ) {
			$tmq_social_box = ot_get_option( 'tmq_portfolio_social_box' );
		} else {
			// fallback
			$tmq_social_box = 'tmq_hide';
		}
	}
	// Is it still empty? Set a default value - fallback
	if ( $tmq_social_box == '' || empty( $tmq_social_box ) ) {
		$tmq_social_box = 'tmq_hide';
	}
	
	// *** RELATED POSTS ***
	$tmq_relatedposts = get_post_meta( $post->ID, 'tmq_portfolio_relatedposts', true);
	if ( empty( $tmq_relatedposts ) || $tmq_relatedposts == 'tmq_default' ) {
		// Set to default theme options if nothing is set or it says to read from default
		if ( function_exists( 'ot_get_option' ) ) {
			$tmq_relatedposts = ot_get_option( 'tmq_portfolio_relatedposts' );
		} else {
			// fallback
			$tmq_relatedposts = 'tmq_show';
		}
	}
	// Is it still empty? Set a default value - fallback
	if ( $tmq_relatedposts == '' || empty( $tmq_relatedposts ) ) {
		$tmq_relatedposts = 'tmq_show';
	}
?>
		<!-- Main Container Section -->	
		<div class="container">
			<div id="page-content">
				<?php if ( 'tmq_hide' != $tmq_brcr ) { ?>
				<!-- Page Banner + Breadcrumb -->
				<div id="page-banner">		
					<h2><?php echo get_the_title();?></h2>
					<?php
						// Show Breadcrumb
						if ( ( function_exists( 'tmq_show_bc' ) ) && ( $tmq_brcr == 'tmq_show' ) ) {
								tmq_show_bc();
						}
					?>
				</div>
				<!-- End Page Banner + Breadcrumb -->
				<?php } ?>
				
				<!-- OnePage Navigation Data -->
				<?php
				/* ======================================================
				   // Get OnePage Navigation Buttons
				   ====================================================== */
				   
				   // *** Back to Index
					$tmq_backtoindex = get_post_meta( $post->ID, 'tmq_backtoindex', true );
					if ( $tmq_backtoindex == 'tmq_link' ) {
						// Custom Link
						$tmq_backtoindex_url = get_post_meta( $post->ID, 'tmq_custom_index_url', true );
					} elseif ( $tmq_backtoindex == 'tmq_none' ) {
						// Do Nothing!
					} else {
						// Not set or Automatic
						$tmq_portfolio_index_page = ot_get_option( 'tmq_portfolio_index_page' );
						if ( !empty( $tmq_portfolio_index_page ) ) {
							$tmq_backtoindex_url = $tmq_portfolio_index_page;
						}
					}
					
					if ( !empty( $tmq_backtoindex_url ) ) {
						echo '<s id="ajax-link-index" class="data-collection" data-type="index" data-title="'. __('Portfolio Index', 'bokeh') .'" data-href="'. esc_url( $tmq_backtoindex_url ) .'"></s>';
					}
					
					// *** Previous Page
					$tmq_previouspage = get_post_meta( $post->ID, 'tmq_previouspage', true );
					if ( $tmq_previouspage == 'tmq_link' ) {
						// Custom Link
						$tmq_previouspage_url = get_post_meta( $post->ID, 'tmq_custom_previous_url', true );
					} elseif ( $tmq_previouspage == 'tmq_none' ) {
						// Do Nothing!
					} else {
						// Not set or Automatic
						$tmq_previous_page = get_previous_post();
						if ( !empty( $tmq_previous_page ) ) {
							$tmq_previouspage_url = get_permalink( $tmq_previous_page->ID );
						}
					}
					
					if ( !empty( $tmq_previouspage_url ) ) {
						echo '<s id="ajax-link-prev" class="data-collection" data-type="prev" data-title="'. __('Previous Post', 'bokeh') .'" data-href="'. esc_url( $tmq_previouspage_url ) .'"></s>';
					}
					
					// *** Next Page
					$tmq_nextpage = get_post_meta( $post->ID, 'tmq_nextpage', true );
					if ( $tmq_nextpage == 'tmq_link' ) {
						// Custom Link
						$tmq_nextpage_url = get_post_meta( $post->ID, 'tmq_custom_next_url', true );
					} elseif ( $tmq_nextpage == 'tmq_none' ) {
						// Do Nothing!
					} else {
						// Not set or Automatic
						$tmq_next_page = get_next_post();
						if ( !empty( $tmq_next_page ) ) {
							$tmq_nextpage_url = get_permalink( $tmq_next_page->ID );
						}
					}
					
					if ( !empty( $tmq_nextpage_url ) ) {
						echo '<s id="ajax-link-next" class="data-collection" data-type="prev" data-title="'. __('Next Post', 'bokeh') .'" data-href="'. esc_url( $tmq_nextpage_url ) .'"></s>';
					}
				?>
				<!-- End OnePage Navigation Data -->

				<!-- Page Content Area -->
				<div id="content-inner">
					<div class="row">
						<?php
						/* ======================================================
						   // Get Sidebar Settings
						   ====================================================== */					
							$tmq_sidebar_position = get_post_meta( $post->ID, 'tmq_sidebar_position', true );
							if ( empty( $tmq_sidebar_position ) || $tmq_sidebar_position == 'tmq_default' ) {
								// Empty? Read from theme default
								$tmq_sidebar_position = ot_get_option( 'tmq_def_portfolio_sidebar_position' );
							}
							if ( empty( $tmq_sidebar_position ) ) {
								// Even theme default is empty? So, force full width
								$tmq_sidebar_position = 'tmq_fullwidth';
							}
							if ( $tmq_sidebar_position != 'tmq_fullwidth' ) {
								// With a sidebar
								$tmq_content_class = 'col-md-9';
								$tmq_content_inner_class = 'col-md-10 col-md-offset-1';
								$tmq_related_cols = 'cols_3_owl';
							} else {
								// Full width
								$tmq_content_class = 'col-md-12';
								$tmq_content_inner_class = 'col-md-8 col-md-offset-2';
								$tmq_related_cols = 'cols_4_owl';
							}
						?>
						<?php
						/* ======================================================
						   // LEFT SIDEBAR
						   ====================================================== */
						if ( $tmq_sidebar_position == 'tmq_leftsidebar' ) {
							// Get Left Sidebar of this page
							$tmq_pagesidebar = get_post_meta( $post->ID, 'tmq_pagesidebar', true);
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								// Set to default theme options if nothing is set or it says to read from default
								if ( function_exists( 'ot_get_option' ) ) {
									$tmq_pagesidebar = ot_get_option( 'tmq_portfolio_left_sidebar' );
								} else {
									// fallback
									$tmq_pagesidebar = 'left-sidebar';
								}
							}
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'left-sidebar';
							}						
						?>
						<!-- Left Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="left-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>			
							</div>						
						</div>
						<!-- End: Left Sidebar -->
						<?php
						}
						?>
						<!-- Main Content Area -->
						<div class="<?php echo esc_attr( $tmq_content_class ); ?>">
							<?php
							/* ======================================================
							   // CONTENT AREA
							   ====================================================== */
								$tmq_showheading = get_post_meta( $post->ID, 'tmq_showheading', true);
								if ( $tmq_showheading == '' || empty( $tmq_showheading ) ) {
									// Metabox is not set
									$tmq_showheading = 'on';
								}
								$tmq_showsummary = get_post_meta( $post->ID, 'tmq_showsummary', true);
								if ( $tmq_showsummary == '' || empty( $tmq_showsummary ) ) {
									// Metabox is not set
									$tmq_showsummary = 'on';
								}
								if ( $tmq_showsummary == 'on' ) {
									$tmq_summary = get_post_meta( $post->ID, 'tmq_summary', true);
									if ( empty( $tmq_summary ) ) {
										// turn off show summary if it's empty
										if ( empty( $post->post_excerpt ) ) {
											// This post has no excerpt
											$tmq_showsummary = 'off';
										} else {
											// This post has excerpt
											$tmq_summary = get_the_excerpt();
										}										
									}
								}
							?>
							<?php if ( $tmq_showheading != 'off' ) { ?>
							<h1 class="main-title triggerAnimation animated" data-animate="fadeIn"><?php echo get_the_title();?></h1>
							<?php } ?>
							<?php if ( $tmq_showsummary != 'off' ) { ?>
							<div class="excerpt <?php echo esc_attr( $tmq_content_inner_class ); ?> triggerAnimation animated" data-animate="fadeInUp">
								<?php echo html_entity_decode( $tmq_summary );?>
							</div>
							<div class="clearfix"></div>
							<?php } ?>
							<?php
							// Show Featured Image if it's not password protected
							if ( ! post_password_required() ) {
							?>
							<?php
								$tmq_post_format = get_post_format( $post->ID );
								if ( $tmq_post_format == 'gallery' ) {
									// Gallery Format
									$tmq_gallery_post_format_images = get_post_meta( $post->ID, 'tmq_gallery_post_format_images', true );
									// Check if it has more than one image to show it as slideshow
									if ( !empty( $tmq_gallery_post_format_images ) ) {
										$tmq_gallery_post_format_images_array = explode(',', $tmq_gallery_post_format_images);
										?>
										<div class="slider-container portfolio-featured-gallery triggerAnimation animated" data-animate="fadeIn">
											<div class="image-slider">
											<?php 
											foreach ( $tmq_gallery_post_format_images_array as $image ) {
												$img_title = get_the_title( $image );   // title
												$img_caption = get_post_field('post_excerpt', $image ); // Get Caption - We don't use it now
												
												// Get slideshow size
												$big_array = image_downsize( $image, 'fullwidth' );
												$img_url = $big_array[0];
												?>
												<div class="image-gallery-item item">
													<img alt="<?php echo esc_attr( $img_title ); ?>" title="<?php echo esc_attr( $img_caption ); ?>" src="<?php echo esc_url( $img_url ); ?>">
												</div>												
												<?php
											}
											?>
											</div>
										</div>
										<?php
									}									
								} elseif ( $tmq_post_format == 'video' ) {
									$tmq_video_post_format_url = get_post_meta( $post->ID, 'tmq_video_url', true );
									$search     = '/youtube\.com\/watch\?v=([a-zA-Z0-9]+)/smi';
									$replace    = "youtube.com/embed/$1";    
									$tmq_video_post_format_url = preg_replace( $search,$replace, $tmq_video_post_format_url );
									?><div class="video-format-image-container videoplay"><?php
									echo '<iframe src="' . esc_url( $tmq_video_post_format_url ) . '"></iframe>';
									?></div><?php
								} else {
									// Simple
									if ( has_post_thumbnail() && $tmq_featured_image != 'off' ) {
									?>
										<div class="portfolio-featured-image">
										<?php the_post_thumbnail( 'banner' );?>
										</div>
									<?php
									}
								}
							?>
							<?php
							// End Password Protected
							}
							?>							
							<div class="row">
								<div class="col-md-10 col-md-offset-1 triggerAnimation animated fadeInUp">
								<?php
									the_content(); 
									$post_pg_arg = array(
										'before'           => '<p>' . __( 'Pages:', 'bokeh' ),
										'after'            => '</p>',
										'link_before'      => '',
										'link_after'       => '',
										'next_or_number'   => 'number',
										'separator'        => ' | ',
										'nextpagelink'     => __( 'Next page', 'bokeh' ),
										'previouspagelink' => __( 'Previous page', 'bokeh' ),
										'pagelink'         => '%',
										'echo'             => 1
									);
									wp_link_pages( $post_pg_arg );									
								?>
								</div>
							</div>
							<div class="spacer large"></div>
							<?php
							// Check Social Network and Tags
							if ( $tmq_social_box == 'tmq_show' || $tmq_tags_box == 'tmq_show' ) {
							?>
								<div class="blog-more portfolio-more">
								<?php
								// Check Social Network
								if ( $tmq_social_box == 'tmq_show' ) {
								?>							
									<h5>Share This</h5>
									<ul class="share-items">
										<li><a href="#"><i class="fa fa-facebook-square"></i></a></li>
										<li><a href="#"><i class="fa fa-twitter-square"></i></a></li>
										<li><a href="#"><i class="fa fa-google-plus-square"></i></a></li>
										<li><a href="#"><i class="fa fa-pinterest-square"></i></a></li>
										<li><a href="#"><i class="fa fa-tumblr-square"></i></a></li>
									</ul>
								<?php
								}
								?>
								<?php
								// Check Tags
								if ( $tmq_tags_box == 'tmq_show' ) {
								?>	
									<div class="blog-tags">
									<?php
									//if ( $tmq_show_tags == 'on' ) {
										the_tags('<h5>' . __('Tagged:','bokeh') . '</h5> ');
									//}
									?>
									</div>
								<?php
								}
								?>
								</div>
							<?php
							}
							?>

							<?php
							// Show related posts
							if ( $tmq_relatedposts != 'tmq_hide' ) {
								$orig_post = $post;
								global $post;
								$tags = wp_get_post_tags( $post->ID );
								
								if ( $tags ) {
									$tag_ids = array();
									foreach( $tags as $individual_tag ) {
										$tag_ids[] = $individual_tag->term_id;
									}
									$args = array(
										'post_type'				=> 'tmq-portfolio',
										'tag__in'				=> $tag_ids,
										'post__not_in'			=> array($post->ID),
										'posts_per_page'		=> 12, 
										'ignore_sticky_posts'	=> 0
										);
									$my_query = new wp_query( $args );

									if ( $my_query->have_posts() ) {								
							?>
							<div class="portfolio-related-posts triggerAnimation animated" data-animate="fadeInUp">
								<h4 class="page-titles"><?php _e( 'Similar Projects', 'bokeh' ); ?></h4>
								<div id="owl-slider" class="<?php echo esc_attr( $tmq_related_cols ); ?>">							
							
										<!-- LOOP -->
										<?php
										while( $my_query->have_posts() ) {
											$my_query->the_post();
											
											// Thumbnail or Not?
											$thumb_class = '';
											if ( has_post_thumbnail() ) {
												$thumb_image = get_the_post_thumbnail( get_the_ID() , 'related-sq' );
											} else {
												$thumb_class = ' active';
												$thumb_image = '<img alt="" src="' . get_stylesheet_directory_uri() . '/images/eeeeee.png" />';
											}
											
											// Categories
											$categories_name = '';
											$filtering_array = get_the_terms( $post ,'portfolio_category');
											
											if ( is_array( $filtering_array ) ) {
												foreach ( $filtering_array as $category ) {
													$categories_name .= $category->name . ' / ';
												}
												$categories_name = rtrim($categories_name, ' / ');
											}

											// Post Format
											$tmq_related_post_format = get_post_format( $post->ID );
											if ( 'gallery' == $tmq_related_post_format ) {
												$tmq_post_format_class = ' fa-image';
											} elseif ( 'video' == $tmq_related_post_format ) {
												$tmq_post_format_class = ' fa-film';
											} else {
												$tmq_post_format_class = ' fa-camera';
											}
											
										?>
										<div class="related-portfolio-item item">
											<a href="<?php echo esc_url( get_permalink() ) ?>">
												<?php
													echo html_entity_decode( $thumb_image );
												?></a>
											<div class="portfolio-info-overlay"></div>
											<div class="portfolio-info-hover">
												<div class="related-portfolio-icon"><i class="fa<?php echo esc_attr( $tmq_post_format_class );?>"></i></div>
												<h3><?php the_title(); ?></h3>
												<div class="related-portfolio-categories"><?php echo html_entity_decode( $categories_name ); ?></div>
												<a href="<?php echo esc_url( get_permalink() ) ?>" class="read-more"><i class="fa fa-arrow-right"></i></a>
											</div>
										</div>										
										<?php
										// End While
										}
										?>
										<!-- END: LOOP -->
									</div>
								</div>
							<div class="clearfix"></div>
							<?php
									// End have posts
									}
								// End if has tags
								}
								// Reset posts
								$post = $orig_post;
							// End related posts
							}
							?>
							<a id="comments"></a>
							<div class="blog-comments-area <?php echo esc_attr( $tmq_content_inner_class ); ?>">							
							<?php
							// Check if we should show Comments?
							if ( 'on' == $tmq_blog_comments ) {
								comments_template( '', true );
							}	
							?>
							</div>
						</div>
						<!-- End: Main Content Area -->
						<?php
						/* ======================================================
						   // RIGHT SIDEBAR
						   ====================================================== */
						if ( $tmq_sidebar_position == 'tmq_rightsidebar' ) {
							// Get sidebar of this page
							$tmq_pagesidebar = get_post_meta( $post->ID, 'tmq_pagesidebar', true);
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								// Set to default theme options if nothing is set or it says to read from default
								if ( function_exists( 'ot_get_option' ) ) {
									$tmq_pagesidebar = ot_get_option( 'tmq_portfolio_right_sidebar' );
								} else {
									// fallback
									$tmq_pagesidebar = 'right-sidebar';
								}
							}
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'right-sidebar';
							}						
						?>						
						<!-- Right Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="right-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>
							</div>						
						</div>
						<!-- End: Right Sidebar -->
						<?php
						}
						?>
					</div>
				</div>
				<!-- End Content Area -->
				
			</div>
		</div>
		<!-- End Container -->
<?php
// End have_posts()
}
?>
<?php get_footer(); ?>