<?php
/**
 * BOKEH
 * ==================================================
 * This is the default index file for blog, archive and ...
 *
 */
get_header();

/* ======================================================
// Get Page Meta Data and Options
====================================================== */
									
// *** BREADCRUMB ***
if ( is_front_page() || is_home() ) {
	// We don't need it on frontpage
	$tmq_brcr = 'tmq_hide';
} else {
	$tmq_brcr = ot_get_option( 'tmq_brcr' );
	if ( empty( $tmq_brcr ) ) {
		$tmq_brcr = 'tmq_show';
	}
}

/* ======================================================
   // Get Sidebar Settings
   ====================================================== */					
	$tmq_def_blog_sidebar_position = ot_get_option( 'tmq_search_sidebar_position' );
	if ( empty( $tmq_def_blog_sidebar_position ) ) {
		// Empty? Force full width
		$tmq_def_blog_sidebar_position = 'tmq_fullwidth';
	}
	
	$tmq_sidebar_position = $tmq_def_blog_sidebar_position;
	
	if ( $tmq_sidebar_position != 'tmq_fullwidth' ) {
		// With a sidebar
		$tmq_content_class = 'col-md-9';
		$tmq_content_inner_class = 'col-md-12';
	} else {
		// Full width
		$tmq_content_class = 'col-md-12';
		$tmq_content_inner_class = 'col-md-10 col-md-offset-1';
	}


/* ======================================================
   // Get Page Title
   ====================================================== */
	$tmq_banner_title = '';
	$tmq_banner_heading = __('Search Results', 'bokeh');
	$tmq_banner_desc = __('Showing search results for', 'bokeh') . ' <strong>' . get_search_query() . '</strong>';
	
	// Posts Limit Excerpt
	$tmq_blogexceptlimit = ot_get_option( 'tmq_blogexceptlimit' );
	if ( empty( $tmq_blogexceptlimit ) ) {
		$tmq_blogexceptlimit = '40';
	}
	
	// Posts Limit Excerpt After!
	$tmq_blogexcept_after_text = ot_get_option( 'tmq_blogexcept_after_text' );
	
/* ======================================================
   // Blog Layout
   ====================================================== */
	$tmq_blog_index_style = ot_get_option( 'tmq_search_style' );
	$tmq_blog_columns = ot_get_option( 'tmq_search_columns' );
	if ( empty( $tmq_blog_index_style ) ) {
		// Empty? Force full width
		$tmq_blog_index_style = 'tmq_classic';
		$tmq_blog_columns = 'tmq_13_13_13';
	}
	
	switch ( $tmq_blog_columns ) {
		case 'tmq_1':
			$grid_class = 'col-md-12 col-md-offset-0 col-sm-8 col-sm-offset-2 col-xs-10 col-xs-offset-1';
			break;
		case 'tmq_12_12':
			$grid_class = 'col-md-6 col-md-offset-0 col-sm-8 col-sm-offset-2 col-xs-10 col-xs-offset-1';
			break;
		case 'tmq_13_13_13':
			$grid_class = 'col-md-4 col-md-offset-0 col-sm-8 col-sm-offset-2 col-xs-10 col-xs-offset-1';
			break;
		case 'tmq_14_14_14_14':
			$grid_class = 'col-md-3 col-md-offset-0 col-sm-8 col-sm-offset-2 col-xs-10 col-xs-offset-1';
			break;
		default:
			$grid_class = 'col-md-4 col-md-offset-0 col-sm-8 col-sm-offset-2 col-xs-10 col-xs-offset-1';
			break;
	}
	
?>
		<!-- Main Container Section -->	
		<div class="container">
			<div id="page-content">
				
				<?php if ( 'tmq_hide' != $tmq_brcr ) { ?>
				<!-- Page Banner + Breadcrumb -->
				<div id="page-banner">		
					<h2><?php echo esc_attr( $tmq_banner_title );?></h2>
					<?php
						// Show Breadcrumb
						if ( ( function_exists( 'tmq_show_bc' ) ) && ( $tmq_brcr == 'tmq_show' ) ) {
								tmq_show_bc();
						}
					?>
				</div>
				<!-- End Page Banner + Breadcrumb -->
				<?php } ?>
				
				<!-- Page Content Area -->
				<div id="content-inner">
					<div class="row">
						<?php
						/* ======================================================
						   // LEFT SIDEBAR
						   ====================================================== */
						if ( $tmq_sidebar_position == 'tmq_leftsidebar' ) {
							// Get Left Sidebar from theme options
							$tmq_pagesidebar = ot_get_option( 'tmq_search_left_sidebar' );
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'left-sidebar';
							}						
						?>
						<!-- Left Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="left-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>			
							</div>						
						</div>
						<!-- End: Left Sidebar -->
						<?php
						}
						?>
						<!-- Main Content Area -->
						<div class="<?php echo esc_attr( $tmq_content_class );?>">
							<h1 class="main-title triggerAnimation animated" data-animate="fadeIn"><?php echo esc_attr( $tmq_banner_heading ); ?></h1>
							<?php if ( !empty( $tmq_banner_desc ) ) { ?>
							<div class="excerpt <?php echo esc_attr( $tmq_content_inner_class ); ?> triggerAnimation animated" data-animate="fadeInUp">
								<?php echo html_entity_decode( $tmq_banner_desc ); ?>
								<?php get_search_form( true ); ?>
							</div>
							<?php } ?>
							<div class="clearfix"></div>
							<?php
							// Add grid only codes
							if ( $tmq_blog_index_style == 'tmq_grid' ) {
								echo '<div class="blog-grid">';
								echo "\t" . '<div class="row">';
							}
							if ( have_posts() ) {
								while ( have_posts() ) {
									the_post();
								?>
								<?php 
								// Blog Layout is Classic!
								if ( $tmq_blog_index_style != 'tmq_grid' ) {
								?>
								<div class="row <?php post_class(); ?>">
									<div class="<?php echo esc_attr( $tmq_content_inner_class ); ?>">
										<div class="blog-list-post triggerAnimation animated" data-animate="fadeIn">
											<div class="blog-list-featured-image">
												<a href="<?php echo esc_url( get_permalink() ); ?>" class="img-link">
												<?php
												if ( has_post_thumbnail() && ! post_password_required() ) {
													the_post_thumbnail( $post->ID, array(1170, 1170) );
												}
												?>
												</a>
											</div>

											<div class="blog-details">
												<span class="blog-date"><?php echo get_the_date( );?></span>
											</div>
											
											<div class="blog-list-content">
												<h2 class="blog-list-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h2>
												<p class="blog-list-excerpt">
													<?php 
														$tmq_excerpt = get_the_excerpt();
														if ( function_exists( 'tmq_string_limit_words' ) ) {
															echo tmq_string_limit_words( $tmq_excerpt, $tmq_blogexceptlimit ) . $tmq_blogexcept_after_text;
														} else {
															echo html_entity_decode( $tmq_excerpt );
														}
													?></p>
												<div class="blog-details">
													<div class="blog-info">
														<span class="blog-detail-author"><i class="fa fa-user"></i> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author();?></a></span><i class="divider">|</i>
														<span class="blog-detail-category"><i class="fa fa-folder-open"></i> 
														<?php 
															$i = 0;
															// Limit Number of Categories to Show on Page
															foreach((get_the_category()) as $cat) {
																if ( $i > 0 ) echo ', ';
																echo '<a href="'.get_category_link($cat->cat_ID).'">' . $cat->cat_name . '</a>';
																if (++$i == 4) break;
															}
															if ( sizeof(get_the_category()) > 4 ) {
																echo ', . . .';
															}
														 ?>
														</span>
														<?php	if ( comments_open() ) { ?>
														<i class="divider">|</i>
														<span class="blog-detail-comments"><i class="fa fa-comments"></i> <a href="<?php comments_link();?>"><?php comments_number(); ?></a></span>
														<?php } ?>
													</div>
												</div>
												<div class="clearfix"></div>
											</div>
										</div>
									</div>
								</div>							
								<?php
								// End: Classic Style
								} else {
								// Grid Layout 
								?>
									<div class="<?php echo esc_attr( $grid_class );?>">
										<div class="blog-grid-item triggerAnimation animated" data-animate="fadeInUp">
											<a class="img-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php
												if ( has_post_thumbnail() && ! post_password_required() ) {
													the_post_thumbnail( $post->ID, array(1170, 1170) );
												}
												?></a>
											<div class="blog-grid-controls">
												<a href="#" title="<?php echo get_the_date( );?>"><i class="fa fa-clock-o"></i></a>
												<?php	if ( comments_open() ) { ?>
												<a href="<?php comments_link();?>" title="<?php comments_number(); ?>"><i class="fa fa-comments"></i></a>
												<?php } ?>
												<a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php _e('Continue Reading','bokeh');?>"><i class="fa fa-arrow-right"></i></a>
											</div>
											<div class="blog-grid-content">
												<h3><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h3>
												<p><?php 
														$tmq_excerpt = get_the_excerpt();
														if ( function_exists( 'tmq_string_limit_words' ) ) {
															echo tmq_string_limit_words( $tmq_excerpt, $tmq_blogexceptlimit ) . $tmq_blogexcept_after_text;
														} else {
															echo html_entity_decode( $tmq_excerpt );
														}
													?></p>
											</div>
										</div>
									</div>								
								<?php
								}
								// End: Grid Layout
								?>
								<?php
								}
							}
							// End: Add grid only codes
							if ( $tmq_blog_index_style == 'tmq_grid' ) {
								echo "\t" . '</div>';
								echo '</div>';
							}							
							?>
							<!-- Blog Pagination Buttons -->
							<div class="row">
								<div class="col-md-12">											
								<?php
									tmq_blog_pagination();
								?>
								</div>
							</div>
							<!-- End: Blog Pagination Buttons -->
						</div>
						<!-- End: Main Content Area -->						
						<?php
						/* ======================================================
						   // RIGHT SIDEBAR
						   ====================================================== */
						if ( $tmq_sidebar_position == 'tmq_rightsidebar' ) {
							// Get Right Sidebar from theme options
							$tmq_pagesidebar = ot_get_option( 'tmq_search_right_sidebar' );
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'right-sidebar';
							}						
						?>
						<!-- Right Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="right-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>			
							</div>						
						</div>
						<!-- End: Right Sidebar -->
						<?php
						}
						?>
					</div>
				</div>
				<!-- End Content Area -->
				
			</div>
		</div>
		<!-- End Container -->
<?php get_footer(); ?>