<?php
/**
 * BOKEH
 * ==================================================
 * This is the template to show normal pages
 *
 */
get_header();

/* ======================================================
   // Get Page Meta Data and Options
   ====================================================== */
	
	// Get Breadcrumb Status 
	if ( is_front_page() ) {
		// We don't need it on frontpage
		$tmq_brcr = 'tmq_hide';
	} else {
		$tmq_brcr = ot_get_option( 'tmq_brcr' );
		if ( empty( $tmq_brcr ) ) {
			$tmq_brcr = 'tmq_show';
		}
	}
?>
		<!-- Main Container Section -->	
		<div class="container">
			<div id="page-content">
				
				<?php if ( 'tmq_hide' != $tmq_brcr ) { ?>
				<!-- Page Banner + Breadcrumb -->
				<div id="page-banner">		
					<h2><?php echo get_the_title();?></h2>
					<?php
						// Show Breadcrumb
						if ( ( function_exists( 'tmq_show_bc' ) ) && ( $tmq_brcr == 'tmq_show' ) ) {
								tmq_show_bc();
						}
					?>
				</div>
				<!-- End Page Banner + Breadcrumb -->
				<?php } ?>

				<!-- OnePage Navigation Data -->
				<?php
				/* ======================================================
				   // Get OnePage Navigation Buttons
				   ====================================================== */
				   
				   // *** Back to Index
					$tmq_backtoindex = get_post_meta( $post->ID, 'tmq_backtoindex', true );
					if ( $tmq_backtoindex == 'tmq_link' ) {
						// Custom Link
						$tmq_backtoindex_url = get_post_meta( $post->ID, 'tmq_custom_index_url', true );
					} else {
						// Do Nothing - For pages Homepage will be the index page automatically!
					}
					
					if ( !empty( $tmq_backtoindex_url ) ) {
						echo '<s id="ajax-link-index" class="data-collection" data-type="index" data-title="'. __('Back to Index', 'bokeh') .'" data-href="'. esc_url( $tmq_backtoindex_url ) .'"></s>';
					}
					
					// *** Previous Page
					$tmq_previouspage = get_post_meta( $post->ID, 'tmq_previouspage', true );
					if ( $tmq_previouspage == 'tmq_link' ) {
						// Custom Link
						$tmq_previouspage_url = get_post_meta( $post->ID, 'tmq_custom_previous_url', true );
					} elseif ( $tmq_previouspage == 'tmq_none' ) {
						// Do Nothing!
					} else {
						// Not set or Automatic
						$tmq_previous_page = get_previous_post();
						if ( !empty( $tmq_previous_page ) ) {
							$tmq_previouspage_url = get_permalink( $tmq_previous_page->ID );
						}
					}
					
					if ( !empty( $tmq_previouspage_url ) ) {
						echo '<s id="ajax-link-prev" class="data-collection" data-type="prev" data-title="'. __('Previous Page', 'bokeh') .'" data-href="'. esc_url( $tmq_previouspage_url ) .'"></s>';
					}
					
					// *** Next Page
					$tmq_nextpage = get_post_meta( $post->ID, 'tmq_nextpage', true );
					if ( $tmq_nextpage == 'tmq_link' ) {
						// Custom Link
						$tmq_nextpage_url = get_post_meta( $post->ID, 'tmq_custom_next_url', true );
					} elseif ( $tmq_nextpage == 'tmq_none' ) {
						// Do Nothing!
					} else {
						// Not set or Automatic
						$tmq_next_page = get_next_post();
						if ( !empty( $tmq_next_page ) ) {
							$tmq_nextpage_url = get_permalink( $tmq_next_page->ID );
						}
					}
					
					if ( !empty( $tmq_nextpage_url ) ) {
						echo '<s id="ajax-link-next" class="data-collection" data-type="prev" data-title="'. __('Next Page', 'bokeh') .'" data-href="'. esc_url( $tmq_nextpage_url ) .'"></s>';
					}
				?>
				<!-- End OnePage Navigation Data -->
				
				<!-- Page Content Area -->
				<div id="content-inner">
					<div class="row">
						<?php
						/* ======================================================
						   // Get Sidebar Settings
						   ====================================================== */					
							$tmq_sidebar_position = get_post_meta( $post->ID, 'tmq_sidebar_position', true );
							if ( empty( $tmq_sidebar_position ) || $tmq_sidebar_position == 'tmq_default' ) {
								// Empty? Read from theme default
								$tmq_sidebar_position = ot_get_option( 'tmq_default_sidebar_position' );
							}
							if ( empty( $tmq_sidebar_position ) ) {
								// Even theme default is empty? So, force full width
								$tmq_sidebar_position = 'tmq_fullwidth';
							}
							if ( $tmq_sidebar_position != 'tmq_fullwidth' ) {
								// With a sidebar
								$tmq_content_class = 'col-md-9';
								$tmq_content_inner_class = 'col-md-12';
							} else {
								// Full width
								$tmq_content_class = 'col-md-12';
								$tmq_content_inner_class = 'col-md-10 col-md-offset-1';
							}
						?>
						<?php
						if ( $tmq_sidebar_position == 'tmq_leftsidebar' ) {
							// Get Left Sidebar of this page
							$tmq_pagesidebar = get_post_meta( $post->ID, 'tmq_pagesidebar', true);
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								// Set to default theme options if nothing is set or it says to read from default
								if ( function_exists( 'ot_get_option' ) ) {
									$tmq_pagesidebar = ot_get_option( 'tmq_def_left_sidebar' );
								} else {
									// fallback
									$tmq_pagesidebar = 'left-sidebar';
								}
							}
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'left-sidebar';
							}						
						?>
						<!-- Left Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="left-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>			
							</div>						
						</div>
						<!-- End: Left Sidebar -->
						<?php
						}
						?>
						<!-- Main Content Area -->
						<div class="<?php echo esc_attr( $tmq_content_class ); ?>">
							<?php
								$tmq_showheading = get_post_meta( $post->ID, 'tmq_showheading', true);
								if ( $tmq_showheading == '' || empty( $tmq_showheading ) ) {
									// Metabox is not set
									$tmq_showheading = 'on';
								}
								$tmq_showsummary = get_post_meta( $post->ID, 'tmq_showsummary', true);
								if ( $tmq_showsummary == '' || empty( $tmq_showsummary ) ) {
									// Metabox is not set
									$tmq_showsummary = 'on';
								}
								if ( $tmq_showsummary == 'on' ) {
									$tmq_summary = get_post_meta( $post->ID, 'tmq_summary', true);
									if ( empty( $tmq_summary ) ) {
										// turn off show summary if it's empty
										$tmq_showsummary = 'off';
									}
								}
							?>
							<?php if ( $tmq_showheading != 'off' ) { ?>
							<h1 class="main-title triggerAnimation animated" data-animate="fadeIn"><?php echo get_the_title();?></h1>
							<?php } ?>
							<?php if ( $tmq_showsummary != 'off' ) { ?>
							<div class="excerpt <?php echo esc_attr( $tmq_content_inner_class );?> triggerAnimation animated" data-animate="fadeInUp">
								<?php echo esc_attr( $tmq_summary );?>
							</div>
							<div class="clearfix"></div>
							<?php } ?>
								<?php
								if (have_posts()) : 
									the_post();
									the_content(); 
									$post_pg_arg = array(
										'before'           => '<p>' . __( 'Pages:', 'bokeh' ),
										'after'            => '</p>',
										'link_before'      => '',
										'link_after'       => '',
										'next_or_number'   => 'number',
										'separator'        => ' | ',
										'nextpagelink'     => __( 'Next page', 'bokeh' ),
										'previouspagelink' => __( 'Previous page', 'bokeh' ),
										'pagelink'         => '%',
										'echo'             => 1
									);
									wp_link_pages( $post_pg_arg );									
								endif; 
								?>
						</div>
						<!-- End: Main Content Area -->
						<?php
						if ( $tmq_sidebar_position == 'tmq_rightsidebar' ) {
							// Get sidebar of this page
							$tmq_pagesidebar = get_post_meta( $post->ID, 'tmq_pagesidebar', true);
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								// Set to default theme options if nothing is set or it says to read from default
								if ( function_exists( 'ot_get_option' ) ) {
									$tmq_pagesidebar = ot_get_option( 'tmq_def_right_sidebar' );
								} else {
									// fallback
									$tmq_pagesidebar = 'right-sidebar';
								}
							}
							
							// Is it still empty? Set a default value - fallback
							if ( $tmq_pagesidebar == '' || empty( $tmq_pagesidebar ) ) {
								$tmq_pagesidebar = 'right-sidebar';
							}						
						?>						
						<!-- Right Sidebar -->
						<div class="col-md-3">
							<div id="sidebar-area" class="right-sidebar">
								<?php dynamic_sidebar( $tmq_pagesidebar ); ?>
							</div>						
						</div>
						<!-- End: Right Sidebar -->
						<?php
						}
						?>
					</div>
				</div>
				<!-- End Content Area -->
				
			</div>
		</div>
		<!-- End Container -->
<?php get_footer(); ?>