<?php
/**
 * Template Name: OnePage Home
 * BOKEH
 * ==================================================
 * This is the template to show one page ajax page
 *
 */
get_header();?>
		
		<!-- Main Container Section -->	
		<div class="container">
			<div id="ajax-container">
				
				<!-- Content of Inner Pages Will Load Here with Ajax -->
				<div id="page-content">

				</div>
				<!-- End Content of Inner Pages -->

				<!-- Onepage Index Page Content -->
				<div id="ajax-loader">
					<div class="row">
						<div class="col-md-12">
						
							<!-- FLIP MENU Container -->
							<div class="row flip-menu">
							
							<?php
							// Added in v1.1 - Choose Menu from Page Settings
							$tmq_onepage_enabled = get_post_meta($post->ID, 'tmq_onepage_enabled', true);
							if ( $tmq_onepage_enabled == 'on' ) {
								$tmq_onepage_post = get_post_meta($post->ID, 'tmq_onepage_post', true);
							} else {
								if ( function_exists( 'ot_get_option' ) ) {
									$tmq_onepage_post = ot_get_option( 'tmq_onepage_post' );
								}
							}		
							
							$ajax_q = get_post( $tmq_onepage_post );
							if ( $ajax_q ) {
								$tmq_ajax_menu = get_post_meta( $tmq_onepage_post, 'tmq_pages_list', true );
								if ( is_array( $tmq_ajax_menu ) ) {
									foreach ( $tmq_ajax_menu as $tmq_ajax_menu_item ) {
										
										$tmq_link_url = '';
										
										if ( $tmq_ajax_menu_item['tmq_linktype'] == 'tmq_page' ) {
											$tmq_link_url = get_permalink($tmq_ajax_menu_item['tmq_page_url']);
										} elseif ( $tmq_ajax_menu_item['tmq_linktype'] == 'tmq_post') {
											$tmq_link_url = get_permalink($tmq_ajax_menu_item['tmq_post_url']);
										} else { 
											$tmq_link_url = $tmq_ajax_menu_item['tmq_custom_url'];
										}
									
										// Disable Rotation When backside is Empty
										if ( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_none' ) {
											echo '<div class="col-md-3 col-sm-6"><div class="flip-item no-flip"><div class="flip-wrapper">';
										}	else {
											echo '<div class="col-md-3 col-sm-6"><div class="flip-item"><div class="flip-wrapper">';
										}
										
										if ( $tmq_ajax_menu_item['tmq_frontside'] == 'tmq_iconned' ) {
											echo '<!-- Front Side -->';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '<a href="' . esc_url( $tmq_link_url ) .'">';
												}
												echo '<div class="flip-content iconned">
													<div class="flip-inner">
														<i class="fa ' . esc_attr( $tmq_ajax_menu_item['tmq_page_icon'] ) .'"></i>
														<h3>' . $tmq_ajax_menu_item['title'] .'</h3>
													</div>
												</div>';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '</a>';
												}
										} elseif ( $tmq_ajax_menu_item['tmq_frontside'] == 'tmq_image' ) {
											$image_url = '';
											$image_url = wp_get_attachment_image_src($tmq_ajax_menu_item['tmq_page_image'], 'related-sq');
											
											echo '<!-- Front Side -->';
											// If it has a link and also if it's no-flip then we should link the front side
											if (( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_none' ) && ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) ) {
												echo '<a href="' . esc_url( $tmq_link_url ) .'">';
											}
												echo '<div class="flip-content">
													<img alt="" src="' . esc_url( $image_url[0] ) .'">
												</div>';
											if (( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_none' ) && ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) ) {
												echo '</a>';
											}
										} else {
											echo '<!-- Front Side -->';
											// If it has a link and also if it's no-flip then we should link the front side
											if (( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_none' ) && ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) ) {
												echo '<a href="' . esc_url( $tmq_link_url ) .'">';
											}
												echo '<div class="flip-content">
													<img alt="" src="' . esc_url( $tmq_ajax_menu_item['tmq_page_image'] ) .'" style="width: 100%; height: auto;">
													<div class="overlay">
														<h3>' . $tmq_ajax_menu_item['title'] .'</h3>
														<p>' . $tmq_ajax_menu_item['tmq_page_text'] .'</p>
														<i class="fa fa-arrow-right"></i>
													</div>
												</div>';		
											if (( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_none' ) && ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) ) {
												echo '</a>';
											}
										}
										
										if ( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_iconned' ) {
											echo '<!-- Back Side -->';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '<a href="' . esc_url( $tmq_link_url ) .'">';
												}
												echo '<div class="flip-hover-content iconned">
														<div class="flip-inner">
															<i class="fa ' . esc_attr( $tmq_ajax_menu_item['tmq_page_icon_bk'] ) .'"></i>
															<h3>' . $tmq_ajax_menu_item['title'] .'</h3>
														</div>
													</div>';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '</a>';
												}
										} elseif ( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_image' ) {
											$image_url = '';
											$image_url = wp_get_attachment_image_src($tmq_ajax_menu_item['tmq_page_image_bk'], 'related-sq');
											
											echo '<!-- Back Side -->';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '<a href="' . $tmq_link_url .'">';
												}
												echo '<div class="flip-hover-content">
														<img alt="" src="' . esc_url( $image_url[0] ) . '">
													</div>';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '</a>';
												}
										} elseif ( $tmq_ajax_menu_item['tmq_backside'] == 'tmq_text' ) {
											echo '<!-- Back Side -->';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '<a href="' . esc_url( $tmq_link_url ) .'">';
												}
												echo '<div class="flip-hover-content">
														<img alt="" src="' . esc_url( $tmq_ajax_menu_item['tmq_page_image_bk'] ) .'">
														<div class="overlay">
															<h3>' . $tmq_ajax_menu_item['title'] .'</h3>
															<p>' . $tmq_ajax_menu_item['tmq_page_text_bk'] .'</p>';
															if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
																echo '<i class="fa fa-arrow-right"></i>';
															}
														echo '</div>
													</div>';
												if ( $tmq_ajax_menu_item['tmq_linktype'] != 'tmq_nolink' ) {
													echo '</a>';
												}
										}
										echo '</div></div></div>';
									}
								}
							}
							?>
							</div>
							<!-- End FLIP MENU Container -->
						</div>
					</div>
				</div>
				<!-- End OnePage Index Page Content -->
				
			</div>
		</div>
		<!-- End Container -->
<?php get_footer(); ?>