/*!
 * Bokeh Template
 * Copyright 2014 ImanGM
 */

var randomColor = tmq_script_vars.onepage_autocolor;
var randomHue = tmq_script_vars.tmq_onepager_color;
var OnePageAjax = tmq_script_vars.tmq_onepage_ajax;

var $ = jQuery.noConflict();
$(window).bind('resize', function ($) {
	"use strict";
	build_header();
	init_popover();
	fit_ajaxloader();
});

$(window).load(function () {
	"use strict";
	jQuery('#loading-effect').fadeOut(1000);
	//$('.loading-content').fadeOut();
	fit_ajaxloader();
	adjust_puzzle_size();
});

$(document).ready(function ($) {
	"use strict";

	init_testimonials();
	init_clients_carousel();
	init_portfolio_isotope();
	init_portfolio_carousel();
	init_image_slider();
	init_magnific_popup();
	if (!/Android|webOS|iPhone|iPod|iPad|BlackBerry/i.test(navigator.userAgent)) {
        init_animated_effects();
    }
	init_fitvids();
	init_popover();

	if ($('#map_canvas').length) {
		google.maps.event.addDomListener(window, 'load', init_googlemap);
	}
	init_postSlider();
	init_back2Top();
	init_tooltips();
	
	
	/*--------------------------------------------------/
	/  =  Responsive Menu Init
	/--------------------------------------------------*/

	// var $wrapper = $('body #page-content'),
	var $wrapper = $('body > .container'),
	nav = $('.mobile-nav').length ? $('.mobile-nav').removeClass('hidden') : $('#main-menu > .menu-container').clone(true, true).attr('id', '').addClass('mobile-nav').removeClass('nav dropdown');
	
	$wrapper.wrap('<div class="mp-container" />');
	$wrapper.wrap('<div class="mp-pusher" id="mp-pusher" />');
	$wrapper.wrap('<div class="scroller" />');
	$wrapper.wrap('<div class="scroller-inner" />');

	$('#mp-pusher').prepend('<nav id="mp-menu" class="mp-menu" />');

	$('nav.mp-menu').append(nav);

	$('nav#mp-menu').find('.menu-container').each( function() {
		$(this).addClass('mp-level');
	}),
	$('nav#mp-menu').find('.mp-level').each( function() {
		$(this).removeClass('menu-container');
	});
	new mlPushMenu( document.getElementById( 'mp-menu' ), document.getElementById( 'trigger' ) );
	
	
	
	/*-------------------------------------------------*/
	/* =  Puzzle Square Size
	/*-------------------------------------------------*/
	
	var minumumHeight = $(window).height();
	$('#ajax-container').css({'min-height':minumumHeight});
	
	var itemWidth = $('.flip-item').width();
	var delay = 80;
	var counter = 0;
	$('.flip-item').each(function() {
	
		// Set Section and Items Height to Make Them Square
		counter++;
		var current_item = $(this);
		$(this).animate({'min-height':itemWidth*0.9}, 'slow', function() {
			var ajaxContainerHeight = $('#ajax-loader').height();
			$('#ajax-container').css({'min-height':ajaxContainerHeight});		
		});
		
		// Give a random color to each element
		// var randomColor = true; // randomColor and randomHue are defined in random[Color].js
		if ( randomColor ) {
			jQuery('.flip-content.iconned').each( function() {
				var randomX = Math.random();
				// Math.floor ( [Level of Change] x random ) Base Color
				
				if ( tmq_script_vars.tmq_random_hue == 'on' ) {
					// Random Hue is ON - Each of RGB Colors will change differently
					var rhue = Math.floor( 40*Math.random() ) + randomHue[0]; 
					var ghue = Math.floor( 40*Math.random() ) + randomHue[1]; 
					var bhue = Math.floor( 40*Math.random() ) + randomHue[2]; 			
				} else {
					// Random Hue is OFF - RGB Colors will change the same
					var rhue = Math.floor( 40*randomX ) + randomHue[0]; 
					var ghue = Math.floor( 40*randomX ) + randomHue[1]; 
					var bhue = Math.floor( 40*randomX ) + randomHue[2];				
				}
				
				var hue = 'rgb(' + rhue + ',' + ghue + ',' + bhue + ')';
				jQuery(this).css({'background-color': hue}, 500);
			});	
		}
		
		// Loading Effect
		setTimeout( function() {
			$(current_item).addClass('images-loaded');
		}, delay*counter);
	});
	
	  
	//Initialize All Scripts 
	try {
		init_headscroll();
	} catch(err) {
		//console.log(err);
	}
});


function init_portfolio_isotope() {

	/*-------------------------------------------------*/
	/* =  portfolio isotope
	/*-------------------------------------------------*/

	var winDow = $(window);
		// Needed variables
		var $container=$('.isotope');
		var $filter=$('.filter');

		try{
			$container.imagesLoaded( function(){
				$container.fadeIn();
				$container.isotope({
					filter:'*',
					layoutMode:'masonry',
					animationOptions:{
						duration:750,
						easing:'linear'
					}
				});
			});
		} catch(err) {
		}

		winDow.bind('resize', function(){
			var selector = $filter.find('a.active').attr('data-filter');

			try {
				$container.isotope({ 
					filter	: selector,
					animationOptions: {
						duration: 750,
						easing	: 'linear',
						queue	: false,
					}
				});
			} catch(err) {
			}
			return false;
		});
		
		// Isotope Filter 
		$filter.find('a').on('click', function(){
			var selector = $(this).attr('data-filter');

			try {
				$container.isotope({ 
					filter	: selector,
					animationOptions: {
						duration: 750,
						easing	: 'linear',
						queue	: false,
					}
				});
			} catch(err) {

			}
			return false;
		});


		var filterItemA	= $('.filter li a');

		filterItemA.on('click', function(){
			var $this = $(this);
			if ( !$this.hasClass('active')) {
				filterItemA.removeClass('active');
				$this.addClass('active');
			}
		});
}

function init_googlemap() {

	/*-------------------------------------------------*/
	/* =  Initialize Google Map
	/*-------------------------------------------------*/	
	
	// Set Lat & Long
	var myLatlng = new google.maps.LatLng(-37.817090, 144.955557);
	
	// Set Convas and Map Options
	var mapCanvas = document.getElementById('map_canvas');
	var mapOptions = {
		center: myLatlng,
		zoom: 16,
		mapTypeId: google.maps.MapTypeId.ROAD
	}
	
	// Set Map Object
	var map = new google.maps.Map(mapCanvas, mapOptions);
	
	// Set Marker
	var marker = new google.maps.Marker({
		position: myLatlng,
		map: map,
		title: 'Envato pty is Here!'
	});
	
	// Set Info Box
	var contentString = '<div id="map-content"><h3>Envato pty is Here!</h3><p>We create awesome websites with WordPress Themes and Site HTMLs. This is awesome! We create awesome websites with WordPress Themes and Site HTMLs. This is awesome!</p></div>';

	var infowindow = new google.maps.InfoWindow({
		content: contentString,
		maxWidth: 400
	});		

	// Assign Info Box to Marker Click
	google.maps.event.addListener(marker, 'click', function() {
		infowindow.open(map,marker);
	});	  

	// Customize Map Style
	map.set('styles', [
		{
			featureType: "all",
			stylers: [
			]
		},{
			featureType: 'road',
			elementType: 'geometry',
			stylers: [
			]
		}
	]);
}


function init_portfolio_carousel() {
	/*-------------------------------------------------*/
	/* =  portfolio OWL Carousel
	/*-------------------------------------------------*/	

	try {
		$(".cols_4_owl").owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: false,
			dots: false,
			nav: true,
			navText: ['', ''],
			items : 4,
			loop: true,
			responsive:{
				0:{
					items:1
				},
				787:{
					items:2
				},
				979:{
					items:3
				},
				1199:{
					items:4
				}
			}			
		});
		
		// Start 3 Cols Versions
		$(".cols_3_owl").owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: false,
			dots: false,
			nav: true,
			navText: ['', ''],
			items : 3,
			loop: true,
			responsive:{
				0:{
					items:1
				},
				787:{
					items:2
				},
				979:{
					items:3
				},
				1199:{
					items:3
				}
			}			
		});	
		
		// Start 2 Cols Versions
		$(".cols_2_owl").owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: false,
			dots: false,
			nav: true,
			navText: ['', ''],
			items : 2,
			loop: true,
			responsive:{
				0:{
					items:1
				},
				787:{
					items:2
				},
				979:{
					items:2
				},
				1199:{
					items:2
				}
			}			
		});	
		
		// Start 1 Col Versions
		$(".cols_1_owl").owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: false,
			dots: false,
			nav: true,
			navText: ['', ''],
			items : 1,
			singleItem : true,
			loop: true,
			responsive:{
				0:{
					items:1
				},
				787:{
					items:1
				},
				979:{
					items:1
				},
				1199:{
					items:1
				}
			}			
		});
	} catch(err) {

	}
}

function init_testimonials() {
	/*-------------------------------------------------*/
	/* =  Testimonials OWL Carousel
	/*-------------------------------------------------*/	

	try {
		$(".testimonials-slider").owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			nav:false,
			autoplayHoverPause: false,
			dots: true,
			items : 1,
			singleItem : true,
			autoHeight : true,
			animateOut: 'fadeOutDown',
			animateIn: 'fadeInUp',
			loop: true
		});
	} catch(err) {
	
	}
}

function init_clients_carousel() {

	/*-------------------------------------------------*/
	/* =  Clients OWL Carousel
	/*-------------------------------------------------*/	

	try {
		$(".clients-slider").owlCarousel({

			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: false,
			nav:false,
			dots: true,
			items : 6,
			loop: true,
			margin: 30,
			responsiveClass:true,
			responsive:{
				0:{
					items:1,
					nav:false
				},
				600:{
					items:3,
					nav:false
				},
				1000:{
					items:5,
					nav:false
				}
			}		
		});
	} catch(err) {

	}
}

function init_image_slider() {
	/*-------------------------------------------------*/
	/* =  Image Slider with OWL Slider
	/*-------------------------------------------------*/	

	try {
		$(".image-slider").on('initialize.owl.carousel', function(e) {
			// Fix first item is hidden bug in OWL Carousel
			setTimeout( function() {
				$(e.target).trigger('next.owl.carousel');
			} , 100 );
			
		}).owlCarousel({
			autoplay: true,
			autoplayTimeout: 5000,
			autoplayHoverPause: true,
			nav:true,
			navText: ['', ''],
			stopOnHover: true,
			loop: true,
			autoHeight: true,
			dots: true,
			animateOut: 'fadeOutDown',
			animateIn: 'fadeInUp',
			items : 1
		});
	} catch(err) {

	}
}

function init_magnific_popup() {
	/* ---------------------------------------------------------------------- */
	/*	magnific-popup
	/* ---------------------------------------------------------------------- */

	try {
		// Example with multiple objects
		$('.zoom').magnificPopup({
			type: 'image',
			gallery: {
				enabled: true
			}
		});
	} catch(err) {

	}

	try {
		// Example with multiple objects
		$('.zoom.video').magnificPopup({
			type: 'iframe',
			gallery: {
				enabled: true
			}
		});
	} catch(err) {

	}	
}

function init_animated_effects() {
	/*-------------------------------------------------*/
	/* =  Animated Effect
	/*-------------------------------------------------*/
	try {
		/* ================ ANIMATED CONTENT ================ */
        if ($(".animated")[0]) {
            $('.animated').css('opacity', '0');
        }

        $('.triggerAnimation').waypoint(function() {
            var animation = $(this).attr('data-animate');
            $(this).css('opacity', '');
            $(this).addClass("animated " + animation);

        },
                {
                    offset: '88%',
                    triggerOnce: true
                }
        );
	} catch(err) {

	}		
}

function init_fitvids() {
	/*-------------------------------------------------*/
	/* =  Fit Embeded Videos in Pages (YouTube/Vimeo)
	/*-------------------------------------------------*/	
	try {
		// Init FitVids
		$('.blog-grid-item').fitVids();
		$('.videoplay').fitVids();
	 } catch(err) {
		
	 }
}

function adjust_puzzle_size() {
	/*-------------------------------------------------*/
	/* =  Set Image size of each item in flip menu base
	/*    Image Size
	/*-------------------------------------------------*/	
	
	$('.flip-item').each(function() {
		
		// Fit Images in Square
		$(this).find('img').each( function() {
			if ( $(this).width() > $(this).height() ) {
				// Landscape
				$(this).height('100%');
				$(this).css({width:'auto'});
			} else {
				// Portrait
				$(this).width('100%');
				$(this).css({height:'auto'});
			}
		});
	});
}


function build_header() {
	/*-------------------------------------------------*/
	/* =  Set Header Responsive Size in Small Screens
	/*-------------------------------------------------*/	

	try {
		//if ( jQuery('.navbar-right li#ajax-b1').hasClass('active') && jQuery(window).width() < 481 ) {
		if ( jQuery(window).width() < 481 ) {
			// It's in a ajax loaded page and screen is small
			jQuery('body.page-template-onepage-php').css({'padding-top':'190px'});
			jQuery('body.page-template-onepage-php header.active .navbar-inverse').css({'min-height':'150px'});	
		} else {
			// It's clicked on close or back to home
			jQuery('body.page-template-onepage-php').css({'padding-top':'120px'});
			jQuery('body.page-template-onepage-php header.active .navbar-inverse').css({'min-height':'70px'});
		}
	} catch(err) {
	
	}
}


function build_nav( $action, $nav_item, $link) {
	/*-------------------------------------------------*/
	/* =  Rebuild Ajax Navigation Buttons - OnePage V.
	/*-------------------------------------------------*/	

	try {

		// Define Navigation Buttons
		if ( $nav_item == 'prev' ) {
			$parent = jQuery('.navbar-right li#ajax-b3');
			$elem = jQuery('.navbar-right li a.link-prev');
			
		} else if ( $nav_item == 'next' ) {
			$parent = jQuery('.navbar-right li#ajax-b4');
			$elem = jQuery('.navbar-right li a.link-next');
			
		} else if ( $nav_item == 'index' ) {
			$parent = jQuery('.navbar-right li#ajax-b2');
			$elem = jQuery('.navbar-right li a.link-index');
		}	
		
		if ( $action == 'show' ) {
			// Show Button
			$elem.attr('href', $link);
			$elem.addClass('active');
			$parent.addClass('active');
		} else {
			// Hide button
			$elem.attr('href', '#');
			$elem.removeClass('active');
			$parent.removeClass('active');
		}

		
		// Read Current Situation
		var items_length = jQuery('.navbar-right li.active').length + 1;
		// Set Home Button Position
		jQuery('.navbar-right li').not('.active').not('#search').css({'right': 0, 'display': 'none'});
		jQuery('.navbar-right li#ajax-b1').css({'right': ( 60 * items_length ) + 'px'});

		jQuery('.navbar-right li.active').each( function() {
			// Shift buttons
			items_length--;
			jQuery(this).css({'right': ( 60 * items_length ) + 'px', 'display': 'inline-block'});
		});
		
	} catch(err) {

	}
}

function init_popover() {

	/*-------------------------------------------------*/
	/* =  Initialize Popover Used for Search Box
	/*-------------------------------------------------*/
	
	$('#search').popover('destroy');
	if ( jQuery(window).width() < 481 ) {
		var popover_position = 'bottom';
	} else {
		var popover_position = 'left';
	}
	$('#search').popover({
		html: true,
		placement: popover_position,
		container: 'body',
		content: function() {
			return $("#popover-content").html();
		}
	});
}


var homeURL = window.location.href;
var isbacked = 0;


function fit_ajaxloader() {

	/*-------------------------------------------------*/
	/* =  Fit Ajax Loader Height On Page Load
	/*-------------------------------------------------*/
	
	var $flip_menu_height = jQuery('#ajax-loader').outerHeight();
	jQuery('#ajax-container').css({'min-height':$flip_menu_height});
}


function randsort(c) {

	/*-------------------------------------------------*/
	/* = Generate a random order for these elements (actually for timeout)
	/*-------------------------------------------------*/
	var o = new Array();
	for (var i = 0; i < c; i++) {
		var n = Math.floor(Math.random()*c);
		if( jQuery.inArray(n, o) > 0 ) --i;
		else o.push(n);
	}
	return o;
}

jQuery('.flip-item a').on('click', function() {
	// Keep the href url for none ajax loaders
	var myhref = jQuery(this).attr('href');
	if( jQuery(this).prop('rel').length <= 0 ) {
		/*-------------------------------------------------*/
		/* = Click Event to Flip Out items and Show Content
		/*-------------------------------------------------*/

		// Show Loading in pageContent area
		if ( OnePageAjax === 'on' ) {
			jQuery('#page-content').html('<div class="loading-content inner"><div id="stage"><p id="spinner"><img src="' + tmq_script_vars.tmq_getrootdir + '"><BR><BR>Loading...</p></div></div>');
		}
		
		// Hide Remained Bootstrap Tooltips // Bootstrap Bug
		hideBootstrapToolTips();
		
		// Refresh homepage on back button
		isbacked = 1;
		
		// Delayed flip for all elements
		var $elem = jQuery('.flip-menu');
		var tmq_srvelem = $elem.find('.flip-item'); // The elements we're searching
		var tmq_srvcount = tmq_srvelem.size() // Total number of those elements
		var tmq_randorder = randsort(tmq_srvcount) // an array of the element indices in random order
		
		// Rotate all <i> elements
		$elem.find('.flip-item').each( function(i) {
			var $current_item = this;
			setTimeout( function() { 
				jQuery($current_item).addClass('active');
			} , 80*tmq_randorder[i] );
		});
		
		// Show Back to Home Button
		jQuery('.navbar-right li#ajax-b1').addClass('active');
		
		// Add active class to ajax loader after all of above
		jQuery('#page-content').fadeIn(1000);
		jQuery('#ajax-loader').css({'background-color':'transparent'});
		setTimeout( function() {
			jQuery('#ajax-loader').hide();
		}, 80*(tmq_srvcount-1));
		
		// Ajax is off only use loading effect
		if ( OnePageAjax === 'off' ) {
			jQuery('#loading-effect').html('<div class="loading-content inner"><div id="stage"><p id="spinner"><img src="' + tmq_script_vars.tmq_getrootdir + '"><BR><BR>Loading...</p></div></div>');
			jQuery('#loading-effect').fadeIn(1500, function() {
				window.location.href = myhref;
			});
			return false;
		}
		
	} else {
        window.open($(this).attr('href'));
        return false;
    }
});

jQuery('body.page-template-onepage-php').on('click', '.tmq_closeserv', function(e) {
	/*-------------------------------------------------*/
	/* = Click Event on Home Button
	/*-------------------------------------------------*/
	
	e.preventDefault();
	// Hide Remained Bootstrap Tooltips // Bootstrap Bug
	hideBootstrapToolTips();
	// Hide Back to Home Button
	// jQuery('.navbar-right li a.tmq_closeserv').animate({opacity:'0'}).css({display:'none'});
	isbacked = 0;
	build_nav( 'hide', 'prev', '' );
	build_nav( 'hide', 'next', '' );
	build_nav( 'hide', 'index', '' );
	jQuery('.navbar-right li#ajax-b1').css({'right': '0px', 'display': 'none'});
	jQuery('.navbar-right li#ajax-b1').removeClass('active');
	build_header();			

	jQuery('#ajax-loader').animate({backgroundColor:'rgba(0,0,0,0.7)'},'slow');
	jQuery('#ajax-loader').show();
	jQuery('#page-content').fadeOut(1000);
	
	// Push Home URL in history
	if (History && History.pushState){
		History.pushState(null, '', homeURL);
	}
	
	var $elem = jQuery('.flip-menu');
	var tmq_srvelem = $elem.find('.flip-item'); // The elements we're searching
	var tmq_srvcount = tmq_srvelem.size() // Total number of those elements
	var tmq_randorder = randsort(tmq_srvcount) // an array of the element indices in random order
	
	// Rotate all <i> elements
	$elem.find('.flip-item').each( function(i) {
		var $current_item = this;
		setTimeout( function() { 
			jQuery($current_item).removeClass('active');
		} , 80*tmq_randorder[i] );
	});
});

jQuery(window).on('popstate', function(event) {
	
	/*-------------------------------------------------*/
	/* = Reload page when user clicks on back button - 
	/* to let it show flip menu again
	/*-------------------------------------------------*/
	
	if ( homeURL == window.location.href && isbacked == 1) {
		location.reload();
	}
});	


function hideBootstrapToolTips() {
	/*-------------------------------------------------*/
	/* = Hide All ToolTips
	/*-------------------------------------------------*/
	jQuery('.tooltip').each( function() {
		jQuery(this).hide();
	});
}

function init_postSlider(act) {

	/*-------------------------------------------------*/
	/* = Post Slider with OWL Carousel
	/*-------------------------------------------------*/
	var sync1 = $(".slides");

	var slides = sync1.on('initialized.owl.carousel', function(e) {
		if ( act == 'ajax' ) {
			$('.post-slider .slides img').show();
			$(document).ready(function() {
				var caroMaxHeight = 470;
				var caroCounter = 0;
				$(e.target).find('.item img').each(function() {
					caroCounter++;
					if (parseInt($(this).height()) > caroMaxHeight) {
						caroMaxHeight = parseInt($(this).height());
					}
				});
				$(e.target).parents('.post-slider').find('.thumbs .item').each( function() {
					$(this).outerHeight(caroMaxHeight/caroCounter);
				});
				$(e.target).parents('.post-slider').css({'opacity':'1'});
			});
		} else {
			$('.post-slider .slides img').show();
			$(window).load(function() {
				var caroMaxHeight = 470;
				var caroCounter = 0;
				$(e.target).find('.item img').each(function() {
					caroCounter++;
					if (parseInt($(this).height()) > caroMaxHeight) {
						caroMaxHeight = parseInt($(this).height());
					}
				});
				$(e.target).parents('.post-slider').find('.thumbs .item').each( function() {
					$(this).outerHeight(caroMaxHeight/caroCounter);
				});
				$(e.target).parents('.post-slider').css({'opacity':'1'});
			});		
		}
	}).owlCarousel({
		autoplay: true,
		autoplayTimeOut: 9000,
		margin: 10,
		items: 1,
		nav:false,
		dots:false,
		animateOut: 'fadeOut',
		animateIn: 'fadeIn'
	}).on('changed.owl.carousel', function(e) {
		var current_slider = $(e.target).parents('.post-slider');
		setTimeout( function() {
			$(current_slider).find('.thumbs .active').removeClass('active');
			$(current_slider).find('.slides .owl-item').each(function(index) {
				if($(this).hasClass('active')) {
					$(current_slider).find('.thumbs .item:nth-child('+(index+1)+')').removeClass('active').addClass('active');
				}  
			});
		
		} , 100 );
	}).data('owl.carousel');
	
	$('.thumbs').on('click', '.item', function(e) {
		var goToSlide = $(e.target).parents('.item').index();
		if ( goToSlide == -1 ) {
			// User did not click on an element inside .item so get itself!
			goToSlide = $(e.target).index();
		}
		$(this).parents('.post-slider').find('.slides').trigger('to.owl.carousel', [goToSlide, 0, true]);
	});
}

	
function init_back2Top() {
/*-------------------------------------------------*/
/* = Back to Top Button
/*-------------------------------------------------*/

	try {
		$(window).scroll(function() {
			if ($(this).scrollTop() > 300) {
				$('#back-to-top').addClass('active');
			} else {
				$('#back-to-top').removeClass('active');
			}
		});
		
		$("#back-to-top").on('click', function(e) {
			e.preventDefault();
			$('html, body').animate({scrollTop: 0}, 'slow');
		});
	} catch(err) {
	
	}
}

function init_tooltips() {
	/*-------------------------------------------------*/
	/* = ToolTip and Smooth Scroll
	/*-------------------------------------------------*/

	try {
		jQuery('.blog-grid-controls a').tooltip({placement: 'top', delay: 100, container: 'body'});
		jQuery('.footer-social a').tooltip({delay: 100});
		jQuery('.navbar-right a').tooltip({placement: 'bottom', delay: 50, container: 'body'});
		jQuery('.team-social a').tooltip({placement: 'top', delay: 50, container: 'body'});
		jQuery('.clients-slider a').tooltip({placement: 'top', delay: 50, container: 'body'});
	} catch(err) {
	
	}

	/* Smooth Scroll */
	if (tmq_script_vars.plugins_scroll == 'on') {
		try {
			jQuery.browserSelector();
			// Adds window smooth scroll on chrome.
			if(jQuery("html").hasClass("chrome")) {
				jQuery.smoothScroll();
			}
		} catch(err) {

		}
	}
}

function init_headscroll() {
	/*-------------------------------------------------*/
	/* = Header animate after scroll
	/*-------------------------------------------------*/
	if (tmq_script_vars.sticky_menu == 'on') {
		var docElem = document.documentElement,
		didScroll = false,
		changeHeaderOn = 40;
		document.querySelector( 'header' );
		
		function tmq_moveheader() {
			window.addEventListener( 'scroll', function() {
				if( !didScroll ) {
					didScroll = true;
					setTimeout( scrollPage, 50 );
				}
			}, false );
		}
		
		function scrollPage() {
			var sy = scrollY();
			if ( sy >= changeHeaderOn ) {
				jQuery( 'header' ).addClass('active');
			}
			else {
				jQuery( 'header' ).removeClass('active');
			}
			didScroll = false;
		}
		
		function scrollY() {
			return window.pageYOffset || docElem.scrollTop;
		}
		
		tmq_moveheader();
	}
}

// Share This Buttons
function tmq_shareThis(site,url) {
	var shareWindow=null;
	switch (site) {
		case 'facebook':
			site = 'http://www.facebook.com/sharer.php?u=';
			break;
		case 'twitter':
			site = 'https://twitter.com/intent/tweet?original_referer=';
			break;
		case 'google':
			site = 'https://plus.google.com/share?url=';
			break;
		case 'pinterest':
			site = 'http://pinterest.com/pin/create/button/?url=';
			break;
		case 'linkedin':
			site = 'https://www.linkedin.com/shareArticle?url=';
			break;
		case 'reddit':
			site = 'http://www.reddit.com/submit?url=';
			break;
		case 'stumbleupon':
			site = 'http://www.stumbleupon.com/submit?url=';
			break;
		case 'delicious':
			site = 'http://delicious.com/save?v=5&noui&jump=close&url=';
			break;
		default:
			break;
	}
	shareWindow = window.open(site + encodeURI(url) ,'shareThis','width=640,height=380');
}

/* Visual Composer Compatibility in Ajax Mode */

var vc_js = function () {
  vc_twitterBehaviour();
  vc_toggleBehaviour();
  vc_tabsBehaviour();
  vc_accordionBehaviour();
  vc_teaserGrid();
  vc_carouselBehaviour();
  vc_slidersBehaviour();
  vc_prettyPhoto();
  vc_googleplus();
  vc_pinterest();
  vc_progress_bar();
  vc_plugin_flexslider();
  vc_google_fonts();
  window.setTimeout(vc_waypoints, 1500);
};
jQuery(document).ready(function ($) {
  window.vc_js();
}); // END jQuery(document).ready

if (typeof window['vc_plugin_flexslider'] !== 'function') {
  function vc_plugin_flexslider($parent) {
    var $slider = $parent ? $parent.find('.wpb_flexslider') : jQuery('.wpb_flexslider');
    $slider.each(function () {
      var this_element = jQuery(this);
      var sliderSpeed = 800,
        sliderTimeout = parseInt(this_element.attr('data-interval')) * 1000,
        sliderFx = this_element.attr('data-flex_fx'),
        slideshow = true;
      if (sliderTimeout == 0) slideshow = false;

      this_element.is(':visible') && this_element.flexslider({
        animation:sliderFx,
        slideshow:slideshow,
        slideshowSpeed:sliderTimeout,
        sliderSpeed:sliderSpeed,
        smoothHeight:true
      });
    });
  }
}

/* Twitter
 ---------------------------------------------------------- */
if (typeof window['vc_twitterBehaviour'] !== 'function') {
  function vc_twitterBehaviour() {
    jQuery('.wpb_twitter_widget .tweets').each(function (index) {
      var this_element = jQuery(this),
        tw_name = this_element.attr('data-tw_name');
      tw_count = this_element.attr('data-tw_count');

      this_element.tweet({
        username:tw_name,
        join_text:"auto",
        avatar_size:0,
        count:tw_count,
        template:"{avatar}{join}{text}{time}",
        auto_join_text_default:"",
        auto_join_text_ed:"",
        auto_join_text_ing:"",
        auto_join_text_reply:"",
        auto_join_text_url:"",
        loading_text:'<span class="loading_tweets">loading tweets...</span>'
      });
    });
  }
}

/* Google plus
 ---------------------------------------------------------- */
if (typeof window['vc_googleplus'] !== 'function') {
  function vc_googleplus() {
    if (jQuery('.wpb_googleplus').length > 0) {
      (function () {
        var po = document.createElement('script');
        po.type = 'text/javascript';
        po.async = true;
        po.src = 'https://apis.google.com/js/plusone.js';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(po, s);
      })();
    }
  }
}

/* Pinterest
 ---------------------------------------------------------- */
if (typeof window['vc_pinterest'] !== 'function') {
  function vc_pinterest() {
    if (jQuery('.wpb_pinterest').length > 0) {
      (function () {
        var po = document.createElement('script');
        po.type = 'text/javascript';
        po.async = true;
        po.src = 'http://assets.pinterest.com/js/pinit.js';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(po, s);
        //<script type="text/javascript" src="//assets.pinterest.com/js/pinit.js"></script>
      })();
    }
  }
}

/* Progress bar
 ---------------------------------------------------------- */
if (typeof window['vc_progress_bar'] !== 'function') {
  function vc_progress_bar() {
    if (typeof jQuery.fn.waypoint !== 'undefined') {

      jQuery('.vc_progress_bar').waypoint(function () {
        jQuery(this).find('.vc_single_bar').each(function (index) {
          var $this = jQuery(this),
            bar = $this.find('.vc_bar'),
            val = bar.data('percentage-value');

          setTimeout(function () {
            bar.css({"width":val + '%'});
          }, index * 200);
        });
      }, { offset:'85%' });
    }
  }
}

/* Waypoints magic
 ---------------------------------------------------------- */
if (typeof window['vc_waypoints'] !== 'function') {
  function vc_waypoints() {
    if (typeof jQuery.fn.waypoint !== 'undefined') {
      jQuery('.wpb_animate_when_almost_visible:not(.wpb_start_animation)').waypoint(function () {
        jQuery(this).addClass('wpb_start_animation');
      }, { offset:'85%' });
    }
  }
}

/* Toggle
 ---------------------------------------------------------- */
if (typeof window['vc_toggleBehaviour'] !== 'function') {
  function vc_toggleBehaviour() {
    jQuery(".wpb_toggle").unbind('click').click(function (e) {
      if (jQuery(this).next().is(':animated')) {
        return false;
      }
      if (jQuery(this).hasClass('wpb_toggle_title_active')) {
        jQuery(this).removeClass('wpb_toggle_title_active').next().slideUp(500);
      } else {
        jQuery(this).addClass('wpb_toggle_title_active').next().slideDown(500);
      }
    });
    jQuery('.wpb_toggle_content').each(function (index) {
      if (jQuery(this).next().is('h4.wpb_toggle') == false) {
        jQuery('<div class="last_toggle_el_margin"></div>').insertAfter(this);
      }
    });
  }
}

/* Tabs + Tours
 ---------------------------------------------------------- */
if (typeof window['vc_tabsBehaviour'] !== 'function') {
  function vc_tabsBehaviour($tab) {
    jQuery(function ($) {
      $(document.body).off('click.preview', 'a')
    });
    var $call = $tab || jQuery('.wpb_tabs, .wpb_tour'),
      ver = jQuery.ui && jQuery.ui.version ? jQuery.ui.version.split('.') : '1.10',
      old_version = parseInt(ver[0]) == 1 && parseInt(ver[1]) < 9;
    // if($call.hasClass('ui-widget')) $call.tabs('destroy');
    $call.each(function (index) {
      var $tabs,
        interval = jQuery(this).attr("data-interval"),
        tabs_array = [];
      //
      $tabs = jQuery(this).find('.wpb_tour_tabs_wrapper').tabs({
        show:function (event, ui) {
          wpb_prepare_tab_content(event, ui);
        },
        beforeActivate: function(event, ui) {
          ui.newPanel.index() !== 1 && ui.newPanel.find('.vc_pie_chart:not(.vc_ready)');
        },
        activate:function (event, ui) {
          wpb_prepare_tab_content(event, ui);
        }
      }).tabs('rotate', interval * 1000);

      jQuery(this).find('.wpb_tab').each(function () {
        tabs_array.push(this.id);
      });

      jQuery(this).find('.wpb_tabs_nav a').click(function (e) {
        e.preventDefault();
        if (jQuery.inArray(jQuery(this).attr('href'), tabs_array)) {
          if (old_version) {
            $tabs.tabs("select", jQuery(this).attr('href'));
          } else {
            $tabs.tabs("option", "active", jQuery(jQuery(this).attr('href')).index() - 1);
          }
          return false;
        }
      });

      jQuery(this).find('.wpb_prev_slide a, .wpb_next_slide a').click(function (e) {
        e.preventDefault();
        if (old_version) {
          var index = $tabs.tabs('option', 'selected');
          if (jQuery(this).parent().hasClass('wpb_next_slide')) {
            index++;
          }
          else {
            index--;
          }
          if (index < 0) {
            index = $tabs.tabs("length") - 1;
          }
          else if (index >= $tabs.tabs("length")) {
            index = 0;
          }
          $tabs.tabs("select", index);
        } else {
          var index = $tabs.tabs("option", "active"),
            length = $tabs.find('.wpb_tab').length;

          if (jQuery(this).parent().hasClass('wpb_next_slide')) {
            index = (index + 1) >= length ? 0 : index + 1;
          } else {
            index = index - 1 < 0 ? length - 1 : index - 1;
          }

          $tabs.tabs("option", "active", index);
        }

      });

    });
  }
}

/* Tabs + Tours
 ---------------------------------------------------------- */
if (typeof window['vc_accordionBehaviour'] !== 'function') {
  function vc_accordionBehaviour() {
    jQuery('.wpb_accordion').each(function (index) {
      var $tabs,
        interval = jQuery(this).attr("data-interval"),
        active_tab = !isNaN(jQuery(this).data('active-tab')) && parseInt(jQuery(this).data('active-tab')) > 0 ? parseInt(jQuery(this).data('active-tab')) - 1 : false,
        collapsible = active_tab === false || jQuery(this).data('collapsible') === 'yes';
      //
      $tabs = jQuery(this).find('.wpb_accordion_wrapper').accordion({
        header:"> div > h3",
        autoHeight:false,
        heightStyle:"content",
        active:active_tab,
        collapsible:collapsible,
        navigation:true,
        activate: vc_accordionActivate,
        change:function (event, ui) {
          if (jQuery.fn.isotope != undefined) {
            ui.newContent.find('.isotope').isotope("layout");
          }
          vc_carouselBehaviour(ui.newPanel);
        }
      });
      //.tabs().tabs('rotate', interval*1000, true);
    });
  }
}

/* Teaser grid: isotope
 ---------------------------------------------------------- */
if (typeof window['vc_teaserGrid'] !== 'function') {
  function vc_teaserGrid() {
    var layout_modes = {
      fitrows:'fitRows',
      masonry:'masonry'
    }
    jQuery('.wpb_grid .teaser_grid_container:not(.wpb_carousel), .wpb_filtered_grid .teaser_grid_container:not(.wpb_carousel)').each(function () {
      var $container = jQuery(this);
      var $thumbs = $container.find('.wpb_thumbnails');
      var layout_mode = $thumbs.attr('data-layout-mode');
      $thumbs.isotope({
        // options
        itemSelector:'.isotope-item',
        layoutMode:(layout_modes[layout_mode] == undefined ? 'fitRows' : layout_modes[layout_mode])
      });
      $container.find('.categories_filter a').data('isotope', $thumbs).click(function (e) {
        e.preventDefault();
        var $thumbs = jQuery(this).data('isotope');
        jQuery(this).parent().parent().find('.active').removeClass('active');
        jQuery(this).parent().addClass('active');
        $thumbs.isotope({filter:jQuery(this).attr('data-filter')});
      });
      jQuery(window).bind('load resize', function () {
        $thumbs.isotope("layout");
      });
    });

    /*
     var isotope = jQuery('.wpb_grid ul.thumbnails');
     if ( isotope.length > 0 ) {
     isotope.isotope({
     // options
     itemSelector : '.isotope-item',
     layoutMode : 'fitRows'
     });
     jQuery(window).load(function() {
     isotope.isotope("layout");
     });
     }
     */
  }
}

if (typeof window['vc_carouselBehaviour'] !== 'function') {
  function vc_carouselBehaviour($parent) {
    var $carousel = $parent ? $parent.find(".wpb_carousel") : jQuery(".wpb_carousel");
    $carousel.each(function () {
      var $this = jQuery(this);
      if ($this.data('carousel_enabled') !== true && $this.is(':visible')) {
        $this.data('carousel_enabled', true);
        var carousel_width = jQuery(this).width(),
          visible_count = getColumnsCount(jQuery(this)),
          carousel_speed = 500;
        if (jQuery(this).hasClass('columns_count_1')) {
          carousel_speed = 900;
        }
        /* Get margin-left value from the css grid and apply it to the carousele li items (margin-right), before carousele initialization */
        var carousele_li = jQuery(this).find('.wpb_thumbnails-fluid li');
        carousele_li.css({"margin-right":carousele_li.css("margin-left"), "margin-left":0 });

        jQuery(this).find('.wpb_wrapper:eq(0)').jCarouselLite({
          btnNext:jQuery(this).find('.next'),
          btnPrev:jQuery(this).find('.prev'),
          visible:visible_count,
          speed:carousel_speed
        })
          .width('100%');//carousel_width

        var fluid_ul = jQuery(this).find('ul.wpb_thumbnails-fluid');
        fluid_ul.width(fluid_ul.width() + 300);

        jQuery(window).resize(function () {
          var before_resize = screen_size;
          screen_size = getSizeName();
          if (before_resize != screen_size) {
            window.setTimeout('location.reload()', 20);
          }
        });
      }

    });
    /*
     if(jQuery.fn.bxSlider !== undefined ) {
     jQuery('.bxslider').each(function(){
     var $slider = jQuery(this);
     $slider.bxSlider($slider.data('settings'));
     });
     }
     */
    if (window.Swiper !== undefined) {

      jQuery('.swiper-container').each(function () {
        var $this = jQuery(this),
          my_swiper,
          max_slide_size = 0,
          options = jQuery(this).data('settings');

        if (options.mode === 'vertical') {
          $this.find('.swiper-slide').each(function () {
            var height = jQuery(this).outerHeight(true);
            if (height > max_slide_size) max_slide_size = height;
          });
          $this.height(max_slide_size);
          $this.css('overflow', 'hidden');
        }
        jQuery(window).resize(function () {
          $this.find('.swiper-slide').each(function () {
            var height = jQuery(this).outerHeight(true);
            if (height > max_slide_size) max_slide_size = height;
          });
          $this.height(max_slide_size);
        });
        my_swiper = jQuery(this).swiper(jQuery.extend(options, {
          onFirstInit:function (swiper) {
            if (swiper.slides.length < 2) {
              $this.find('.vc_arrow-left,.vc_arrow-right').hide();
            } else if (swiper.activeIndex === 0 && swiper.params.loop !== true) {
              $this.find('.vc_arrow-left').hide();
            } else {
              $this.find('.vc_arrow-left').show();
            }
          },
          onSlideChangeStart:function (swiper) {
            if (swiper.slides.length > 1 && swiper.params.loop !== true) {
              if (swiper.activeIndex === 0) {
                $this.find('.vc_arrow-left').hide();
              } else {
                $this.find('.vc_arrow-left').show();
              }
              if (swiper.slides.length - 1 === swiper.activeIndex) {
                $this.find('.vc_arrow-right').hide();
              } else {
                $this.find('.vc_arrow-right').show();
              }
            }
          }
        }));
        $this.find('.vc_arrow-left').click(function (e) {
          e.preventDefault();
          my_swiper.swipePrev();
        });
        $this.find('.vc_arrow-right').click(function (e) {
          e.preventDefault();
          my_swiper.swipeNext();
        });
        my_swiper.reInit();
      });

    }

  }
}

if (typeof window['vc_slidersBehaviour'] !== 'function') {
  function vc_slidersBehaviour() {
    //var sliders_count = 0;
    jQuery('.wpb_gallery_slides').each(function (index) {
      var this_element = jQuery(this);
      var ss_count = 0;

      /*if ( this_element.hasClass('wpb_slider_fading') ) {
       var sliderSpeed = 500, sliderTimeout = this_element.attr('data-interval')*1000, slider_fx = 'fade';
       var current_ss;

       function slideshowOnBefore(currSlideElement, nextSlideElement, options) {
       jQuery(nextSlideElement).css({"position" : "absolute" });
       jQuery(nextSlideElement).find("div.description").animate({"opacity": 0}, 0);
       }

       function slideshowOnAfter(currSlideElement, nextSlideElement, options) {
       jQuery(nextSlideElement).find("div.description").animate({"opacity": 1}, 2000);

       jQuery(nextSlideElement).css({"position" : "static" });
       var new_h = jQuery(nextSlideElement).find('img').height();
       if ( jQuery.isNumeric(new_h) ) {
       //this_element.animate({ "height" : new_h }, sliderSpeed );
       }
       }

       this_element.find('ul')
       .before('<div class="ss_nav ss_nav_'+ss_count+'"></div><div class="wpb_fading_nav"><a id="next_'+ss_count+'" href="#next"></a> <a id="prev_'+ss_count+'" href="#prev"></a></div>')
       .cycle({
       fx: slider_fx, // choose your transition type, ex: fade, scrollUp, shuffle, etc...
       pause: 1,
       speed: sliderSpeed,
       timeout: sliderTimeout,
       delay: -ss_count * 1000,
       before: slideshowOnBefore,
       after:slideshowOnAfter,
       pager:  '.ss_nav_'+ss_count
       });
       //.find('.description').width(jQuery(this).width() - 20);
       ss_count++;
       }
       else*/
      if (this_element.hasClass('wpb_slider_nivo')) {
        var sliderSpeed = 800,
          sliderTimeout = this_element.attr('data-interval') * 1000;

        if (sliderTimeout == 0) sliderTimeout = 9999999999;

        this_element.find('.nivoSlider').nivoSlider({
          effect:'boxRainGrow,boxRain,boxRainReverse,boxRainGrowReverse', // Specify sets like: 'fold,fade,sliceDown'
          slices:15, // For slice animations
          boxCols:8, // For box animations
          boxRows:4, // For box animations
          animSpeed:sliderSpeed, // Slide transition speed
          pauseTime:sliderTimeout, // How long each slide will show
          startSlide:0, // Set starting Slide (0 index)
          directionNav:true, // Next & Prev navigation
          directionNavHide:true, // Only show on hover
          controlNav:true, // 1,2,3... navigation
          keyboardNav:false, // Use left & right arrows
          pauseOnHover:true, // Stop animation while hovering
          manualAdvance:false, // Force manual transitions
          prevText:'Prev', // Prev directionNav text
          nextText:'Next' // Next directionNav text
        });
      }
      else if (this_element.hasClass('wpb_flexslider') && 1 == 2) { /* TODO: remove this */
        /*
         var sliderSpeed = 800,
         sliderTimeout = this_element.attr('data-interval')*1000,
         sliderFx = this_element.attr('data-flex_fx'),
         slideshow = true;
         if ( sliderTimeout == 0 ) slideshow = false;

         this_element.flexslider({
         animation: sliderFx,
         slideshow: slideshow,
         slideshowSpeed: sliderTimeout,
         sliderSpeed: sliderSpeed,
         smoothHeight: true

         });
         */

        /*
         var $first_object = this_element.find('li:first').show().find('*:not(a)');

         $first_object.bind('load', function() {
         if(!this_element.find('.flex-control-nav').is('ol')) {
         this_element.flexslider({
         animation: sliderFx,
         slideshow: slideshow,
         slideshowSpeed: sliderTimeout,
         sliderSpeed: sliderSpeed,
         smoothHeight: true
         });
         }
         });

         window.setTimeout(function(){
         if(!this_element.find('.flex-control-nav').is('ol')) {
         this_element.flexslider({
         animation: sliderFx,
         slideshow: slideshow,
         slideshowSpeed: sliderTimeout,
         sliderSpeed: sliderSpeed,
         smoothHeight: true
         });
         }
         }, 5000);
         */
      }
      else if (this_element.hasClass('wpb_image_grid')) {
        var isotope = this_element.find('.wpb_image_grid_ul');
        isotope.isotope({
          // options
          itemSelector:'.isotope-item',
          layoutMode:'fitRows'
        });
        jQuery(window).load(function () {
          isotope.isotope("layout");
        });
      }
    });
  }
}

if (typeof window['vc_prettyPhoto'] !== 'function') {
  function vc_prettyPhoto() {
    try {
      // just in case. maybe prettyphoto isnt loaded on this site
      jQuery('a.prettyphoto, .gallery-icon a[href*=".jpg"]').prettyPhoto({
        animationSpeed:'normal', /* fast/slow/normal */
        padding:15, /* padding for each side of the picture */
        opacity:0.7, /* Value betwee 0 and 1 */
        showTitle:true, /* true/false */
        allowresize:true, /* true/false */
        counter_separator_label:'/', /* The separator for the gallery counter 1 "of" 2 */
        //theme: 'light_square', /* light_rounded / dark_rounded / light_square / dark_square */
        hideflash:false, /* Hides all the flash object on a page, set to TRUE if flash appears over prettyPhoto */
        deeplinking:false, /* Allow prettyPhoto to update the url to enable deeplinking. */
        modal:false, /* If set to true, only the close button will close the window */
        callback:function () {
          var url = location.href;
          var hashtag = (url.indexOf('#!prettyPhoto')) ? true : false;
          if (hashtag) location.hash = "!";
        } /* Called when prettyPhoto is closed */,
        social_tools:''
      });
    } catch (err) {
    }
  }
}

if ( typeof window['vc_google_fonts'] !== 'function' ) {
    function vc_google_fonts() {
        return;
    }
}
/* Helper
 ---------------------------------------------------------- */
function getColumnsCount(el) {
  var find = false,
    i = 1;

  while (find == false) {
    if (el.hasClass('columns_count_' + i)) {
      find = true;
      return i;
    }
    i++;
  }
}

var screen_size = getSizeName();
function getSizeName() {
  var screen_size = '',
    screen_w = jQuery(window).width();

  if (screen_w > 1170) {
    screen_size = "desktop_wide";
  }
  else if (screen_w > 960 && screen_w < 1169) {
    screen_size = "desktop";
  }
  else if (screen_w > 768 && screen_w < 959) {
    screen_size = "tablet";
  }
  else if (screen_w > 300 && screen_w < 767) {
    screen_size = "mobile";
  }
  else if (screen_w < 300) {
    screen_size = "mobile_portrait";
  }
  return screen_size;
}


function loadScript(url, $obj, callback) {

  var script = document.createElement("script")
  script.type = "text/javascript";

  if (script.readyState) {  //IE
    script.onreadystatechange = function () {
      if (script.readyState == "loaded" ||
        script.readyState == "complete") {
        script.onreadystatechange = null;
        callback();
      }
    };
  } else {  //Others
    /*
     script.onload = function(){

     callback();
     };
     */
  }

  script.src = url;
  $obj.get(0).appendChild(script);
}

/**
 * Prepare html to correctly display inside tab container
 *
 * @param event - ui tab event 'show'
 * @param ui - jquery ui tabs object
 */

function wpb_prepare_tab_content(event, ui) {
  var panel = ui.panel || ui.newPanel,
      $pie_charts = panel.find('.vc_pie_chart:not(.vc_ready)'),
      $carousel = panel.find('[data-ride="vc_carousel"]'),
      $ui_panel, $google_maps;
  vc_carouselBehaviour();
  vc_plugin_flexslider(panel);
  $pie_charts.length && jQuery.fn.vcChat && $pie_charts.vcChat();
  $carousel.length && jQuery.fn.carousel && $carousel.carousel('resizeAction');
  $ui_panel = panel.find('.isotope');
  $google_maps = panel.find('.wpb_gmaps_widget');
  if ($ui_panel.length > 0) {
    $ui_panel.isotope("layout");
  }
  if ($google_maps.length && !$google_maps.is('.map_ready')) {
    var $frame = $google_maps.find('iframe');
    $frame.attr('src', $frame.attr('src'));
    $google_maps.addClass('map_ready');
  }
  if(panel.parents('.isotope').length) {
    panel.parents('.isotope').each(function(){
      jQuery(this).isotope("layout");
    });
  }
}
var vc_accordionActivate = function(event, ui) {
  var $pie_charts = ui.newPanel.find('.vc_pie_chart:not(.vc_ready)'),
    $carousel = ui.newPanel.find('[data-ride="vc_carousel"]');
  if (jQuery.fn.isotope != undefined) {
    ui.newPanel.find('.isotope').isotope("layout");
  }
  vc_carouselBehaviour(ui.newPanel);
  vc_plugin_flexslider(ui.newPanel);
  $pie_charts.length && jQuery.fn.vcChat && $pie_charts.vcChat();
  $carousel.length && jQuery.fn.carousel && $carousel.carousel('resizeAction');
  if(ui.newPanel.parents('.isotope').length) {
    ui.newPanel.parents('.isotope').each(function(){
      jQuery(this).isotope("layout");
    });
  }
}