<?php
/**
 * Initialize the custom theme options.
 */
add_action( 'admin_init', 'custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 */
function custom_theme_options() {
  /**
   * Get a copy of the saved settings array.
   */
  $saved_settings = get_option( 'option_tree_settings', array() );

  /**
   * Custom settings array that will eventually be
   * passes to the OptionTree Settings API Class.
   */
  $custom_settings = array(
    'contextual_help' => array(
      'sidebar'       => ''
    ),
    'sections'        => array(
      array(
        'id'          => 'general',
        'title'       => 'General',
		'class'		  => 'tmq_icon_general'
      ),
      array(
        'id'          => 'tmq_ajaxonepage',
        'title'       => 'Ajax OnePage',
		'class'		  => 'tmq_icon_ajax'
      ),
      array(
        'id'          => 'tmq_header_sec',
        'title'       => 'Header Options',
		'class'		  => 'tmq_icon_header tmq_blog_bgcolor tmq_block_start block_parent'
      ),
      array(
        'id'          => 'tmq_footer_sec',
        'title'       => 'Footer Settings',
		'class'		  => 'tmq_icon_footer'
      ),	  
      array(
        'id'          => 'tmq_pageoptions_sec',
        'title'       => 'Page Options',
		'class'		  => 'tmq_icon_page tmq_blog_bgcolor tmq_block_start block_parent'
      ),
      array(
        'id'          => 'tmq_blogoptions',
        'title'       => 'Blog Options',
		'class'		  => 'tmq_icon_blog tmq_blog_bgcolor block_parent'
      ),
      array(
        'id'          => 'tmq_portfolio_sec',
        'title'       => 'Portfolio Options',
		'class'		  => 'tmq_icon_portfolio tmq_blog_bgcolor block_parent'
      ),
      array(
        'id'          => 'tmq_search_sec',
        'title'       => 'Search Page Settings',
		'class'		  => 'tmq_icon_search'
      ),
      array(
        'id'          => 'tmq_typography_sec',
        'title'       => 'Typography',
		'class'		  => 'tmq_icon_typography block_parent',
      ),
      array(
        'id'          => 'tmq_sidebars_sec',
        'title'       => 'Unlimited Sidebars',
		'class'		  => 'tmq_icon_sidebars'
      ),
      array(
        'id'          => 'tmq_3rd_party',
        'title'       => '3rd Party',
		'class'		  => 'tmq_icon_thirdparty'
      ),
      array(
        'id'          => 'tmq_rendered_code',
        'title'       => 'Custom CSS',
		'class'		  => 'tmq_icon_css'
      ),
	   array(
        'id'          => 'tmq_google_code',
        'title'       => 'Google Api Key',
		'class'		  => 'tmq_goole'
      )
    ),
	
    'settings'        => array(
      array(
        'id'          => 'tmq_general_tab',
        'label'       => 'General Settings',
        'type'        => 'tab',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
	  array(
        'id'          => 'tmq_css',
        'label'       => '',
        'desc'        => '',
        'std'         => '{{tmq_color_settings}}',
        'type'        => 'css',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => 'hidden'
      ),
      array(
        'id'          => 'tmq_dark_light',
        'label'       => '',
        'desc'        => '',
        'std'         => 'light',
        'type'        => 'radio-image',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'light',
            'label'       => 'Light Layout',
            'src'         => get_template_directory_uri() . '/includes/framework/images/light.png'
          ),
          array(
            'value'       => 'dark',
            'label'       => 'Dark Layout',
            'src'         => get_template_directory_uri() . '/includes/framework/images/dark.png'
          )
        ),
      ),	  
	  array(
        'id'          => 'tmq_accent_color',
        'label'       => 'Accent Color of the Site',
        'desc'        => 'Choose the accent color of the site - This is the most important color of your website',
        'std'         => '#0f9db1',
        'type'        => 'colorpicker',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 	 
	  array(
        'id'          => 'tmq_background_color',
        'label'       => 'Background Color',
        'desc'        => 'Choose the background color of your website.',
        'std'         => '#ffffff',
        'type'        => 'colorpicker',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),	  
      array(
        'id'          => 'tmq_background_image',
        'label'       => 'Background Image',
        'desc'        => 'Upload a large and beautiful background image for your site. This will override the background color.',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_background_overlay',
        'label'       => 'Background Dark Overlay Opacity',
        'desc'        => 'Choose the opacity level of the dark overlay on your background. This will help your content to be seen more easily.',
        'std'         => '3',
        'type'        => 'numeric-slider',
        'section'     => 'general',
        'taxonomy'    => '',
		'min_max_step'=> '0,10,1',
        'class'       => ''
      ),	  
	  array(
        'id'          => 'tmq_scrollbar',
        'label'       => 'Smooth Scrollbar',
        'desc'        => 'You can turn on Smooth scroll bar to emulate modern tablets smooth scroll effect on your website. This won\'t work on old IEs',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
      ),
      array(
        'id'          => 'tmq_favicon',
        'label'       => 'Favorite Icon',
        'desc'        => 'Upload favorite icon of the website. File dimension should be 16 x 16 pixels in .png or .ico formats.<BR><BR>Note: Old IEs will work only if you upload an <strong>.ico</strong> image',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_appletouch_icon',
        'label'       => 'Apple Touch Icon',
        'desc'        => 'Upload your apple touch icon for the website. File dimension should be 129 x 129 pixels in .png format.',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'general',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_onepage_ajax',
        'label'       => 'Ajax Navigation (New)',
        'desc'        => 'Turning on this option may cause some conflicts with third party javascript codes. If you are experiencing any incompatibility PLEASE turn this option off.',
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),	  
      array(
        'id'          => 'tmq_onepage_post',
        'label'       => 'Default Ajax One Page Menu',
        'desc'        => 'Choose the onepage ajax menu that you want to use in onepage version. You should create it in Ajax Menu first. <BR><BR>Please note that in special cases such as when you are using <strong>WPML</strong>, you may set different onepage menus for different homepages by editing your different onepage powered pages individually.',
       'std'         => '',
        'type'        => 'custom-post-type-select',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => 'tmq-ajaxonepager',
        'taxonomy'    => '',
        'class'       => ''
      ),  
	  array(
        'id'          => 'tmq_onepage_mainmenu',
        'label'       => 'Show Top Menu in OnePage Version? (Not Recommended)',
        'desc'        => 'In onepage version, top menu will be replaced with right side navigation buttons. By turning this option ON, you\'ll have main menu in OnePage version too.',
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_auto_color_one_pager',
        'label'       => 'Different Color Tones for OnePager Menu',
        'desc'        => 'By turning this option on, the color of one pager menu items will vary a little.',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_auto_color_random_hue',
        'label'       => 'Random Hue Value',
        'desc'        => 'This will apply a random value to each R/G/B colors. The result will be more color variation on the OnePager Menu.',
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_auto_color_one_pager:is(on)',
		'operator'	  => 'and',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_loading',
        'label'       => 'Page Loading Spinning Icon / Logo',
        'desc'        => 'Upload an image to spin while your page is loading in ajax powered onepage version. Transparent version of your logo would be a great choice!',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_blog_index_page',
        'label'       => 'Where to Link Blog Index Page?',
        'desc'        => 'In onepage version, this is the page where your blog page\'s Back to Index button will link to',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_portfolio_index_page',
        'label'       => 'Where to Link Portfolio Index Page?',
        'desc'        => 'In onepage version, this is the page where your portfolio page\'s Back to Index button will link to',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'tmq_ajaxonepage',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_logo_tab',
        'label'       => 'Logo',
        'desc'        => 'Enter your company main phone number here. It will appear in header. Enter none if you don\'t want to have this option on the header',
        'std'         => '+1-888-123-1234',
        'type'        => 'tab',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
	  array(
        'id'          => 'tmq_logo_type',
        'label'       => 'Logo Type',
        'desc'        => 'Do you have a image to upload as your logo or you want to keep it simple with a text only logo?',
        'std'         => 'tmq_image',
        'type'        => 'select',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_image',
            'label'       => 'Image',
            'src'         => ''
          ),
          array(
            'value'       => 'tmq_text',
            'label'       => 'Text',
            'src'         => ''
          )
        ),
      ),
      array(
        'id'          => 'tmq_logo',
        'label'       => 'Website Logo',
        'desc'        => 'Upload Logo of your business. Please upload a png transparent file',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_logo_type:is(tmq_image)',
		'operator'	  => 'and',			
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_logo_2',
        'label'       => 'Website Logo for Sticky Menu',
        'desc'        => 'You may choose a different logo for sticky menu (when user scrolls down the page)',
        'std'         => '',
        'type'        => 'upload',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_logo_type:is(tmq_image)',
		'operator'	  => 'and',			
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_logo_text',
        'label'       => 'Website Name (Text Logo)',
        'desc'        => 'Enter the name of website. ( It\'s highly recommended to upload a image logo )',
        'std'         => 'BOKEH',
        'type'        => 'text',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_logo_type:is(tmq_text)',
		'operator'	  => 'and',	
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_logo_color',
        'label'       => 'Color of Text Logo',
        'desc'        => 'Choose the color of your text logo',
        'std'         => '#ffffff',
        'type'        => 'colorpicker',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_logo_type:is(tmq_text)',
		'operator'	  => 'and',	
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_logo_color_2',
        'label'       => 'Color of Text Logo in Sticky Menu',
        'desc'        => 'Choose the color of your text logo',
        'std'         => '#000000',
        'type'        => 'colorpicker',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_logo_type:is(tmq_text)',
		'operator'	  => 'and',	
        'taxonomy'    => '',
        'class'       => ''
      ),	  
      array(
        'id'          => 'tmq_logo_font_size',
        'label'       => 'Text Logo Font Size (px)',
        'desc'        => 'Specify font size of your text logo in pixels',
        'std'         => '32',
        'type'        => 'numeric-slider',
        'section'     => 'tmq_header_sec',
        'taxonomy'    => '',
		'min_max_step'=> '16,48,1',
		'condition'   => 'tmq_logo_type:is(tmq_text)',
		'operator'	  => 'and',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_logo_url',
        'label'       => 'Where to Link Logo?',
        'desc'        => 'Enter the URL of your logo link. It usually should be your homepage. Leave it empty to make a automatic link to your homepage',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_menu_settings_tab',
        'label'       => 'Menu Settings',
        'type'        => 'tab',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_sticky_menu',
        'label'       => 'Sticky Menu',
        'desc'        => 'Do you want the main menu follow visitors when they scroll down the page? It\'s recommended to let it stay enable if you have less than 10 menu items. For more menu items, please disable it.',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),	  
      array(
        'id'          => 'tmq_menu_l2_width',
        'label'       => 'Width of Submenu items',
        'desc'        => 'Enter the preferred width of submenu items. Default: 200px',
        'std'         => '200',
        'type'        => 'numeric-slider',
        'section'     => 'tmq_header_sec',
		'min_max_step'=> '150,250,1',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_menu_l2_padding',
        'label'       => 'Top/Bottom Padding of SubMenu Items',
        'desc'        => 'This will control the height of the submenu items. Default: 10px',
        'std'         => '10',
        'type'        => 'numeric-slider',
        'section'     => 'tmq_header_sec',
		'min_max_step'=> '5,15,1',
        'taxonomy'    => '',
        'class'       => ''
      ),	  
      array(
        'id'          => 'tmq_header_navigation',
        'label'       => 'Header Navigation Buttons',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_search_header',
        'label'       => 'Show Search in Header',
        'desc'        => 'Turn this on to have search button right on your site header',
        'std'         => '',
        'type'        => 'on-off',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_brcr_tab',
        'label'       => 'Breadcrumb Area',
        'type'        => 'tab',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
	  array(
        'id'          => 'tmq_brcr',
        'label'       => 'Breadcrumb Visibility',
        'desc'        => 'Choose the visibility of the breadcrumb in the site. Some people simply doesn\'t like breadcrumbs!',
        'std'         => 'tmq_show',
        'type'        => 'select',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_show',
            'label'       => 'Show it',
            'src'         => ''
          ),
          array(
            'value'       => 'tmq_hide',
            'label'       => 'Hide it',
            'src'         => ''
          )
        ),
      ),
	  array(
        'id'          => 'tmq_brcr_format',
        'label'       => 'Breadcrumb Text Format',
        'desc'        => 'How do you like to see breadcrumb texts on your site?',
        'std'         => 'tmq_lowercase',
        'type'        => 'select',
        'section'     => 'tmq_header_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_brcr:is(tmq_show)',
		'operator'	  => 'and',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_none',
            'label'       => 'none',
            'src'         => ''
          ),
          array(
            'value'       => 'tmq_lowercase',
            'label'       => 'lowercase',
            'src'         => ''
          ),
          array(
            'value'       => 'tmq_uppercase',
            'label'       => 'UPPERCASE',
            'src'         => ''
          ),
          array(
            'value'       => 'tmq_capitalize',
            'label'       => 'Capitalize',
            'src'         => ''
          )
        ),
      ),
      array(
        'id'          => 'tmq_footer_tab',
        'label'       => 'Footer',
        'type'        => 'tab',
        'section'     => 'tmq_footer_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_footer_site_name',
        'label'       => 'Site Name',
        'desc'        => 'Enter your site name if you wish to see it in the footer too',
        'std'         => 'Bokeh',
        'type'        => 'text',
        'section'     => 'tmq_footer_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_copyright_text',
        'label'       => 'Copyright Text',
        'desc'        => 'Copyright message on footer of the site',
        'std'         => 'Copyright &copy; Bokeh WordPress Theme',
        'type'        => 'text',
        'section'     => 'tmq_footer_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_backtotop',
        'label'       => 'Back to Top Button',
        'desc'        => 'You can enable or disable back to top button on your site here.',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'tmq_footer_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
      ),
	  array(
        'label'       => 'Social Items',
        'id'          => 'tmq_social_items',
        'type'        => 'list-item',
        'desc'        => 'Add social items that you want. You can sort, edit or remove them anytime.',
        'settings'    => array(
          array(
            'label'       => 'Item Type',
            'id'          => 'tmq_social_items_type',
            'type'        => 'select',
            'desc'        => 'What is this social item? Is this facebook, twitter or ...?',
            'std'         => '',
            'rows'        => '',
            'post_type'   => '',
            'taxonomy'    => '',
            'class'       => '',
			'choices'     => array(
				array(
				'value'       => 'facebook',
				'label'       => 'Facebook',
				'src'         => ''
				),
				array(
				'value'       => 'twitter',
				'label'       => 'Twitter',
				'src'         => ''
				),
				array(
				'value'       => 'google',
				'label'       => 'Google+',
				'src'         => ''
				),
				array(
				'value'       => 'vimeo',
				'label'       => 'Vimeo',
				'src'         => ''
				),
				array(
				'value'       => 'dribbble',
				'label'       => 'Dribbble',
				'src'         => ''
				),
				array(
				'value'       => 'pinterest',
				'label'       => 'Pinterest',
				'src'         => ''
				),
				array(
				'value'       => 'youtube',
				'label'       => 'YouTube',
				'src'         => ''
				),
				array(
				'value'       => 'linkedin',
				'label'       => 'LinkedIn',
				'src'         => ''
				),
				array(
				'value'       => 'instagram',
				'label'       => 'Instagram',
				'src'         => ''
				),
				array(
				'value'       => 'custom',
				'label'       => 'Custom',
				'src'         => ''
				),
			),
          ),
          array(
            'label'       => 'Item URL',
            'id'          => 'tmq_social_items_url',
            'type'        => 'text',
            'desc'        => 'Enter URL of your page in this social network. Don\'t forget to prefix it with http://',
            'std'         => '',
            'rows'        => '',
            'post_type'   => '',
            'taxonomy'    => '',
            'class'       => ''
          ),
          array(
            'label'       => 'Choose Your Custom Icon',
            'id'          => 'tmq_social_custom_icon',
            'type'        => 'fontawesome_select',
            'std'         => '',
            'rows'        => '',
            'post_type'   => '',
			'condition'   => 'tmq_social_items_type:is(custom)',
			'operator'	  => 'and',			
            'taxonomy'    => '',
            'class'       => ''
          )
        ),
        'std'         => '',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'section'     => 'tmq_footer_sec'
      ),
      array(
        'id'          => 'tmq_page_color_tab',
        'label'       => 'Color Settings',
        'type'        => 'tab',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
	  array(
        'id'          => 'tmq_page_p_color_light',
        'label'       => 'Default Paragraph Color (Light Version)',
        'desc'        => 'Choose the default paragraph color of the theme. Default is #666666. Using very light colors is not recommended.',
        'std'         => '#666666',
        'type'        => 'colorpicker',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_dark_light:is(light)',
		'operator'    => 'and',	
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_page_p_color_dark',
        'label'       => 'Default Paragraph Color (Dark Version)',
        'desc'        => 'Choose the default paragraph color of the theme. Default is #eeeeee. Using very dark colors is not recommended.',
        'std'         => '#eeeeee',
        'type'        => 'colorpicker',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
		'condition'   => 'tmq_dark_light:is(dark)',
		'operator'    => 'and',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_page_sidebar_tab',
        'label'       => 'Sidebar Settings',
        'type'        => 'tab',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
      array(
        'id'          => 'tmq_default_sidebar_position',
        'label'       => 'Default Sidebar Position',
        'desc'        => 'Default page layout. There is a per/page option in add/edit pages for this setting. You can choose the default settings here.',
        'std'         => 'tmq_fullwidth',
        'type'        => 'radio-image',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_rightsidebar',
            'label'       => 'Right Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
          ),
          array(
            'value'       => 'tmq_leftsidebar',
            'label'       => 'Left Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
          ),
         array(
            'value'       => 'tmq_fullwidth',
            'label'       => 'No Sidebars (Full Width)',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
          )
		),
      ),
      array(
        'id'          => 'tmq_def_left_sidebar',
        'label'       => 'Default Left Sidebar',
        'desc'        => 'Choose default sidebar for pages with <strong>left sidebar template</strong>. You can change this per page/post.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_def_right_sidebar',
        'label'       => 'Default Right Sidebar',
        'desc'        => 'Choose default sidebar for pages with <strong>right sidebar template</strong>. You can change this per page/post.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_404_tab',
        'label'       => '404 Error Page',
        'type'        => 'tab',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
      array(
        'id'          => 'tmq_404_heading',
        'label'       => '404 Error Page Heading',
        'desc'        => 'Choose 404 page not found error page heading',
        'std'         => '404 File Not Found!',
        'type'        => 'text',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_404_text',
        'label'       => '404 Error Page Text',
        'desc'        => 'Choose 404 page not found error page text',
        'std'         => '',
        'type'        => 'text',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),	
      array(
        'id'          => 'tmq_404_search',
        'label'       => 'Enable Search Box?',
        'desc'        => 'You can enable or disable search box on 404 not found page.',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'tmq_pageoptions_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_blog_general_tab',
        'label'       => 'General Settings',
        'desc'        => 'Turn this on to have search button right on your top bar section',
        'std'         => '',
        'type'        => 'tab',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),    
      array(
        'id'          => 'tmq_def_blog_sidebar_position',
        'label'       => 'Default Blog Layout',
        'desc'        => 'Choose position of sidebar in blog index page and also the default position for single posts. You can override this option per post.',
        'std'         => 'tmq_rightsidebar',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_rightsidebar',
            'label'       => 'Right Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
          ),
          array(
            'value'       => 'tmq_leftsidebar',
            'label'       => 'Left Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
          ),
          array(
            'value'       => 'tmq_fullwidth',
            'label'       => 'No Sidebar (Full Width)',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
          )
        ),
      ),
		array(
			'id'          => 'tmq_blog_left_sidebar',
			'label'       => 'Default Left Sidebar',
			'desc'        => 'Choose the sidebar to show on blog posts with left sidebar. You can override this per post.',
			'std'         => '',
			'type'        => 'sidebar-select',
			'section'     => 'tmq_blogoptions',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => ''
		),
		array(
			'id'          => 'tmq_blog_right_sidebar',
			'label'       => 'Default Right Sidebar',
			'desc'        => 'Choose the sidebar to show on blog posts with right sidebar. You can override this per post.',
			'std'         => '',
			'type'        => 'sidebar-select',
			'section'     => 'tmq_blogoptions',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => ''
		),
      array(
        'id'          => 'tmq_blogexceptlimit',
        'label'       => 'Limit Posts Excerpt Lengh',
        'desc'        => 'Enter number of words that you want to see in posts excerpt section. Choose less words if you\'ve selected more columns.',
        'std'         => '40',
        'type'        => 'numeric-slider',
        'section'     => 'tmq_blogoptions',
		'min_max_step'=> '0,80,1',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_blogexcept_after_text',
        'label'       => 'Text to Show After Excerpt',
        'desc'        => 'This text will be shown after excerpt in blog posts list.',
        'std'         => '[...]',
        'type'        => 'text',
        'section'     => 'tmq_blogoptions',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_blog_single_tab',
        'label'       => 'Blog Single Page',
        'type'        => 'tab',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 
	  array(
			'id'          => 'tmq_social_box',
			'label'       => 'Default Status of Share to Social Networks Box',
			'type'        => 'select',
			'section'     => 'tmq_blogoptions',
			'desc'        => 'Do you want your visitors be able to share your post over social networks? You can override this setting per post.',
			'std'         => 'tmq_show',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => '',
			'choices'     => array(
				array(
				'label'        => 'Show',
				'value'        => 'tmq_show'
				),
				array(
				'label'        => 'Hide',
				'value'        => 'tmq_hide'
				)
			)
		),
		array(
			'id'          => 'tmq_tags_box',
			'label'       => 'Default Status of Tags on Single Post',
			'type'        => 'select',
			'section'     => 'tmq_blogoptions',
			'desc'        => 'Do you want your visitors be able to see the tags of your post? You can override this setting per post.',
			'std'         => 'tmq_show',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => '',
			'choices'     => array(
				array(
				'label'        => 'Show',
				'value'        => 'tmq_show'
				),
				array(
				'label'        => 'Hide',
				'value'        => 'tmq_hide'
				)
			)
		),
		array(
			'id'          => 'tmq_author_box',
			'label'       => 'Default Status of Author Information Box',
			'type'        => 'select',
			'section'     => 'tmq_blogoptions',
			'desc'        => 'Do you want your visitors see the author information box in the bottom of each post? You can override this setting per post.',
			'std'         => 'tmq_show',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => '',
			'choices'     => array(
				array(
				'label'        => 'Show',
				'value'        => 'tmq_show'
				),
				array(
				'label'        => 'Hide',
				'value'        => 'tmq_hide'
				)
			)
		),
		array(
		'label'       => 'Default Status for Related Posts',
		'id'          => 'tmq_relatedposts',
		'type'        => 'select',
        'section'     => 'tmq_blogoptions',
		'desc'        => 'Show related post at the end of the each post. You can override this per post.',
		'std'         => 'tmq_show',
		'rows'        => '',
		'post_type'   => '',
		'taxonomy'    => '',
		'class'       => '',
		'choices'     => array(
			array(
			'label'        => 'Show',
			'value'        => 'tmq_show'
			),
			array(
			'label'        => 'Hide',
			'value'        => 'tmq_hide'
			)
		)
	  ),
	  array(
		'label'       => 'Comments On Blog Posts',
		'id'          => 'tmq_blog_comments',
		'type'        => 'on-off',
		'desc'        => 'Do you want to globally enable or disable comments on blog posts?',
        'section'     => 'tmq_blogoptions',   
		'std'         => 'on',
		'rows'        => '',
		'post_type'   => '',
		'taxonomy'    => '',
		'class'       => ''
	  ),
      array(
        'id'          => 'tmq_blog_index_tab',
        'label'       => 'Blog Index Page',
        'type'        => 'tab',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_blog_index_style',
        'label'       => 'Blog Index Layout',
        'desc'        => 'Choose default layout for blog index page.',
        'std'         => 'tmq_classic',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_classic',
            'label'       => 'Classic Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-classic.png'
          ),
          array(
            'value'       => 'tmq_grid',
            'label'       => 'Grid Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-grid.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_blog_columns',
        'label'       => 'Blog Index Page Columns',
        'desc'        => 'Choose the number of columns for default blog page. <BR><BR>For the pages with a sidebar, if you choose three (3) columns, it will automatically reduce to two (2) columns to keep your site beautiful!',
        'std'         => 'tmq_13_13_13',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
		'condition'   => 'tmq_blog_index_style:is(tmq_grid)',
		'operator'	  => 'and',		
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_1',
            'label'       => 'One Column',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_1.png'
          ),
          array(
            'value'       => 'tmq_12_12',
            'label'       => 'Two Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_12_12.png'
          ),
          array(
            'value'       => 'tmq_13_13_13',
            'label'       => 'Three Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_13_13_13.png'
          ),
          array(
            'value'       => 'tmq_14_14_14_14',
            'label'       => 'Four Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_14_14_14_14.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_blog_category_tab',
        'label'       => 'Blog Categories',
        'type'        => 'tab',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_blog_category_style',
        'label'       => 'Blog Category Layout',
        'desc'        => 'Choose default layout for blog category pages.',
        'std'         => 'tmq_classic',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_classic',
            'label'       => 'Classic Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-classic.png'
          ),
          array(
            'value'       => 'tmq_grid',
            'label'       => 'Grid Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-grid.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_blog_category_columns',
        'label'       => 'Blog Category Pages Columns',
        'desc'        => 'Choose the number of columns for default blog category pages. <BR><BR>For the pages with a sidebar, if you choose three (3) columns, it will automatically reduce to two (2) columns to keep your site beautiful!',
        'std'         => 'tmq_12_12',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
		'condition'   => 'tmq_blog_category_style:is(tmq_grid)',
		'operator'	  => 'and',		
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_1',
            'label'       => 'One Column',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_1.png'
          ),
          array(
            'value'       => 'tmq_12_12',
            'label'       => 'Two Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_12_12.png'
          ),
          array(
            'value'       => 'tmq_13_13_13',
            'label'       => 'Three Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_13_13_13.png'
          ),
          array(
            'value'       => 'tmq_14_14_14_14',
            'label'       => 'Four Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_14_14_14_14.png'
          )
        ),
      ),	
	  array(
        'id'          => 'tmq_blog_category_sidebar_position',
        'label'       => 'Blog Category Pages Layout',
        'desc'        => 'Choose default position of sidebar in blog category pages.',
        'std'         => 'tmq_rightsidebar',
        'type'        => 'radio-image',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_rightsidebar',
            'label'       => 'Right Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
          ),
          array(
            'value'       => 'tmq_leftsidebar',
            'label'       => 'Left Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
          ),
          array(
            'value'       => 'tmq_fullwidth',
            'label'       => 'No Sidebar (Full Width)',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_blog_category_left_sidebar',
        'label'       => 'Left Sidebar',
        'desc'        => 'Choose the sidebar to show on blog category pages with left sidebar.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',		
		'condition'   => 'tmq_blog_category_sidebar_position:is(tmq_leftsidebar)',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_blog_category_right_sidebar',
        'label'       => 'Right Sidebar',
        'desc'        => 'Choose the sidebar to show on blog category pages with right sidebar.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_blogoptions',
        'rows'        => '',
        'post_type'   => '',		
		'condition'   => 'tmq_blog_category_sidebar_position:is(tmq_rightsidebar)',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_portfolio_general_tab',
        'label'       => 'General Settings',
        'type'        => 'tab',
        'section'     => 'tmq_portfolio_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  
      array(
        'id'          => 'tmq_def_portfolio_sidebar_position',
        'label'       => 'Default Portfolio Layout',
        'desc'        => 'Choose default position of sidebar in portfolio posts. You can override this option per post.',
        'std'         => 'tmq_rightsidebar',
        'type'        => 'radio-image',
        'section'     => 'tmq_portfolio_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_rightsidebar',
            'label'       => 'Right Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
          ),
          array(
            'value'       => 'tmq_leftsidebar',
            'label'       => 'Left Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
          ),
          array(
            'value'       => 'tmq_fullwidth',
            'label'       => 'No Sidebar (Full Width)',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_portfolio_left_sidebar',
        'label'       => 'Default Left Sidebar',
        'desc'        => 'Choose the sidebar to show on portfolio posts with left sidebar. You can override this per post.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_portfolio_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_portfolio_right_sidebar',
        'label'       => 'Default Right Sidebar',
        'desc'        => 'Choose the sidebar to show on portfolio posts with right sidebar. You can override this per post.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_portfolio_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_defportfoliopage',
        'label'       => 'Portfolio Archive Page',
        'desc'        => 'Where should a user go when he/she clicks on portfolio list in the single portfolio item?',
        'std'         => '',
        'type'        => 'page-select',
        'section'     => 'tmq_portfolio_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
			'id'          => 'tmq_portfolio_social_box',
			'label'       => 'Default Status of Share to Social Networks Box',
			'type'        => 'select',
			'section'     => 'tmq_portfolio_sec',
			'desc'        => 'Do you want your visitors be able to share your project over social networks? You can override this setting per project.',
			'std'         => 'tmq_hide',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => '',
			'choices'     => array(
				array(
				'label'        => 'Show',
				'value'        => 'tmq_show'
				),
				array(
				'label'        => 'Hide',
				'value'        => 'tmq_hide'
				)
			)
		),
		array(
			'id'          => 'tmq_portfolio_tags_box',
			'label'       => 'Default Status of Tags on Project',
			'type'        => 'select',
			'section'     => 'tmq_portfolio_sec',
			'desc'        => 'Do you want your visitors be able to see the tags of your project? You can override this setting per project.',
			'std'         => 'tmq_hide',
			'rows'        => '',
			'post_type'   => '',
			'taxonomy'    => '',
			'class'       => '',
			'choices'     => array(
				array(
				'label'        => 'Show',
				'value'        => 'tmq_show'
				),
				array(
				'label'        => 'Hide',
				'value'        => 'tmq_hide'
				)
			)
		),
	   array(
		'label'       => 'Default Setting for Related Portfolio Items',
		'id'          => 'tmq_portfolio_relatedposts',
		'type'        => 'select',
        'section'     => 'tmq_portfolio_sec',
		'desc'        => 'Show related post at the end of the each post. You can override this per post.',
		'std'         => 'tmq_show',
		'rows'        => '',
		'post_type'   => '',
		'taxonomy'    => '',
		'class'       => '',
		'choices'     => array(
			array(
			'label'        => 'Show',
			'value'        => 'tmq_show'
			),
			array(
			'label'        => 'Hide',
			'value'        => 'tmq_hide'
			)
		)
	  ),	  
	  array(
		'label'       => 'Comments On Portfolio',
		'id'          => 'tmq_portfolio_comments',
		'type'        => 'on-off',
		'desc'        => 'Do you want to enable comments on portfolio items?',
        'section'     => 'tmq_portfolio_sec',    
		'std'         => 'off',
		'rows'        => '',
		'post_type'   => '',
		'taxonomy'    => '',
		'class'       => ''
	  ),
      array(
        'id'          => 'tmq_search_tab',
        'label'       => 'Search Page',
        'type'        => 'tab',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 
	  array(
        'id'          => 'tmq_search_sidebar_position',
        'label'       => 'Search Page Layout',
        'desc'        => 'Choose position of sidebar in search results page.',
        'std'         => 'tmq_rightsidebar',
        'type'        => 'radio-image',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_rightsidebar',
            'label'       => 'Right Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
          ),
          array(
            'value'       => 'tmq_leftsidebar',
            'label'       => 'Left Sidebar',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
          ),
          array(
            'value'       => 'tmq_fullwidth',
            'label'       => 'No Sidebar (Full Width)',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_search_left_sidebar',
        'label'       => 'Search Page Left Sidebar',
        'desc'        => 'Choose the sidebar to show on search results page with left sidebar.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_search_right_sidebar',
        'label'       => 'Search Page Right Sidebar',
        'desc'        => 'Choose the sidebar to show on search results page with right sidebar.',
        'std'         => '',
        'type'        => 'sidebar-select',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
	  array(
        'id'          => 'tmq_search_style',
        'label'       => 'Search Layout',
        'desc'        => 'Choose default layout for search page.',
        'std'         => 'tmq_classic',
        'type'        => 'radio-image',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_classic',
            'label'       => 'Classic Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-classic.png'
          ),
          array(
            'value'       => 'tmq_grid',
            'label'       => 'Grid Style',
            'src'         => get_template_directory_uri() . '/includes/framework/images/blog-grid.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_search_columns',
        'label'       => 'Search Results Pages Columns',
        'desc'        => 'Choose the number of columns for search results page. <BR><BR>For the pages with a sidebar, if you choose three (3) columns, it will automatically reduce to two (2) columns to keep your site beautiful!',
        'std'         => 'tmq_12_12',
        'type'        => 'radio-image',
        'section'     => 'tmq_search_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
		'condition'   => 'tmq_search_style:is(tmq_grid)',
		'operator'	  => 'and',		
        'class'       => '',
        'choices'     => array(
          array(
            'value'       => 'tmq_1',
            'label'       => 'One Column',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_1.png'
          ),
          array(
            'value'       => 'tmq_12_12',
            'label'       => 'Two Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_12_12.png'
          ),
          array(
            'value'       => 'tmq_13_13_13',
            'label'       => 'Three Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_13_13_13.png'
          ),
          array(
            'value'       => 'tmq_14_14_14_14',
            'label'       => 'Four Columns',
            'src'         => get_template_directory_uri() . '/includes/framework/images/sch_cols_14_14_14_14.png'
          )
        ),
      ),
      array(
        'id'          => 'tmq_typo_general_tab',
        'label'       => 'General Settings',
        'type'        => 'tab',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 
      array(
        'id'          => 'tmq_about_typography',
        'label'       => 'Some Typography Options',
        'desc'        => 'Here you can change the typography settings of the theme. By the way, the default settings would be the best for your site. We do recommend to do not change these values very much.',
        'std'         => '',
        'type'        => 'textblock_titled',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_support_latin',
        'label'       => 'Support Latin Sub-Set',
        'desc'        => 'Please turn this on if your site is using Latin codepages such as Turkish, ...',
        'std'         => 'on',
        'type'        => 'on-off',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_support_greek',
        'label'       => 'Support Greek Sub-Set',
        'desc'        => 'Please turn this on if your site is using Greek codepages',
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_support_cyrillic',
        'label'       => 'Support Cyrillic Sub-Set',
        'desc'        => 'Please turn this on if your site is using Cyrillic codepages such as Russian, Polish, ...',
        'std'         => 'off',
        'type'        => 'on-off',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_paragraph_font',
        'label'       => 'Default Paragraphs Font Settings',
        'desc'        => '',
        'std'         => '',
        'type'        => 'googlefonts-select',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_heading_webfont',
        'label'       => 'Headings (H1-H6) WebFont',
        'desc'        => '',
        'std'         => '',
        'type'        => 'googlefonts-select-small',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),		  
      array(
        'id'          => 'tmq_h1_font',
        'label'       => 'H1 Font Size',
        'desc'        => 'Default: 38px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_h2_font',
        'label'       => 'H2 Font Size',
        'desc'        => 'Default: 24px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_h3_font',
        'label'       => 'H3 Font Size',
        'desc'        => 'Default: 22px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_h4_font',
        'label'       => 'H4 Font Size',
        'desc'        => 'Default: 18px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_h5_font',
        'label'       => 'H5 Font Size',
        'desc'        => 'Default: 15px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_h6_font',
        'label'       => 'H6 Font Size',
        'desc'        => 'Default: 12px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),  	
      array(
        'id'          => 'tmq_typo_menu_tab',
        'label'       => 'Main Menu',
        'type'        => 'tab',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 
      array(
        'id'          => 'tmq_menu_webfont',
        'label'       => 'Menu font (All Levels)',
        'desc'        => '',
        'std'         => '',
        'type'        => 'googlefonts-select-small',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_menu_fontsize',
        'label'       => 'Menu Font Size',
        'desc'        => 'Default: 16px - Minimum 11px - Maximum 24px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_menu_l2_fontsize',
        'label'       => 'SUB Menu Font Size',
        'desc'        => 'Default: 14px - Minimum 11px - Maximum 24px',
        'std'         => '',
        'type'        => 'measurement',
        'section'     => 'tmq_typography_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_customsidebars',
        'label'       => 'Custom Sidebars',
        'desc'        => 'List of custom sidebars',
        'std'         => '',
        'type'        => 'list-item',
        'section'     => 'tmq_sidebars_sec',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => '',
        'settings'    => array(
          array(
            'id'          => 'tmq_sidebarhelper',
            'label'       => 'SideBarHelper',
            'desc'        => 'Enter sidebar name in the above field.',
            'std'         => '',
            'type'        => 'textblock',
            'rows'        => '',
            'post_type'   => '',
            'taxonomy'    => '',
            'class'       => ''
          )
        )
      ),
      array(
        'id'          => 'tmq_googleanalytics',
        'label'       => 'Google Analytics',
        'desc'        => 'Enter your Google Analytics tracking code here. (Sign up here: http://analytics.google.com/). This service will provide you complete statistics about your website.',
        'std'         => '',
        'type'        => 'textarea-simple',
        'section'     => 'tmq_3rd_party',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
      array(
        'id'          => 'tmq_usercss',
        'label'       => 'Custom CSS',
        'desc'        => 'Put your custom CSS Codes Here.',
        'std'         => '',
        'type'        => 'css',
        'section'     => 'tmq_rendered_code',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ), 
	  array(
        'id'          => 'google_api',
        'label'       => 'Google API Key',
        'desc' => wp_kses( __( '<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">Get Api Key</a>', "bokeh" ), array( 'a' => array( 'target' => array(), 'href' => array() ) ) ),
        'std'         => '',
        'type'        => 'text',
        'section'     => 'tmq_google_code',
        'rows'        => '',
        'post_type'   => '',
        'taxonomy'    => '',
        'class'       => ''
      ),
    )
  );

  /* allow settings to be filtered before saving */
  $custom_settings = apply_filters( 'option_tree_settings_args', $custom_settings );

  /* settings are not the same update the DB */
  if ( $saved_settings !== $custom_settings ) {
    update_option( 'option_tree_settings', $custom_settings );
  }

}

/**
 * IMPORT EXPORT THEME OPTIONS
 */
add_action( 'init', 'register_options_pages' );

/**
 * Registers all the required admin pages.
 */
function register_options_pages() {

  // Only execute in admin & if OT is installed
  if ( is_admin() && function_exists( 'ot_register_settings' ) ) {
    // Register the pages
    ot_register_settings( 
      array(
        array( 
          'id'              => 'import_export',
          'pages'           => array(
            array(
              'id'              => 'import_export',
              'parent_slug'     => 'themes.php',
              'page_title'      => 'Theme Options Backup/Restore',
              'menu_title'      => 'Options Backup',
              'capability'      => 'edit_theme_options',
              'menu_slug'       => 'tmq-theme-backup',
              'icon_url'        => null,
              'position'        => null,
              'updated_message' => 'Options updated.',
              'reset_message'   => 'Options reset.',
              'button_text'     => 'Save Changes',
              'show_buttons'    => false,
              'screen_icon'     => 'themes',
              'contextual_help' => null,
              'sections'        => array(
				array(
                  'id'          => 'tmq_import_export',
                  'title'       =>  'Import/Export'
                )
              ),
              'settings'        => array(
                array(
					'id'          => 'import_data_text',
					'label'       => 'Import Theme Options',
					'desc'        =>  'Theme Options',
					'std'         => '',
					'type'        => 'import-data',
					'section'     => 'tmq_import_export',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				  ),
				  array(
					'id'          => 'export_data_text',
					'label'       => 'Export Theme Options',
					'desc'        =>  'Theme Options',
					'std'         => '',
					'type'        => 'export-data',
					'section'     => 'tmq_import_export',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				  )
              )
            )
          )
        )
      )
    );
  }
}

/**
 * Import Data option type.
 *
 * @return    string
 *
 * @access    public
 * @since     2.0
 */
if ( ! function_exists( 'ot_type_import_data' ) ) {
  
  function ot_type_import_data() {
    
    echo '<form method="post" id="import-data-form">';
      
      /* form nonce */
      wp_nonce_field( 'import_data_form', 'import_data_nonce' );
        
      /* format setting outer wrapper */
      echo '<div class="format-setting type-textarea has-desc">';
        
        /* description */
        echo '<div class="description">';
          
          if ( OT_SHOW_SETTINGS_IMPORT ) echo '<p>' .  __('Only after you\'ve imported the Settings should you try and update your Theme Options.', 'bokeh' ) . '</p>';
          
          echo '<p>' .  __('To import your Theme Options copy and paste what appears to be a random string of alpha numeric characters into this textarea and press the "Import Theme Options" button.', 'bokeh' ) . '</p>';
          /* button */
          echo '<button class="option-tree-ui-button blue right hug-right">' .  __('Import Theme Options', 'bokeh' ) . '</button>';
        echo '</div>';
        
        /* textarea */
        echo '<div class="format-setting-inner">';
          echo '<textarea rows="10" cols="40" name="import_data" id="import_data" class="textarea"></textarea>';
        echo '</div>';
      echo '</div>';
    echo '</form>';
    
  }
  
}

/**
 * Export Data option type.
 *
 * @return    string
 *
 * @access    public
 * @since     2.0
 */
if ( ! function_exists( 'ot_type_export_data' ) ) {
  
  function ot_type_export_data() {
    
    /* format setting outer wrapper */
    echo '<div class="format-setting type-textarea simple has-desc">';
      
      /* description */
      echo '<div class="description">';
        echo '<p>' .  __('Export your Theme Options data by highlighting this text and doing a copy/paste into a blank .txt file. Then save the file for importing into another install of WordPress later. Alternatively, you could just paste it into the <code>OptionTree->Settings->Import</code> <strong>Theme Options</strong> textarea on another web site.', 'bokeh' ) . '</p>';
      echo '</div>';
      
      /* get theme options data */
      $data = get_option( 'option_tree' );
      $data = ! empty( $data ) ? ot_encode( serialize( $data ) ) : '';
        
      echo '<div class="format-setting-inner">';
        echo '<textarea rows="10" cols="40" name="export_data" id="export_data" class="textarea">' . $data . '</textarea>';
      echo '</div>';
    echo '</div>';
  }
}
