<?php
/* ==========================================================================
   Register Default Sidebars and Dynamic Sidebars
   ========================================================================== */

	// If Dynamic Sidebar Exists
	if (function_exists('register_sidebar')) {

		// Define Sidebar Widget Area 1 (RIGHT)
		register_sidebar(array(
			'name' 			=> __('Right Sidebar', 'bokeh'),
			'description' 	=> __('The widgets which will place at right sidebar', 'bokeh'),
			'id' 			=> 'right-sidebar',
		    'before_widget' => '<div id="%1$s" class="widget-side widget %2$s">',
		    'after_widget' 	=> '</div>',			
			'before_title' 	=> '<h4>',
			'after_title' 	=> '</h4>'
		));
		
		// Define Sidebar Widget Area 2 (LEFT)
		register_sidebar(array(
			'name' 			=> __('Left Sidebar', 'bokeh'),
			'description' 	=> __('The widgets which will place at left sidebar', 'bokeh'),
			'id' 			=> 'left-sidebar',
		    'before_widget' => '<div id="%1$s" class="widget-side widget %2$s">',
		    'after_widget' 	=> '</div>',	
			'before_title' 	=> '<h4>',
			'after_title' 	=> '</h4>'
		));
			
	}

	// Register Custom Sidebars
	function custom_register_sidebar_widgets() {
	  if ( function_exists( 'ot_get_option' ) ) {
		// get the related list-item variable name
		$tmq_customsidebars = ot_get_option( 'tmq_customsidebars' );
		if(!empty( $tmq_customsidebars ) && sizeof( $tmq_customsidebars ) > 0) {  
		  foreach( $tmq_customsidebars as $customsidebar) {  
			foreach( $customsidebar as $mysidebar ) {
			  register_sidebar( array(  
				  'name' => $mysidebar ,
				  'id' => tmq_generateSlug($mysidebar , 45),  
				  'before_widget' 	=> '<div id="%1$s" class="widget user-widgets %2$s">',
				  'after_widget' 	=> '</div>',
				  'before_title'	=> '<h4>',
				  'after_title' 	=> '</h4>'
			  ) );  
			}
		  }  
		} 
	  } 
	}
	add_action( 'widgets_init', 'custom_register_sidebar_widgets' ); 


?>