<?php
/* ==========================================================================
   Loading Option Tree Configs
   ========================================================================== */	
   
	// Optional: set 'ot_show_pages' filter to false.
	// This will hide the settings & documentation pages.
	add_filter( 'ot_show_pages', '__return_false' );
	add_filter( 'ot_show_settings_import', '__return_true' );
	add_filter( 'ot_show_settings_export', '__return_true' );
	add_filter( 'ot_show_docs', '__return_false' );
	add_filter( 'ot_show_options_ui', '__return_false' );

	// Optional: set 'ot_show_new_layout' filter to false.
	// This will hide the "New Layout" section on the Theme Options page.
	add_filter( 'ot_show_new_layout', '__return_true' );

	// Required: set 'ot_theme_mode' filter to true.
	add_filter( 'ot_theme_mode', '__return_true' );

	// Required: include OptionTree.
	load_template( trailingslashit( get_template_directory() ) . 'option-tree/ot-loader.php' );

/* ==========================================================================
   Set some dynamic css from values which are currently in option panel
   ========================================================================== */
	function filter_css_value( $value, $option_id ) {
		
		if ( $option_id == 'tmq_google_font_name' ) {
			
			return googlefontfamily('name');
			
		} elseif ( $option_id == 'tmq_google_font_size' ) {
		
			$googlefontarray = ot_get_option( 'tmq_google_webfont' );
			$googlefontsize = ( isset( $googlefontarray['font-size'] ) && 'font-size' != $googlefontarray['font-size'] ) ? $googlefontarray['font-size'] : '14px';
			return $googlefontsize;
			
		} elseif ( $option_id == 'tmq_google_font_height' ) {
			
			$googlefontarray = ot_get_option( 'tmq_google_webfont' );
			$googlefontheight = ( isset( $googlefontarray['line-height'] ) && 'line-height' != $googlefontarray['line-height'] ) ? $googlefontarray['line-height'] : '1.4';
			return $googlefontheight;
			
		} elseif ( $option_id == 'tmq_color_settings' ) {
		
			$tmq_color_settings = '';
			
			/* ==========================================================================
			   Unlimited Colors Setting
			   ========================================================================== */
			// Main Accent Color
			$tmq_accent_color = ot_get_option( 'tmq_accent_color' );
			if ( empty( $tmq_accent_color ) ) {
				// Fall back
				$tmq_accent_color = '#0f9db1';
			}
			$tmq_rgb_array = tmq_hex2rgb( $tmq_accent_color );
			$tmq_rgb_color = 'rgb(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ')';
			$tmq_rgba_09_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.9)';
			$tmq_rgba_08_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.8)';
			$tmq_rgba_07_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.7)';
			$tmq_rgba_05_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.5)';
			$tmq_rgba_03_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.3)';
			$tmq_rgba_01_color = 'rgba(' . $tmq_rgb_array[0] . ',' . $tmq_rgb_array[1] . ',' . $tmq_rgb_array[2] . ', 0.1)';

			// Background Color
			$tmq_background_color = ot_get_option( 'tmq_background_color' );
			if ( empty( $tmq_background_color ) ) {
				// Fall back
				$tmq_background_color = '#ffffff';
			}
			
			// Background Iman
			$tmq_background_image = ot_get_option( 'tmq_background_image' );
			if ( !empty( $tmq_background_image ) ) {
				$tmq_color_settings .=
				'body {' . "\n" .
				'	background-image: url(\''. $tmq_background_image .'\');' . "\n" .
				'}' . "\n" .
				'' . "\n" .
				'';				
			}
			
			$tmq_background_overlay = ot_get_option( 'tmq_background_overlay' );
			if ( empty( $tmq_background_overlay ) ) {
				// Fall back
				$tmq_background_overlay = '0';
			} else {
				if ( is_numeric( $tmq_background_overlay ) ) {
					$tmq_background_overlay = $tmq_background_overlay / 10;
				} else {
					$tmq_background_overlay = '0.3';
				}
			}
			
			// Search PopOver Color
			$tmq_dark_light = ot_get_option( 'tmq_dark_light' );
			if ( empty( $tmq_dark_light ) ) { 
				$tmq_dark_light = 'light';
			}
			if ( $tmq_dark_light == 'dark' ) {
				$tmq_popover_bg = $tmq_accent_color;
			} else {
				$tmq_popover_bg = '#ffffff';
			}
			
			$tmq_color_settings .= 
			'/* =========================================== ' . "\n" .
			'    Unlimited Colors Setting                   ' . "\n" .
			' =========================================== */' . "\n" .
			'' . "\n" .
			'.bypostauthor .comment-box, #respond input[type="submit"], .blog-grid-controls a, .wpcf7 input[type="submit"], .portfolio-info-overlay, .owl-theme .owl-controls .owl-nav div, .service-item.active, .steps .step-item.active, .team-member:hover .team-title, .btn-primary {' . "\n" .
			'	background-color: '. $tmq_accent_color .';' . "\n" .
			'	background-color: '. $tmq_rgba_07_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container > ul > li.current-menu-ancestor > a, nav#main-menu > .menu-container > ul > li.current-menu-parent > a, .navbar-inverse .navbar-toggle:hover, .navbar-right li a:hover, .blog-details .blog-date, .author-box, #respond input[type="submit"]:hover, .tooltip-inner, .footer .footer-social li a:hover, .tagcloud a:hover, .blog-grid-controls a:hover, .wpcf7 input[type="submit"]:hover, .owl-theme .owl-controls .owl-nav div:hover, ul.filter li a:hover, ul.filter li a.active, .service-item:hover, .steps .step-item:hover, .image-box .image a:hover, .image-box:hover, .team-title, .testimonials, .clients-slider.owl-theme .owl-dot.active, nav#main-menu > .menu-container > ul > li:hover > a, nav#main-menu > .menu-container .menu-container, .mp-level, .flip-content, #trigger, .post-slider .thumbs .item:hover, .post-slider .thumbs .item.active, #back-to-top:hover, .btn-primary:hover, .btn-primary:focus, .btn-primary:active, table thead,ul.page-numbers li a.active, ul.page-numbers li a:hover, ul.page-numbers li span {' . "\n" .
			'	background-color: '. $tmq_accent_color .';' . "\n" .
			'	background-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'ul.iconned-list li i, .steps .step-item .step-icon, .ui-accordion-header-active a, .ui-tabs-active a {' . "\n" .
			'	color: '. $tmq_accent_color .';' . "\n" .
			'	color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'.portfolio-more:before, h4.underlined, .main-title:after, .page-titles:after, .blog-content:after, #respond h3#reply-title, #sidebar-area .widget > h4, #map-content h3:after, .blog-list-content > h2:after, .blog-grid-item .blog-grid-content h3, .tooltip.bottom .tooltip-arrow {' . "\n" .
			'	border-bottom-color: '. $tmq_accent_color .';' . "\n" .
			'	border-bottom-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'.tooltip.top .tooltip-arrow {' . "\n" .
			'	border-top-color: '. $tmq_accent_color .';' . "\n" .
			'	border-top-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'.image-box:hover .image-box-content:before, .post-slider .thumbs .item.active:after {' . "\n" .
			'	border-right-color: '. $tmq_accent_color .';' . "\n" .
			'	border-right-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container > ul > li > a, .flickr_badge_image img:hover {' . "\n" .
			'	border-color: '. $tmq_accent_color .';' . "\n" .
			'	border-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'#respond input, #respond textarea, .sidebar-searchbox input:focus, .sidebar-searchbox input:hover, .wpcf7 input, .wpcf7 textarea {' . "\n" .
			'	outline-color: '. $tmq_accent_color .';' . "\n" .
			'	outline-color: '. $tmq_rgb_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'body:after {' . "\n" .
			'	background-color: rgba(0,0,0,'. $tmq_background_overlay .');' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'.popover {' . "\n" .
			'	background-color: '. $tmq_popover_bg .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'.popover.left > .arrow:after {' . "\n" .
			'	border-left-color: '. $tmq_popover_bg .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'body {' . "\n" .
			'	background-color: '. $tmq_background_color .';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'';
			
			/* ==========================================================================
			   Logo Settings - Top and Bottom Padding
			   ========================================================================== */
			$tmq_logo_padding = ot_get_option( 'tmq_logo_padding' );
			if ( empty( $tmq_logo_padding ) ) { 
				$tmq_logo_padding = '48';
			}
			$tmq_color_settings .=
			'/* Logo Positioning */' . "\n" .
			'.header-logo {' . "\n" .
			'	padding-top: ' . $tmq_logo_padding . 'px;' . "\n" .
			'	padding-bottom: ' . $tmq_logo_padding . 'px;' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'';	
			
			/* ==========================================================================
			   Logo Settings - Text Logo
			   ========================================================================== */
			$tmq_logo_font_size = ot_get_option( 'tmq_logo_font_size' );
			if ( empty( $tmq_logo_font_size ) ) { 
				$tmq_logo_font_size = '32';
			}
			$tmq_logo_color = ot_get_option( 'tmq_logo_color' );
			if ( empty( $tmq_logo_color ) ) { 
				$tmq_logo_color = '#000000';
			}
			$tmq_logo_color_2 = ot_get_option( 'tmq_logo_color_2' );
			if ( empty( $tmq_logo_color_2 ) ) { 
				$tmq_logo_color_2 = '#ffffff';
			}
			$tmq_color_settings .=
			'/* Text Logo Font Size */' . "\n" .
			'a.navbar-brand span {' . "\n" .
			'	font-size: ' . $tmq_logo_font_size . 'px;' . "\n" .
			'	color: ' . $tmq_logo_color . ';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'header.active a.navbar-brand span {' . "\n" .
			'	color: ' . $tmq_logo_color_2 . ';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'';		
			
			/* ==========================================================================
			   OnePager Top Menu?
			   ========================================================================== */
			$tmq_onepage_mainmenu = ot_get_option( 'tmq_onepage_mainmenu' );
			if ( empty( $tmq_onepage_mainmenu ) ) { 
				$tmq_onepage_mainmenu = 'off';
			}
			
			if ( $tmq_onepage_mainmenu == 'on' ) {
				$tmq_color_settings .=
				'/* Show Main Menu In OnePager */' . "\n" .
				'body.page-template-onepage-php nav#main-menu {' . "\n" .
				'	 display: block;' . "\n" .
				'}' . "\n" .
				'' . "\n" .
				'';	
			}	
			
			/* ==========================================================================
			   Default Paragraph Font Color
			   ========================================================================== */
			
			if ( $tmq_dark_light == 'dark' ) {
				// Dark theme
				$tmq_page_p_color = ot_get_option( 'tmq_page_p_color_dark' );
			
				if ( empty( $tmq_page_p_color ) ) { 
					$tmq_page_p_color = '#eeeeee';
				}			
			} else {
				// Light theme
				$tmq_page_p_color = ot_get_option( 'tmq_page_p_color_light' );
			
				if ( empty( $tmq_page_p_color ) ) { 
					$tmq_page_p_color = '#666666';
				}			
			}

			
			$tmq_color_settings .=
			'/* Set default font color for all paragraphs */' . "\n" .
			'div, p, a {' . "\n" .
			'	color: ' . $tmq_page_p_color . ';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'';
			
			/* ==========================================================================
			   Menu Settings - Sticky Menu
			   ========================================================================== */
			$tmq_sticky_menu = ot_get_option( 'tmq_sticky_menu' );
			if ( empty( $tmq_sticky_menu ) ) { 
				$tmq_sticky_menu = 'on';
			}
			if ( $tmq_sticky_menu == 'off' ) {
				// We need this only if it's disabled
				$tmq_color_settings .=
				'/* Disable Sticky Menu */' . "\n" .
				'.navbar.navbar-inverse.navbar-fixed-top {' . "\n" .
				'	position: absolute;' . "\n" .
				'}' . "\n" .
				'' . "\n" .
				'.admin-bar header {' . "\n" .
				'	top: 45px;' . "\n" .
				'}' . "\n" .
				'' . "\n" .
				'';
			}
			
			/* ==========================================================================
			   Typography Settings - Paragraphs
			   ========================================================================== */				
			$tmq_paragraph_font = googlefontfamily('name', 'tmq_paragraph_font');
			if ( empty( $tmq_paragraph_font ) ) { 
				$tmq_paragraph_font = 'open sans';
			}
			$tmq_paragraph_font_array = ot_get_option( 'tmq_paragraph_font' );
			$tmq_paragraph_fontsize = ( isset( $tmq_paragraph_font_array['font-size'] ) && 'font-size' != $tmq_paragraph_font_array['font-size'] && !empty( $tmq_paragraph_font_array['font-size'] ) ) ? $tmq_paragraph_font_array['font-size'] : '14px';
			$tmq_paragraph_lineheight = ( isset( $tmq_paragraph_font_array['line-height'] ) && 'line-height' != $tmq_paragraph_font_array['line-height'] && !empty( $tmq_paragraph_font_array['line-height'] ) ) ? $tmq_paragraph_font_array['line-height'] : '1.4';
			$tmq_color_settings .=
			'/* Default Paragraph Font Setting */' . "\n" .
			'body, p {' . "\n" .
			'	font-family: "' . $tmq_paragraph_font . '", "sans serif";' . "\n" .
			'	font-size: ' . $tmq_paragraph_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'';				
			
			/* ==========================================================================
			   Menu Settings - Fonts and ...
			   ========================================================================== */			
			// Get Menu Font Settings
			$tmq_menu_fontfamily = googlefontfamily('name', 'tmq_menu_webfont');
			if ( empty( $tmq_menu_fontfamily ) ) { 
				$tmq_menu_fontfamily = 'open sans';
			}
			
			// Menu 1st Level Font Size
			$tmq_menu_fontsize = ot_get_option( 'tmq_menu_fontsize' );
			if ( is_array( $tmq_menu_fontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_menu_fontsize[0] ) ) {
					$tmq_menu_fontsize_number = $tmq_menu_fontsize[0];
			
					// Set a minumum and maximum number
					if ( $tmq_menu_fontsize[0] > 24 ) {
						$tmq_menu_fontsize_number = 24;
					} elseif ( $tmq_menu_fontsize[0] < 11 ) {
						$tmq_menu_fontsize_number = 11;
					}						

				} else {
					$tmq_menu_fontsize_number = 16;
				}

				// Check unit is set properly
				if ( empty( $tmq_menu_fontsize[1] ) ) {
					$tmq_menu_fontsize_unit = 'px';
				} else {
					$tmq_menu_fontsize_unit = $tmq_menu_fontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_menu_fontsize_number = 16;
				$tmq_menu_fontsize_unit = 'px';
			}
			   
			// Menu 2nd+ Level Font Size
			$tmq_menu_l2_fontsize = ot_get_option( 'tmq_menu_l2_fontsize' );
			if ( is_array( $tmq_menu_l2_fontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_menu_l2_fontsize[0] ) ) {
					$tmq_menu_l2_fontsize_number = $tmq_menu_l2_fontsize[0];
					
					// Set a minumum and maximum number
					if ( $tmq_menu_l2_fontsize[0] > 24 ) {
						$tmq_menu_l2_fontsize_number = 24;
					} elseif ( $tmq_menu_l2_fontsize[0] < 11 ) {
						$tmq_menu_l2_fontsize_number = 11;
					}	
					
				} else {
					$tmq_menu_l2_fontsize_number = 14;
				}
				
				// Check unit is set properly
				if ( empty( $tmq_menu_l2_fontsize[1] ) ) {
					$tmq_menu_l2_fontsize_unit = 'px';
				} else {
					$tmq_menu_l2_fontsize_unit = $tmq_menu_l2_fontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_menu_l2_fontsize_number = 14;
				$tmq_menu_l2_fontsize_unit = 'px';
			}
			
			// Get submenu width
			$tmq_menu_l2_width = ot_get_option( 'tmq_menu_l2_width' );
			if ( !is_numeric( $tmq_menu_l2_width ) ) {
				// Validate it
				$tmq_menu_l2_width = 200;
			}
			
			// Get submenu padding
			$tmq_menu_l2_padding = ot_get_option( 'tmq_menu_l2_padding' );
			if ( !is_numeric( $tmq_menu_l2_padding ) ) {
				// Validate it
				$tmq_menu_l2_padding = 10;
			}			
			
			$tmq_color_settings .=
			'/* Menu Font Setting */' . "\n" .
			'nav#main-menu {' . "\n" .
			'	font-family: "' . $tmq_menu_fontfamily . '", "sans serif";' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container > ul > li > a {' . "\n" .
			'	font-size: ' . $tmq_menu_fontsize_number . $tmq_menu_fontsize_unit . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container > ul > li.drop > .menu-container a {' . "\n" .
			'	font-size: ' . $tmq_menu_l2_fontsize_number . $tmq_menu_l2_fontsize_unit . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container .menu-container {' . "\n" .
			'	min-width: ' . $tmq_menu_l2_width . 'px;' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container .menu-container .menu-container {' . "\n" .
			'	left: ' . $tmq_menu_l2_width . 'px;' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'nav#main-menu > .menu-container .menu-container ul > li > a {' . "\n" .
			'	padding-top: ' . $tmq_menu_l2_padding . 'px;' ."\n" .
			'	padding-bottom: ' . $tmq_menu_l2_padding . 'px;' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'';	
			
			/* ==========================================================================
			   Breadcrumb Settings
			   ========================================================================== */
			$tmq_brcr_format = ot_get_option( 'tmq_brcr_format' );
			if ( $tmq_brcr_format == 'tmq_none' ) { 
				$tmq_brcr_format = 'none';
			} elseif ( $tmq_brcr_format == 'tmq_uppercase' ) { 
				$tmq_brcr_format = 'uppercase';
			} elseif ( $tmq_brcr_format == 'tmq_capitalize' ) { 
				$tmq_brcr_format = 'capitalize';
			} else {
				// This is our preferred setting so set it as default!
				$tmq_brcr_format = 'lowercase';
			}
			
			$tmq_brcr_visibility = ot_get_option( 'tmq_brcr' );
			if ( empty( $tmq_brcr_visibility ) ) { 
				$tmq_brcr_visibility = 'tmq_show';
			}
			
			if ( 'tmq_hide' == $tmq_brcr_visibility ) {
				$tmq_color_settings .=
				'/* Hidden Breadcrumb Area */' . "\n" .
				'#page-banner {' . "\n" .
				'	display: none;' . "\n" .
				'}' . "\n" .
				'' . "\n" .
				'';				
			}
			
			$tmq_color_settings .=
			'/* Breadcrumb text format */' . "\n" .
			'ol.breadcrumb {' . "\n" .
			'	text-transform: ' . $tmq_brcr_format . ';' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'';			

			/* ==========================================================================
			   Typography Settings - H1 to H6
			   ========================================================================== */				
			// H1 to H6 Font Family
			$tmq_heading_webfont = googlefontfamily('name', 'tmq_heading_webfont');
			if ( empty( $tmq_heading_webfont ) ) { 
				$tmq_heading_webfont = 'open sans';
			}

			// H1 Tag
			$tmq_h1_googlefontsize = ot_get_option( 'tmq_h1_font' );
			if ( is_array( $tmq_h1_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h1_googlefontsize[0] ) ) {
					$tmq_h1_fontsize_number = $tmq_h1_googlefontsize[0];
				} else {
					$tmq_h1_fontsize_number = 38;
				}

				// Check unit is set properly
				if ( empty( $tmq_h1_googlefontsize[1] ) ) {
					$tmq_h1_fontsize_unit = 'px';
				} else {
					$tmq_h1_fontsize_unit = $tmq_h1_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h1_fontsize_number = 38;
				$tmq_h1_fontsize_unit = 'px';
			}
			
			// Set H1 font size variable
			$tmq_h1_fontsize = $tmq_h1_fontsize_number . $tmq_h1_fontsize_unit;
			
			// H2 Tag
			$tmq_h2_googlefontsize = ot_get_option( 'tmq_h2_font' );
			if ( is_array( $tmq_h2_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h2_googlefontsize[0] ) ) {
					$tmq_h2_fontsize_number = $tmq_h2_googlefontsize[0];
				} else {
					$tmq_h2_fontsize_number = 24;
				}

				// Check unit is set properly
				if ( empty( $tmq_h2_googlefontsize[1] ) ) {
					$tmq_h2_fontsize_unit = 'px';
				} else {
					$tmq_h2_fontsize_unit = $tmq_h2_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h2_fontsize_number = 24;
				$tmq_h2_fontsize_unit = 'px';
			}
			
			// Set H2 font size variable
			$tmq_h2_fontsize = $tmq_h2_fontsize_number . $tmq_h2_fontsize_unit;			
			
			// H3 Tag
			$tmq_h3_googlefontsize = ot_get_option( 'tmq_h3_font' );
			if ( is_array( $tmq_h3_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h3_googlefontsize[0] ) ) {
					$tmq_h3_fontsize_number = $tmq_h3_googlefontsize[0];
				} else {
					$tmq_h3_fontsize_number = 22;
				}

				// Check unit is set properly
				if ( empty( $tmq_h3_googlefontsize[1] ) ) {
					$tmq_h3_fontsize_unit = 'px';
				} else {
					$tmq_h3_fontsize_unit = $tmq_h3_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h3_fontsize_number = 22;
				$tmq_h3_fontsize_unit = 'px';
			}
			
			// Set H3 font size variable
			$tmq_h3_fontsize = $tmq_h3_fontsize_number . $tmq_h3_fontsize_unit;
			
			// H4 Tag
			$tmq_h4_googlefontsize = ot_get_option( 'tmq_h4_font' );
			if ( is_array( $tmq_h4_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h4_googlefontsize[0] ) ) {
					$tmq_h4_fontsize_number = $tmq_h4_googlefontsize[0];
				} else {
					$tmq_h4_fontsize_number = 18;
				}

				// Check unit is set properly
				if ( empty( $tmq_h4_googlefontsize[1] ) ) {
					$tmq_h4_fontsize_unit = 'px';
				} else {
					$tmq_h4_fontsize_unit = $tmq_h4_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h4_fontsize_number = 18;
				$tmq_h4_fontsize_unit = 'px';
			}
			
			// Set H4 font size variable
			$tmq_h4_fontsize = $tmq_h4_fontsize_number . $tmq_h4_fontsize_unit;
			
			// H5 Tag
			$tmq_h5_googlefontsize = ot_get_option( 'tmq_h5_font' );
			if ( is_array( $tmq_h5_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h5_googlefontsize[0] ) ) {
					$tmq_h5_fontsize_number = $tmq_h5_googlefontsize[0];
				} else {
					$tmq_h5_fontsize_number = 15;
				}

				// Check unit is set properly
				if ( empty( $tmq_h5_googlefontsize[1] ) ) {
					$tmq_h5_fontsize_unit = 'px';
				} else {
					$tmq_h5_fontsize_unit = $tmq_h5_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h5_fontsize_number = 15;
				$tmq_h5_fontsize_unit = 'px';
			}
			
			// Set H5 font size variable
			$tmq_h5_fontsize = $tmq_h5_fontsize_number . $tmq_h5_fontsize_unit;
			
			// H6 Tag
			$tmq_h6_googlefontsize = ot_get_option( 'tmq_h6_font' );
			if ( is_array( $tmq_h6_googlefontsize ) ) {
				// Validate it
				if ( is_numeric( $tmq_h6_googlefontsize[0] ) ) {
					$tmq_h6_fontsize_number = $tmq_h6_googlefontsize[0];
				} else {
					$tmq_h6_fontsize_number = 12;
				}

				// Check unit is set properly
				if ( empty( $tmq_h6_googlefontsize[1] ) ) {
					$tmq_h6_fontsize_unit = 'px';
				} else {
					$tmq_h6_fontsize_unit = $tmq_h6_googlefontsize[1];
				}
			} else {
				// It's empty - Set Default
				$tmq_h6_fontsize_number = 12;
				$tmq_h6_fontsize_unit = 'px';
			}
			
			// Set H6 font size variable
			$tmq_h6_fontsize = $tmq_h6_fontsize_number . $tmq_h6_fontsize_unit;
					
			$tmq_color_settings .=
			'/* Headings Font Setting */' . "\n" .
			'h1, h2, h3, h4, h5, h6 {' . "\n" .
			'	font-family: "' . $tmq_heading_webfont . '", "sans serif";' . "\n" .
			'}' . "\n" .
			'' . "\n" .
			'h1 {' . "\n" .
			'	font-size: ' . $tmq_h1_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'h2 {' . "\n" .
			'	font-size: ' . $tmq_h2_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'h3 {' . "\n" .
			'	font-size: ' . $tmq_h3_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'h4 {' . "\n" .
			'	font-size: ' . $tmq_h4_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'h5 {' . "\n" .
			'	font-size: ' . $tmq_h5_fontsize . ';' ."\n" .
			'}' . "\n" .
			'' . "\n" .
			'h6 {' . "\n" .
			'	font-size: ' . $tmq_h6_fontsize . ';' ."\n" .
			'}' . "\n" .
			'';							
			
			return $tmq_color_settings;
			/* ====================================== */
			/*	Dynamic CSS For ALL Updates :: END!   */
			/* ====================================== */
		}
		return $value;
	}
	add_filter( 'ot_insert_css_with_markers_value', 'filter_css_value', 10, 2 );

		
/* ==========================================================================
   Add Font Awesome Option
   ========================================================================== */
	function add_fontawesome_select_type( $array ) {
		$array['revslider-select'] = 'Revolution Slider Select';
		return $array;
	}
	add_filter( 'ot_option_types_array', 'add_fontawesome_select_type' );	

/* ==========================================================================
   Show Font Awesome Option
   ========================================================================== */
	function ot_type_fontawesome_select( $args = array() ) {
	  extract( $args );
	  $has_desc = $field_desc ? true : false;
	  echo '<div class="format-setting type-fontawesome-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';
	  echo html_entity_decode( $has_desc ) ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';
		echo '<div class="format-setting-inner">';
		if ( 1 == 1 ) {
			$tmq_icons_set = '';
			$tmq_icons_set .= '<div class="tmq-icon-container tmq-icon-container-ot">';
			$tmq_icons_set .= '<input type="text" name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" value="'. $field_value .'"/>';
			$tmq_icons_set .= "\n\t" . '<div class="tabs-heading">';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="new">New</a>';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="web-apps">Web Apps</a>';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="editor">Editor</a>';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="directional">Directional</a>';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="brands">Brands</a>';
			$tmq_icons_set .= "\n\t\t" . '<a href="#" id="other">Other</a>';
			$tmq_icons_set .= "\n\t" . '</div>';
			$tmq_icons_set .= "\n\t" . '<div class="iconslist">';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="new">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bed"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-buysellads"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cart-arrow-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cart-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-connectdevelop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dashcube"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-diamond"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-facebook-official"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-forumbee"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heartbeat"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hotel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-leanpub"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-double"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke-h"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke-v"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-medium"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mercury"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-motorcycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-neuter"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pinterest-p"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sellsy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-server"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ship"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-shirtsinbulk"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-simplybuilt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-skyatlas"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-street-view"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-subway"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-train"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-transgender"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-transgender-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-secret"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-times"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus-double"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus-mars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-viacoin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-whatsapp"></i></li>';
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="web-apps">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-adjust"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-anchor"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-archive"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-area-chart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-h"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-v"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-asterisk"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-at"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-automobile"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ban"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bank"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bar-chart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bar-chart-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-barcode"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bed"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-beer"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bell"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bell-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bell-slash"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bell-slash-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bicycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-binoculars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-birthday-cake"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bolt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bomb"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-book"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bookmark"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bookmark-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-briefcase"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bug"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-building"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-building-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bullhorn"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bullseye"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cab"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-calculator"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-calendar"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-calendar-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-camera"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-camera-retro"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-car"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cart-arrow-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cart-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-certificate"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-check"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-check-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-check-circle-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-check-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-check-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-child"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-circle-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-circle-o-notch"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-circle-thin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-clock-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-close"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cloud"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cloud-download"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cloud-upload"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-code"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-code-fork"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-coffee"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cog"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cogs"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-comment"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-comment-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-comments"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-comments-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-compass"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-copyright"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-credit-card"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-crop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-crosshairs"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cube"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cubes"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cutlery"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dashboard"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-database"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-desktop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-diamond"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dot-circle-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-download"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-edit"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ellipsis-h"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ellipsis-v"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-envelope"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-envelope-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-envelope-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eraser"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-exchange"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-exclamation"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-exclamation-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-exclamation-triangle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-external-link"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-external-link-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eye"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eye-slash"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eyedropper"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fax"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-female"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fighter-jet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-archive-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-audio-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-code-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-excel-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-image-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-movie-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-pdf-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-photo-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-picture-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-powerpoint-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-sound-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-video-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-word-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-zip-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-film"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-filter"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fire"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fire-extinguisher"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flag"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flag-checkered"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flag-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flash"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flask"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-folder"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-folder-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-folder-open"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-folder-open-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-frown-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-futbol-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gamepad"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gavel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gear"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gears"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-genderless"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gift"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-glass"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-globe"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-graduation-cap"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-group"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hdd-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-headphones"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heart-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heartbeat"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-history"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-home"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hotel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-image"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-inbox"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-info"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-info-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-institution"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-key"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-keyboard-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-language"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-laptop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-leaf"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-legal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-lemon-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-level-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-level-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-life-bouy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-life-buoy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-life-ring"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-life-saver"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-lightbulb-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-line-chart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-location-arrow"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-lock"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-magic"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-magnet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mail-forward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mail-reply"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mail-reply-all"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-male"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-map-marker"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-meh-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-microphone"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-microphone-slash"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-minus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-minus-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-minus-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-minus-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mobile"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mobile-phone"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-money"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-moon-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mortar-board"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-motorcycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-music"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-navicon"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-newspaper-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paint-brush"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paper-plane"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paper-plane-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paw"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pencil"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pencil-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pencil-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-phone"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-phone-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-photo"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-picture-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pie-chart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plane"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plug"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plus-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plus-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plus-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-power-off"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-print"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-puzzle-piece"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-qrcode"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-question"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-question-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-quote-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-quote-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-random"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-recycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-refresh"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-remove"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-reorder"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-reply"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-reply-all"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-retweet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-road"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rocket"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rss"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rss-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-search"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-search-minus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-search-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-send"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-send-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-server"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-alt-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-shield"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ship"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-shopping-cart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sign-in"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sign-out"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-signal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sitemap"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sliders"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-smile-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-soccer-ball-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-alpha-asc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-alpha-desc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-amount-asc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-amount-desc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-asc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-desc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-numeric-asc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-numeric-desc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sort-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-space-shuttle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-spinner"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-spoon"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-square-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star-half"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star-half-empty"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star-half-full"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star-half-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-star-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-street-view"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-suitcase"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sun-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-support"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tablet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tachometer"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tag"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tags"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tasks"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-taxi"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-terminal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-thumb-tack"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-thumbs-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-thumbs-o-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-thumbs-o-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-thumbs-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ticket"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-times"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-times-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-times-circle-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tint"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-off"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-on"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-trash"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-trash-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tree"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-trophy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-truck"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tty"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-umbrella"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-university"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-unlock"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-unlock-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-unsorted"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-upload"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-secret"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-times"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-users"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-video-camera"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-volume-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-volume-off"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-volume-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-warning"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wheelchair"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wifi"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wrench"></i></li>';
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="editor">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-align-center"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-align-justify"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-align-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-align-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bold"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chain"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chain-broken"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-clipboard"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-columns"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-copy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cut"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dedent"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eraser"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-text"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-text-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-files-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-floppy-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-font"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-header"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-indent"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-italic"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-link"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-list"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-list-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-list-ol"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-list-ul"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-outdent"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paperclip"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paragraph"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paste"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-repeat"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rotate-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rotate-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-save"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-scissors"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-strikethrough"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-subscript"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-superscript"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-table"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-text-height"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-text-width"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-th"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-th-large"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-th-list"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-underline"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-undo"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-unlink"></i></li>';
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="directional">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-double-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-double-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-double-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-double-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angle-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-o-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-o-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-o-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-o-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-circle-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrow-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-h"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-v"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-square-o-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-caret-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-circle-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-circle-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-circle-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-circle-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-chevron-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hand-o-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hand-o-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hand-o-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hand-o-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-long-arrow-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-long-arrow-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-long-arrow-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-long-arrow-up"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-down"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-left"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-right"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-toggle-up"></i></li>';
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="brands">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-adn"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-android"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-angellist"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-apple"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-behance"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-behance-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bitbucket"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bitbucket-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bitcoin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-btc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-buysellads"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-amex"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-discover"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-mastercard"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-paypal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-stripe"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cc-visa"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-codepen"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-connectdevelop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-css3"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dashcube"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-delicious"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-deviantart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-digg"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dribbble"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dropbox"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-drupal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-empire"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-facebook"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-facebook-f"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-facebook-official"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-facebook-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-flickr"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-forumbee"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-foursquare"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ge"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-git"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-git-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-github"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-github-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-github-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gittip"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-google"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-google-plus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-google-plus-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-google-wallet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gratipay"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hacker-news"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-html5"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-instagram"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ioxhost"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-joomla"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-jsfiddle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-lastfm"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-lastfm-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-leanpub"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-linkedin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-linkedin-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-linux"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-maxcdn"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-meanpath"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-medium"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-openid"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pagelines"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-paypal"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pied-piper"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pied-piper-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pinterest"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pinterest-p"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pinterest-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-qq"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ra"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rebel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-reddit"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-reddit-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-renren"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sellsy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-share-alt-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-shirtsinbulk"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-simplybuilt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-skyatlas"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-skype"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-slack"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-slideshare"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-soundcloud"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-spotify"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stack-exchange"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stack-overflow"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-steam"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-steam-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stumbleupon"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stumbleupon-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tencent-weibo"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-trello"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tumblr"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-tumblr-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-twitch"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-twitter"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-twitter-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-viacoin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-vimeo-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-vine"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-vk"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wechat"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-weibo"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-weixin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-whatsapp"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-windows"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wordpress"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-xing"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-xing-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-yahoo"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-yelp"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-youtube"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-youtube-play"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-youtube-square"></i></li>';
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t\t" . '<ul data-page="other">';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ambulance"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-automobile"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bicycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cab"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-car"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fighter-jet"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-motorcycle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plane"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rocket"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ship"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-space-shuttle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-subway"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-taxi"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-train"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-truck"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wheelchair"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-circle-thin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-genderless"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-double"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke-h"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mars-stroke-v"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-mercury"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-neuter"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-transgender"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-transgender-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus-double"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-venus-mars"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-archive-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-audio-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-code-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-excel-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-image-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-movie-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-pdf-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-photo-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-picture-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-powerpoint-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-sound-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-text"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-text-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-video-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-word-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-file-zip-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-bitcoin"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-btc"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-cny"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-dollar"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eur"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-euro"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-gbp"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ils"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-inr"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-jpy"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-krw"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-money"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rmb"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rouble"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rub"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ruble"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-rupee"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-shekel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-sheqel"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-try"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-turkish-lira"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-usd"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-won"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-yen"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-arrows-alt"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-backward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-compress"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-eject"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-expand"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fast-backward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-fast-forward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-forward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-pause"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-play"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-play-circle"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-play-circle-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-step-backward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-step-forward"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stop"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-youtube-play"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-ambulance"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-h-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heart"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heart-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-heartbeat"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-hospital-o"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-medkit"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-plus-square"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-stethoscope"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-user-md"></i></li>';
			$tmq_icons_set .= "\n\t\t\t" . '<li><i class="fa fa-wheelchair"></i></li>';			
			$tmq_icons_set .= "\n\t\t" . '</ul>';
			$tmq_icons_set .= "\n\t" . '</div>';
			$tmq_icons_set .= '</div>';
			$tmq_icons_set .= '<div class="icons-preview">';
			$tmq_icons_set .= '<span class="icon-zoom"><i class="fa ' . $field_value . '"></i></span>';
			$tmq_icons_set .= '<span class="icon-name">' . $field_value . '</span>';
			$tmq_icons_set .= '</div>';		
			echo html_entity_decode( $tmq_icons_set );
		}
		echo '</div>';
	  echo '</div>';
	}		
		
		
/* ==========================================================================
   Add Revolution Slider select option
   ========================================================================== */
	function add_revslider_select_type( $array ) {
		$array['revslider-select'] = 'Revolution Slider Select';
		return $array;
	}
	add_filter( 'ot_option_types_array', 'add_revslider_select_type' );	

/* ==========================================================================
   Show RevolutionSlider select option
   ========================================================================== */
	function ot_type_revslider_select( $args = array() ) {
	  extract( $args );
	  $has_desc = $field_desc ? true : false;
	  echo '<div class="format-setting type-revslider-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';
	  echo html_entity_decode( $has_desc ) ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';
		echo '<div class="format-setting-inner">';
		// Add This only if RevSlider is Activated
		if ( class_exists( 'RevSliderAdmin' ) ) {
		  echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">';

		  /* get revolution array */
		  $slider = new RevSlider();
		  $arrSliders = $slider->getArrSlidersShort();

		  /* has slides */
		  if ( ! empty( $arrSliders ) ) {
			echo '<option value="">-- ' . __( 'Choose One', 'bokeh' ) . ' --</option>';
			foreach ( $arrSliders as $rev_id => $rev_slider ) {
			  echo '<option value="' . esc_attr( $rev_id ) . '"' . selected( $field_value, $rev_id, false ) . '>' . esc_attr( $rev_slider ) . '</option>';
			}
		  } else {
			echo '<option value="">' . __( 'No Sliders Found', 'bokeh' ) . '</option>';
		  }
		  echo '</select>';
		} else {
			echo '<span style="color: red;">' . __( 'Sorry! Revolution Slider is not Installed or Activated', 'bokeh' ). '</span>';
		}
		echo '</div>';
	  echo '</div>';
	}
	
/* ==========================================================================
   ADD CUSTOM TYPOGRAPHY OPTION
   ========================================================================== */	
	if ( ! function_exists( 'ot_google_webfont_families' ) ) {
	  function ot_google_webfont_families( $field_id = '' ) {
		return apply_filters( 'ot_google_webfont_families', array(
		  'pt_sans_narrow' 		=> '"PT Sans Narrow"',
		  'open_sans_condensed'	=> '"Open Sans Condensed"',
		  'abel'				=> '"Abel"',
		  'source_sans_pro'     => '"Source Sans Pro"',
		  'open_sans'   		=> '"Open Sans"',
		  'pt_sans'  			=> '"PT Sans"',
		  'merriweather_sans'	=> '"Merriweather Sans"',
		  'alef'   				=> '"Alef"',
		  'dosis'   			=> '"Dosis"',
		  'archivo_narrow'		=> '"Archivo Narrow"',
		  'roboto'				=> '"Roboto"',
		  'roboto_condensed'	=> '"Roboto Condensed"',
		  'roboto_slab'			=> '"Roboto Slab"',
		  'raleway'				=> '"Raleway"',
		  'montserrat'			=> '"Montserrat"',
		  'droid_sans'   		=> '"Droid Sans"',
		  'oswald'   			=> '"Oswald"',
		  'ubuntu'   			=> '"Ubuntu"',
		  'lato'   				=> '"Lato"',
		  'lora'   				=> '"Lora"',
		  'ubuntu_condensed'	=> '"Ubuntu Condensed"',
		  'rationale'			=> '"Rationale"',
		  'benchnine'			=> '"Benchnine"',
		  'yanone_kaffeesatz'	=> '"Yanone Kaffeesatz"',
		  'economica'			=> '"Economica"',
		  'cuprum'   			=> '"Cuprum"',
		  'nobile'   			=> '"Nobile"',
		  'nunito'   			=> '"Nunito"',
		  'questrial'   		=> '"Questrial"',
		  'muli'   				=> '"Muli"'
		), $field_id );
	  }
	}

/* ==========================================================================
   Add custom sidebar select option
   ========================================================================== */
	function add_googlefonts_select_type( $array ) {
	  $array['googlefonts-select'] = 'Google Fonts';
	  return $array;
	}
	add_filter( 'ot_option_types_array', 'add_googlefonts_select_type' );

/* ==========================================================================
   Show Google Web Fonts
   ========================================================================== */
	function ot_type_googlefonts_select( $args = array() ) {

		/* turns arguments array into variables */
		extract( $args );

		/* verify a description */
		$has_desc = $field_desc ? true : false;

		/* format setting outer wrapper */
		echo '<div class="format-setting type-typography ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

		/* description */
		echo html_entity_decode( $has_desc ) ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

		/* format setting inner wrapper */
		echo '<div class="format-setting-inner">'; 
		
		/* allow fields to be filtered */
		$ot_recognized_typography_fields = apply_filters( 'ot_recognized_typography_fields', array( 
		  'font-family', 
		  'font-size', 
		  'font-style', 
		  'line-height'
		), $field_id );
		
		/* build font family */
		if ( in_array( 'font-family', $ot_recognized_typography_fields ) ) {
		  $font_family = isset( $field_value['font-family'] ) ? $field_value['font-family'] : '';
		  echo '<select name="' . esc_attr( $field_name ) . '[font-family]" id="' . esc_attr( $field_id ) . '-font-family" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
			echo '<option value="">font-family</option>';
			foreach ( ot_google_webfont_families( $field_id ) as $key => $value ) {
			  echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_family, $key, false ) . '>' . esc_attr( $value ) . '</option>';
			}
		  echo '</select>';
		}
		
		/* build font size */
		if ( in_array( 'font-size', $ot_recognized_typography_fields ) ) {
		  $font_size = isset( $field_value['font-size'] ) ? esc_attr( $field_value['font-size'] ) : '';
		  echo '<select name="' . esc_attr( $field_name ) . '[font-size]" id="' . esc_attr( $field_id ) . '-font-size" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
			echo '<option value="">font-size</option>';
			foreach( ot_recognized_font_sizes( $field_id ) as $option ) { 
			  echo '<option value="' . esc_attr( $option ) . '" ' . selected( $font_size, $option, false ) . '>' . esc_attr( $option ) . '</option>';
			}
		  echo '</select>';
		}
		
		/* build font style */
		if ( in_array( 'font-style', $ot_recognized_typography_fields ) ) {
		  $font_style = isset( $field_value['font-style'] ) ? esc_attr( $field_value['font-style'] ) : '';
		  echo '<select name="' . esc_attr( $field_name ) . '[font-style]" id="' . esc_attr( $field_id ) . '-font-style" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
			echo '<option value="">font-style</option>';
			foreach ( ot_recognized_font_styles( $field_id ) as $key => $value ) {
			  echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_style, $key, false ) . '>' . esc_attr( $value ) . '</option>';
			}
		  echo '</select>';
		}
		
		/* build line height */
		if ( in_array( 'line-height', $ot_recognized_typography_fields ) ) {
		  $line_height = isset( $field_value['line-height'] ) ? esc_attr( $field_value['line-height'] ) : '';
		  echo '<select name="' . esc_attr( $field_name ) . '[line-height]" id="' . esc_attr( $field_id ) . '-line-height" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
			echo '<option value="">line-height</option>';
			foreach( ot_recognized_line_heights( $field_id ) as $option ) { 
			  echo '<option value="' . esc_attr( $option ) . '" ' . selected( $line_height, $option, false ) . '>' . esc_attr( $option ) . '</option>';
			}
		  echo '</select>';
		}	
	  echo '</div>';
	echo '</div>';

	}

/* ==========================================================================
   ADD CUSTOM TYPOGRAPHY OPTION SMALL
   ========================================================================== */
	function add_googlefonts_select_type_small( $array ) {
		$array['googlefonts-select-small'] = 'Google Fonts Small';
		return $array;
	}
	add_filter( 'ot_option_types_array', 'add_googlefonts_select_type_small' );

/* ==========================================================================
   SHOW GOOGLE WEB FONTS
   ========================================================================== */
	function ot_type_googlefonts_select_small( $args = array() ) {
		/* turns arguments array into variables */
		extract( $args );
		/* verify a description */
		$has_desc = $field_desc ? true : false;
		/* format setting outer wrapper */
		echo '<div class="format-setting type-typography ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';
		/* description */
		echo html_entity_decode( $has_desc ) ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';
		/* format setting inner wrapper */
		echo '<div class="format-setting-inner">'; 
		/* allow fields to be filtered */
		$ot_recognized_typography_fields = apply_filters( 'ot_recognized_typography_fields', array( 
		'font-family'
		), $field_id );
		
		/* build font family */
		if ( in_array( 'font-family', $ot_recognized_typography_fields ) ) {
		  $font_family = isset( $field_value['font-family'] ) ? $field_value['font-family'] : '';
		  echo '<select name="' . esc_attr( $field_name ) . '[font-family]" id="' . esc_attr( $field_id ) . '-font-family" class="option-tree-ui-select ' . esc_attr( $field_class ) . '">';
			echo '<option value="">font-family</option>';
			foreach ( ot_google_webfont_families( $field_id ) as $key => $value ) {
			  echo '<option value="' . esc_attr( $key ) . '" ' . selected( $font_family, $key, false ) . '>' . esc_attr( $value ) . '</option>';
			}
		  echo '</select>';
		}
		echo '</div>';
		echo '</div>';
	}	
?>