<?php
/**
 * Initialize the meta boxes. 
 */
add_action( 'admin_init', 'tmq_bokeh_meta_boxes' );

/**
 * @access    private
 * @since     2.0
 */
 
function tmq_bokeh_meta_boxes() {
	// Get supported post formats
	$format_arg = array( 'gallery', 'video' );
	if ( is_array( $format_arg ) ) {
		add_theme_support( 'post-formats', $format_arg );
	}
	/**
	* After adding the theme support, we add an empty item to $format_arg to make it an array to prevent system 
	* conflict null and array
	*/	
	if ( empty( $format_arg ) ) {
		$format_arg[] = '';
	}
  
  /**
   * Create a custom meta boxes array that we pass to 
   * the OptionTree Meta Box API Class.
   */

   // Get Sidebars in Array
	$tmq_sidebarsArray = array();
	
	$tmq_sidebarsArray[] = array('label' => __('Default (Theme Options)', 'bokeh'), 'value' => 'theme-options');
	$tmq_sidebarsArray[] = array('label' => __('Right Sidebar', 'bokeh'), 'value' => tmq_generateSlug('right-sidebar', 45));
	$tmq_sidebarsArray[] = array('label' => __('Left Sidebar', 'bokeh'), 'value' => tmq_generateSlug('left-sidebar', 45));

	$tmq_customsidebars = ot_get_option( 'tmq_customsidebars' );
	if(!empty($tmq_customsidebars) && sizeof($tmq_customsidebars) > 0)  
	{  
		foreach($tmq_customsidebars as $sidebar)  
		{  
			foreach( $sidebar as $myside ) {
				$tmq_sidebarsArray[] = array('label' => $myside, 'value' => tmq_generateSlug($myside, 45));
			}
		}  
	} 
	//End Get Sidebars
	
	$tmq_post_options = array (
		array(
			'id'          => 'tmq_sidebar_settings',
			'title'       => __('Sidebar Settings', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'page', 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'id'          => 'tmq_sidebar_position',
					'label'       => __('Sidebar Position', 'bokeh'),
					'std'         => 'tmq_default',
					'type'        => 'radio-image',
					'section'     => 'tmq_pageoptions_sec',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
							'value'       => 'tmq_leftsidebar',
							'label'       => __('Left Sidebar', 'bokeh'),
							'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_left_105.png'
						),
						array(
							'value'       => 'tmq_rightsidebar',
							'label'       => __('Right Sidebar', 'bokeh'),
							'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_right_105.png'
						),
						array(
							'value'       => 'tmq_fullwidth',
							'label'       => __('Full Width', 'bokeh'),
							'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_full_width_105.png'
						),
						array(
							'value'       => 'tmq_default',
							'label'       => __('Default (Read From Theme Options)', 'bokeh'),
							'src'         => get_template_directory_uri() . '/includes/framework/images/sch_sides_default_105.png'
						)
					),
				),
				array(
					'label'       => __('Choose Sidebar (If appliable)', 'bokeh'),
					'id'          => 'tmq_pagesidebar',
					'type'        => 'sidebar-select',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'condition'   => 'tmq_sidebar_position:not(tmq_fullwidth)',
					'operator'    => 'and',						
					'taxonomy'    => '',
					'class'       => ''
				),
				array(
					'id'          => 'tmq_pagesidebar_desc',
					'type'        => 'textblock',
					'desc'        => 'Leave the above field empty to read the default sidebar from theme options',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'condition'   => 'tmq_sidebar_position:isnot(tmq_fullwidth)',
					'operator'    => 'and',						
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_onepage_multilingual',
			'title'       => __('Set as Onepage Homepage (WPML)', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'page' ),
			'context'     => 'side',
			'priority'    => 'core',
			'fields'      => array(
				array(
					'id'          => 'tmq_onepage_enabled_title',
					'label'       => 'Set as Onepage Home?',
					'desc'        => 'By turning on this option, and if you use "<strong>OnePage Home</strong>" template, you can override default onepage ajax menu which is set in Theme Options. This is useful if you are using WPML or any other kind of multilingual plugins',
					'std'         => '',
					'type'        => 'textblock',
					'rows'        => '',
					'taxonomy'    => '',
					'class'       => ''				
				),
				array(
					'label'       => '',
					'id'          => 'tmq_onepage_enabled',
					'type'        => 'on-off',
					'desc'        => '',
					'std'         => 'off',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),			
				array(
					'id'          => 'tmq_onepage_post',
					'label'       => 'Choose the Onepage Menu',
					'desc'        => '',
					'std'         => '',
					'type'        => 'custom-post-type-select',
					'rows'        => '',
					'condition'   => 'tmq_onepage_enabled:is(on)',
					'operator'	  => 'and',	
					'post_type'   => 'tmq-ajaxonepager',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_onepage_settings',
			'title'       => __('Ajax OnePage Settings', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'page', 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Back to Index', 'bokeh'),
					'id'          => 'tmq_backtoindex',
					'type'        => 'select',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Automatic (Only for posts)', 'bokeh'),
						'value'        => 'tmq_auto'
						),
						array(
						'label'        => __('None', 'bokeh'),
						'value'        => 'tmq_none'
						),
						array(
						'label'        => __('Custom Link', 'bokeh'),
						'value'        => 'tmq_link'
						)
					)
				),
				array(
				  'id'          => 'tmq_link_text',
  				  'label'       => 'Link Desc',
  				  'desc'        => 'Link URL which you want the index button to links to:',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'condition'   => 'tmq_backtoindex:is(tmq_link)',
				  'operator'    => 'and',	
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'label'       => '',
					'id'          => 'tmq_custom_index_url',
					'type'        => 'text',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'condition'   => 'tmq_backtoindex:is(tmq_link)',
					'operator'    => 'and',	
					'taxonomy'    => '',
					'class'		  => ''
				),
				array(
					'label'       => __('Previous Page', 'bokeh'),
					'id'          => 'tmq_previouspage',
					'type'        => 'select',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Automatic', 'bokeh'),
						'value'        => 'tmq_auto'
						),
						array(
						'label'        => __('None', 'bokeh'),
						'value'        => 'tmq_none'
						),
						array(
						'label'        => __('Custom Link', 'bokeh'),
						'value'        => 'tmq_link'
						)
					)
				),
				array(
				  'id'          => 'tmq_link_text',
  				  'label'       => 'Link Desc',
  				  'desc'        => 'Link URL which you want previous button to links to:',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'condition'   => 'tmq_previouspage:is(tmq_link)',
				  'operator'    => 'and',	
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'label'       => '',
					'id'          => 'tmq_custom_previous_url',
					'type'        => 'text',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'condition'   => 'tmq_previouspage:is(tmq_link)',
					'operator'    => 'and',	
					'taxonomy'    => '',
					'class'		  => ''
				),
				array(
					'label'       => __('Next Page', 'bokeh'),
					'id'          => 'tmq_nextpage',
					'type'        => 'select',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Automatic', 'bokeh'),
						'value'        => 'tmq_auto'
						),
						array(
						'label'        => __('None', 'bokeh'),
						'value'        => 'tmq_none'
						),
						array(
						'label'        => __('Custom Link', 'bokeh'),
						'value'        => 'tmq_link'
						)
					)
				),
				array(
				  'id'          => 'tmq_link_text',
  				  'label'       => 'Link Desc',
  				  'desc'        => 'Link URL which you want next button to links to:',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'condition'   => 'tmq_nextpage:is(tmq_link)',
				  'operator'    => 'and',	
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'label'       => '',
					'id'          => 'tmq_custom_next_url',
					'type'        => 'text',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'condition'   => 'tmq_nextpage:is(tmq_link)',
					'operator'    => 'and',	
					'taxonomy'    => '',
					'class'		  => ''
				)
			)
		),
		array(
			'id'          => 'tmq_featured_image_single',
			'title'       => __('Featured Image Settings', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'low',
			'fields'      => array(
				array(
				  'id'          => 'tmq_featured_image_text',
  				  'label'       => 'Featured Image Desc',
  				  'desc'        => 'Show featured image in single page:',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'label'       => '',
					'id'          => 'tmq_featured_image',
					'type'        => 'on-off',
					'desc'        => '',
					'std'         => 'on',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_gallery_options',
			'title'       => __('Gallery Post Format', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'high',
			'fields'      => array(
			    array(
				  'id'          => 'tmq_gallery_desc',
  				  'label'       => 'Gallery Desc',
  				  'desc'        => 'Upload images that you want to see in this post slideshow - This will only works with <strong>GALLERY</strong> post format.',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'id'          => 'tmq_gallery_post_format_images',
					'type'        => 'gallery',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
				)
			)
		),
		array(
			'id'          => 'tmq_header_options',
			'title'       => __('Page / Post Header Settings', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'page', 'tmq-portfolio' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Show Page / Post Heading', 'bokeh'),
					'id'          => 'tmq_showheading',
					'type'        => 'on-off',
					'desc'        => __('Show heading in top of the page?', 'bokeh'),
					'std'         => 'on',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
				),array(
					'label'       => __('Show Page / Post Summary', 'bokeh'),
					'id'          => 'tmq_showsummary',
					'type'        => 'on-off',
					'desc'        => __('Show page/post summary below the page title?', 'bokeh'),
					'std'         => 'on',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
				),array(
					'label'       => __('Page / Post Summary', 'bokeh'),
					'id'          => 'tmq_summary',
					'type'        => 'textarea',
					'desc'        => __('Write down the page / post summary here. 2 or 3 lines will look great!', 'bokeh'),
					'std'         => '',
					'rows'        => '3',
					'condition'   => 'tmq_showsummary:is(on)',
					'operator'    => 'and',	
					'taxonomy'    => '',
					'class'       => ''
				)			
			)
		),
		array(
			'id'          => 'tmq_post_options',
			'title'       => __('Post Options', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Share on Social Networks Box', 'bokeh'),
					'id'          => 'tmq_social_box',
					'type'        => 'select',
					'desc'        => __('Do you want your visitors be able to share this post over social networks?', 'bokeh'),
					'std'         => 'tmq_default',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				),
				array(
					'label'       => __('Show Tags of the Post', 'bokeh'),
					'id'          => 'tmq_tags_box',
					'type'        => 'select',
					'desc'        => __('Do you want your visitors be able to see the tags of this post?', 'bokeh'),
					'std'         => 'tmq_default',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				),
				array(
					'label'       => __('Author Information Box', 'bokeh'),
					'id'          => 'tmq_author_box',
					'type'        => 'select',
					'desc'        => __('Do you want your visitors see the author information box in bottom of this post?', 'bokeh'),
					'std'         => 'tmq_default',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				),
				array(
					'label'       => __('Related Posts', 'bokeh'),
					'id'          => 'tmq_relatedposts',
					'type'        => 'select',
					'desc'        => __('Show related post at the end of the current post.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				)				
			)
		),
		array(
			'id'          => 'tmq_portfolio_options',
			'title'       => __('Portfolio Options', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-portfolio' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Share on Social Networks Box', 'bokeh'),
					'id'          => 'tmq_portfolio_social_box',
					'type'        => 'select',
					'desc'        => __('Do you want your visitors be able to share this post over social networks?', 'bokeh'),
					'std'         => 'tmq_default',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				),
				array(
					'label'       => __('Show Tags of the Post', 'bokeh'),
					'id'          => 'tmq_portfolio_tags_box',
					'type'        => 'select',
					'desc'        => __('Do you want your visitors be able to see the tags of this post?', 'bokeh'),
					'std'         => 'tmq_default',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				),
				array(
					'label'       => __('Related Posts', 'bokeh'),
					'id'          => 'tmq_portfolio_relatedposts',
					'type'        => 'select',
					'desc'        => __('Show related post at the end of the current post.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => __('Default (Read from theme options)', 'bokeh'),
						'value'        => 'tmq_default'
						),
						array(
						'label'        => __('Show', 'bokeh'),
						'value'        => 'tmq_show'
						),
						array(
						'label'        => __('Hide', 'bokeh'),
						'value'        => 'tmq_hide'
						)
					)
				)				
			)
		),	
		array(
			'id'          => 'tmq_portfolio_masonry',
			'title'       => __('Masonry Image Setting', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'low',
			'fields'      => array(
				array(
				  'id'          => 'tmq_masonry_image_text',
  				  'label'       => 'Featured Image Desc',
  				  'desc'        => 'Choose the preferred image size and aspect ratio for masonry view:',
				  'std'         => '',
				  'type'        => 'textblock',
				  'rows'        => '',
				  'post_type'   => '',
				  'taxonomy'    => '',
				  'class'       => ''
			    ),
				array(
					'id'          => 'tmq_portfolio_masonry_image',
					'type'        => 'select',
					'std'         => '1x1',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
						'label'        => 'Square: 1x1',
						'value'        => '1x1'
						),
						array(
						'label'        => 'Big Square: 2x2',
						'value'        => '2x2'
						),
						array(
						'label'        => 'Vertical: 1x2',
						'value'        => '1x2'
						),
						array(
						'label'        => 'Horizontal: 2x1',
						'value'        => '2x1'
						)
					)
				)				
			)
		),		
		array(
			'id'          => 'tmq_custom_background',
			'title'       => __('Custom Background Image', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'tmq-portfolio', 'page' ),
			'context'     => 'normal',
			'priority'    => 'low',
			'fields'      => array(
				array(
					'id'          => 'tmq_backgroundimage',
					'label'       => 'Background Image',
					'desc'        => 'Upload a large and beautiful background image for this page. If you leave this empty, it will load from theme options default background image.',
					'std'         => '',
					'type'        => 'upload',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_team_member_options',
			'title'       => __('Themique Team Member Options', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'team-members' ),
			'context'     => 'normal',
			'priority'    => 'low',
			'fields'      => array(
				array(
					'label'       => __('Member Position', 'bokeh'),
					'id'          => 'tmq_memberposition',
					'type'        => 'text',
					'desc'        => __('Enter member position in the Company.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Short Biography', 'bokeh'),
					'id'          => 'tmq_memberbio',
					'type'        => 'text',
					'desc'        => __('Short description about this member', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Facebook Profile', 'bokeh'),
					'id'          => 'tmq_memberfacebook',
					'type'        => 'text',
					'desc'        => __('Member\'s Facebook profile url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Twitter Page', 'bokeh'),
					'id'          => 'tmq_membertwitter',
					'type'        => 'text',
					'desc'        => __('Member\'s Twitter page url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Google Plus Page', 'bokeh'),
					'id'          => 'tmq_membergoogleplus',
					'type'        => 'text',
					'desc'        => __('Member\'s Google+ page url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('LinkedIn Page', 'bokeh'),
					'id'          => 'tmq_memberlinkedin',
					'type'        => 'text',
					'desc'        => __('Member\'s LinkedIn page url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Pinterest Page', 'bokeh'),
					'id'          => 'tmq_memberpinterest',
					'type'        => 'text',
					'desc'        => __('Member\'s Pinterest page url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Website URL', 'bokeh'),
					'id'          => 'tmq_memberweburl',
					'type'        => 'text',
					'desc'        => __('Member\'s Website url. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Email Address', 'bokeh'),
					'id'          => 'tmq_memberemailaddress',
					'type'        => 'text',
					'desc'        => __('Member\'s Email address. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),array(
					'label'       => __('Phone Number', 'bokeh'),
					'id'          => 'tmq_memberphone',
					'type'        => 'text',
					'desc'        => __('Member\'s Phone Number. Enter "none" to do not include this item.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_testimonials_options',
			'title'       => __('Themique Testimonials List', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-testimonials' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Testimonials List', 'bokeh'),
					'id'          => 'tmq_testimonials_list',
					'type'        => 'list-item',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'settings'	  => array(
						array(
							'label'       => __('Role in Company', 'bokeh'),
							'id'          => 'tmq_testimonials_role',
							'type'        => 'text',
							'desc'        => __('What\'s his/her role in company?', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),array(
							'label'       => __('Company Name', 'bokeh'),
							'id'          => 'tmq_testimonials_company',
							'type'        => 'text',
							'desc'        => __('Enter company name here', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),array(
							'label'       => __('What did he/she said?', 'bokeh'),
							'id'          => 'tmq_testimonials_quote',
							'type'        => 'textarea',
							'desc'        => __('What did they said about you?', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						)
					)
				)
			)
		),
		array(
			'id'          => 'tmq_pricetable_options',
			'title'       => __('Themique Price Table Items', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-pricetable' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('List of Items', 'bokeh'),
					'id'          => 'tmq_price_item',
					'type'        => 'list-item',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'settings'	  => array(
						array(
							'label'       => __('Is Featured', 'bokeh'),
							'id'          => 'tmq_price_item_featured',
							'type'        => 'on-off',
							'desc'        => __('Is this the most recommended package that you want to offer? Will style different.', 'bokeh'),
							'std'         => 'off',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => '',
						),
						array(
							'label'       => __('Price', 'bokeh'),
							'id'          => 'tmq_price_item_price',
							'type'        => 'text',
							'desc'        => __('e.g. $10.99/month', 'bokeh'),
							'std'         => '$10.99/month',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #1', 'bokeh'),
							'id'          => 'tmq_price_item_f1',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #2', 'bokeh'),
							'id'          => 'tmq_price_item_f2',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #3', 'bokeh'),
							'id'          => 'tmq_price_item_f3',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #4', 'bokeh'),
							'id'          => 'tmq_price_item_f4',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #5', 'bokeh'),
							'id'          => 'tmq_price_item_f5',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Feature #6', 'bokeh'),
							'id'          => 'tmq_price_item_f6',
							'type'        => 'text',
							'desc'        => __('Any feature you wish', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Button Text', 'bokeh'),
							'id'          => 'tmq_price_item_button',
							'type'        => 'text',
							'desc'        => __('e.g. SIGN UP! / ORDER NOW! / MORE', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
						array(
							'label'       => __('Button Link', 'bokeh'),
							'id'          => 'tmq_price_item_href',
							'type'        => 'text',
							'desc'        => __('Link of the Table Button', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),
					)
				)
			)
		),
		array(
			'id'          => 'tmq_clients_options',
			'title'       => __('Themique Clients List', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-clients' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Clients List', 'bokeh'),
					'id'          => 'tmq_clients_list',
					'type'        => 'list-item',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'settings'	  => array(
						array(
							'label'       => __('Logo', 'bokeh'),
							'id'          => 'tmq_clients_logo',
							'type'        => 'upload',
							'desc'        => __('Upload client\'s logo here.', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						),array(
							'label'       => __('Link to Website', 'bokeh'),
							'id'          => 'tmq_clients_website',
							'type'        => 'text',
							'desc'        => __('Leave empty or enter "none" to ignore this item', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''						
						)
					)
				)
			)
		),
		array(
			'id'          => 'tmq_ajaxonepager_options',
			'title'       => __('Menu Items', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'tmq-ajaxonepager' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('List of Pages', 'bokeh'),
					'id'          => 'tmq_pages_list',
					'type'        => 'list-item',
					'desc'        => '',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'settings'	  => array(			
						array(
							'label'       => __('Type of Link', 'bokeh'),
							'id'          => 'tmq_linktype',
							'type'        => 'select',
							'desc'        => __('Choose the type of link of this menu item', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => '',
							'choices'     => array(
								array(
									'label'        => __('A Page', 'bokeh'),
									'value'        => 'tmq_page'
								),
								array(
									'label'        => __('A Post / Portfolio', 'bokeh'),
									'value'        => 'tmq_post'
								),
								array(
									'label'        => __('Custom URL', 'bokeh'),
									'value'        => 'tmq_custom'
								),
								array(
									'label'        => __('No Link', 'bokeh'),
									'value'        => 'tmq_nolink'
								)
							)
						),	
						array(
							'label'       => __('Choose a Page', 'bokeh'),
							'id'          => 'tmq_page_url',
							'type'        => 'page-select',
							'desc'        => __('Choose a page to link this menu item to it.', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'condition'   => 'tmq_linktype:is(tmq_page)',
							'operator'    => 'and',	
							'taxonomy'    => '',
							'class'       => ''
						),
						array(
							'label'       => __('Choose a Post', 'bokeh'),
							'id'          => 'tmq_post_url',
							'type'        => 'custom-post-type-select',
							'desc'        => __('Choose a post to link this menu item to it.', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => 'tmq-portfolio, post',
							'condition'   => 'tmq_linktype:is(tmq_post)',
							'operator'    => 'and',	
							'taxonomy'    => '',
							'class'       => ''
						),
						array(
							'label'       => __('Custom URL', 'bokeh'),
							'id'          => 'tmq_custom_url',
							'type'        => 'text',
							'desc'        => __('Enter link URL which you want the menu item to links to.', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'condition'   => 'tmq_linktype:is(tmq_custom)',
							'operator'    => 'and',	
							'taxonomy'    => '',
							'class'       => ''
						),		
						array(
							'label'       => __('Front Side Type', 'bokeh'),
							'id'          => 'tmq_frontside',
							'type'        => 'select',
							'desc'        => __('Choose the type of front side of this page', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => '',
							'choices'     => array(
								array(
									'label'        => __('Iconned Menu', 'bokeh'),
									'value'        => 'tmq_iconned'
								),
								array(
									'label'        => __('Image Menu', 'bokeh'),
									'value'        => 'tmq_image'
								),
								array(
									'label'        => __('Text Menu', 'bokeh'),
									'value'        => 'tmq_text'
								)
							)
						),		
						array(
							'label'       => __('Choose an Icon', 'bokeh'),
							'id'          => 'tmq_page_icon',
							'type'        => 'fontawesome_select',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_frontside:is(tmq_iconned)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''				
						),
						array(
							'label'       => __('Choose an Image', 'bokeh'),
							'id'          => 'tmq_page_image',
							'type'        => 'upload',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_frontside:is(tmq_image)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => 'ot-upload-attachment-id'				
						),
						array(
							'label'       => __('Enter Short Text', 'bokeh'),
							'id'          => 'tmq_page_text',
							'type'        => 'text',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_frontside:is(tmq_text)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''				
						),			
						array(
							'label'       => __('Back Side Type', 'bokeh'),
							'id'          => 'tmq_backside',
							'type'        => 'select',
							'desc'        => __('Choose the type of back side of this page', 'bokeh'),
							'std'         => '',
							'rows'        => '',
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => '',
							'choices'     => array(
								array(
									'label'        => __('Text Menu', 'bokeh'),
									'value'        => 'tmq_text'
								),
								array(
									'label'        => __('Image Menu', 'bokeh'),
									'value'        => 'tmq_image'
								),
								array(
									'label'        => __('Iconned Menu', 'bokeh'),
									'value'        => 'tmq_iconned'
								),
								array(
									'label'        => __('None (No Flip)', 'bokeh'),
									'value'        => 'tmq_none'
								)
							)
						),		
						array(
							'label'       => __('Choose an Icon', 'bokeh'),
							'id'          => 'tmq_page_icon_bk',
							'type'        => 'fontawesome_select',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_backside:is(tmq_iconned)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''				
						),
						array(
							'label'       => __('Choose an Image', 'bokeh'),
							'id'          => 'tmq_page_image_bk',
							'type'        => 'upload',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_backside:is(tmq_image)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => 'ot-upload-attachment-id'				
						),
						array(
							'label'       => __('Enter Short Text', 'bokeh'),
							'id'          => 'tmq_page_text_bk',
							'type'        => 'text',
							'desc'        => '',
							'std'         => '',
							'rows'        => '',
							'condition'   => 'tmq_backside:is(tmq_text)',
							'operator'    => 'and',		
							'post_type'   => '',
							'taxonomy'    => '',
							'class'       => ''				
						)
					)
				)
			)
		),
		array(
			'id'          => 'tmq_link_format',
			'title'       => __('Post Formats (LINK)', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('URL to Link', 'bokeh'),
					'id'          => 'tmq_linkurl',
					'type'        => 'text',
					'desc'        => __('Enter link URL which you want the Link Post Format links to it.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_audio_format',
			'title'       => __('Post Formats (AUDIO)', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Audio Source', 'bokeh'),
					'id'          => 'tmq_audiosource',
					'type'        => 'select',
					'desc'        => __('What is the source of audio file which you want to put it into your site?', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => '',
					'choices'     => array(
						array(
							'label'        => __('Third Party (SoundCloud)', 'bokeh'),
							'value'        => 'tmq_thirdparty'
						),
						array(
							'label'        => __('Hosted', 'bokeh'),
							'value'        => 'tmq_hosted'
						)
					)
				),array(
					'label'       => __('(SoundCloud) Enter Embed Code', 'bokeh'),
					'id'          => 'tmq_audiosoundcloud',
					'type'        => 'textarea',
					'desc'        => __('Enter the embed code from SoundCloud website.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),
				array(
					'label'       => __('(Hosted) Upload Audio File', 'bokeh'),
					'id'          => 'tmq_audiohosted',
					'type'        => 'upload',
					'desc'        => __('Upload audio file for audio format post here.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_video_format',
			'title'       => __('Video Post Formats', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post', 'tmq-portfolio' ),
			'context'     => 'side',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Video Post Format', 'bokeh'),
					'id'          => 'tmq_video_text',
					'type'        => 'textblock',
					'desc'        => __('<strong>Youtube Video URL</strong><br><hr>Enter youtube video URL (Only works in video post format).', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),
				array(
					'id'          => 'tmq_video_url',
					'type'        => 'text',
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		),
		array(
			'id'          => 'tmq_quote_format',
			'title'       => __('Post Formats (QUOTE)', 'bokeh'),
			'desc'        => '',
			'pages'       => array( 'post' ),
			'context'     => 'normal',
			'priority'    => 'high',
			'fields'      => array(
				array(
					'label'       => __('Quoted Text', 'bokeh'),
					'id'          => 'tmq_quotedtext',
					'type'        => 'textarea',
					'desc'        => __('Enter quoted text here.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				),
				array(
					'label'       => __('Quoted From', 'bokeh'),
					'id'          => 'tmq_quotedfrom',
					'type'        => 'text',
					'desc'        => __('Enter the person name who this text is quoted from him/her.', 'bokeh'),
					'std'         => '',
					'rows'        => '',
					'post_type'   => '',
					'taxonomy'    => '',
					'class'       => ''
				)
			)
		)	
	);
  
  /**
   * Register our meta boxes using the 
   * ot_register_meta_box() function.
   */
   foreach ( $tmq_post_options as $tmq_option ) {
		/** 
		 *	This switch will check for enabled post-formats in admin panel. Only enabled post-formats related
		 *  metaboxes will load. DEFAULT switch will register other metaboxes without any conditions.
		 */
		switch ( $tmq_option['id'] ) {
			case 'tmq_link_format':
				if (in_array( 'link', $format_arg )){
					ot_register_meta_box( $tmq_option );
				}			
				break;
			case 'tmq_quote_format':
				if (in_array( 'quote', $format_arg )){
					ot_register_meta_box( $tmq_option );
				}
				break;
			case 'tmq_audio_format':
				if (in_array( 'audio', $format_arg )){
					ot_register_meta_box( $tmq_option );
				}			
				break;
			case 'tmq_video_format':
				if (in_array( 'video', $format_arg )){
					ot_register_meta_box( $tmq_option );
				}			
				break;
			default:
				ot_register_meta_box( $tmq_option );
				break;
		}
	}

}
