<?php

	// Registering Theme Locations
	function register_my_menu() {
		register_nav_menu('main-menu',__( 'Main Menu', 'bokeh' ));
	}
	add_action( 'init', 'register_my_menu' );

	// Add Menu Support
	function theme_nav() {
		if ( has_nav_menu( 'main-menu' ) ) {
		 //Do Create menu
			wp_nav_menu(
				array(
				'theme_location'  => 'main-menu',
				'container'       => false, 
				'container_class' => '', 
				'container_id'    => '',
				'menu_class'      => 'main-menu', 
				'menu_id'         => 'main-menu',
				'echo'            => true,
				'fallback_cb'     => 'wp_page_menu',
				'before'          => '',
				'after'           => '',
				'link_before'     => '<span>',
				'link_after'      => '</span>',
				'items_wrap'      => '<nav id="%1$s" class="%2$s"><div class="menu-container"><ul>%3$s</ul></div></nav>',
				'depth'           => 0,
				'walker'		  => new TMQ_Walker_Nav_Menu()
				)
			);
		} else {
			?><div class="setmenu"><p><a href="<?php esc_url( admin_url("/nav-menus.php") ); ?>"><?php esc_html_e( 'Set the menu', 'bokeh' ); ?></p></div><?php
		}
	}
	
	// Change Sub-Menu class name
	class TMQ_Walker_Nav_Menu extends Walker_Nav_Menu {
		function start_lvl( &$output, $depth = 0, $arg = Array() ) {
			$indent = str_repeat( "\t", $depth );
			$output .= "\n$indent<div class=\"menu-container\">\n<a class=\"mp-back\" href=\"#\">" . __('back', 'bokeh') . "</a><ul>";
		}	
		function end_lvl( &$output, $depth = 0, $arg = Array() ) {
			$indent = str_repeat( "\t", $depth );
			$output .= "\n$indent</ul></div>";
		}		
	}
	
	// Change Menu with Children Class Name
	add_filter( 'wp_nav_menu_objects', 'add_menu_parent_class' );
	function add_menu_parent_class( $items ) {
		$parents = array();
		foreach ( $items as $item ) {
			if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
				$parents[] = $item->menu_item_parent;
			}
		}
		foreach ( $items as $item ) {
			if ( in_array( $item->ID, $parents ) ) {
				$item->classes[] = 'drop'; 
			}
		}
		return $items;    
	}	
?>