<?php

	// Load Custom Theme Scripts using Enqueue
	function load_tmq_theme_scripts() {
		// register javascripts
		
		wp_register_script('modernizr', get_template_directory_uri() .  '/js/modernizr.js', array(), '1.10.2');
		wp_register_script('jquery', get_template_directory_uri() .  '/js/jquery-1.11.1.min.js', array(), '1.10.2', true);
		//wp_register_script('migrate', get_template_directory_uri() .  '/js/jquery.migrate.js', array(), '1.0', true);
		wp_register_script('bootstrap', get_template_directory_uri() .  '/js/bootstrap.min.js', array(), '3.0.0', true);
		wp_register_script('plugins-scroll', get_template_directory_uri() .  '/js/plugins-scroll.js', array(), '0.1', true);
		wp_register_script('owl', get_template_directory_uri() .  '/js/owl.carousel.min.js', array(), '0.1', true);
		wp_register_script('fitvids', get_template_directory_uri() .  '/js/jquery.fitvids.js', array(), '0.1', true);
		wp_register_script('magnific-popup', get_template_directory_uri() .  '/js/jquery.magnific-popup.min.js', array(), '0.1', true);
		wp_register_script('bokeh_script', get_template_directory_uri() .  '/js/scripts.js', array(), '1.0.1', true);
		wp_register_script('isotope', get_template_directory_uri() .  '/js/jquery.isotope.min.js', array(), '1.0', true);
		wp_register_script('imagesloaded', get_template_directory_uri() .  '/js/imagesloaded.pkgd.min.js', array(), '1.0', true);
		wp_register_script('waypoints', get_template_directory_uri() .  '/js/waypoints.min.js', array(), '1.0', true);
		wp_register_script('responsive-menu', get_template_directory_uri() .  '/js/classie.js', array(), '1.0', true);
		wp_register_script('mlpushmenu', get_template_directory_uri() .  '/js/mlpushmenu.js', array(), '1.0', true);
		wp_register_script('style_switcher', get_template_directory_uri() .  '/js/switcher.js', array(), '1.0', true);
		wp_register_script('respond', get_template_directory_uri() .  '/js/respond.min.js', array(), '1.0', true);
		wp_register_script('navigatejs', get_template_directory_uri() .  '/js/navigate.js', array(), '1.0', true);
		wp_register_script('ajaxloader', get_template_directory_uri() .  '/js/ajax-loader.js', array(), '1.0', true);

		$map_api = "";
		$map_api = ot_get_option('google_api');
		
		wp_enqueue_script('Google-map',  get_template_directory_uri().'/js/gmap3.min.js');

		if( $map_api != "" ) {
			wp_enqueue_script('Google-map-api',  'http://maps.google.com/maps/api/js?key='. $map_api );			
		}
		else {
			wp_enqueue_script('Google-map-api',  'https://maps.googleapis.com/maps/api/js?v=3.exp' );
		}
		
		if (!is_admin()) {
		
			// Enqueue Some of Theme Scripts in the Header
			wp_enqueue_script('modernizr');
			
			// Init VC Scripts and Styles
			if ( function_exists( 'wpb_js_composer_check_version_schedule_deactivation' ) ) {
				wp_enqueue_script( 'jquery-ui-tabs' );
				wp_enqueue_script('jquery_ui_tabs_rotate');
				wp_enqueue_script('jquery-ui-accordion');
				wp_enqueue_script( 'nivo-slider' );
				wp_enqueue_style( 'nivo-slider-css' );
				wp_enqueue_style( 'nivo-slider-theme' );			
				wp_enqueue_style( 'flexslider' );
				wp_enqueue_script( 'flexslider' );
			}
			// Footer Scripts
			wp_enqueue_script('jquery');
			wp_enqueue_script('bokeh_script');
			// wp_enqueue_script('respond');
			//wp_enqueue_script('migrate');
			wp_enqueue_script('bootstrap');
			wp_enqueue_script('retina');
			wp_enqueue_script('flexslider');
			wp_enqueue_script('magnific-popup');
			wp_enqueue_script('imagesloaded');
			wp_enqueue_script('isotope');
			wp_enqueue_script('waypoints');
			wp_enqueue_script('owl');
			wp_enqueue_script('fitvids');
			wp_enqueue_script('responsive-menu');
			wp_enqueue_script('mlpushmenu');
			// We need switcher on demo not your website!
			
			if ( function_exists( 'ot_get_option' ) ) {
				// Enqueue plugins-scroll by condition
				$tmq_scrollbar = ot_get_option( 'tmq_scrollbar' );
				if ( $tmq_scrollbar == 'on' ) {
					wp_enqueue_script('plugins-scroll');
				}
				
				// Enqueue Ajax Navigation Only If It's Enabled
				$tmq_onepage_ajax = ot_get_option( 'tmq_onepage_ajax' );
				if ( $tmq_onepage_ajax == 'on' ) {
					wp_enqueue_script('navigatejs');
					wp_enqueue_script('ajaxloader');
				}
			}

			// Apply Theme Options in Javascript
			wp_localize_script('bokeh_script', 'tmq_script_vars', array(
				'plugins_scroll'		=> tmq_scrollbartype(),
				'sticky_menu'			=> tmq_sticky_menutype(),
				'onepage_autocolor'		=> tmq_auto_color_one_pager(),
				'tmq_onepage_ajax'		=> tmq_onepage_ajax(),
				'tmq_onepager_color'	=> tmq_onepager_color(),
				'tmq_random_hue'		=> tmq_random_hue(),
				'tmq_getrootdir'		=> tmq_getrootdir()
			));
			
		}
	}

	add_action('wp_enqueue_scripts', 'load_tmq_theme_scripts'); // Add Custom Scripts
	
	// Theme Stylesheets using Enqueue
	function load_theme_styles() {
		// register css stylesheets
		wp_register_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css', array(), '3.0.0', 'all');
		wp_register_style('magnific-popup', get_template_directory_uri() . '/css/magnific-popup.css', array(), '1.5.3', 'all');
		wp_register_style('tmq-font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '1.5.3', 'all');
		wp_register_style('owlcarousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '1.5.3', 'all');
		wp_register_style('owlcarousel-theme', get_template_directory_uri() . '/css/owl.theme.css', array(), '1.5.3', 'all');
		wp_register_style('animate', get_template_directory_uri() . '/css/animate.min.css', array(), '1.4.0', 'all');
		wp_register_style('hover-effects', get_template_directory_uri() . '/css/hover-min.css', array(), '1.4.0', 'all');
		wp_register_style('pushmenu', get_template_directory_uri() . '/css/pushmenu.css', array(), '1.4.0', 'all');
		wp_register_style('ot-dynamic-tmq_css', get_stylesheet_directory_uri() . '/dynamic.css', array('bokeh_style'), '1.0', 'all');
		// wp_register_style('ot-dynamic-tmq_usercss', get_stylesheet_directory_uri() . '/dynamic.css', array('bokeh_style'), '1.0', 'all');
		wp_register_style('responsive', get_template_directory_uri() . '/css/responsive.css', array('ot-dynamic-tmq_css'), '1.0', 'all');
		wp_register_style('style_switcher', get_template_directory_uri() . '/css/switcher.css', array(), '1.0.0', 'all');		
		wp_register_style('theme_style', get_template_directory_uri() . '/style.css', array('bokeh_style'), '1.4.0', 'all');
		wp_deregister_style('ot-dynamic-tmq_usercss');
		
		if ( function_exists( 'ot_get_option' ) ) {
			// Enqueue Dark / Light Layout
			$tmq_skin_mode = ot_get_option( 'tmq_dark_light' );
			if ( $tmq_skin_mode == 'dark' ) {
				wp_register_style('bokeh_style', get_template_directory_uri() . '/css/style-dark.css', array('bootstrap'), '1.4.0', 'all');
			} else {
				wp_register_style('bokeh_style', get_template_directory_uri() . '/css/style.css', array('bootstrap'), '1.4.0', 'all');
			}
		}		

		if ( function_exists( 'ot_get_option' ) ) {
			// Enable full width layout
			$tmq_full_width_layout = ot_get_option( 'tmq_full_width_layout' );
			if ( $tmq_full_width_layout == 'on' ) {
				wp_enqueue_style('fullwidth-layout'); 
			}
			
			// Add Google Web Fonts
			// $googlefontfamily = googlefontfamily('style', 'tmq_google_webfont');
			$tmq_menu_googlefontfamily = googlefontfamily('style', 'tmq_menu_webfont');
			$tmq_heading_googlefontfamily = googlefontfamily('style', 'tmq_heading_webfont');
			$tmq_paragraph_googlefontfamily = googlefontfamily('style', 'tmq_paragraph_font');
			
			// Enable Latin and Greek Language Support
			$tmq_support_latin = ot_get_option( 'tmq_support_latin' );
			$tmq_support_greek = ot_get_option( 'tmq_support_greek' );
			$tmq_support_cyrillic = ot_get_option( 'tmq_support_cyrillic' );

			$tmq_subset_string = '&subset=';
			$tmq_latin_subset = 'latin,latin-ext,';
			$tmq_greek_subset = 'greek,greek-ext,';
			$tmq_cyrillic_subset = 'cyrillic,cyrillic-ext,';
			
			// Latin
			if ( $tmq_support_latin != 'off' ) {
				$tmq_subset_string .= $tmq_latin_subset;
			}
			
			// Greek
			if ( $tmq_support_greek != 'off' ) {
				$tmq_subset_string .= $tmq_greek_subset;
			}
			
			// Cyrillic
			if ( $tmq_support_cyrillic != 'off' ) {
				$tmq_subset_string .= $tmq_cyrillic_subset;
			}
			
			if ( $tmq_support_latin != 'off' || $tmq_support_greek != 'off' || $tmq_support_cyrillic != 'off' ) {
				// Remove trailing comma ","
				$tmq_subset_string = rtrim($tmq_subset_string, ',');

				// Add Subsets to fonts
				$tmq_menu_googlefontfamily .= $tmq_subset_string;
				$tmq_heading_googlefontfamily .= $tmq_subset_string;			
				$tmq_paragraph_googlefontfamily .= $tmq_subset_string;			
			}
			

			wp_register_style('menu-google-font', 'http://fonts.googleapis.com/css?family='. $tmq_menu_googlefontfamily, array(), '', 'all');
			wp_enqueue_style('menu-google-font');
			
			// Check for duplicate fonts
			if ( $tmq_menu_googlefontfamily != $tmq_heading_googlefontfamily ) {
				wp_register_style('heading-google-font', 'http://fonts.googleapis.com/css?family='. $tmq_heading_googlefontfamily, array(), '', 'all');
				wp_enqueue_style('heading-google-font');
			}	
			
			if ( ( $tmq_menu_googlefontfamily != $tmq_paragraph_googlefontfamily ) && ( $tmq_heading_googlefontfamily != $tmq_paragraph_googlefontfamily ) ) {
				wp_register_style('paragraph-google-font', 'http://fonts.googleapis.com/css?family='. $tmq_paragraph_googlefontfamily, array(), '', 'all');
				wp_enqueue_style('paragraph-google-font');
			}
			// End duplicate font check
			
			$tmq_responsive_layout = ot_get_option ( 'tmq_responsive_layout' );
			if ( empty( $tmq_responsive_layout ) ) {
				$tmq_responsive_layout == 'on';
			}
		}	
	
		// We need switcher on demo not your website!
		
		wp_enqueue_style('bootstrap'); 
		wp_enqueue_style('magnific-popup'); 
		wp_enqueue_style('tmq-font-awesome'); 
		wp_enqueue_style('owlcarousel'); 
		wp_enqueue_style('owlcarousel-theme'); 
		wp_enqueue_style('animate'); 
		wp_enqueue_style('hover-effects'); 
		wp_enqueue_style('pushmenu'); 
		wp_enqueue_style('bokeh_style'); 
		wp_enqueue_style('theme_style'); 
		wp_enqueue_style('ot-dynamic-tmq_css'); 
		if ( $tmq_responsive_layout != 'off' ) {
			wp_enqueue_style('responsive'); 
		}
	}
	
	function load_theme_admin_styles() {
		wp_register_style('tmq_ot', get_template_directory_uri() . '/css/ot.css', array('ot-admin-css'), '1.2.0', 'all');
		wp_enqueue_style('tmq_ot');
	}
	
	add_action('wp_enqueue_scripts', 'load_theme_styles'); // Add Theme Stylesheet
	add_action('admin_enqueue_scripts', 'load_theme_admin_styles'); // Add Admin Theme Stylesheet

?>