<?php
/**
 * Bokeh
 * ==================================================
 * This is the main header file - header.php
 *
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php
 /* Theme Options Variables
 * ==================================================
 */
	if ( function_exists( 'ot_get_option' ) ) {
		
		// Website Logo
		$tmq_logo_type = ot_get_option( 'tmq_logo_type' );
		if ( empty( $tmq_logo_type ) ) {
			$tmq_logo_type = 'tmq_image';
		}
		
		// Logo URL
		$tmq_logo_url = ot_get_option( 'tmq_logo_url' );
		if ( empty( $tmq_logo_url ) ) {
			$tmq_logo_url = home_url();
		}		
		
		if ( $tmq_logo_type == 'tmq_text' ) {
			
			// Text Logo
			$tmq_logo_text = ot_get_option( 'tmq_logo_text' );
			if ( empty( $tmq_logo_text ) ) {
				$tmq_logo_text = 'BOKEH';
			}
		} else {
		
			// Image Logo x 2
			$tmq_logo = ot_get_option( 'tmq_logo' );
			if ( empty( $tmq_logo ) ) {
				$tmq_logo = get_template_directory_uri() . '/images/logo.png';
			}
			
			$tmq_logo_2 = ot_get_option( 'tmq_logo_2' );
			if ( empty( $tmq_logo_2 ) ) {
				$tmq_logo_2 = get_template_directory_uri() . '/images/logo-2.png';
			}
		}
		
		// Background image should be load from page meta first
		if ( is_single() || is_page() ) {
			$tmq_backgroundimage = get_post_meta( $post->ID, 'tmq_backgroundimage', true );
		} else {
			$tmq_backgroundimage = '';
		}

		// empty? read from theme options
		if ( empty( $tmq_backgroundimage ) ) {
			$tmq_backgroundimage = ot_get_option( 'tmq_backgroundimage' );
		}
		
		// Apply it
		if ( !empty( $tmq_backgroundimage ) ) {
			$tmq_backgroundimage = '<img alt="' . get_bloginfo( 'name' ) . '" src="' . $tmq_backgroundimage . '">';
		} else {
			$tmq_backgroundimage = '';
		}

		// Responsive Layout
		$tmq_responsive_layout = ot_get_option ( 'tmq_responsive_layout' );
		if ( empty( $tmq_responsive_layout ) ) {
			$tmq_responsive_layout == 'on';
		}
		
		// Header Search Button
		$tmq_search_header = ot_get_option( 'tmq_search_header' );
		if ( empty( $tmq_search_header ) ) {
			$tmq_search_header == 'on';
		}	

	} else {
		// Fall backs
		$tmq_logo_type = 'tmq_image';
		$tmq_logo_url = home_url();
		$tmq_logo = get_template_directory_uri() . '/images/logo.png';
		$tmq_logo_2 = get_template_directory_uri() . '/images/logo-2.png';
		$tmq_backgroundimage = '';
		$tmq_responsive_layout = 'on';
		$tmq_search_header == 'on';
	}
 /* 
 * ==================================================
 @END Theme Options Variables */
?>
	<head>
		
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="alternate" type="application/atom+xml" title="<?php bloginfo( 'name' ); ?> Atom Feed" href="<?php bloginfo( 'atom_url' ); ?>" />
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<?php 
			// Background image should be load from page meta first
			if ( is_single() || is_page() ) {
				$tmq_backgroundimage = get_post_meta( $post->ID, 'tmq_backgroundimage', true );
			} else {
				$tmq_backgroundimage = '';
			}

			// empty? read from theme options
			if ( empty( $tmq_backgroundimage ) ) {
				$tmq_backgroundimage = ot_get_option( 'tmq_backgroundimage' );
			}
			
			// if background is set in page or theme options
			if ( !empty ( $tmq_backgroundimage ) ) {
				add_action( 'wp_enqueue_scripts', 'tmq_update_boxed_bg_image', 10, 1 );
				do_action( 'wp_enqueue_scripts', $tmq_backgroundimage );
			}


			// if background is set in page or theme options
			if ( !empty ( $tmq_banner_background_css_code ) ) {
				add_action( 'wp_enqueue_scripts', 'tmq_update_banner_bg_image', 10, 1 );
				do_action( 'wp_enqueue_scripts', $tmq_banner_background_css_code );
			}
	?>
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
		<!--[if lt IE 9]>
		  <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<?php wp_head();?>
	</head>
	<body <?php body_class(); ?>>
		<!-- Website Preloading for OnePage Version -->
		<?php
			$tmq_loading_image = ot_get_option('tmq_loading');
			if ( empty($tmq_loading_image) ) {
				$tmq_loading_image = get_template_directory_uri() . '/images/loading.png';
			}
		?>
		<div id="loading-effect">		
			<div class="loading-content">
				<div id="stage">
					<p id="spinner"><img alt="loading" src="<?php echo esc_url( $tmq_loading_image );?>"><BR><BR><?php _e('Loading...', 'bokeh'); ?></p>
				</div>
			</div>
		</div>
		<!-- End Preloading -->	
		<!-- Header Section -->
		<header>
			<div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
				<div class="container">
					<div class="navbar-header">
						<!-- Responsive Menu Trigger -->
						<a id="trigger" href="#" title="Menu"><i class="fa fa-bars"></i></a>
						
						<!-- Website Logo -->
						<a class="navbar-brand" title="<?php bloginfo( 'name' ); ?>" href="<?php echo esc_url( $tmq_logo_url ); ?>"><?php
							if ( $tmq_logo_type == 'tmq_text' ) {
								// Text Logo
								?><span><?php echo esc_attr( $tmq_logo_text );?></span><?php
							} else {
								// Image Logo
								?><img class="logo" alt="<?php bloginfo( 'name' ); ?>" src="<?php echo esc_url( $tmq_logo ); ?>"><?php
								?><img class="logo2" alt="<?php bloginfo( 'name' ); ?>" src="<?php echo esc_url( $tmq_logo_2 ); ?>"><?php
							}				
						?></a>
					</div>
					
					<!-- Main Menu -->
					<?php
						// Load Navigation Menu
						theme_nav();
					?>
					<!-- End Main Menu -->
					
					<ul class="navbar-right">
						<!-- One Page Layout Navigation Buttons -->
						<li id="ajax-b1"><a href="#" class="tmq_closeserv" title="<?php _e('Back to Home', 'bokeh');?>"><i class="fa fa-home"></i></a></li>
						<li id="ajax-b2"><a href="#" class="link-index" title="<?php _e('Back to List', 'bokeh');?>"><i class="fa fa-th-large"></i></a></li>
						<li id="ajax-b3"><a href="#" class="link-prev" title="<?php _e('Previous', 'bokeh');?>"><i class="fa fa-chevron-left"></i></a></li>
						<li id="ajax-b4"><a href="#" class="link-next" title="<?php _e('Next', 'bokeh');?>"><i class="fa fa-chevron-right"></i></a></li>
						<!-- End One Page Layout Navigation Buttons -->
						<?php 
							if ( $tmq_search_header != 'off' ) {
						?>
						<!-- Search Button -->
						<li id="search" data-toggle="popover"><a href="javascript:void(0);" class="top-search" title="Search"><i class="fa fa-search"></i></a></li>
						<!-- End Search Button -->
						<?php
							}
						?>
					</ul>
				</div>
			</div>
		</header>
		<!-- End Header -->