<?php
/**
 * Bokeh
 * ==================================================
 * This is the main function file - functions.php
 *
 */
 
/* Change OT Title */
add_filter('ot_header_version_text', 'tmq_options_title', 10, 2);
function tmq_options_title($title, $page_id) {
	if ($page_id == 'ot_theme_options') {
		return 'Bokeh Theme Options';
	} else {
		return $title;
	}
} 

/* Change OT Title Link */
add_filter('ot_header_logo_link', 'tmq_options_logo_link', 10, 2);
function tmq_options_logo_link($title, $page_id) {
	return '<img src="' . trailingslashit( get_template_directory_uri() ) . 'images/logo.png">';
}

 
  /* ==========================================================================
   Configure VC
   ========================================================================== */
   
	// Enable VC on all posts
	if ( !function_exists( 'tmq_enable_vc_post_types' ) ) {
		function tmq_enable_vc_post_types() {
			update_option('wpb_js_content_types', array( 'post', 'page', 'tmq-portfolio', 'tmq-magic-widget' ) );
		}
		add_action( 'after_setup_theme', 'tmq_enable_vc_post_types' );
	}
	/* if ( function_exists( 'wpb_js_composer_check_version_schedule_deactivation' ) ) {
		wpb_js_composer_check_version_schedule_deactivation(); 
	} * -/
	
	/* Force adding VC Front CSS */
	function vc_enqueue_main_css_forever() { 
		wp_enqueue_style('js_composer_front'); 
	} 
	add_action('wp_enqueue_scripts', 'vc_enqueue_main_css_forever');
	
 /* ==========================================================================
   Loading Functions and Features
   ========================================================================== */

	include_once('includes/framework/ot.php');
	include_once('includes/framework/webfonts.php');
	include_once('includes/framework/breadcrumb.php');   
	include_once('includes/framework/authors.php');   
	include_once('includes/framework/menu.php');
	include_once('includes/framework/ajax-loader.php');
	include_once('includes/framework/enqueue.php');
	include_once('includes/framework/sidebars.php');   
	include_once('includes/framework/functions.php');
	include_once('includes/framework/theme-support.php');
	include_once('tgm/tgm.php');
	
	load_template( trailingslashit( get_template_directory() ) . 'includes/theme-options.php' );
	load_template( trailingslashit( get_template_directory() ) . 'includes/framework/meta-boxes.php' );

	// Add Image Sizes
	load_template( trailingslashit( get_template_directory() ) . 'includes/framework/images.php' );

	/* Better WPML Menu Support */
	function new_nav_menu_items($items,$args) {
		if (function_exists('icl_get_languages')) {
			if( 'main-menu' == $args->theme_location ) {
				$languages = icl_get_languages('skip_missing=0');
				if(1 < count($languages)){
					$items_drop = '';
					$items_active = '';
					foreach($languages as $l){
						if(!$l['active']){
							$items_drop = $items_drop.'<li class="menu-item"><a href="'.$l['url'].'"><img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" /><span>'. $l['native_name'] .'</span></a></li>';
						} else {
							$items_active = '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
						}
					}
					$items .= '<li class="menu-item menu-item-has-children"><a href="javascript:void(0);">'. $items_active .'</a><div class="menu-container"><a class="mp-back" href="#">back</a><ul class="wpml-lang-menu">';
					$items .= $items_drop;
					$items = $items.'</ul></div></li>';
				}
			}
		}
		return $items;
	}
	add_filter( 'wp_nav_menu_items', 'new_nav_menu_items',10,2 );	
	
 /* ==========================================================================
   Bokeh Self Error Checking
   ========================================================================== */

	/*if ( !function_exists( 'my_custom_warning' ) ) {
		function my_custom_warning() {
		  if( ot_get_option('tmq_css') != '{{tmq_color_settings}}' ) {
			echo '<div id="my-custom-warning" class="error"><h3>Warning: Bokeh Theme Activation</h3><p>There is a problem in your theme installation. Please follow these steps to fix it easily: </p><ul><li>If you\'ve installed the theme just now, You should go to your "<strong>Appearance > Theme Options</strong>" page and save your settings once and check if it\'s fixed.</li><li>Re-import your theme options in "<strong>Appearance > Options Backup</strong>". Then save your theme options once again.</li><li>If none of the above steps helped, then please contact support and we will help you on this issue soon.</li></ul></div>';
		  }
		}
		add_action( 'admin_notices', 'my_custom_warning' );
	}*/
   

// Localisation Support
load_theme_textdomain('bokeh', get_template_directory() . '/languages');

// wordpress root directory
if ( !function_exists( 'get_wp_path' ) ) {
	function get_wp_path() {
		return str_replace( '\\', '/', ABSPATH );
	}
}

// display favorite icon
if ( !function_exists( 'show_favicon' ) ) {
	function show_favicon() {
		$favicon_url = ot_get_option( 'tmq_favicon' );
		if ( empty( $favicon_url ) ) {
			return false;
		}
		
		$favicon_dir = str_replace( get_site_url(), get_wp_path(), $favicon_url );
		if ( file_exists( $favicon_dir ) ) {
			echo '<link rel="shortcut icon" href="' . $favicon_url . '">';
		} else {
			echo '<!-- No FavIcons Found -->';
		}
	}
	add_action('wp_head', 'show_favicon'); // Add Favorites Icon to Site
}

// display appletouch icon
if ( !function_exists( 'show_appletouchicon' ) ) {
	function show_appletouchicon() {
		$appletouchicon_url = ot_get_option( 'tmq_appletouchicon' );
		if ( empty( $appletouchicon_url ) ) {
			return false;
		}
		
		$appletouchicon_dir = str_replace( get_site_url(), get_wp_path(), $appletouchicon_url );
		if ( file_exists( $appletouchicon_dir ) ) {
			echo '<link rel="apple-touch-icon" href="' . esc_url( $appletouchicon_url ) . '"/>';
		} else {
			echo '<!-- No AppleTouchIcon Found -->';
		}
	}
	add_action('wp_head', 'show_appletouchicon'); // Add AppleTouch Icon to Site
}

// display edit button for admin
if ( !function_exists( 'show_tmq_admin_edit' ) ) {
	function show_tmq_admin_edit() {
		if ( current_user_can('update_themes') && current_user_can('edit_pages') && current_user_can('edit_posts')  ) {
			edit_post_link( '<i title="'. __( 'Edit Post', 'bokeh' ) .'" class="fa fa-pencil"></i>', '<span class="tmq-edit-link">', '</span>' );
		}
	}
	add_action('wp_footer', 'show_tmq_admin_edit'); // Add Edit This Icon for Admins
}


/* ==========================================================================
   Customize WP Functions
   ========================================================================== */
   
	// Custom Read More Content to Post
	if ( !function_exists( 'remove_read_more' ) ) {
		function remove_read_more( $more ) {
			global $post;
			return ' [...]';
		}
		add_filter('excerpt_more', 'remove_read_more'); 
	}
	// Remove Admin bar
	if ( !function_exists( 'remove_admin_bar' ) ) {
		function remove_admin_bar() {
			if ( ! current_user_can('administrator') && ! is_admin() )
				return false;
			else
				return false; //?!?@! what? this should be true for admin menu
		}
		// add_filter('show_admin_bar', 'remove_admin_bar'); 
	}
	
	// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
	if ( !function_exists( 'remove_thumbnail_dimensions' ) ) {
		function remove_thumbnail_dimensions( $html )
		{
			$html = preg_replace( '/(width|height)=\"\d*\"\s/', "", $html );
			return $html;
		}
		add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10); 
	}
	
	if ( !function_exists( 'baw_hack_wp_title_for_home' ) ) {
		function baw_hack_wp_title_for_home( $title ) {
		  if( empty( $title ) && ( is_home() || is_front_page() ) ) {
			return __( 'Home', 'bokeh' ) . ' | ' . get_bloginfo( 'description' );
		  }
		  return $title;
		}
		add_filter( 'wp_title', 'baw_hack_wp_title_for_home' );
	}
	
	
/* ==========================================================================
   Add Filters for Above Functions
   ========================================================================== */
	
	// Allow shortcodes in Dynamic Sidebar
	add_filter('widget_text', 'do_shortcode'); 

	// Remove <p> tags in Dynamic Sidebars (better!)
	add_filter('widget_text', 'shortcode_unautop'); 	


/* ==========================================================================
   Get number of comments of a post
   ========================================================================== */
   
   if ( !function_exists( 'tmq_get_comments_count' ) ) {
		function tmq_get_comments_count( $post_id, $nocomments , $onecomment, $morecomments ) {
			$comments_count = get_comments_number( $post_id );
			if ( $comments_count == 0 || empty( $comments_count ) ) {
				return $nocomments;
			} elseif ( $comments_count == 1 ) {
				return '1 ' . $onecomment;
			} elseif ( $comments_count > 1 ) {
				return $comments_count . ' ' . $morecomments;
			} else {
				return '';
			}
		}
	}
/* ==========================================================================
	WooCommerce Support
	========================================================================== */

add_theme_support( 'woocommerce' );
		
	
?>