<?php
/**
 * Bokeh
 * ==================================================
 * This is the footer file - footer.php
 *
 */
 
  /* Theme Options Variables
 * ==================================================
 */
	if ( function_exists( 'ot_get_option' ) ) {
		// Back to Top Button
		$tmq_backtotop = ot_get_option( 'tmq_backtotop' );
		if ( $tmq_backtotop != 'off' ) {
			$tmq_backtotop = '<a href="#" id="back-to-top"><i class="fa fa-arrow-up"></i></a>';
		} else {
			$tmq_backtotop = '';
		}
		
		// Footer Site Text
		$tmq_footer_site_name = ot_get_option( 'tmq_footer_site_name' );
		if ( empty( $tmq_footer_site_name ) ) {
			$tmq_footer_site_name = 'BOKEH';
		}
		
		// Copyright Text
		$tmq_copyright_text = ot_get_option( 'tmq_copyright_text' );
		if ( empty( $tmq_copyright_text ) ) {
			$tmq_copyright_text = __( 'Copyright' , 'bokeh' ) . ' &copy; '. date( 'Y' ) .' ' . get_bloginfo( 'name' );
		}
		
		// Header Social Elements - Sortable List
		$tmq_social_items = ot_get_option( 'tmq_social_items' );
		if ( is_Array ( $tmq_social_items ) ) {
			// Socials are available - make the empty string to add items and prepare for output
			$tmq_social_media_links = '';
			
			foreach ( $tmq_social_items as $tmq_social_item ) {
				// Extract icons from Theme Options
				$tmq_social_title 		= $tmq_social_item['title'];
				$tmq_social_items_type 	= $tmq_social_item['tmq_social_items_type'];
				$tmq_social_items_url 	= $tmq_social_item['tmq_social_items_url'];
				$tmq_social_custom_icon	= $tmq_social_item['tmq_social_custom_icon'];

				// Choose Social Icon
				switch ( $tmq_social_items_type ) {
					case 'facebook':
					case 'twitter':
					case 'pinterest':
					case 'linkedin':
					case 'youtube':
					case 'dribbble':
					case 'skype':
					case 'instagram':
						$tmq_social_icon = 'fa fa-' . esc_attr( $tmq_social_items_type );
						break;
					case 'google':
						$tmq_social_icon = 'fa fa-' . esc_attr( $tmq_social_items_type ) . '-plus';
						break;
					case 'vimeo':
						$tmq_social_icon = 'fa fa-' . esc_attr( $tmq_social_items_type ) . '-square';
						break;
					case 'custom':
						$tmq_social_icon = 'fa ' . esc_attr( $tmq_social_custom_icon );
						break;
					default:
						$tmq_social_icon = 'fa fa-share';
						break;
				}
				// Check for empty custom icon
				if ( $tmq_social_icon == 'fa fa-' ) {
					$tmq_social_icon = 'fa fa-link';
				}
				// Put Social Option into the Variable
				if ( !empty( $tmq_social_items_url ) && !empty( $tmq_social_title ) ) { 
					$tmq_social_media_links .= '<li><a title="'. esc_attr( $tmq_social_title ) .'" href="'. esc_url( $tmq_social_items_url ) .'" target="_blank"><i class="' . esc_attr( $tmq_social_icon ) . '"></i></a></li>' . "\n";
				}
			}
		} else {
			// No social items are added - make the empty variable.
			$tmq_social_media_links = '';
		}		
		
	} else {
		// Fall backs
		$tmq_backtotop = '<a class="go-top" href="#"></a>';
		$tmq_footer_site_name = 'BOKEH';
		$tmq_copyright_text = __( 'Copyright' , 'bokeh' ) . ' ' . get_bloginfo( 'name' );
		$tmq_social_media_links = '';
	}
 /* 
* ==================================================
@END Theme Options Variables */
 
?>
	<!-- Footer Section -->
		<footer class="footer">
			<div class="container">
				<div class="footer-logo"><?php echo esc_attr( $tmq_footer_site_name );?></div>
				<div class="footer-copyright"><p class="text-muted"><?php echo esc_attr( $tmq_copyright_text ); ?></p></div>
				<ul class="footer-social">
					<?php echo html_entity_decode( $tmq_social_media_links );?>
				</ul>
			</div>
		</footer>
		<!-- End Footer -->
		
		<!-- Search box will be used in header PopOver -->
		<div id="popover-content" class="hide">
			<form class="sidebar-searchbox" method="get" action="<?php echo esc_url(home_url());?>">
				<input type="search" name="s" placeholder="Search and hit Enter!">
			</form>
		</div>
		
		<!-- Back to Top Button -->
		<?php echo html_entity_decode( $tmq_backtotop ); ?>

		<?php
			// Load Comment Reply WP JS - We dont check for is_single because of the ajax loader
			wp_enqueue_script( 'comment-reply' );
			
			// Load Google Analytics
			if ( function_exists( 'ot_get_option' ) ) {
				$tmq_googleanalytics = ot_get_option( 'tmq_googleanalytics' );
			} else {
				$tmq_googleanalytics = '<!-- Google Analytics -->';
			}
			
			echo html_entity_decode( $tmq_googleanalytics );
			// Load WordPress Footer Functions		
		?>
		<?php wp_footer(); ?>
	</body>
</html>