<?php
/**
 * BOKEH
 * ==================================================
 * This is the default 404 Error file 
 *
 */
get_header();

/* ======================================================
// Get Page Meta Data and Options
====================================================== */
									
// *** BREADCRUMB ***
if ( is_front_page() || is_home() ) {
	// We don't need it on frontpage
	$tmq_brcr = 'tmq_hide';
} else {
	$tmq_brcr = ot_get_option( 'tmq_brcr' );
	if ( empty( $tmq_brcr ) ) {
		$tmq_brcr = 'tmq_show';
	}
}

/* ======================================================
   // Get 404 Page Settings
   ====================================================== */
    $tmq_banner_title = '';
	
	$tmq_404_heading = ot_get_option( 'tmq_404_heading' );
	if ( empty( $tmq_404_heading ) ) {
		$tmq_404_heading = __('404 File Not Found!', 'bokeh');
	}
	$tmq_404_text = ot_get_option( 'tmq_404_text' );
	if ( empty( $tmq_404_text ) ) {
		$tmq_404_text = __('Oops! The page you are looking for could not be found! Maybe you want to search for it?', 'bokeh');
	}
	$tmq_404_search = ot_get_option( 'tmq_404_search' );
	if ( empty( $tmq_404_search ) ) {
		$tmq_404_search = 'on';
	}
?>
		<!-- Main Container Section -->	
		<div class="container">
			<div id="page-content">
				
				<?php if ( 'tmq_hide' != $tmq_brcr ) { ?>
				<!-- Page Banner + Breadcrumb -->
				<div id="page-banner">		
					<h2><?php echo esc_attr( $tmq_banner_title );?></h2>
					<?php
						// Show Breadcrumb
						if ( ( function_exists( 'tmq_show_bc' ) ) && ( $tmq_brcr == 'tmq_show' ) ) {
								tmq_show_bc();
						}
					?>
				</div>
				<!-- End Page Banner + Breadcrumb -->
				<?php } ?>
				
				<!-- Page Content Area -->
				<div id="content-inner">
					<div class="row">
						<!-- Main Content Area -->
						<div class="col-md-12">
							<h1 class="main-title triggerAnimation animated" data-animate="fadeIn"><?php echo esc_attr( $tmq_404_heading ); ?></h1>
							<div class="excerpt col-md-10 col-md-offset-1 triggerAnimation animated" data-animate="fadeInUp">
								<?php echo esc_attr( $tmq_404_text );?>
								<?php
								if ( 'on' == $tmq_404_search ) {
									get_search_form( true );
								}
								?>
							</div>
							<div class="clearfix"></div>
						</div>
						<!-- End: Main Content Area -->						
					</div>
				</div>
				<!-- End Content Area -->
				
			</div>
		</div>
		<!-- End Container -->
<?php get_footer(); ?>