<?php

function getbowtied_home_content()
{
	global 	
		$theme_slug_gbt_dash,
		$theme_name_gbt_dash,
		$theme_version_gbt_dash,
		$theme_url_docs_gbt_dash,
		$theme_url_changelog_gbt_dash,
		$theme_url_support_gbt_dash;
?>

	<div class="wrap">
		
		<h1 class="wp-heading-inline"><?php echo esc_html($theme_name_gbt_dash); ?> <?php echo esc_html($theme_version_gbt_dash); ?></h1>
		<a href="<?php echo esc_url($theme_url_changelog_gbt_dash); ?>" target="_blank" class="page-title-action">Changelog</a>
		<br /><br />

		<div class="">
			
			<h2>You're just starting out?</h2>

			<?php
			if (is_plugin_active('kits-templates-and-patterns/kits-templates-and-patterns.php')) {
			?>

			    <p>Give our Starter Templates a try! They'll help you launch your project faster.</p>

			    <a href="<?php echo esc_url(admin_url('themes.php?page=kits-templates-and-patterns&browse=' . $theme_slug_gbt_dash)); ?>" class="button button-primary button-large">Go to the Starter Templates</a>
			
			<?php
			
			} else {

			?>

			    <p>
			    	Install the "<strong>Kits, Templates and Patterns</strong>" plugin and give our Starter Templates a try! They'll help you launch your project faster.<br />
			    	These templates are built with Elementor, and you will have access to all the widgets in Elementor PRO without a subscription.
			    </p>

			    <a href="<?php echo esc_url(admin_url('plugins.php?page='.$theme_slug_gbt_dash.'-plugins')); ?>" class="button button-primary button-large">Get "Kits, Templates and Patterns" plugin for <?php echo esc_html($theme_name_gbt_dash); ?>. It's free.</a>
			
			<?php
			}
			?>

			<br /><br />

			<h2>Want your website to be different?</h2>
			<a href="<?php echo esc_url(admin_url('customize.php')); ?>" class="button button-primary button-large">Customize it</a>
			<br /><br />

			<h2>Need Help?</h2>
			<ul>
				<li>
					<a href="<?php echo esc_url($theme_url_docs_gbt_dash); ?>" target="_blank" class="button button-primary button-large">Read the documentation</a>
					&nbsp;
					<a href="<?php echo esc_url($theme_url_support_gbt_dash); ?>" target="_blank" class="button button-large">Contact the Customer Support</a>
				</li>
				<li>&nbsp;</li>
			</ul>
			<br /><br />

		</div>

	</div>

<?php
}
