<?php
/**
*	Theme Options Config File
*	@version	1.0
*
* 	@author		Greatives Team
* 	@URI		http://greatives.eu
*/

if ( !class_exists( "ReduxFramework" ) ) {
	return;
}

function blade_grve_redux_dimensions_validation( $field, $value, $existing_value ) {
	$error = false;

	if ( empty( $value['width'] ) || !is_numeric( $value['width'] ) ) {
		$error = true;
	}
	if ( empty( $value['height'] ) || !is_numeric( $value['height'] ) ) {
		$error = true;
	}

	if ( $error == true ) {
		$value = $existing_value;
		$field['msg'] = esc_html__( 'You must provide a numerical value for both options.', 'blade' );
	}

	$return['value'] = $value;
	if ( $error == true ) {
		$return['error'] = $field;
	}
	return $return;

}

if (!class_exists("Blade_GRVE_Redux_Framework_config")) {

	class Blade_GRVE_Redux_Framework_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			// No errors please
			if ( !isset( $this->args['opt_name'] ) ) {
				return;
			}
			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function blade_grve_redux_customizer_visibility() {
			$visibility = apply_filters( 'blade_grve_redux_customizer_visibility', false );
			return $visibility;
		}

		public function setSections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			 * */
			global $blade_grve_social_list, $blade_grve_button_type_selection, $blade_grve_button_shape_selection, $blade_grve_button_color_selection;

			$grve_social_options = $blade_grve_social_list;

			$grve_portfolio_social_options = array(
				'email' => esc_html__( 'E-mail', 'blade' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'pinterest' => 'Pinterest',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$grve_portfolio_term_selection = array(
				'none' => esc_html__( 'None', 'blade' ),
				'portfolio_category' => esc_html__( 'Portfolio Category', 'blade' ),
				'portfolio_field' => esc_html__( 'Portfolio Field', 'blade' ),
			);

			$grve_post_social_options = array(
				'email' => esc_html__( 'E-mail', 'blade' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$grve_product_social_options = array(
				'email' => esc_html__( 'E-mail', 'blade' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'grve-likes' => '(Greatives) Likes',
			);

			$grve_blog_style_selection = array(
				'large' => esc_html__( 'Large Media', 'blade' ),
				'small' => esc_html__( 'Small Media', 'blade' ),
				'masonry' => esc_html__( 'Masonry' , 'blade' ),
				'grid' => esc_html__( 'Grid' , 'blade' ),
			);

			$grve_blog_image_mode_selection = array(
				'auto' => esc_html__( 'Auto Crop', 'blade' ),
				'resize' => esc_html__( 'Resize', 'blade' ),
				'large' => __( 'Resize ( Large )', 'blade' ),
				'medium_large' => __( 'Resize ( Medium Large )', 'blade' ),
				'medium' => __( 'Resize ( Medium )', 'blade' ),
			);

			$grve_blog_masonry_image_mode_selection = array(
				'large' => __( 'Resize ( Large )', 'blade' ),
				'medium_large' => __( 'Resize ( Medium Large )', 'blade' ),
				'medium' => __( 'Resize ( Medium )', 'blade' ),
			);

			$grve_blog_columns_selection = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
			);
			$grve_blog_columns_selection_mobile = array(
				'1' => '1',
				'2' => '2',
			);
			$grve_blog_headings_tag_selection = array(
				'auto' => esc_html__( 'Auto', 'blade' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);

			$grve_blog_headings_selection = array(
				'auto' => esc_html__( 'Auto', 'blade' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'blade' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'blade' ),
				'small-text' => esc_html__( 'Small Text', 'blade' ),
				'link-text' => esc_html__( 'Link Text', 'blade' ),
			);

			$grve_theme_layout_selection = array(
				'stretched' => esc_html__( 'Stretched', 'blade' ),
				'boxed' => esc_html__( 'Boxed', 'blade' ),
			);

			$grve_layout_selection = array(
				'none' => array('alt' => esc_html__( 'Full Width', 'blade' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
				'left' => array('alt' => esc_html__( 'Left Sidebar', 'blade' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
				'right' => array('alt' => esc_html__( 'Right Sidebar', 'blade' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
			);

			$grve_align_selection = array(
				'left' => esc_html__( 'Left', 'blade' ),
				'right' => esc_html__( 'Right', 'blade' ),
			);

			$grve_align_selection_extra = array(
				'left' => esc_html__( 'Left', 'blade' ),
				'center' => esc_html__( 'Center', 'blade' ),
				'right' => esc_html__( 'Right', 'blade' ),
			);

			$grve_align_selection_full = array(
				'left-top' => esc_html__( 'Left Top', 'blade' ),
				'left-center' => esc_html__( 'Left Center', 'blade' ),
				'left-bottom' => esc_html__( 'Left Bottom', 'blade' ),
				'center-top' => esc_html__( 'Center Top', 'blade' ),
				'center-center' => esc_html__( 'Center Center', 'blade' ),
				'center-bottom' => esc_html__( 'Center Bottom', 'blade' ),
				'right-top' => esc_html__( 'Right Top', 'blade' ),
				'right-center' => esc_html__( 'Right Center', 'blade' ),
				'right-bottom' => esc_html__( 'Right Bottom', 'blade' ),
			);

			$grve_animation_selection = array(
				'fade-in' => esc_html__( 'Default', 'blade' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'blade' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'blade' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'blade' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'blade' ),
				'zoom-in' => esc_html__( 'Zoom In', 'blade' ),
				'zoom-out' => esc_html__( 'Zoom Out', 'blade' ),
			);

			$grve_title_bg_mode = array(
				'color' => esc_html__( 'Color Only', 'blade' ),
				'featured' => esc_html__( 'Featured Image', 'blade' ),
				'custom' => esc_html__( 'Custom Image', 'blade' ),
			);

			$grve_title_bg_mode_limited = array(
				'color' => esc_html__( 'Color Only', 'blade' ),
				'custom' => esc_html__( 'Custom Image', 'blade' ),

			);

			$grve_background_type = array(
				'transparent' => esc_html__( 'None', 'blade' ),
				'colored' => esc_html__( 'Background', 'blade' ),
				'advanced' => esc_html__( 'Stretched Background', 'blade' ),
			);

			$grve_header_menu_options = array(
				'search' => esc_html__( 'Search', 'blade' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 Required)', 'blade' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'blade' ),
				'cart' => esc_html__( 'Shopping Cart (WooCommerce Required)', 'blade' ),
				'social' => esc_html__( 'Social Icons', 'blade' ),
				'login' => esc_html__( 'Login', 'blade' ),
			);
			$grve_header_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				'cart' => false,
				'social' => false,
				'login' => false,
			);

			$grve_header_menu_selection = array(
				'default' => esc_html__( 'Default', 'blade' ),
				'ubermenu' => esc_html__( 'UberMenu Direct', 'blade' ),
				'disabled' => esc_html__( 'Disabled', 'blade' ),
			);

			$grve_retina_support_selection = array(
				'default' => esc_html__( 'Theme Defined Images Only', 'blade' ),
				'full' => esc_html__( 'Full', 'blade' ),
				'disabled' => esc_html__( 'Disabled', 'blade' ),
			);

			$grve_top_bar_options = array(
				'menu' => esc_html__( 'Menu (Assigned: Menus - Manage Locations)', 'blade' ),
				'text' => esc_html__( 'Text', 'blade' ),
				'search' => esc_html__( 'Search', 'blade' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'blade' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 Required)', 'blade' ),
				'social' => esc_html__( 'Social Icons', 'blade' ),
			);
			$grve_top_bar_options_default = array(
				'menu' => false,
				'text' => false,
				'search' => false,
				'language' => false,
				'form' => false,
				'social' => false,
			);

			$grve_menu_animations = array(
				'none' => esc_html__( 'None', 'blade' ),
				'fade-in' => esc_html__( 'Fade in', 'blade' ),
				'fade-in-up' => esc_html__( 'Fade in Up', 'blade' ),
				'fade-in-down' => esc_html__( 'Fade in Down', 'blade' ),
				'fade-in-left' => esc_html__( 'Fade in Left', 'blade' ),
				'fade-in-right' => esc_html__( 'Fade in Right', 'blade' ),
			);
			$grve_menu_pointers = array(
				'none' => esc_html__( 'None', 'blade' ),
				'arrow' => esc_html__( 'Arrow', 'blade' ),
			);

			$grve_color_selection = array(
				'dark' => esc_html__( 'Dark', 'blade' ),
				'light' => esc_html__( 'Light', 'blade' ),
				'primary-1' => esc_html__( 'Primary 1', 'blade' ),
				'primary-2' => esc_html__( 'Primary 2', 'blade' ),
				'primary-3' => esc_html__( 'Primary 3', 'blade' ),
				'primary-4' => esc_html__( 'Primary 4', 'blade' ),
				'primary-5' => esc_html__( 'Primary 5', 'blade' ),
			);
			$grve_color_selection_extra = array(
				'dark' => esc_html__( 'Dark', 'blade' ),
				'light' => esc_html__( 'Light', 'blade' ),
				'primary-1' => esc_html__( 'Primary 1', 'blade' ),
				'primary-2' => esc_html__( 'Primary 2', 'blade' ),
				'primary-3' => esc_html__( 'Primary 3', 'blade' ),
				'primary-4' => esc_html__( 'Primary 4', 'blade' ),
				'primary-5' => esc_html__( 'Primary 5', 'blade' ),
				'custom' => esc_html__( 'Custom', 'blade' ),
			);

			$grve_bg_color_selection = array(
				'none' => esc_html__( 'None', 'blade' ),
				'dark' => esc_html__( 'Dark', 'blade' ),
				'light' => esc_html__( 'Light', 'blade' ),
				'primary-1' => esc_html__( 'Primary 1', 'blade' ),
				'primary-2' => esc_html__( 'Primary 2', 'blade' ),
				'primary-3' => esc_html__( 'Primary 3', 'blade' ),
				'primary-4' => esc_html__( 'Primary 4', 'blade' ),
				'primary-5' => esc_html__( 'Primary 5', 'blade' ),
			);

			$grve_header_style = array(
				'default' => esc_html__( 'Default', 'blade' ),
				'dark' => esc_html__( 'Dark', 'blade' ),
				'light' => esc_html__( 'Light', 'blade' ),
			);

			$grve_enable_selection = array(
				'no' => esc_html__( 'No', 'blade' ),
				'yes' => esc_html__( 'Yes', 'blade' ),
			);

			$grve_menu_responsibe_style_selection = array(
				'1' => esc_html__( 'Style 1', 'blade' ),
				'2' => esc_html__( 'Style 2', 'blade' ),
			);

			$grve_menu_responsibe_toggle_selection = array(
				'icon' => esc_html__( 'Icon', 'blade' ),
				'text' => esc_html__( 'Text', 'blade' ),
			);

			$grve_footer_column_selection = array(
				'footer-1' => array('alt' => esc_html__( 'Footer 1', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-1.png' ),
				'footer-2' => array('alt' => esc_html__( 'Footer 2', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-2.png' ),
				'footer-3' => array('alt' => esc_html__( 'Footer 3', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-3.png' ),
				'footer-4' => array('alt' => esc_html__( 'Footer 4', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-4.png' ),
				'footer-5' => array('alt' => esc_html__( 'Footer 5', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-5.png' ),
				'footer-6' => array('alt' => esc_html__( 'Footer 6', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-6.png' ),
				'footer-7' => array('alt' => esc_html__( 'Footer 7', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-7.png' ),
				'footer-8' => array('alt' => esc_html__( 'Footer 8', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-8.png' ),
				'footer-9' => array('alt' => esc_html__( 'Footer 9', 'blade' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-9.png' ),
			);

			$grve_opacity_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.10' => '10%',
				'0.15' => '15%',
				'0.20' => '20%',
				'0.25' => '25%',
				'0.30' => '30%',
				'0.35' => '35%',
				'0.40' => '40%',
				'0.45' => '45%',
				'0.50' => '50%',
				'0.55' => '55%',
				'0.60' => '60%',
				'0.65' => '65%',
				'0.70' => '70%',
				'0.75' => '75%',
				'0.80' => '80%',
				'0.85' => '85%',
				'0.90' => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);
			$grve_ratio_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.1'  => '10%',
				'0.15' => '15%',
				'0.2'  => '20%',
				'0.25' => '25%',
				'0.3'  => '30%',
				'0.35' => '35%',
				'0.4'  => '40%',
				'0.45' => '45%',
				'0.5'  => '50%',
				'0.55' => '55%',
				'0.6'  => '60%',
				'0.65' => '65%',
				'0.7'  => '70%',
				'0.75' => '75%',
				'0.8'  => '80%',
				'0.85'  => '85%',
				'0.9'  => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);

			$grve_headings_tag_selection = array(
				'div' => 'div',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$grve_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'blade' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'blade' ),
				'small-text' => esc_html__( 'Small Text', 'blade' ),
				'link-text' => esc_html__( 'Link Text', 'blade' ),
			);

			$grve_pattern_selection = array(
				'none' => esc_html__( 'No', 'blade' ),
				'default' => esc_html__( 'Yes', 'blade' ),
			);

			//Standard Fonts
			$grve_std_fonts = array(
				"Arial, Helvetica, sans-serif"                         => "Arial, Helvetica, sans-serif",
				"'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
				"'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
				"'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
				"Courier, monospace"                                   => "Courier, monospace",
				"Garamond, serif"                                      => "Garamond, serif",
				"Georgia, serif"                                       => "Georgia, serif",
				"Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
				"'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
				"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
				"'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
				"'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
				"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
				"Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
				"'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
				"'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
				"Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
			);
			$grve_std_fonts = apply_filters( 'blade_grve_std_fonts', $grve_std_fonts );

			$grve_feature_section_post_types_selection = array(
				'page'   => esc_html__( 'Pages', 'blade' ),
				'portfolio'   => esc_html__( 'Portfolio Items', 'blade' ),
				'post'   => esc_html__( 'Posts', 'blade' ),
				'product'   => esc_html__( 'Products', 'blade' ),
			);

			//Skin Presets
			$grve_skin_palette_1 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#f1b144","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#f1b144","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#f1b144","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#f1b144","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#f1b144","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#f1b144","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#f1b144","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#f1b144","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#f1b144","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#f1b144","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#f1b144","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#f1b144","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#f1b144","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#f1b144","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#f1b144","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#f1b144","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#f1b144","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#f1b144","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_2 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#fa4949","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#fa4949","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#fa4949","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#fa4949","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#fa4949","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#fa4949","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#fa4949","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#fa4949","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#fa4949","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#fa4949","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#fa4949","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#fa4949","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#fa4949","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#fa4949","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#fa4949","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#fa4949","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#fa4949","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#fa4949","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_3 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#00e5ff","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#00e5ff","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#00e5ff","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#00e5ff","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#00e5ff","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#00e5ff","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#00e5ff","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#00e5ff","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#00e5ff","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#00e5ff","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#00e5ff","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#00e5ff","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#00e5ff","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#00e5ff","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#00e5ff","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#00e5ff","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#00e5ff","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#00e5ff","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_4 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#64dd17","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#64dd17","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#64dd17","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#64dd17","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#64dd17","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#64dd17","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#64dd17","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#64dd17","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#64dd17","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#64dd17","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#64dd17","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#64dd17","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#64dd17","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#64dd17","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#64dd17","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#64dd17","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#64dd17","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#64dd17","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_5 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#aa00ff","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#aa00ff","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#aa00ff","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#aa00ff","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#aa00ff","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#aa00ff","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#aa00ff","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#aa00ff","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#aa00ff","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#aa00ff","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#aa00ff","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#aa00ff","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#aa00ff","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#aa00ff","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#aa00ff","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#aa00ff","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#aa00ff","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#aa00ff","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_6 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#ff7043","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#ff7043","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#ff7043","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#ff7043","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#ff7043","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#ff7043","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#ff7043","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#ff7043","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#ff7043","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#ff7043","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#ff7043","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#ff7043","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#ff7043","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#ff7043","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#ff7043","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#ff7043","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#ff7043","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#ff7043","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_7 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#fdd835","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#fdd835","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#fdd835","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#fdd835","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#fdd835","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#fdd835","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#fdd835","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#fdd835","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#fdd835","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#fdd835","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#fdd835","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#fdd835","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#fdd835","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#fdd835","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#fdd835","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#fdd835","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#fdd835","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#fdd835","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_8 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#2962ff","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#2962ff","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#2962ff","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#2962ff","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#2962ff","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#2962ff","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#2962ff","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#2962ff","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#2962ff","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#2962ff","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#2962ff","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#2962ff","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#2962ff","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#2962ff","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#2962ff","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#2962ff","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#2962ff","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#2962ff","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_9 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#00897b","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#00897b","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#00897b","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#00897b","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#00897b","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#00897b","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#00897b","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#00897b","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#00897b","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#00897b","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#00897b","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#00897b","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#00897b","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#00897b","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#00897b","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#00897b","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#00897b","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#00897b","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';
			$grve_skin_palette_10 = '{"top_bar_bg_color":"#232323","top_bar_font_color":"#777777","top_bar_link_color":"#777777","top_bar_hover_color":"#82b1ff","default_header_background_color":"#ffffff","default_header_background_color_opacity":"1","default_header_menu_text_color":"#000000","default_header_menu_text_hover_color":"#82b1ff","default_header_menu_type_color":"#ededed","default_header_menu_type_color_hover":"#82b1ff","default_header_submenu_bg_color":"#232323","default_header_submenu_text_color":"#777777","default_header_submenu_text_hover_color":"#ffffff","default_header_submenu_text_bg_hover_color":"#1f1f1f","default_header_submenu_column_text_color":"#ffffff","default_header_submenu_column_text_hover_color":"#82b1ff","default_header_submenu_border_color":"#3e3e3e","logo_top_header_logo_area_background_color":"#ffffff","logo_top_header_logo_area_background_color_opacity":"1","logo_top_header_menu_area_background_color":"#ffffff","logo_top_header_menu_area_background_color_opacity":"1","logo_top_header_menu_text_color":"#000000","logo_top_header_menu_text_hover_color":"#82b1ff","logo_top_header_menu_type_color":"#ededed","logo_top_header_menu_type_color_hover":"#82b1ff","logo_top_header_submenu_bg_color":"#232323","logo_top_header_submenu_text_color":"#777777","logo_top_header_submenu_text_hover_color":"#ffffff","logo_top_header_submenu_text_bg_hover_color":"#1f1f1f","logo_top_header_submenu_column_text_color":"#ffffff","logo_top_header_submenu_column_text_hover_color":"#82b1ff","logo_top_header_submenu_border_color":"#3e3e3e","side_header_background_color":"#232323","side_header_background_color_opacity":"1","side_header_menu_text_color":"#656565","side_header_menu_text_hover_color":"#ffffff","side_header_submenu_text_color":"#656565","side_header_submenu_text_hover_color":"#ffffff","side_header_border_color":"#323232","side_header_border_opacity":"1","header_sticky_background_color":"#000000","header_sticky_background_color_opacity":"0.85","sticky_menu_text_color":"#ffffff","sticky_menu_text_hover_color":"#999999","header_sticky_menu_type_color":"#ededed","header_sticky_menu_type_color_hover":"#ededed","light_menu_text_hover_color":"#82b1ff","light_menu_type_color_hover":"#ededed","dark_menu_text_hover_color":"#82b1ff","dark_menu_type_color_hover":"#ededed","responsive_header_background_color":"#ffffff","responsive_header_elements_color":"#000000","responsive_header_elements_hover_color":"#82b1ff","responsive_menu_background_color":"#232323","responsive_menu_link_color":"#ffffff","responsive_menu_link_hover_color":"#82b1ff","responsive_menu_close_btn_color":"#777777","responsive_menu_border_color":"#3e3e3e","responsive_menu_overflow_background_color":"#ffffff","responsive_menu_overflow_background_color_opacity":"0.90","page_anchor_menu_background_color":"#232323","page_anchor_menu_text_color":"#777777","page_anchor_menu_text_hover_color":"#ffffff","page_anchor_menu_background_hover_color":"#1a1a1a","page_anchor_menu_border_color":"#323232","main_content_background_color":"#ffffff","body_heading_color":"#000000","body_text_color":"#777777","body_text_link_color":"#82b1ff","body_text_link_hover_color":"#000000","body_border_color":"#e4e4e4","body_primary_1_color":"#82b1ff","body_primary_2_color":"#044475","body_primary_3_color":"#487F84","body_primary_4_color":"#5F597E","body_primary_5_color":"#d6ccad","blog_title_bg_color":"dark","blog_title_bg_color_custom":"#232323","blog_title_color":"light","blog_title_color_custom":"#ffffff","blog_description_color":"light","blog_description_color_custom":"#ffffff","post_title_bg_color":"dark","post_title_bg_color_custom":"#232323","post_title_color":"light","post_title_color_custom":"#ffffff","post_description_color":"light","post_description_color_custom":"#ffffff","post_bar_background_color":"#f7f7f7","post_bar_socials_color":"#000000","post_bar_socials_color_hover":"#82b1ff","post_bar_nav_title_color":"#afafaf","post_bar_nav_subheading_color":"#c4c4c4","post_bar_arrow_color":"#000000","post_bar_border_color":"#f2f2f2","page_title_bg_color":"dark","page_title_bg_color_custom":"#232323","page_title_color":"light","page_title_color_custom":"#ffffff","page_description_color":"light","page_description_color_custom":"#ffffff","portfolio_title_bg_color":"dark","portfolio_title_bg_color_custom":"#232323","portfolio_title_color":"light","portfolio_title_color_custom":"#ffffff","portfolio_description_color":"light","portfolio_description_color_custom":"#ffffff","portfolio_bar_background_color":"#f7f7f7","portfolio_bar_socials_color":"#000000","portfolio_bar_socials_color_hover":"#82b1ff","portfolio_bar_nav_title_color":"#afafaf","portfolio_bar_nav_subheading_color":"#c4c4c4","portfolio_bar_arrow_color":"#000000","portfolio_bar_border_color":"#f2f2f2","product_tax_title_bg_color":"dark","product_tax_title_bg_color_custom":"#232323","product_tax_title_color":"light","product_tax_title_color_custom":"#ffffff","product_tax_description_color":"light","product_tax_description_color_custom":"#ffffff","product_title_bg_color":"dark","product_title_bg_color_custom":"#232323","product_title_color":"light","product_title_color_custom":"#ffffff","product_description_color":"light","product_description_color_custom":"#ffffff","footer_widgets_bg_color":"#232323","footer_widgets_headings_color":"#ffffff","footer_widgets_font_color":"#777777","footer_widgets_link_color":"#a0a0a0","footer_widgets_hover_color":"#82b1ff","footer_widgets_border_color":"#3e3e3e","footer_bar_bg_color":"#1a1a1a","footer_bar_bg_color_opacity":"1","footer_bar_font_color":"#5f5f5f","footer_bar_link_color":"#696969","footer_bar_hover_color":"#ffffff","page_breadcrumbs_background_color":"#ffffff","page_breadcrumbs_text_color":"#6e6e6e","page_breadcrumbs_text_hover_color":"#82b1ff","page_breadcrumbs_divider_color":"#b2b2b2","page_breadcrumbs_border_color":"#e0e0e0","sliding_area_background_color":"#232323","sliding_area_title_color":"#ffffff","sliding_area_text_color":"#777777","sliding_area_link_color":"#777777","sliding_area_link_hover_color":"#82b1ff","sliding_area_close_btn_color":"#777777","sliding_area_border_color":"#3e3e3e","sliding_area_overflow_background_color":"#ffffff","sliding_area_overflow_background_color_opacity":"0.90","modal_title_color":"#ffffff","modal_text_color":"#777777","modal_close_btn_color":"#ffffff","modal_border_color":"#3e3e3e","modal_overflow_background_color":"#000000","modal_overflow_background_color_opacity":"0.95"}';


			$blade_gmap_api_key_link = '<a href="//developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">' . esc_html__( 'Generate Google Map API Key', 'blade' ) . '</a>';
			$regenerate_link = '<a href="//wordpress.org/plugins/regenerate-thumbnails/" target="_blank">' . esc_html__( 'regenerate your thumbnails', 'blade' ) . '</a>';
			$blade_gmap_style_link = '<a href="//mapstyle.withgoogle.com/" target="_blank">' . esc_html__( 'Styling Wizard Google Maps API.', 'blade' ) . '</a>';
			// ACTUAL DECLARATION OF SECTIONS

			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'title' => esc_html__( 'General Settings', 'blade' ),
				'id' => 'grve_redux_section_general_settings',
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'theme_layout',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Theme Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select between Streched or Boxed for the theme basic Layout.', 'blade' ),
						'options' => $grve_theme_layout_selection,
						'default' => 'stretched',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'boxed_size',
						'type' => 'text',
						'default' => '1220',
						'title' => esc_html__( 'Theme Wrapper Size', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Theme Wrapper width in px (Default is 1220).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'boxed' ),
					),
					array(
						'id' => 'container_size',
						'type' => 'text',
						'default' => '1170',
						'title' => esc_html__( 'Container Size', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Container width in px (Default is 1170).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id'       => 'body_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Theme Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the theme.', 'blade' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'output'    => '#grve-body',
						'default' => array (
							'background-color' => '#ffffff',
						),
					),
					array(
						'id'=>'theme_loader',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Loader', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader.', 'blade' ),
						'default' => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'replace_admin_logo',
						'type' => 'checkbox',
						'title' => esc_html__( 'Replace Admin Logo', 'blade' ),
						'subtitle'=> esc_html__( 'Check the box beside to replace the backend admin logo with your company logo.', 'blade' ),
						'default' => 0,
					),
					array(
						'id'       => 'admin_logo',
						'type'     => 'media',
						'title' => esc_html__( 'Admin Logo', 'blade' ),
						'subtitle' => esc_html__( 'Select the image for your company logo. ( If empty Logo Default will be used instead )', 'blade' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'admin_logo_height',
						'type' => 'text',
						'default' => '84',
						'title' => esc_html__( 'Admin Logo Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the company logo height in px (Default is 84).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'tracking_code',
						'type' => 'ace_editor',
						'mode' => 'html',
						'theme' => 'chrome',
						'title' => esc_html__( 'Tracking Code', 'blade' ),
						'subtitle' => esc_html__( 'Copy and paste your tracking code here.', 'blade' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Logos', 'blade' ),
				'id' => 'grve_redux_section_logos',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'logo',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Default Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '273', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Default Header.', 'blade' ),
					),
					array(
						'id' => 'logo_light',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Light Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-light.png', 'width' => '273', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Light Header.', 'blade' ),
					),
					array(
						'id' => 'logo_dark',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Dark Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-dark.png', 'width' => '273', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Dark Header.', 'blade' ),
					),
					array(
						'id' => 'logo_side',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Side Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-side.png', 'width' => '141', 'height' => '70' ),
						'subtitle' => esc_html__( 'Upload the logo for the Side Header.', 'blade' ),
					),
					array(
						'id' => 'logo_sticky',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Sticky Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-sticky.png', 'width' => '273', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Sticky Header.', 'blade' ),
					),
					array(
						'id' => 'logo_responsive',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Responsive Header', 'blade' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-responsive.png', 'width' => '273', 'height' => '40' ),
						'subtitle' => esc_html__( 'Upload the logo for the Responsive Header.', 'blade' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Top Bar Options', 'blade' ),
				'id' => 'grve_redux_section_top_bar_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the TopBar area, just above the Header, in order to add various elements in two different positions, left and right.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-arrow-up',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'top_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Area', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the TopBar Area, the area just above your header.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'             => 'top_bar_spacing',
						'type'           => 'spacing',
						'output'         => array('#grve-top-bar .grve-wrapper'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Top Bar Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the TopBar Area.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Top Bar Full Width', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Top Bar Area.', 'blade' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'blade' ),
							'fullwidth-element' => esc_html__( 'Yes', 'blade' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_top_bar_left',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Left Top Bar Area', 'blade' ),
						'desc' => esc_html__( 'In side navigation mode, Left Top Bar Area is shown first.', 'blade' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_left_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Left Area', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Left TopBar Area.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_left_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Left Area Elements', 'blade' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Left TopBar Area.', 'blade' ),
						'options' => $grve_top_bar_options,
						'default' => $grve_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_text',
						'type' => 'text',
						'title' => esc_html__( 'Left Area Text', 'blade' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Left TopBar Area.', 'blade' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'blade' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'blade' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Left Area Social Icons', 'blade' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'blade' ),
						'desc' => '',
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $grve_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_top_bar_right',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Right Top Bar Area', 'blade' ),
						'desc' => esc_html__( 'In side navigation mode, Right Top Bar Area is shown second.', 'blade' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_right_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Right Area', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Right TopBar Area.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_right_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Right Area Elements', 'blade' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Right TopBar Area.', 'blade' ),
						'options' => $grve_top_bar_options,
						'default' => $grve_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_text',
						'type' => 'text',
						'title' => esc_html__( 'Right Area Text', 'blade' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Right TopBar Area.', 'blade' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'blade' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'blade' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Right Area Social Icons', 'blade' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'blade' ),
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $grve_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header Options', 'blade' ),
				'id' => 'grve_redux_section_header_options',
				'header' => '',
				'desc' => esc_html__( 'Here you can set your preferences for the Theme Header(Logo, Menu and Menu Elements). Notice that most of the options below depend on your first selection where you have to select among Default, Logo on Top or Side Navigation Header.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'header_mode',
						'type' => 'button_set',
						'title' => esc_html__( 'Header Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select your Header Mode. keep in mind that this is one of the most important options for the appearance of your site. Your selection here will determine the following section options.', 'blade' ),
						'options' => array(
							'default' => esc_html__( 'Default', 'blade' ),
							'logo-top' => esc_html__( 'Logo on Top', 'blade' ),
							'side' => esc_html__( 'Side', 'blade' ),
						),
						'default' => 'default',
					),
					array(
						'id' => 'header_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Header Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 90).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'header_side_width',
						'type' => 'text',
						'default' => '300',
						'title' => esc_html__( 'Header Width', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Header Width in px (Default is 300).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_spacing',
						'type'           => 'spacing',
						'output'         => array('#grve-main-header.grve-header-side .grve-content, #grve-main-header.grve-header-side .grve-header-elements-wrapper'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'top'           => 'false',
						'bottom'          => 'false',
						'title'          => esc_html__( 'Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacings for the content of the Header.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Right, Left in px.', 'blade'),
						'default'        => array(
							'padding-left'     => '30px',
							'padding-right'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Header Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the header.', 'blade' ),
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Full Width', 'blade' ),
						'subtitle'=> esc_html__( 'Check the box beside if you want to have full width Header.', 'blade' ),
						'default' => 0,
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id'   => 'info_logo_default_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Default Header', 'blade' ),
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'logo_height',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Logo Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 18).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'   => 'info_logo_ontop_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Logo on Top Header', 'blade' ),
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_height',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Logo Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 30).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_height',
						'type' => 'text',
						'default' => '120',
						'title' => esc_html__( 'Logo Area Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Logo Area Height in px (Default is 120).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id'   => 'info_logo_side_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Side Header', 'blade' ),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_height',
						'type' => 'text',
						'default' => '50',
						'title' => esc_html__( 'Logo Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Logo Height in px (Default is 30).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_logo_spacing',
						'type'           => 'spacing',
						'output'         => array('#grve-main-header.grve-header-side .grve-logo'),
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacings of the Logo.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '100px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'   => 'info_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Options', 'blade' ),
					),
					array(
						'id' => 'menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'blade' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'blade' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'blade' ),
							'button' => esc_html__( 'Button Style', 'blade' ),
							'underline' => esc_html__( 'Underline', 'blade' ),
							'hidden' => esc_html__( 'Hidden', 'blade' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'right',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'default' ),
						'required' => array( 'menu_type', '!=', 'hidden' ),
					),
					array(
						'id' => 'header_bottom_height',
						'type' => 'text',
						'default' => '50',
						'title' => esc_html__( 'Menu Area Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Menu Area Height in px (Default is 50).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'blade' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'blade' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'blade' ),
							'button' => esc_html__( 'Button Style', 'blade' ),
							'underline' => esc_html__( 'Underline', 'blade' ),
							'hidden' => esc_html__( 'Hidden', 'blade' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
						'required' => array( 'header_top_logo_menu_type', '!=', 'hidden' ),
					),
					array(
						'id' => 'submenu_pointer',
						'type' => 'select',
						'title' => esc_html__( 'Sub Menu Pointer', 'blade' ),
						'subtitle'=> esc_html__( 'Choose pointer for the submenu.', 'blade' ),
						'options' => $grve_menu_pointers,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'header_menu_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Type', 'blade' ),
						'subtitle' => esc_html__( 'Select your menu type.', 'blade' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'blade' ),
							'slide' => esc_html__( 'Slide', 'blade' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'blade' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'blade' ),
							'center' => esc_html__( 'Center', 'blade' ),
						),
						'default' => 'center',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_menu_open_type', 'equals', 'toggle' ),
						),

					),
					array(
						'id'   => 'info_menu_elements',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Menu Elements Options', 'blade' ),
					),
					array(
						'id'=>'header_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Menu Elements', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like shop cart, socials, search, language selector and Contact Form.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'header_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Menu Elements Options', 'blade' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements options.', 'blade' ),
						'options' => $grve_header_menu_options,
						'default' => $grve_header_menu_options_default,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'blade' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'blade' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'login_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Login Custom Link URL', 'blade' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your login page.', 'blade' ),
						"default" => '',
					),
					array(
						'id'=>'header_menu_social_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Social Icons Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social icons single or modal.', 'blade' ),
						'options' => array(
							'modal' => esc_html__( 'Modal Popup', 'blade' ),
							'single' => esc_html__( 'Single Social Icons', 'blade' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Menu Social Icons', 'blade' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'blade' ),
						'desc' => '',
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $grve_social_options,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Sticky Header Options', 'blade' ),
				'id' => 'grve_redux_section_sticky_header_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the Sticky Header option if you want to provide constant access to the Header elements while visitors scroll down the page. These settings will not affect if you select the Side Header Mode in Theme Options > Header Options.', 'blade' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'header_sticky_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Header', 'blade' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header option.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'header_sticky_type',
						'type' => 'select',
						'title' => esc_html__( 'Sticky Header Type', 'blade' ),
						'subtitle'=> esc_html__( 'Select the type of the Sticky Header.', 'blade' ),
						'options' => array(
							'simple' => esc_html__( 'Simple', 'blade' ),
							'shrink' => esc_html__( 'Shrink', 'blade' ),
							'advanced' => esc_html__( 'Advanced Shrink', 'blade' ),
						),
						'default' => 'simple',
						'validate' => 'not_empty',
						'required' => array( 'header_sticky_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_sticky_shrink_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Header Shrink Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Header in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id' => 'header_sticky_shrink_logo_height',
						'type' => 'text',
						'default' => '16',
						'title' => esc_html__( 'Logo Shrink Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Logo in px (Default is 16).', 'blade' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id'=>'header_sticky_devices_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Devices Sticky Header', 'blade' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header on small devices ( Tablet Portrait and Mobiles ).', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'header_sticky_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Header Options', 'blade' ),
				'id' => 'grve_redux_section_responsive_header_options',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the responsive header. These settings will affect when the responsive header appears, below 1024px.', 'blade' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'responsive_header_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Responsive Header Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 90).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Responsive Header overlaps the content.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_responsive_logo_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Responsive Header', 'blade' ),
					),
					array(
						'id' => 'responsive_logo_height',
						'type' => 'text',
						'default' => '16',
						'title' => esc_html__( 'Responsive Logo Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 16).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id'   => 'info_responsive_menu_options',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Responsive Menu Options', 'blade' ),
					),
					array(
						'id' => 'menu_responsive_toggle_selection',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Toggle Button Selection', 'blade' ),
						'subtitle' => esc_html__( 'Select the toggle button content for your responsive menu.', 'blade' ),
						'options' => $grve_menu_responsibe_toggle_selection,
						'default' => 'icon',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_toggle_text',
						'type' => 'text',
						'title' => esc_html__( 'Responsive Menu Text', 'blade' ),
						'subtitle' => esc_html__( 'Enter the text for your responsive menu.', 'blade' ),
						'default' => 'Menu',
						'required' => array( 'menu_responsive_toggle_selection', 'equals', 'text' ),
					),
					array(
						'id' => 'menu_responsive_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive Menu Type', 'blade' ),
						'subtitle' => esc_html__( 'Select your responsive menu type.', 'blade' ),
						'desc' => esc_html__( "Note: This setting will also affect hidden menu.", 'blade' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'blade' ),
							'slide' => esc_html__( 'Slide', 'blade' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_align',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Align', 'blade' ),
						'subtitle' => esc_html__( 'Select your responsive menu align.', 'blade' ),
						'desc' => esc_html__( "Note: This setting will also affect hidden menu.", 'blade' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'blade' ),
							'center' => esc_html__( 'Center', 'blade' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Footer Options', 'blade' ),
				'id' => 'grve_redux_section_footer_options',
				'desc' => esc_html__( 'Footer is the area that appears at the bottom of your pages. Define your preferences.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'footer_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Footer Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'footer_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the footer.', 'blade' ),
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'   => 'info_footer_widgets',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Widgets Settings', 'blade' ),
					),
					array(
						'id'=>'footer_widgets_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Widgets Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable the Footer Area to show the widget areas of the footer.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'footer_widgets_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Footer Column Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the Footer column layout.', 'blade' ),
						'options' => $grve_footer_column_selection,
						'default' => 'footer-1',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'sticky_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Footer', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want a sticky footer.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'footer_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Full Width', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Area.', 'blade' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'blade' ),
							'fullwidth-element' => esc_html__( 'Yes', 'blade' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'footer_widgets_spacing',
						'type'           => 'spacing',
						'output'         => array('.grve-widget-area'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacing of the Footer Area.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '70px',
							'units'           => 'px',
						),
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_footer_bar',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Footer Bar Settings', 'blade' ),
					),
					array(
						'id'=>'footer_bar_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Bar Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable the Footer Bar Area to add text (copyright), bottom menu and socials.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'footer_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Full Width', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Bar Area.', 'blade' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'blade' ),
							'fullwidth-element' => esc_html__( 'Yes', 'blade' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_bar_align_center',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Center', 'blade' ),
						'subtitle'=> esc_html__( 'Select if the Footer Bar elements will be centered.', 'blade' ),
						'options' => array(
							'no' => esc_html__( 'No', 'blade' ),
							'yes' => esc_html__( 'Yes', 'blade' ),
						),
						'default' => 'yes',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'footer_bar_spacing',
						'type'           => 'spacing',
						'output'         => array('.grve-footer-bar'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacing of Footer Bar Area.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'footer_copyright_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Copyright Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable the Footer Copyright Area. Edit it as you wish.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_copyright_text',
						'type' => 'editor',
						'title' => esc_html__( 'Copyright Text', 'blade' ),
						'subtitle' => esc_html__( 'Type your copyright text or anything else you want.', 'blade' ),
						'default' => 'With <i class="grve-text-primary-1 fa fa-heart-o"></i> by <a href="//greatives.eu" target="_blank">Greatives</a> - HQ Themes',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'footer_copyright_visibility', 'equals', '1' ),
						),
					),
					array(
						'id'=>'second_area_visibility',
						'type' => 'button_set',
						'title' => esc_html__( 'Second Footer Area', 'blade' ),
						'subtitle'=> esc_html__( 'This is the second position in the Footer Bar Area. You can easily add the Bottom Menu(assigned in Appearance > Menus) or socials.', 'blade' ),
						'options' => array(
							'1' => esc_html__( 'Hide', 'blade' ),
							'2' => esc_html__( 'Menu', 'blade' ),
							'3' => esc_html__( 'Socials', 'blade' ),
						),
						'default' => '1',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_social_display',
						'type' => 'select',
						'title' => esc_html__( 'Footer Social Display', 'blade' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social items.', 'blade' ),
						'options' => array(
							'text' => esc_html__( 'Text', 'blade' ),
							'icon' => esc_html__( 'Icons', 'blade' ),
						),
						'default' => 'text',
						'validate' => 'not_empty',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
					array(
						'id' => 'footer_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Footer Social items', 'blade' ),
						'subtitle' => esc_html__( 'Select your social icons.', 'blade' ),
						'desc' => '',
						'class' => 'grve-redux-columns',
						'label' => true,
						'options' => $grve_social_options,
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Blog Options', 'blade' ),
				'id' => 'grve_redux_section_blog_options',
				'desc' => esc_html__( 'Changes here will affect the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays and not when you use the shortcodes to create a blog page. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'blog_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Blog Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the layout for the assigned blog page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'blog_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar for the assigned blog page.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Fixed Sidebar', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Blog Sliding Area for the assigned blog page.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_blog_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Style and Basic Blog Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the default blog.', 'blade' ),
					),
					array(
						'id' => 'blog_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Style', 'blade' ),
						'subtitle' => esc_html__( 'Select the blog style', 'blade' ),
						'options' => $grve_blog_style_selection,
						'default' => 'large',
					),
					array(
						'id' => 'blog_item_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Item Style', 'blade' ),
						'subtitle' => esc_html__( 'Select the blog item style', 'blade' ),
						'options' => array(
							'1' => esc_html__( 'Style 1', 'blade' ),
							'2' => esc_html__( 'Style 2', 'blade' ),
						),
						'default' => '1',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select the Blog Mode', 'blade' ),
						'options' =>array(
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'blade' ),
							'shadow-mode' => esc_html__( 'With Shadow', 'blade' ),
						),
						'default' => 'no-shadow-mode',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_media_area',
						'type' => 'switch',
						'title' => esc_html__( 'Blog Media Area visibility', 'blade' ),
						'subtitle' => esc_html__( 'Select if you want to enable media area', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'blog_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select your Blog Image Mode', 'blade' ),
						'options' => $grve_blog_image_mode_selection,
						'default' => 'auto',
						'required' => array(
							array( 'blog_style','!=', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_masonry_image_mode',
						'type' => 'select',
						'title' => __( 'Blog Masonry Image Mode', 'blade' ),
						'subtitle' => __( 'Select your Blog Masonry Image Mode', 'blade' ),
						'options' => $grve_blog_masonry_image_mode_selection,
						'default' => 'large',
						'required' => array(
							array( 'blog_style','equals', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_prio',
						'type' => 'select',
						'title' => esc_html__( 'Blog Featured Image Priority', 'blade' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed instead of media element', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
						'required' => array( 'blog_media_area', 'equals', '1' ),
					),
					array(
						'id' => 'blog_columns',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select the Blog Columns', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '4',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Landscape Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '4',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Portrait Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '2',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mobile Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'blade' ),
						'options' => $grve_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array(
							array( 'blog_style','!=', 'large' ),
							array( 'blog_style','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Tag', 'blade' ),
						'subtitle' => esc_html__( 'Select tag for your blog title.', 'blade' ),
						'options' => $grve_blog_headings_tag_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_heading',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Size', 'blade' ),
						'subtitle' => esc_html__( 'Select size and typography for your blog title.', 'blade' ),
						'options' => $grve_blog_headings_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_item_spinner',
						'type' => 'select',
						'title' => esc_html__( 'Blog Loader', 'blade' ),
						'subtitle' => esc_html__( 'If selected, this will enable a graphic spinner before load.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'blade' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'blog_style', '!=', 'large' ),
					),
					array(
						'id' => 'blog_auto_excerpt',
						'type' => 'switch',
						'title' => esc_html__( 'Auto Excerpt', 'blade' ),
						'subtitle'=> esc_html__( "Adds automatic excerpt to all posts. If auto excerpt is off, blog will show all content, a desired 'cut-off' can be inserted in each post with more quicktag.", 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'blog_style', 'equals', 'large' ),
					),

					array(
						'id'=>'blog_excerpt_length',
						'type' => 'text',
						'default' => '55',
						'title' => esc_html__( 'Excerpt Length', 'blade' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 55).', 'blade' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'blog_auto_excerpt', 'equals', '1' ),
							array( 'blog_style', 'equals', 'large' ),
						),
					),
					array(
						'id' => 'blog_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'blade' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'blog_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Field Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments field of your blog overview.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'blog_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Field Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the author field of your blog overview.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'blog_date_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Date Field Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field of your blog overview.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'blog_like_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Like Field Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the like field of your blog overview.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'   => 'info_style_blog_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Blog Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default blog header.', 'blade' ),
					),
					array(
						'id' => 'blog_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your blog header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'blog_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Blog Header overlaps the content. Combine this option with the Light or Dark Header.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'=>'blog_title',
						'type' => 'select',
						'title' => esc_html__( 'Main Blog Title', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to use the site name and tagline as the main blog title or hide it.', 'blade' ),
						'options' => array(
							'sitetitle' => esc_html__( 'Site Title / Tagline', 'blade' ),
							'none' => esc_html__( 'None', 'blade' ),
						),
						'default' => 'sitetitle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter blog title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter blog title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default blog title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default blog title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'blog_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Background for the blog page, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'blog_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default blog title.', 'blade' ),
						'required' => array( 'blog_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Post Settings', 'blade' ),
				'id' => 'grve_redux_section_single_post_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Posts. Notice that most of them can be overridden when you create a single post.', 'blade' ),
				'submenu' => true,
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Posts. Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'post_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Posts.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Post Content Width', 'blade' ),
						'subtitle' => esc_html__( 'Select the Single Post Content width (only for Full Width Post Layout)', 'blade' ),
						'options' => array(
							'1170' => esc_html__( 'Large' , 'blade' ),
							'990' => esc_html__( 'Medium' , 'blade' ),
							'600' => esc_html__( 'Small' , 'blade' ),
						),
						'default' => '990',
					),
					array(
						'id' => 'post_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Post Sliding Area if you want.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_feature_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Featured Image Visibility (Standard Post)', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_tag_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Tags Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post tags.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Categories Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post categories.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Info Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Author Info field.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_date_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Date Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'post_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Posts Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the related posts.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'post_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your single posts.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'   => 'info_style_post_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Post Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'blade' ),
					),
					array(
						'id' => 'post_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your post header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'post_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Post Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single post.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_post_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default single post title.', 'blade' ),
					),
					array(
						'id' => 'post_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter post title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter post title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default post title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default post title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'post_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Post Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'post_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default post title.', 'blade' ),
						'required' => array( 'post_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'post_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'post_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'post_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'post_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'post_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'post_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_post_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per post.', 'blade' ),
					),
					array(
						'id' => 'post_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in posts.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_anchor_menu_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'blade' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_post_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'blade' ),
					),
					array(
						'id'=>'post_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Post / Archives / Categories / Tags.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'blade' ),
						'default' => 0,
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),

					array(
						'id'   => 'info_style_post_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar & Socials Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar.', 'blade' ),
					),
					array(
						'id'=>'post_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Posts Navigation Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the posts navigation.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'post_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Post Navigation Same Term', 'blade' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'blade' ),
						'default' => 0,
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'post_nav_spacing',
						'type'           => 'spacing',
						'output'         => array('#grve-post-bar'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '90px',
							'padding-bottom'  => '90px',
							'units'           => 'px',
						),
					),
					array(
						'id' => 'post_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'blade' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Posts.', 'blade' ),
						'options' => $grve_post_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-pencil',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Options', 'blade'),
				'id' => 'grve_redux_section_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'blade' ),
				'desc' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the layout for the pages. Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the pages in case you do not use full width layout.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the pages.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'page_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Easily disable the comments for all pages.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'   => 'info_style_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'blade' ),
					),
					array(
						'id' => 'page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default page title.', 'blade' ),
					),
					array(
						'id' => 'page_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Page title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Page title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default page title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default page title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default page title.', 'blade' ),
						'required' => array( 'page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_page_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per page.', 'blade' ),
					),
					array(
						'id' => 'page_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_anchor_menu_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'blade' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_page_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'blade' ),
					),
					array(
						'id'=>'page_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Page.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'page_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'blade' ),
						'default' => 0,
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-search',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Search Page Options', 'blade'),
				'id' => 'grve_redux_section_search_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the search page here.', 'blade' ),
				'desc' => esc_html__( 'You can find the basic settings for the search page here.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'search_page_custom_header_title',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Custom Search Header/Title Options', 'blade' ),
						'subtitle'=> esc_html__( 'Enable if you want custom Header/Title Options for your search page. If disabled Page Options will be used instead.', 'blade' ),
						'default' => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'   => 'info_style_search_page_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the search page header.', 'blade' ),
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id'   => 'search_info_style_search_page_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the search page title.', 'blade' ),
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Page title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Page title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the search page title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id' => 'search_page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the search page title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id'       => 'search_page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'search_page_custom_header_title', 'equals', '1' ),
					),
					array(
						'id'       => 'search_page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the search page title.', 'blade' ),
						'required' => array(
							array( 'search_page_title_bg_mode', 'equals', 'custom' ),
							array( 'search_page_custom_header_title', 'equals', '1' ),
						),
					),
					array(
						'id' => 'search_page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'search_page_title_bg_mode', '!=', 'color' ),
							array( 'search_page_custom_header_title', 'equals', '1' ),
						),
					),
					array(
						'id' => 'search_page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'search_page_title_bg_mode', '!=', 'color' ),
							array( 'search_page_custom_header_title', 'equals', '1' ),
						),
					),
					array(
						'id' => 'search_page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'search_page_title_bg_mode', '!=', 'color' ),
							array( 'search_page_custom_header_title', 'equals', '1' ),
						),
					),
					array(
						'id' => 'search_page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'search_page_title_bg_mode', '!=', 'color' ),
							array( 'search_page_custom_header_title', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_style_search_page_settings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Search Page Style and Basic Search Page Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the search page.', 'blade' ),
					),
					array(
						'id' => 'search_page_style',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Style', 'blade' ),
						'subtitle' => esc_html__( 'Select the search page style', 'blade' ),
						'options' => array(
							'masonry' => esc_html__( 'Masonry' , 'blade' ),
							'grid' => esc_html__( 'Grid' , 'blade' ),
						),
						'default' => 'masonry',
					),
					array(
						'id' => 'search_page_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select the Search Page Mode', 'blade' ),
						'options' => array(
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'blade' ),
							'shadow-mode' => esc_html__( 'With Shadow', 'blade' ),
						),
						'default' => 'shadow-mode',
					),
					array(
						'id' => 'search_page_show_image',
						'type' => 'select',
						'title' => esc_html__( 'Show Search Page Featured Image', 'blade' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'search_page_columns',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '3',
					),
					array(
						'id' => 'search_page_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Landscape Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '3',
					),
					array(
						'id' => 'search_page_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Portrait Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'blade' ),
						'options' => $grve_blog_columns_selection,
						'default' => '2',
					),
					array(
						'id' => 'search_page_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mobile Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'blade' ),
						'options' => $grve_blog_columns_selection_mobile,
						'default' => '1',
					),
					array(
						'id' => 'search_page_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Tag', 'blade' ),
						'subtitle' => esc_html__( 'Select tag for your search result title.', 'blade' ),
						'options' => $grve_headings_tag_selection,
						'default' => 'h4',
					),
					array(
						'id' => 'search_page_heading',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Size', 'blade' ),
						'subtitle' => esc_html__( 'Select size and typography for your search result title.', 'blade' ),
						'options' => $grve_headings_selection,
						'default' => 'h4',
					),
					array(
						'id'=>'search_page_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'blade' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'blade' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'search_page_not_found_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Not Found Text Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select custom text to define your own text, otherwise the default text will be displayed.', 'blade' ),
						'options' => array(
							'default' => esc_html__( 'Default Text', 'blade' ),
							'custom' => esc_html__( 'Custom Text', 'blade' ),
						),
						'default' => 'default',
					),
					array(
						'id' => 'search_page_not_found_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Search Page Not Found Content', 'blade' ),
						'subtitle' => esc_html__( 'Type the content of your search page when no results are found.', 'blade' ),
						'default' => '<p class="grve-align-center grve-leader-text">Hey there mate!<br />Your lost treasure is not found here...</p><p class="grve-align-center">Check again your spelling and rewrite the content you are seeking for in the search field.</p>',
						'required' => array( 'search_page_not_found_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_modal_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Modal Placeholder Text Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select custom text to define your own text, otherwise the default text will be displayed.', 'blade' ),
						'options' => array(
							'default' => esc_html__( 'Default Text', 'blade' ),
							'custom' => esc_html__( 'Custom Text', 'blade' ),
						),
						'default' => 'default',
					),
					array(
						'id' => 'search_modal_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Placeholder Text', 'blade' ),
						'subtitle' => esc_html__( 'Type the search placeholder text.', 'blade' ),
						'default' => 'Search for ...',
						'required' => array( 'search_modal_mode', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Portfolio Options', 'blade' ),
				'id' => 'grve_redux_section_portfolio_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'portfolio_slug',
						'type' => 'text',
						'default' => 'portfolio',
						'title' => esc_html__( 'Slug', 'blade' ),
						'subtitle' => esc_html__( "Enter Portfolio Slug (Default is 'portfolio'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'blade' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'blade' ),
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio (single portfolio items). Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single portfolio items.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the single portfolio items.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_details_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Text', 'blade' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details title.', 'blade' ),
						"default" => 'Project Details',
					),
					array(
						'id'=>'portfolio_recents_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Recent Items Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the recent items carousel.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'portfolio_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your portfolio.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'   => 'info_style_portfolio_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default portfolio header.', 'blade' ),
					),
					array(
						'id' => 'portfolio_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your portfolio header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'portfolio_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single portfolio.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_portfolio_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the single default portfolio title.', 'blade' ),
					),
					array(
						'id' => 'portfolio_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter portfolio title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter portfolio title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default portfolio title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default portfolio title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default portfolio title.', 'blade' ),
						'required' => array( 'portfolio_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
										array(
						'id' => 'portfolio_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_portfolio_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per portfolio item.', 'blade' ),
					),
					array(
						'id' => 'portfolio_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_anchor_menu_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'blade' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_portfolio_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'blade' ),
					),
					array(
						'id'=>'portfolio_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Portfolio.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'blade' ),
						'default' => 0,
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),

					array(
						'id'   => 'info_style_portfolio_nav',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar & Socials Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar.', 'blade' ),
					),
					array(
						'id'=>'portfolio_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Portfolio Navigation Visibility', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the portfolio navigation.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'portfolio_nav_term',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Same Term', 'blade' ),
						'subtitle' => esc_html__( 'If selected, only navigation items with the same selected taxonomy term will be displayed.', 'blade' ),
						'options' => $grve_portfolio_term_selection,
						'default' => 'none',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Backlink', 'blade' ),
						'subtitle' => esc_html__( 'Select the overview page for your portfolio backlink.', 'blade' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'portfolio_nav_spacing',
						'type'           => 'spacing',
						'output'         => array('#grve-portfolio-bar'),
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'blade' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'blade' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'blade'),
						'default'        => array(
							'padding-top'     => '90px',
							'padding-bottom'  => '90px',
							'units'           => 'px',
						),
					),
					array(
						'id' => 'portfolio_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'blade' ),
						'subtitle' => esc_html__( 'Enable or Disable the social shares you like in the single portfolio items.', 'blade' ),
						'options' => $grve_portfolio_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WooCommerce Options', 'blade'),
				'id' => 'grve_redux_section_woocommerce_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the WooCommerce here.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'product_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the default layout for the Product Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Product Taxonomy.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Product Taxonomy.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_tax_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default Product Taxonomy header.', 'blade' ),
					),
					array(
						'id' => 'product_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your Product Taxonomy header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_tax_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Product Taxonomy title.', 'blade' ),
					),
					array(
						'id' => 'product_tax_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default Product Taxonomy title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Product Taxonomy title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Product Taxonomy Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default Product Taxonomy title.', 'blade' ),
						'required' => array( 'product_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
										array(
						'id' => 'product_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_product_overview',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Shop Overview Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the shop overview.', 'blade' ),
					),
					array(
						'id' => 'product_overview_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Overview Product Image effect', 'blade' ),
						'subtitle'=> esc_html__( 'Select the effect for the overview product image', 'blade' ),
						'options' => array(
							'none' => esc_html__( 'None', 'blade' ),
							'second' => esc_html__( 'Second Image on Hover', 'blade' ),
						),
						'default' => 'second',
					),
					array(
						'id' => 'product_loop_columns',
						'type' => 'select',
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '4',
						'title' => esc_html__( 'Loop Columns', 'blade' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'blade' ),
					),
					array(
						'id' => 'product_loop_shop_per_page',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Loop Products per Page', 'blade' ),
						'subtitle' => esc_html__( 'Select how many products per page you want to show (Default is 12).', 'blade' ),
						'validate' => 'numeric',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Product Settings', 'blade' ),
				'id' => 'grve_redux_section_single_product_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Products. Notice that most of them can be overridden when you create a single product.', 'blade' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Layout', 'blade' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Products. Choose among Full Width, Left Sidebar or Right Sidebar.', 'blade' ),
						'options' => $grve_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'product_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Products.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable the Product Sliding Area if you want.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Sidebar', 'blade' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'blade' ),
						'data' => 'sidebar',
						'default' => 'grve-default-sidebar',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_style_product_header',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Product Header Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'blade' ),
					),
					array(
						'id' => 'product_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your product header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single product.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_title',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Title Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the default single product title.', 'blade' ),
					),
					array(
						'id' => 'product_title_height',
						'type' => 'text',
						'default' => '350',
						'title' => esc_html__( 'Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter product title height in px (Default is 350).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter product title minimum height in px (Default is 320).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'blade' ),
						'subtitle'=> esc_html__( 'Select your alignment for the default product title/description.', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'blade' ),
						'subtitle'=> esc_html__( 'Select your animation for the default product title/description.', 'blade' ),
						'options' => $grve_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the Product Title Background, Color or Image.', 'blade' ),
						'options' => $grve_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'blade' ),
						'subtitle' => esc_html__( 'Select a background image for the default product title.', 'blade' ),
						'required' => array( 'product_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'blade' ),
						'options' => $grve_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'blade' ),
						'options' => $grve_pattern_selection,
						'default' => 'none',
						'required' => array( 'product_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'blade' ),
						'options' => $grve_color_selection,
						'default' => 'dark',
						'required' => array( 'product_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'blade' ),
						'options' => $grve_opacity_selection,
						'default' => '0',
						'required' => array( 'product_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_product_anchor_menu',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per product.', 'blade' ),
					),
					array(
						'id' => 'product_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in products.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_anchor_menu_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'blade' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_product_breadcrumbs',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'blade' ),
					),
					array(
						'id'=>'product_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Product / Product Categories / Product Tags.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'product_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'blade' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'blade' ),
						'validate' => 'numeric',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'blade' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'blade' ),
						'options' => $grve_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'blade' ),
						'default' => 0,
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_product_image',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Product Image Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Set the style for the single product image.', 'blade' ),
					),
					array(
						'id' => 'product_image_thumb_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Image / Thumbnails Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select the style for the single product image and thumbnails. Note: some external plugins might not be compatible with Theme style.', 'blade' ),
						'options' => array(
							'theme' => esc_html__( 'Theme Style', 'blade' ),
							'woo' => esc_html__( 'Default WooCommerce Style', 'blade' ),
						),
						'default' => 'theme',
					),
					array(
						'id' => 'product_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Product Image effect', 'blade' ),
						'subtitle'=> esc_html__( 'Select the effect for the main product image', 'blade' ),
						'options' => array(
							'none' => esc_html__( 'None', 'blade' ),
							'zoom' => esc_html__( 'Zoom', 'blade' ),
						),
						'default' => 'zoom',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_gallery_mode',
						'type' => 'select',
						'title' => esc_html__( 'Product Gallery Mode', 'blade' ),
						'subtitle'=> esc_html__( 'Select the mode for the single product gallery', 'blade' ),
						'options' => array(
							'none' => esc_html__( 'None', 'blade' ),
							'popup' => esc_html__( 'Magnific Popup', 'blade' ),
						),
						'default' => 'popup',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_gallery_title_caption',
						"type" => "select",
						"title" => esc_html__( "Product Gallery Image Title & Caption Visibility", "blade" ),
						"subtitle" => esc_html__( "Define the visibility for your image title - caption.", "blade" ),
						'options' => array(
							'none' => esc_html__( 'None' , 'blade' ),
							'title-caption' => esc_html__( 'Title and Caption' , 'blade' ),
							'title-only' => esc_html__( 'Title Only' , 'blade' ),
							'caption-only' => esc_html__( 'Caption Only' , 'blade' ),
						),
						'default' => 'none',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id'=>'product_gallery_woo_zoom',
						'type' => 'switch',
						'title' => esc_html__( 'Zoom Effect', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable image zoom effect.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'=>'product_gallery_woo_lightbox',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Lightbox', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery lightbox.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'=>'product_gallery_woo_slider',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Slider', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery slider.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id' => 'product_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'blade' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Product.', 'blade' ),
						'options' => $grve_product_social_options,
						'default' => 0,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Typography Options', 'blade' ),
				'id' => 'grve_redux_section_typography_options',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header/Body', 'blade' ),
				'id' => 'grve_redux_section_typography_header',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_body_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Body Fonts', 'blade' ),
					),
					array(
						'id' => 'body_font',
						'type' => 'typography',
						'title' => esc_html__( 'Body Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the body font properties.', 'blade' ),
						'google' => true,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '28px',
							'font-family' => 'Cabin Condensed',
							'font-weight' => '400',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id'   => 'info_logo_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Logo as text Fonts', 'blade' ),
					),
					array(
						'id' => 'logo_font',
						'type' => 'typography',
						'title' => esc_html__( 'Logo Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the logo font properties.', 'blade' ),
						'google' => true,
						'line-height'=> false,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '36px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id'   => 'info_menu_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Main Menu Fonts', 'blade' ),
					),
					array(
						'id' => 'main_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the menu font properties.', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'sub_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Submenu Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the submenu font properties.', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '14px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'description_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Description Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the Menu description font properties.', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '13px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Headings (H1-H6)', 'blade' ),
				'id' => 'grve_redux_section_typography_headings',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_headers_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Headings Fonts', 'blade' ),
					),
					array(
						'id' => 'headings_font',
						'type' => 'typography',
						'title' => esc_html__( 'Headings Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the headings font.', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => false,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'font-size' => false,
						'default' => array(
							'font-family' => 'Montserrat',
							'text-transform' => 'uppercase',
							'font-weight' => '700',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'h1_font',
						'type' => 'typography',
						'title' => esc_html__( 'H1 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H1 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '53px',
							'line-height' => '60px',
							'letter-spacing' => '',
						),
					),
					array(
						'id' => 'h2_font',
						'type' => 'typography',
						'title' => esc_html__( 'H2 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H2 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '36px',
							'line-height' => '40px',
							'letter-spacing' => '',
						),
					),
					array(
						'id' => 'h3_font',
						'type' => 'typography',
						'title' => esc_html__( 'H3 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H3 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '30px',
							'line-height' => '33px',
							'letter-spacing' => '',
						),
					),
					array(
						'id' => 'h4_font',
						'type' => 'typography',
						'title' => esc_html__( 'H4 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H4 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '23px',
							'line-height' => '26px',
							'letter-spacing' => '',
						),
					),
					array(
						'id' => 'h5_font',
						'type' => 'typography',
						'title' => esc_html__( 'H5 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H5 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '18px',
							'line-height' => '20px',
							'letter-spacing' => '',
						),
					),
					array(
						'id' => 'h6_font',
						'type' => 'typography',
						'title' => esc_html__( 'H6 Font', 'blade' ),
						'subtitle' => esc_html__( 'Specify the H6 font.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => false,
						'font-family' => false,
						'font-weight' => false,
						'font-style' => false,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '18px',
							'letter-spacing' => '',
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Titles/Descriptions', 'blade' ),
				'id' => 'grve_redux_section_typography_titles',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Page/Blog Typography', 'blade' ),
					),
					array(
						'id' => 'page_title',
						'type' => 'typography',
						'title' => esc_html__( 'Page Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '64px',
							'line-height' => '68px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'page_description',
						'type' => 'typography',
						'title' => esc_html__( 'Page Description', 'blade' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id'   => 'info_post_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Single Post Typography', 'blade' ),
					),
					array(
						'id' => 'post_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Title Meta', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for meta in the post title section.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '18px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '3.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'post_title',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the single post titles.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '64px',
							'line-height' => '68px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'post_title_desc',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post Description', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the single post description.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id'   => 'info_portfolio_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Portfolio Typography', 'blade' ),
					),
					array(
						'id' => 'portfolio_title',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio titles.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '64px',
							'line-height' => '68px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'portfolio_description',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Description', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio description.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
					),
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'WooCommerce Typography', 'blade' ),
					),
					array(
						'id' => 'product_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '64px',
							'line-height' => '68px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'product_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Description', 'blade' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Feature Section', 'blade' ),
				'id' => 'grve_redux_section_typography_feature_section',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_feature_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography', 'blade' ),
					),
					array(
						'id' => 'feature_subheading_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Sub Heading', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the custom sub-heading in the feature section. (Sub Heading, Custom Size Slider Title)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '18px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '3.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'feature_title_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the custom title in the feature section. (Custom Title, Custom Size Slider Title)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '64px',
							'line-height' => '68px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'feature_desc_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Description', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the custom description in the feature section. (Custom Description, Custom Size Slider Description)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'feature_subheading_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Fullscreen Sub Heading', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the fullscreen sub-heading in the feature section. (Sub Heading, Fullscreen mode)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '20px',
							'line-height' => '30px',
							'font-weight' => '400',
							'text-transform' => 'uppercase',
							'letter-spacing' => '3.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'feature_title_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Title for Fullscreen Section', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the custom title in the feature section in case you use full screen mode. (Custom Title, Custom Size Slider Title)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '90px',
							'line-height' => '96px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'feature_desc_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Description for Fullscreen Section', 'blade' ),
						'subtitle' => esc_html__( 'Specify the font for the custom description in the feature section in case you use full screen mode. (Custom Description, Custom Size Slider Description)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '30px',
							'line-height' => '36px',
							'font-weight' => '400',
							'font-style' => 'italic',
							'text-transform' => 'none',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Extras', 'blade' ),
				'id' => 'grve_redux_section_typography_extras',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'widgets_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Widgets Typography', 'blade' ),
					),
					array(
						'id' => 'widget_title',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Title', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the widget titles.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '16px',
							'line-height' => '24px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'widget_text',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Text', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the widget texts.', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '14px',
							'line-height' => '24px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id'   => 'info_special_typography',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Special Text Typography', 'blade' ),
					),
					array(
						'id' => 'leader_text',
						'type' => 'typography',
						'title' => esc_html__( 'Leader Text', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the leader text. This is used in various elements (Text block, Testimonial...)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '26px',
							'line-height' => '32px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'subtitle_text',
						'type' => 'typography',
						'title' => esc_html__( 'Subtitle Text', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the subtitle text. This is used in various elements (Slogan Subtitle...)', 'blade' ),
						'google' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '14px',
							'line-height' => '18px',
							'font-weight' => '600',
							'text-transform' => 'uppercase',
							'letter-spacing' => '3.7px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'small_text',
						'type' => 'typography',
						'title' => esc_html__( 'Small Text', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the small text. This is used in various elements (Tags, Post Meta...)', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Cabin Condensed',
							'font-size' => '11px',
							'font-weight' => '500',
							'text-transform' => 'uppercase',
							'letter-spacing' => '2px',
						),
						'fonts' => $grve_std_fonts,
					),
					array(
						'id' => 'link_text',
						'type' => 'typography',
						'title' => esc_html__( 'Link Text', 'blade' ),
						'subtitle' => esc_html__( 'Specify the style for the link text. This is used in various elements (Buttons, Read More...)', 'blade' ),
						'google' => true,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Montserrat',
							'font-size' => '13px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '0.7px',
						),
						'fonts' => $grve_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Typography', 'blade' ),
				'id' => 'grve_redux_section_responsive_typography',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Headings', 'blade' ),
				'id' => 'grve_redux_section_responsive_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness for the Typography Headings ( H1-H6 ).', 'blade' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_tablet_landscape_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold_headings',
						'type' => 'text',
						'default' => '35',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 35).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold_headings',
						'type' => 'text',
						'default' => '35',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 35).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile_headings',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'blade' ),
					),
					array(
						'id' => 'typography_mobile_threshold_headings',
						'type' => 'text',
						'default' => '35',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 35).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive First Group', 'blade' ),
				'id' => 'grve_redux_section_responsive_typography_first_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for following elements: Page / Post / Portfolio / Product / Feature Section Titles.', 'blade' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_tablet_landscape',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.85',
					),
					array(
						'id'   => 'info_typography_mobile',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'blade' ),
					),
					array(
						'id' => 'typography_mobile_threshold',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 30).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.4',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Second Group', 'blade' ),
				'id' => 'grve_redux_section_responsive_typography_second_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for following elements: Page / Post / Portfolio / Product / Feature Section Descriptions, Leader Text, Subtitle Text, Link Texts and Buttons.', 'blade' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_tablet_landscape2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'blade' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile2',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'blade' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'blade' ),
					),
					array(
						'id' => 'typography_mobile_threshold2',
						'type' => 'text',
						'default' => '13',
						'title' => esc_html__( 'Size Threshold', 'blade' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 13).', 'blade' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'blade' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'blade' ),
						'options' => $grve_ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'CSS / JS Options', 'blade' ),
				'id' => 'grve_redux_section_css_js_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'   => 'info_style_css_code',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'CSS', 'blade' ),
					),
					array(
						'id' => 'css_code',
						'type' => 'ace_editor',
						'title' => esc_html__( 'CSS Code', 'blade' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'blade' ),
						'mode' => 'css',
						'theme' => 'monokai',
						'desc' => '',
						'default' => ''
					),
					array(
						'id'   => 'info_style_js_code',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'JS', 'blade' ),
					),
					array(
						'id' => 'custom_js',
						'type' => 'ace_editor',
						'mode' => 'javascript',
						'theme' => 'chrome',
						'title' => esc_html__( 'JS Code', 'blade' ),
						'subtitle' => esc_html__( 'Add your custom JavaScript code here. Please do not include any script tags.', 'blade' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Style Options', 'blade' ),
				'id' => 'grve_redux_section_style_options',
				'desc' => sprintf( wp_kses( __( 'To customize the color scheme, please use the <a href="%s">Live Color Customizer</a>.', 'blade' ), array( 'br' => array(), 'a' => array( 'href' => true, 'target' => true ) ) ), admin_url('/customize.php') ),
				'customizer' => false,
				'fields' => array(
					array(
						'id'    => 'info_style_color_preset',
						'type'  => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Skin Presets', 'blade' ),
					),
					array(
						'id'        => 'skin_preset',
						'type'      => 'image_select',
						'presets'   => true,
						'title'     => esc_html__( 'Select your Skin', 'blade' ),
						'default'   => 0,
						'subtitle'  => esc_html__( 'Use the preset as you wish in order to customize your color scheme.', 'blade' ),
						'options'   => array(
							'palette-1'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-1.png', 'presets' => $grve_skin_palette_1 ),
							'palette-2'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-2.png', 'presets' => $grve_skin_palette_2 ),
							'palette-3'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-3.png', 'presets' => $grve_skin_palette_3 ),
							'palette-4'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-4.png', 'presets' => $grve_skin_palette_4 ),
							'palette-5'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-5.png', 'presets' => $grve_skin_palette_5 ),
							'palette-6'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-6.png', 'presets' => $grve_skin_palette_6 ),
							'palette-7'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-7.png', 'presets' => $grve_skin_palette_7 ),
							'palette-8'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-8.png', 'presets' => $grve_skin_palette_8 ),
							'palette-9'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-9.png', 'presets' => $grve_skin_palette_9 ),
							'palette-10'  => array('img' => get_template_directory_uri() . '/includes/images/skins/palette-10.png', 'presets' => $grve_skin_palette_10 ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Top Bar', 'blade' ),
				'id' => 'grve_redux_section_colors_top_bar',
				'desc' => esc_html__( 'Set your color preferences for the TopBar (you will see the changes in the live preview only if TopBar is enabled).', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					//Top Bar Color Settings
					array(
						'id'          => 'top_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your Top Bar.', 'blade' ),
						'default'     => '#232323',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Font Color', 'blade' ),
						'subtitle'    => esc_html__( 'Font color for your Top Bar.', 'blade' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Link Color', 'blade' ),
						'subtitle'    => esc_html__( 'Link color for your Top Bar.', 'blade' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Hover color for your Top Bar.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Header / Menu', 'blade' ),
				'id' => 'grve_redux_section_colors_header_menu',
				'desc' => esc_html__( 'Set your color preferences for the Header and Menu.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Default Header', 'blade' ),
				'id' => 'grve_redux_section_colors_default_header',
				'desc' => esc_html__( 'Set your color preferences for the Default Header. Keep in mind that the basic settings for the Default Header are in Theme Options > Header Options.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Default Header Color Settings
					array(
						'id'       => 'default_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'default_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.10',
					),
					//Menu Color Settings
					array(
						'id'          => 'default_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'blade' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'default_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'blade' ),
						'default'     => '#232323',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'blade' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'blade' ),
						'default'     => '#1f1f1f',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'blade' ),
						'default'     => '#3e3e3e',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Logo on Top Header', 'blade' ),
				'id' => 'grve_redux_section_colors_logotop_header',
				'desc' => esc_html__( 'Set your color preferences for the Logo on top Header. Keep in mind that the basic settings for the Logo on top Header are in Theme Options > Header Options.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'logo_top_header_logo_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Logo Area Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the logo area.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_logo_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Logo Area Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the logo area.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_menu_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Area Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the menu area.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_menu_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Menu Area Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the menu area.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'logo_top_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'blade' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'logo_top_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'blade' ),
						'default'     => '#232323',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'blade' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'blade' ),
						'default'     => '#1f1f1f',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'blade' ),
						'default'     => '#3e3e3e',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Side Header', 'blade' ),
				'id' => 'grve_redux_section_colors_side_header',
				'desc' => esc_html__( 'Set your color preferences for the Side Header. Keep in mind that the basic settings for the Side Header are in Theme Options > Header Options.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'side_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'side_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'blade' ),
						'default'     => '#656565',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'side_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'blade' ),
						'default'     => '#656565',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a border color.', 'blade' ),
						'default'     => '#323232',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_border_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the borders.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sticky Header', 'blade' ),
				'id' => 'grve_redux_section_colors_sticky_header',
				'desc' => esc_html__( 'Set your color preferences for the Sticky Header. You can enable/disable, select the type and logo for the sticky header in Theme Options > Header Options > Sticky Header Options.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sticky Header Color Settings
					array(
						'id'       => 'header_sticky_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color for the header.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.85',
					),
					array(
						'id'       => 'header_sticky_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a border color for the sticky header.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the sticky header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.30',
					),
					//Menu Color Settings
					array(
						'id'          => 'sticky_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'sticky_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'blade' ),
						'default'     => '#999999',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Light Header', 'blade' ),
				'id' => 'grve_redux_section_colors_light_header',
				'desc' => esc_html__( 'Notice that the Light Header is the transparent header with light fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'light_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a border color for the light header.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'light_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the light header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.30',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Dark Header', 'blade' ),
				'id' => 'grve_redux_section_colors_dark_header',
				'desc' => esc_html__( 'Notice that the Dark Header is the transparent header with dark fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'blade' ),
				'submenu' => false,
				'grve_colors' => true,
				'panel' => false,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'dark_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'blade' ),
						'default'     => '#ededed',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a border color for the dark header.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'dark_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the dark header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.10',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Header', 'blade' ),
				'id' => 'grve_redux_section_colors_responsive_header',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Header. These settings will affect when the responsive header appears, below 1024px.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_header_background_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Color Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the responsive header.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '1',
					),
					array(
						'id'          => 'responsive_header_elements_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'responsive_header_elements_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements hover.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Menu', 'blade' ),
				'id' => 'grve_redux_section_colors_responsive_menu',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Menu. These settings will also affect for the hidden menu.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the responsive menu.', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the responsive menu.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the responsive menu.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the responsive menu.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the responsive menu.', 'blade' ),
						'default'  => '#3e3e3e',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when responsive menu opens.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_menu_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when responsive menu opens.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Anchor Menu', 'blade' ),
				'id' => 'grve_redux_section_colors_anchor_menu',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Anchor Menu in case you use one in any of your pages, posts or portfolio items.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_anchor_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Background color for the Anchor Menu.', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'blade' ),
						'subtitle' => esc_html__( 'Font color for the Anchor Menu.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'blade' ),
						'subtitle' => esc_html__( 'Hover color for the Anchor Menu.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_background_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Hover background color for the Anchor Menu.', 'blade' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Border color for the Anchor Menu.', 'blade' ),
						'default'  => '#323232',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Main Content', 'blade' ),
				'id' => 'grve_redux_section_colors_main_content',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the main content area of your site.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'main_content_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a background color.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,

					),
					array(
						'id'       => 'body_heading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Text Color (h1-h6)', 'blade' ),
						'subtitle'    => esc_html__( 'Pick a color for headings text.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the links.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for hover text.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a border color.', 'blade' ),
						'default'  => '#e4e4e4',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 1 Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for primary 1.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 2 Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for primary 2.', 'blade' ),
						'default'  => '#044475',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 3 Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for primary 3.', 'blade' ),
						'default'  => '#487F84',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_4_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 4 Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for primary 4.', 'blade' ),
						'default'  => '#5F597E',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_5_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 5 Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for primary 5.', 'blade' ),
						'default'  => '#d6ccad',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Blog /Post', 'blade' ),
				'id' => 'grve_redux_section_colors_blog_post',
				'desc' => esc_html__( 'Set your color preferences for your Blog / Post.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Blog Title', 'blade' ),
				'id' => 'grve_redux_section_colors_blog_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the blog title area and the color of the blog title. These settings will only affect in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'blog_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your blog title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'blog_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'blog_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your blog title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your blog description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'blog_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Title', 'blade' ),
				'id' => 'grve_redux_section_colors_post_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single post title area and the color of the post title. Notice that you can disable it, override it or even use the feature section when you edit your single posts.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your post title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'post_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'post_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your post title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your post description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'post_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Bar', 'blade' ),
				'id' => 'grve_redux_section_colors_post_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single posts.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'post_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Background color for the post bar.', 'blade' ),
						'default'  => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'blade' ),
						'default'  => '#afafaf',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_subheading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Subheadings Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Subheadings.', 'blade' ),
						'default'  => '#c4c4c4',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Post Bar Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Border color for the Post Bar.', 'blade' ),
						'default'  => '#f2f2f2',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page', 'blade' ),
				'id' => 'grve_redux_section_colors_page',
				'desc' => esc_html__( 'Set your color preferences for your page.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Page Title', 'blade' ),
				'id' => 'grve_redux_section_colors_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the predefined page title area and the color of the page title. Notice that you can disable it, override it or even use the feature section when you edit your single pages.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Search Page', 'blade' ),
				'id' => 'grve_redux_section_colors_search_page',
				'desc' => esc_html__( 'Set your color preferences for your search page.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Search Page Title', 'blade' ),
				'id' => 'grve_redux_section_colors_search_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the search page title area and the color of the page title. Notice that these settings will be applied only if you have enabled Custom Header/Title Settings from Theme Options - Search Page Options.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'search_page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'search_page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'search_page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_description_color', 'equals', 'custom' ),
					),
				)
			);


			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Portfolio', 'blade' ),
				'id' => 'grve_redux_section_colors_portfolio',
				'desc' => esc_html__( 'Set your color preferences for your portfolio.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Title', 'blade' ),
				'id' => 'grve_redux_section_colors_portfolio_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single portfolio title area and the color of the portfolio title and description. Notice that you can disable it, override it or even use the feature section when you edit your single portfolio items.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your portfolio title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'portfolio_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'portfolio_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your portfolio title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your portfolio description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Bar', 'blade' ),
				'id' => 'grve_redux_section_colors_portfolio_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single portfolio.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'portfolio_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Background color for the portfolio bar.', 'blade' ),
						'default'  => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_socials_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Socials.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_socials_color_hover',
						'type'     => 'color',
						'title'    => esc_html__( 'Socials Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Hover color for the Socials.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'blade' ),
						'default'  => '#afafaf',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_nav_subheading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Subheadings Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Subheadings.', 'blade' ),
						'default'  => '#c4c4c4',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'blade' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Portfolio Bar Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Border color for the portfolio Bar.', 'blade' ),
						'default'  => '#f2f2f2',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Shop/Product', 'blade' ),
				'id' => 'grve_redux_section_colors_shop_product',
				'desc' => esc_html__( 'Set your color preferences for your Shop/Product.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Taxonomy Title', 'blade' ),
				'id' => 'grve_redux_section_colors_product_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the product taxonomies title area and the color of the product taxonomies title and description.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'product_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'product_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Title', 'blade' ),
				'id' => 'grve_redux_section_colors_product_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single product title area and the color of the product title and description. Notice that you can disable it, override it or even use the feature section when you edit your single product items.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'product_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'blade' ),
						'transparent' => false,
						'default'  => '#232323',
						'required' => array( 'product_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'blade' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'blade' ),
						'options' => $grve_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'blade' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Footer', 'blade' ),
				'id' => 'grve_redux_section_colors_footer',
				'desc' => esc_html__( 'Set your color preferences for your Footer.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Area', 'blade' ),
				'id' => 'grve_redux_section_colors_footer_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Area. Define the Footer Area in Theme Options > Footer Options.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Area Color Settings
					array(
						'id'          => 'footer_widgets_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Area.', 'blade' ),
						'default'     => '#232323',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'blade' ),
						'subtitle'    => esc_html__( 'Headings color for your Footer Area.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'blade' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Area.', 'blade' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'blade' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Area.', 'blade' ),
						'default'     => '#a0a0a0',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Area.', 'blade' ),
						'default'     => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'blade' ),
						'subtitle'    => esc_html__( 'Border color for your Footer Area.', 'blade' ),
						'default'     => '#3e3e3e',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Bar Area', 'blade' ),
				'id' => 'grve_redux_section_colors_footer_bar_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Bar Area(copyright area). Define the Footer Bar Area in Theme Options > Footer Options.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Bar Color Settings
					array(
						'id'          => 'footer_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'blade' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Bar Area.', 'blade' ),
						'default'     => '#1a1a1a',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_bg_color_opacity',
						'type'        => 'select',
						'title'       => esc_html__('Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for your Footer Bar Area.', 'blade' ),
						'options'     => $grve_opacity_selection,
						"default"     => '1',
					),
					array(
						'id'          => 'footer_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'blade' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Bar Area.', 'blade' ),
						'default'     => '#5f5f5f',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'blade' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Bar Area.', 'blade' ),
						'default'     => '#696969',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'blade' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Bar Area.', 'blade' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Breadcrumbs', 'blade' ),
				'id' => 'grve_redux_section_colors_breadcrumbs',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Breadcrumbs in case you use then in any of your pages, posts or portfolio items.', 'blade' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_breadcrumbs_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Background color for the Breadcrumbs.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'blade' ),
						'subtitle' => esc_html__( 'Font color for the Breadcrumbs.', 'blade' ),
						'default'  => '#6e6e6e',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'blade' ),
						'subtitle' => esc_html__( 'Hover color for the Breadcrumbs.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_divider_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Divider Color', 'blade' ),
						'subtitle' => esc_html__( 'Divider color for the Breadcrumbs.', 'blade' ),
						'default'  => '#b2b2b2',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Border color for the Breadcrumbs.', 'blade' ),
						'default'  => '#e0e0e0',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sliding Area', 'blade' ),
				'id' => 'grve_redux_section_colors_sliding_area',
				'desc' => esc_html__( 'Set your color preferences for the Sliding Area.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'sliding_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the sliding area.', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the sliding area.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the sliding area.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the sliding area.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the sliding area.', 'blade' ),
						'default'  => '#f1b144',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the sliding area.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the sliding area.', 'blade' ),
						'default'  => '#3e3e3e',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when sliding area opens.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'sliding_area_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when sliding area opens.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Modals', 'blade' ),
				'id' => 'grve_redux_section_colors_modals',
				'desc' => esc_html__( 'Set your color preferences for the Modals.', 'blade' ),
				'submenu' => false,
				'panel' => false,
				'grve_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'modal_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the modal.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the modal.', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the modal.', 'blade' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the modal.', 'blade' ),
						'default'  => '#3e3e3e',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when modal opens.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'modal_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'blade' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when modal opens.', 'blade' ),
						'options' => $grve_opacity_selection,
						"default" => '0.95',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Social Media', 'blade' ),
				'id' => 'grve_redux_section_social_media',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'social_options',
						'type' => 'sortable',
						'title' => esc_html__( 'Social URLs', 'blade' ),
						'subtitle' => esc_html__( 'Define and reorder your social URLs. Clear the input field for any social link you do not wish to display.', 'blade' ),
						'desc' => '',
						'label' => true,
						'options' => $grve_social_options,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-map-marker',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Map Options', 'blade' ),
				'id' => 'grve_redux_section_map_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'map_api_mode',
						'type' => 'button_set',
						'title' => esc_html__( 'Map API', 'blade' ),
						'subtitle'=> esc_html__( 'Select the map API', 'blade' ),
						'options' => array(
							'google-maps' => esc_html__( 'Google Maps', 'blade' ),
							'openstreetmap' => esc_html__( 'OpenStreetMap', 'blade' ),
						),
						'default' => 'google-maps',
					),
					array(
						'id'=>'map_tile_url',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer URL', 'blade' ),
						'subtitle' => esc_html__( 'Define the Tile Layer. Used to load and display tile layers on the map.', 'blade' ),
						'desc' => sprintf( '%1$s: <a href="//wiki.openstreetmap.org/wiki/Tile_servers" target="_blank"> %2$s </a>', esc_html__('See more tile servers', 'blade'), esc_html__('here', 'blade') ),
						"default" => 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_url_subdomains',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Subdomains', 'blade' ),
						'subtitle'=> esc_html__( 'Define the Tile Layer subdomains.', 'blade' ),
						"default" => "abc",
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_attribution',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Attribution', 'blade' ),
						'subtitle' => esc_html__( 'Enter the Tile Layer attribution', 'blade' ),
						"default" => '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Google API Key', 'blade' ),
						'subtitle' => $blade_gmap_api_key_link,
						'default'  => '',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id'=>'gmap_custom_enabled',
						'type' => 'button_set',
						'title' => esc_html__( 'Enable Custom Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to enable custom style for your map.', 'blade' ),
						'options' => array(
							'0' => esc_html__( 'No', 'blade' ),
							'1' => esc_html__( 'Custom', 'blade' ),
							'2' => esc_html__( 'Custom Code', 'blade' ),
						),
						'default' => '0',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_custom_code',
						'type' => 'textarea',
						'title' => esc_html__( 'Custom Code', 'blade' ),
						'subtitle' => esc_html__( 'Copy and paste the JSON here.', 'blade' ) . ' ' . $blade_gmap_style_link,
						'default' => '',
						'rows' => '30',
						'required' => array( 'gmap_custom_enabled', 'equals', '2' ),
					),
					array(
						'id'       => 'gmap_water_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Water color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for water', 'blade' ),
						'default'  => '#424242',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_landscape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Landscape color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for landscape', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_poi_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Point of interest color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for point of interest', 'blade' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_road_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Roads color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for roads', 'blade' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_label_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Label', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to enable labels for your map.', 'blade' ),
						'default' => 1,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for labels', 'blade' ),
						'default'  => '#777777',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_country_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Country Stroke color', 'blade' ),
						'subtitle' => esc_html__( 'Pick a color for country stroke.', 'blade' ),
						'default'  => '#000000',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_zoom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Zoom Control', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to enable zoom control for your map.', 'blade' ),
						'default' => 0,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-error',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( '404 Page', 'blade'),
				'id' => 'grve_redux_section_404',
				'subtitle' => esc_html__( 'You can find the settings for the 404 page here.', 'blade' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_404_header',
						'type' => 'switch',
						'title' => esc_html__( 'Show Header', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show header.', 'blade' ),
						'default' => 0,
					),
					array(
						'id' => '404_page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'blade' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'blade' ),
						'options' => $grve_header_style,
						'default' => 'default',
						'required' => array( 'page_404_header', 'equals', '1' ),
					),
					array(
						'id' => '404_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'no',
						'required' => array( 'page_404_header', 'equals', '1' ),
					),
					array(
						'id' => 'page_404_content',
						'type' => 'editor',
						'title' => esc_html__( 'Page 404 Content', 'blade' ),
						'subtitle' => esc_html__( 'Type the content of your 404 page, you can also use shortcodes.', 'blade' ),
						'default' => "<h3><em>404 ERROR</em></h3><h1>Hey there mate!</h1><h2>Your lost treasure is not found here...</h2><p class='grve-leader-text'>Sorry! The page you are looking for wasn't found!</p>",
					),
					array(
						'id' => 'page_404_search',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Search Box', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show a search box.', 'blade' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_home_button',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Back to home Button', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show a back to home button.', 'blade' ),
						'default' => 1,
					),
					array(
						'id' => 'page_404_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Show Footer', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show footer.', 'blade' ),
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Miscellaneous', 'blade' ),
				'id' => 'grve_redux_section_miscellaneous',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'feature_section_post_types',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__( 'Feature Section Post Types', 'blade' ),
						'subtitle' => esc_html__( 'Select the post types you wish to enable the Feature Section.', 'blade' ),
						'options' => $grve_feature_section_post_types_selection,
						'default' => array( 'page', 'portfolio' ),
					),
					array(
						'id'=>'wp_gallery_popup',
						'type' => 'switch',
						'title' => esc_html__( 'Lightbox for WordPress Gallery', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle lightbox for native WordPress Gallery on or off.', 'blade' ),
						"default" => '0',
						'on' => esc_html__('On', 'blade' ),
						'off' => esc_html__('Off', 'blade' ),
					),
					array(
						'id'=>'logo_as_text_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Logo as text', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle logo as text on or off. When on, all logo images will be replaced with site name.', 'blade' ),
						"default" => '0',
						'on' => esc_html__('On', 'blade' ),
						'off' => esc_html__('Off', 'blade' ),
					),
					array(
						'id'=>'logo_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Logo Custom Link URL', 'blade' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your logo. If empty homepage will be used instead.', 'blade' ),
						"default" => '',
					),
					array(
						'id' => 'retina_support',
						'type' => 'select',
						'title' => esc_html__( 'Retina Support', 'blade' ),
						'subtitle' => esc_html__( 'Select the retina suppport of your site.', 'blade' ),
						'options' => $grve_retina_support_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'menu_header_integration',
						'type' => 'select',
						'title' => esc_html__( 'Main Menu Integration', 'blade' ),
						'subtitle' => esc_html__( 'Select the main menu integration method. Selection available for custom menu integration.', 'blade' ),
						'options' => $grve_header_menu_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'sidebar_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Headings Tag', 'blade' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Sidebar Titles.', 'blade' ),
						'options' => $grve_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'footer_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Footer Sidebar Headings Tag', 'blade' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Footer Sidebar Titles.', 'blade' ),
						'options' => $grve_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'disable_seo_page_analysis',
						'type' => 'checkbox',
						'title' => esc_html__( 'Disable WordPress SEO Page Analysis', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to disable WordPress SEO page analysis.', 'blade' ),
						'default' => 0,
					),
					array(
						'id' => 'responsive_sidearea_button_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Sliding Area Button Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable/Disable the Sliding Area Button on devices.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'spinner_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Spinner Image', 'blade' ),
						'subtitle' => esc_html__( 'Upload a custom image if you want to replace the default graphic spinner.', 'blade' ),
					),
					array(
						'id' => 'responsive_scrolling_page_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Scrolling Page Visibility', 'blade' ),
						'subtitle' => esc_html__( 'Enable/Disable the scrolling page effect on devices.', 'blade' ),
						'options' => $grve_enable_selection,
						'default' => 'yes',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Builder Addons', 'blade' ),
				'desc' => esc_html__( 'Enable/Disable default Page Builder functionality.', 'blade' ),
				'id' => 'grve_redux_section_page_builder',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'vc_grid_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Grid Elements', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Grid elements on or off.', 'blade' ),
						"default" => '0',
						'on' => esc_html__('On', 'blade' ),
						'off' => esc_html__('Off', 'blade' ),
					),
					array(
						'id'=>'vc_charts_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Charts Elements', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Charts elements on or off.', 'blade' ),
						"default" => '0',
						'on' => esc_html__('On', 'blade' ),
						'off' => esc_html__('Off', 'blade' ),
					),
					array(
						'id'=>'vc_auto_updater',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Auto Updater', 'blade' ),
						'subtitle'=> esc_html__( 'Enable/Disable Page Builder Auto Updater ( Activation Required ).', 'blade' ),
						"default" => '0',
						'on' => esc_html__('On', 'blade' ),
						'off' => esc_html__('Off', 'blade' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Button Settings', 'blade' ),
				'desc' => esc_html__( 'Set the style for the buttons.', 'blade' ),
				'id' => 'grve_redux_section_buttons',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'button_type',
						'type' => 'select',
						'title' => esc_html__( 'Button Type', 'blade' ),
						'subtitle' => esc_html__( 'Select the type of your Buttons.', 'blade' ),
						'options' => $blade_grve_button_type_selection,
						'default' => 'simple',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Button Shape', 'blade' ),
						'subtitle' => esc_html__( 'Select the shape of your Buttons.', 'blade' ),
						'options' => $blade_grve_button_shape_selection,
						'default' => 'square',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'blade' ),
						'subtitle' => esc_html__( 'Select the color of your Buttons.', 'blade' ),
						'options' => $blade_grve_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'blade' ),
						'subtitle' => esc_html__( 'Select the hover color of your Buttons.', 'blade' ),
						'options' => $blade_grve_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Back To Top Settings', 'blade' ),
				'desc' => esc_html__( 'Set the style for the back to top button.', 'blade' ),
				'id' => 'grve_redux_section_back_to_top',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'back_to_top_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Back to Top', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Back to Top button.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'back_to_top_color',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Icon Color', 'blade' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top icon.', 'blade' ),
						'options' => $blade_grve_button_color_selection,
						'default' => 'grey',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'back_to_top_shape',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Shape', 'blade' ),
						'subtitle' => esc_html__( 'Select the shape of Back to Top button.', 'blade' ),
						'options' => array(
							'none' => esc_html__( 'No Shape', 'blade' ),
							'square' => esc_html__( 'Square', 'blade' ),
							'round' => esc_html__( 'Round', 'blade' ),
							'circle' => esc_html__( 'Circle', 'blade' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'back_to_top_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Shape Color', 'blade' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top shape.', 'blade' ),
						'options' => $blade_grve_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
						'required' => array(
							array( 'back_to_top_enabled', 'equals', '1' ),
							array( 'back_to_top_shape', '!=', 'none' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Meta Tags', 'blade' ),
				'desc' => esc_html__( 'Configure your site meta tags.', 'blade' ),
				'id' => 'grve_redux_section_meta_tags',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'meta_viewport_responsive',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Viewport Meta', 'blade' ),
						'subtitle'=> esc_html__( 'Enable or Disable Responsive Viewport.', 'blade' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'meta_opengraph',
						'type' => 'switch',
						'title' => esc_html__( 'Open Graph Meta', 'blade' ),
						'subtitle'=> esc_html__( 'Generate open graph meta tags for social sharing ( e.g: Facebook, Google+, LinkedIn etc )', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'meta_twitter',
						'type' => 'switch',
						'title' => esc_html__( 'Twitter Card Meta', 'blade' ),
						'subtitle'=> esc_html__( 'Generate meta tags for Twitter', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-wrench',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Coming Soon', 'blade' ),
				'id' => 'grve_redux_section_coming_soon',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'coming_soon_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Coming Soon', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle Coming Soon Redirect on or off.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id'=>'coming_soon_template',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Template', 'blade' ),
						'subtitle' => esc_html__( 'Select content only or use the defined page template.', 'blade' ),
						'options' => array(
							'content' => esc_html__( 'Content Only', 'blade' ),
							'template' => esc_html__( 'Use Page Template', 'blade' ),
						),
						'default' => 'content',
						'validate' => 'not_empty',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'coming_soon_page',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Page', 'blade' ),
						'subtitle' => esc_html__( 'Select the page for your redirection.', 'blade' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-resize-small',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Media Sizes', 'blade' ),
				'desc' => esc_html__( 'These settings affect the display and dimensions of images in the Theme. After changing these settings you may need to', 'blade' ) . " "  . $regenerate_link . ".",
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'size_large_landscape_wide',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Landscape Wide Large', 'blade'),
						'subtitle'=> esc_html__( 'Default 1170x658 - 16:9 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '1170',
							'height'  => '658'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_landscape_wide',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Landscape Wide', 'blade'),
						'subtitle'=> esc_html__( 'Default 800x450 - 16:9 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '800',
							'height'  => '450'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_landscape',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Landscape', 'blade'),
						'subtitle'=> esc_html__( 'Default 800x600 - 4:3 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '800',
							'height'  => '600'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Portrait', 'blade'),
						'subtitle'=> esc_html__( 'Default 600x800 - 3:4 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '600',
							'height'  => '800'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Square', 'blade'),
						'subtitle'=> esc_html__( 'Default 600x600 - 1:1 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '600',
							'height'  => '600'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Portrait Large', 'blade'),
						'subtitle'=> esc_html__( 'Default 560x1120 - 1:2 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '1120'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Square Large', 'blade'),
						'subtitle'=> esc_html__( 'Default 1120x1120 - 1:1 ratio (Cropped)', 'blade' ),
						'default'  => array(
							'width'   => '1120',
							'height'  => '1120'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_fullscreen',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => __('Fullscreen', 'blade'),
						'subtitle'=> esc_html__( 'Default 1920x1920 (Resize)', 'blade' ),
						'default'  => array(
							'width'   => '1920',
							'height'  => '1920'
						),
						'validate_callback' => 'blade_grve_redux_dimensions_validation',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-lock',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Privacy / Cookies', 'blade' ),
				'desc' => esc_html__( 'The following shortcodes will allow your users to change certain behavior of your website regarding privacy.', 'blade' ) . '<br>' .
					'<ul>' .
					'<li><strong>grve_privacy_required</strong> - ' . esc_html__( 'displays a required content for your site e.g: Cloudlflare, CDN etc.', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_gtracking</strong> - ' . esc_html__( 'allows a user to enable/disable Google Analytics tracking code in the user\'s browser', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_gfonts</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Fonts in the user\'s browser', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_gmaps</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Maps in the user\'s browser', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_video_embeds</strong> - ' . esc_html__( 'allows a user to enable/disable video embeds in the user\'s browser', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_policy_page_link</strong> - ' . esc_html__( 'displays a link to the privacy policy page set from the WordPress admin panel', 'blade' ) . '</li>' .
					'<li><strong>grve_privacy_preferences_link</strong> - ' . esc_html__( 'displays a link to the privacy preferences as defined in the Privacy Consent Info Bar', 'blade' ) . '</li>' .
					'</ul>' .
					esc_html__( 'You can use any of them in your privacy policy or in any text area that allows shortcodes.', 'blade' ) . '<br><br>' .
					'<strong>[grve_privacy_required value="required"]For performance and security reasons we use Cloudflare[/grve_privacy_required]</strong><br>' .
					'<strong>[grve_privacy_gtracking]</strong><br>' .
					'<strong>[grve_privacy_gfonts]</strong><br>' .
					'<strong>[grve_privacy_gmaps]</strong><br>' .
					'<strong>[grve_privacy_video_embeds]</strong><br>' .
					'<strong>[grve_privacy_policy_page_link]</strong><br>' .
					'<strong>[grve_privacy_preferences_link]</strong><br><br>' .
					esc_html__( 'Note: To change the default text add your text inside the shortcode tags [shortcode]Your text[/shortcode]', 'blade' ),
				'id' => 'grve_redux_section_privacy_cookies',
				'submenu' => true,
				'customizer' => false,
				'class' => 'grve-redux-desc-full',
				'fields' => array(
					array(
						'id'   => 'info_style_blocking_content',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Content Blocking Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Configure the privacy content blocking settings.', 'blade' ) . '<br>' . esc_html__( 'Note: The usage of the Blocking content feature is not recommended if you have added caching plugins or page rules to cache static HTML content (aggressive cache). If you use this feature you might need to disable such type of caching.', 'blade' ),
					),
					array(
						'id' => 'privacy_content_blocking_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Content Blocking', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to enable/disable privacy content blocking.', 'blade' ) .'<br><br>' . esc_html__( 'Note: if you disable content blocking certain privacy shortcodes will be automatically disabled.', 'blade' ),
						'default' => 1,
					),
					array(
						'id'      => 'privacy_initial_state',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Privacy Initial Blocking State', 'blade' ),
						'subtitle'    => esc_html__( 'Check if you want to block the content when the page loads.', 'blade' ),
						'options'  => array(
							'gtracking'     => 'Google Tracking',
							'gfonts' => 'Google Fonts',
							'gmaps' => 'Google Maps',
							'video-embeds'   => 'Embed Videos'
						),
						'default' => array(
							'gtracking'     => '0',
							'gfonts' => '0',
							'gmaps' => '0',
							'video-embeds'   => '0'
						),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_fallback_content',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Fallback Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Configure the privacy fallback info box.', 'blade' ),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_fallback_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Fallback Content', 'blade' ),
						'subtitle' => esc_html__( 'Type the fallback text when the content is blocked.', 'blade' ),
						'default' => 'This content is blocked. Please review your Privacy Preferences.',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_preferences_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display Privacy Preferences link', 'blade'),
						'subtitle' => esc_html__('Select if you want to display the Privacy Preferences link ( if defined in the privacy consent bar ).', 'blade'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_content_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display redirect link of the blocked content', 'blade'),
						'subtitle' => esc_html__('Select if you want to display a redirect link of the blocked content ( blocked content will open in a new tab e.g: YouTube website ).', 'blade'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_consent_bar',
						'type' => 'info',
						'class' => 'grve-redux-sub-info',
						'title' => esc_html__( 'Privacy Consent Info Bar Settings', 'blade' ),
						'subtitle'=> esc_html__( 'Configure the consent info bar.', 'blade' ),
					),
					array(
						'id' => 'privacy_consent_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Consent Info Bar', 'blade' ),
						'subtitle'=> esc_html__( 'Select if you want to show a privacy consent info bar.', 'blade' ),
						'default' => 0,
					),
					array(
						'id' => 'privacy_consent_bar_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Info Bar Content', 'blade' ),
						'subtitle' => esc_html__( 'Type the content of your consent info bar.', 'blade' ),
						'default' => 'Our website uses cookies, mainly from 3rd party services. Define your Privacy Preferences and/or agree to our use of cookies.',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_agreement_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Agreement Button Label', 'blade' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy agreement button. Leave empty to remove.', 'blade' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'I Agree',
					),
					array(
						'id'=>'privacy_preferences_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Button Label', 'blade' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy preferences button. Leave empty to remove.', 'blade' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'Privacy Preferences',
					),
					array(
						'id' => 'privacy_preferences_button_link',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Preferences Button Link Mode', 'blade' ),
						'subtitle' => esc_html__( 'Select the preferences button link mode: modal, privacy policy page or custom url.', 'blade' ),
						'options' => array(
							'modal' => esc_html__( 'Modal', 'blade' ),
							'privacy_page' => esc_html__( 'Privacy Policy Page', 'blade' ),
							'custom_url' => esc_html__( 'Custom URL', 'blade' ),
						),
						'default' => 'modal',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_preferences_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Custom Link URL', 'blade' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your privacy preferences button.', 'blade' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '',
					),
					array(
						'id'=>'privacy_preferences_link_target',
						'type' => 'select',
						'title' => esc_html__( 'Privacy Preferences Custom Link Target', 'blade' ),
						'subtitle'=> esc_html__( 'Define the target for your custom url, same or new page.', 'blade' ),
						'options' => array(
							'_self' => esc_html__( 'Same Page', 'blade' ),
							'_blank' => esc_html__( 'New page', 'blade' ),
						),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '_self',
					),
					array(
						'id' => 'privacy_consent_modal_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Privacy Modal Content', 'blade' ),
						'subtitle' => esc_html__( 'Type the content of your modal consent dialog.', 'blade' ),
						'default' => '<h5>Privacy Preferences</h5><p>When you visit our website, it may store information through your browser from specific services, usually in the form of cookies. Here you can change your Privacy preferences. It is worth noting that blocking some types of cookies may impact your experience on our website and the services we are able to offer.</p><div>[grve_privacy_gtracking][grve_privacy_gfonts][grve_privacy_gmaps][grve_privacy_video_embeds]</div>',
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
					),
					array(
						'id'=>'privacy_refresh_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Refresh Button Label', 'blade' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy refresh button. Leave empty to remove.', 'blade' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
						"default" => 'Save Preferences',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-repeat',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Theme Update', 'blade' ),
				'id' => 'grve_redux_section_theme_update',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'update_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Theme Update', 'blade' ),
						'subtitle'=> esc_html__( 'Toggle Theme update on or off.', 'blade' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'blade' ),
						'off' => esc_html__( 'Off', 'blade' ),
					),
					array(
						'id' => 'update_user_name',
						'type' => 'text',
						'title' => esc_html__( 'Themeforest username', 'blade' ),
						'subtitle' => esc_html__( 'Enter your Themeforest username here.', 'blade' ),
						'default' => '',
						'required' => array( 'update_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'update_api_key',
						'type' => 'text',
						'title' => esc_html__( 'Secret API Key', 'blade' ),
						'subtitle' => esc_html__( 'Enter your Envato API Key here. You will find it under Settings > API Keys in your Envato Account.', 'blade' ),
						'default' => '',
						'required' => array( 'update_enabled', 'equals', '1' ),
					),
				)
			);

			//Show Sections available only in customizer
			if ( ( defined( 'BLADE_GRVE_THEME_REDUX_CUSTOM_PANEL' ) &&  true === BLADE_GRVE_THEME_REDUX_CUSTOM_PANEL ) || $this->blade_grve_redux_customizer_visibility() ) {
				foreach ( $this->sections as $k => $section ) {
					if ( isset( $section['grve_colors'] ) && isset( $section['panel'] ) ) {
						unset($this->sections[$k]['panel']);
					}
				}
			}

		}


		public function setArguments() {

			$theme = wp_get_theme();
			$theme_version = $theme->get('Version');
			if( is_child_theme() ) {
				$parent_theme = wp_get_theme( get_template() );
				$theme_version .= ' ( ' . $parent_theme->get('Name') .': ' . $parent_theme->get('Version') . ' )';
			}

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'grve_blade_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => ' ', // Name that appears at the top of your panel
				'display_version' => $theme_version, // Version that appears at the top of your panel
				'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => false, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__( 'Theme Options', 'blade' ),
				'page' => esc_html__( 'Theme Options', 'blade' ),
				'google_api_key' => 'AIzaSyBBgve_JGMTPX8CWMxeoG1KrfmUF6WN4NE', // Must be defined to add google fonts to the typography module
				'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => 'blade_grve_options', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => true, // Enable basic customizer support
				'ajax_save' => true,
				'ajax_max_input' => true,
				'templates_path' => get_template_directory() . '/includes/admin/templates/panel/', //Redux Template files

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() .'/includes/images/adminmenu/theme.png', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'blade_grve_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'use_cdn' => false,
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true,
				'disable_tracking' => true,
				'help_tabs' => array(),
				'help_sidebar' => '',
			);

			// Panel Intro text -> before the form
			$this->args['intro_text'] ='';

			// Add content after the form.
			$this->args['footer_text'] = '';
			$this->args['footer_credit'] = ' ';

		}

	}

	global $blade_grve_redux_framework;
	$blade_grve_redux_framework = new Blade_GRVE_Redux_Framework_config();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
