<?php
/*
 * Theme Options
 * @package bizex
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {


    //
    // Set a unique slug-like ID
    $prefix = 'bizex';

    //
    // Create options
    CSF::createOptions( $prefix . '_theme_options', array(
        'menu_title'         => 'Bizex Option',
        'menu_slug'          => 'bizex-theme-option',
        'menu_type'          => 'menu',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'menu_position' => 50,
        'theme'                   => 'dark',
        'framework_title'    => wp_kses_post( 'Bizex Options <small>by Raziul <br/> Version: 1.0</small> ' ),
        'footer_text'    => wp_kses_post( 'The Theme will Created By Themexriver ' ),
    ) );

    // Create a top-tab
    CSF::createSection( $prefix . '_theme_options', array(
        'id'    => 'header_opts', // Set a unique slug-like ID
        'title' => 'Header',
    ) );


    /*-------------------------------------------------------
     ** Logo Settings  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Logo Settings', 'bizex-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Site Logo', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'      => 'theme_logo',
                'title'   => esc_html__( 'Main Logo', 'bizex-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Your Main Logo Here', 'bizex-tools' ),
            ),

            array(
                'id'      => 'theme_v2_logo',
                'title'   => esc_html__( 'Main Logo V2', 'bizex-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Your Main Logo Here', 'bizex-tools' ),
            ),
            
        ),
    ) );

    /*-------------------------------------------------------
     ** Header  Options
    --------------------------------------------------------*/

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Header', 'bizex-tools' ),
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header Layout', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'          => 'header_glob_style',
                'type'        => 'select',
                'title'       => 'Choose Header',
                'chosen'      => true,
                'placeholder' => 'Header Global Style',
                'options'     => array(
                  'header-style-one'    => 'Header Style 1',
                  'header-style-two'    => 'Header Style 2',
                  'header-style-three'  => 'Header Style 3',
                  'header-style-four'  => 'Header Style 4',
                ),
                'default'     => 'header-style-two'
            ),
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Header Option', 'bizex-tools' ) . '</h3>',
            ),
            
            array(
                'id'    => 'call_title',
                'type'  => 'text',
                'title' => esc_html__( 'Call Title', 'bizex-tools' ),
            ),

            array(
                'id'    => 'phone_no',
                'type'  => 'text',
                'title' => esc_html__( 'Phone', 'bizex-tools' ),
            ),
            
            array(
                'id'    => 'h_button',
                'type'  => 'link',
                'title' => esc_html__( 'Header Button', 'bizex-tools' ),
            ),
            array(
                'id'    => 'h_button_t',
                'type'  => 'link',
                'title' => esc_html__( 'Header Button Two', 'bizex-tools' ),
            ),
        ),
    ) );

    // Preloader section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Site Preloader',
        'parent'     => 'header_opts',
        'icon'   => 'fa fa-refresh',
        'fields' => array(

            array(
                'id'      => 'preloader_enable',
                'title'   => esc_html__( 'Enable Preloader', 'bizex-tools' ),
                'type'    => 'switcher',
                'desc'    => esc_html__( 'Enable or Disable Preloader', 'bizex-tools' ),
                'default' => true,
            ),
            

        ),
    ) );

    // Sidebar Option
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'OffCanvas Menu',
        'icon'   => 'fa fa-bars',
        'fields' => array(
            array(
                'id'      => 'is_enable_offcanvas_nav',
                'type'    => 'switcher',
                'title'   => 'Switcher',
                'label'    => esc_html__( 'Do you want Offcanvas Nav? ', 'bizex-tools' ),
                'default' => true
            ),

            array(
                'id'      => 'off_logo',
                'title'   => esc_html__( 'Logo', 'bizex-tools' ),
                'type'    => 'media',
                'desc'    => esc_html__( 'Upload Offcanvas Logo Here', 'bizex-tools' ),
                'default' => true,
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),
            array(
                'id'      => 'aboout_title',
                'title'   => esc_html__( 'About TItle', 'bizex-tools' ),
                'type'    => 'text',
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),
            array(
                'id'      => 'aboout_info',
                'title'   => esc_html__( 'About Info', 'bizex-tools' ),
                'type'    => 'textarea',
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),

            array(
                'id'      => 'galle_title',
                'title'   => esc_html__( 'Gallery Title', 'bizex-tools' ),
                'type'    => 'text',
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),

            array(
                'id'    => 'galle-gallery-1',
                'type'  => 'gallery',
                'title' => 'Gallery',
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),
            array(
                'id'      => 'social_title_title',
                'title'   => esc_html__( 'Social TItle', 'bizex-tools' ),
                'type'    => 'text',
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],
            ),
            array(
                'id'         => 'offc_social_icons',
                'type'       => 'group',
                'title'      => 'Add Social Icon',
                'fields'     => array(
                    array(
                        'id'    => 'icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Social Icon', 'bizex-tools' ),
                    ),
                    array(
                        'id'    => 'link',
                        'type'  => 'text',
                        'title' => esc_html__( 'Social Profile Link', 'bizex-tools' ),
                    ),
                ),
                'dependency'  => [
                    'is_enable_offcanvas_nav', '==', 'true',
                ],

            ),

        ),
    ) );
    

    /*-------------------------------------
     ** Typography Options
    -------------------------------------*/
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Typography', 'bizex-tools' ),
        'id'     => 'typography_options',
        'icon'   => 'fa fa-font',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Body', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'body-typography',
                'type'   => 'typography',
                'output' => 'body',

            ),

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Heading', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'     => 'heading-gl-typo',
                'type'   => 'typography',
                'output' => 'h1, h2, h3, h4, h5, h6',
            ),

        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Blog', 'bizex-tools' ),
        'id'     => 'blog_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Blog Options', 'bizex-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Blog Breadcrumb Title', 'bizex-tools'),
                'desc'    => esc_html__('If you Do not Blog Breadcrumb Custom Title then type Title Here', 'bizex-tools'),
            ),
            array(
                'id'      => 'br_shape',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Shape', 'bizex-tools'),
            ),
            array(
                'id'      => 'br_shape_tw',
                'type'    => 'media',
                'title'   => esc_html__('Breadcrumb Two Shape', 'bizex-tools'),
            ),

            
            array(
                'id'      => 'blog_btn_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Read More Button', 'bizex-tools' ),
                'default' => esc_html__( 'Explore More', 'bizex-tools' ),
                'desc'    => esc_html__( 'Type Blog Read More Button Text Here', 'bizex-tools' ),
            ),
        ),
    ) );

    // blog optoins
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Shop', 'bizex-tools' ),
        'id'     => 'shop_page',
        'icon'   => 'fa fa-rss-square',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Shop Options', 'bizex-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'brs_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Shop Breadcrumb Title', 'bizex-tools'),
            ),
            array(
                'id'      => 'brss_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Single Product Breadcrumb Title', 'bizex-tools'),
            ),
            array(
                'id'      => 'product_count',
                'type'    => 'text',
                'title'   => esc_html__('How Many Product You Want to Show?', 'bizex-tools'),
            ),
            
        ),
    ) );
    
    
   // bizex Color Setting
   CSF::createSection( $prefix . '_theme_options', array(
    'title'  => 'Color Control',
    'id'     => 'apix_color_control',
    'icon'   => 'fa fa-paint-brush',
    'fields' => array(
        

        array(  //nav bar one start
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Bizex Color', 'bizex-tools' ) . '</h3>',
        ),
        array(
            'id'        => 'theme-color-set',
            'type'      => 'color_group',
            'title'     => 'Theme Primary Gradiend Color',
            'options'   => array(
              '1' => 'Color 1',
              '2' => 'Color 2',
            ),
            'default'   => array(
                '1' => '#5956f0',
                '2' => '#ff50b8',
            )
        ),

        array(
            'id'      => 'bizex-color-two',
            'type'    => 'color',
            'title'   => 'Primery Color Two',
            'desc'    => 'This color Display Mianly Home 3 & 4',
            'default' => '#5956f0'
        ),
        array(
            'id'      => 'bizex-color-three',
            'type'    => 'color',
            'title'   => 'Primery Color Three',
            'desc'    => 'This color Display Mianly Home 2',
            'default' => '#ff6600'
        ),
        
    ),
) );

    // Create a section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'bizex Social Icon',
        'id'     => 'bizex_social_icons',
        'icon'   => 'fa fa-share-square-o',
        'fields' => array(
            

            array(  //nav bar one start
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Social Icon Options', 'bizex-tools' ) . '</h3>',
            ),
            
            array(
                'id'        => 'bizex-social-global',
                'type'      => 'repeater',
                'title'     => 'bizex Global Social',
                'subtitle'      => 'Add Social Icon And Icon Link Here',
                'fields'    => array(     
                        
                  array(
                    'id'    => 'social_icon',
                    'type'  => 'icon',
                    'title' => 'Choose Social Icon Here',
                  ),
                  array(
                    'id'    => 'social_title',
                    'type'  => 'text',
                    'title' => 'Social Title Here',
                  ),
                  array(
                    'id'    => 'social_follow_title',
                    'type'  => 'text',
                    'title' => 'Social Flow Title Here',
                  ),
                  array(
                    'id'    => 'social_link',
                    'type'  => 'text',
                    'title' => 'Social Profile Link Here',
                  ),
              
                ),
                'default'   => array(
                  array(
                    'social_icon' => 'fab fa-facebook-f',
                    'social_link' => '#',
                  ),
                  array(
                    'social_icon' => 'fab fa-twitter',
                    'social_link' => '#',
                  ),
                  array(
                    'social_icon' => 'fab fa-instagram',
                    'social_link' => '#',
                  ),
                  array(
                    'social_icon' => 'fab fa-youtube',
                    'social_link' => '#',
                  ),
                  array(
                    'social_icon' => 'fab fa-pinterest',
                    'social_link' => '#',
                  ),
                ),
            ),

        ),
    ) );


    // Create a section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => 'Error Page',
        'id'     => 'error_page',
        'icon'   => 'fa fa-exclamation-triangle',
        'fields' => array(
            

            array(  //nav bar one start
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( '404 Page Options', 'bizex-tools' ) . '</h3>',
            ),
            
            array(
                'id'      => 'error_code',
                'type'    => 'text',
                'title'   => esc_html__( 'Error Code', 'bizex-tools' ),
                'default' => esc_html__( '404', 'bizex-tools' ),
            ),
            array(
                'id'      => 'error_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Title', 'bizex-tools' ),
                'default' => esc_html__( 'Oops... It looks like you ‘re lost !', 'bizex-tools' ),
            ),
            array(
                'id'      => 'error_info_title',
                'type'    => 'textarea',
                'title'   => esc_html__( '404 Text', 'bizex-tools' ),
                'default' => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'bizex-tools' ),
            ),
            array(
                'id'      => 'error_button',
                'type'    => 'text',
                'title'   => esc_html__( '404 Button', 'bizex-tools' ),
                'default' => esc_html__( 'Go Back Home', 'bizex-tools' ),
            ),
            array(
                'id'      => 'er_custom_title',
                'type'    => 'text',
                'title'   => esc_html__( '404 Breadcrumb Title', 'bizex-tools' ),
            ),

                     
        ),
    ) );

    /*-------------------------------------------------------
     ** Footer  Options
    --------------------------------------------------------*/
    // Create a top-tab
    CSF::createSection( $prefix . '_theme_options', array(
        'id'    => 'footer_opts', // Set a unique slug-like ID
        'title' => 'Footer',
    ) );
    
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Global Options', 'bizex-tools' ),
        'parent'     => 'footer_opts',
        'icon'   => 'fa fa-copyright',
        'fields' => array(

            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Style Options', 'bizex-tools' ) . '</h3>',
            ),
            array(
                'id'          => 'footer_glob_style',
                'type'        => 'select',
                'title'       => 'Choose Footer',
                'chosen'      => true,
                'placeholder' => 'Footer Global Style',
                'options'     => array(
                  'footer-style-one'    => 'Footer Style 1',
                  'footer-style-two'    => 'Footer Style 2',
                  'footer-style-three'  => 'Footer Style 3',
                  'footer-style-four'   => 'Footer Style 4',
                ),
                'default'     => 'footer-style-one'
            ),            
            
            array(
                'id'    => 'bizex_copywrite_text',
                'title' => esc_html__( 'Copyright Area Text', 'bizex-tools' ),
                'type'  => 'wp_editor',
                'desc'  => esc_html__( 'Footer Copyright Text', 'bizex-tools' ),
            ),

            array(
                'id'     => 'footer_social',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Footer Social Profile Option', 'bizex-tools'),
                'fields' => array(
                    array(
                        'id'      => 'icon',
                        'title'   => esc_html__( 'icon', 'bizex-tools' ),
                        'type'    => 'icon',
                        'desc'    => esc_html__( 'Select Icon', 'bizex-tools' ),
                    ),
                    
                    array(
                        'id'    => 'link',
                        'type'  => 'text',
                        'title' => esc_html__('Social Link', 'bizex-tools'),
                    ),
                
                ),
            ),
        ),
    ) );

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer One', 'bizex-tools' ),
        'parent'     => 'footer_opts',
        'icon'   => 'fa fa-copyright',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Top Option', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'    => 'f_title',
                'type'  => 'text',
                'title' => esc_html__('Footer Title', 'bizex-tools'),
            ),

            array(
                'id'    => 'f_text',
                'type'  => 'textarea',
                'title' => esc_html__('Footer Description', 'bizex-tools'),
            ),

            array(
                'id'    => 'f_btn',
                'title' => esc_html__( 'Footer Button', 'bizex-tools' ),
                'type'  => 'link',
            ),


            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Contact Option', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'    => 'contact_title',
                'type'  => 'text',
                'title' => esc_html__('Contact Title', 'bizex-tools'),
            ),

            array(
                'id'    => 'cf_f_info',
                'type'  => 'textarea',
                'title' => esc_html__('Contact Info', 'bizex-tools'),
            ),
            

            array(
                'id'    => 'chat_icon',
                'type'  => 'media',
                'title' => esc_html__('Chat Icon', 'bizex-tools'),
            ),
            array(
                'id'    => 'chat_text',
                'type'  => 'text',
                'title' => esc_html__('Chat Text', 'bizex-tools'),
            ),

            array(
                'id'     => 'footer_links',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Footer Link', 'bizex-tools'),
                'fields' => array(
                    
                    array(
                        'id'    => 'link',
                        'type'  => 'link',
                        'title' => esc_html__('Footer Link Item', 'bizex-tools'),
                    ),
                
                ),
            ),

        ),
    ) );

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Two', 'bizex-tools' ),
        'parent'     => 'footer_opts',
        'icon'   => 'fa fa-copyright',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Option', 'bizex-tools' ) . '</h3>',
            ),

            array(
                'id'    => 'ft_shape',
                'type'  => 'media',
                'title' => esc_html__('Shape', 'bizex-tools'),
            ),
            array(
                'id'    => 'title',
                'type'  => 'textarea',
                'title' => esc_html__('Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'newsletter',
                'type'  => 'textarea',
                'title' => esc_html__('Newsletter', 'bizex-tools'),
            ),
            array(
                'id'    => 'f_p_title',
                'type'  => 'text',
                'title' => esc_html__('Phone Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'f_p_no',
                'type'  => 'text',
                'title' => esc_html__('Phone Number', 'bizex-tools'),
            ),

           


        ),
    ) );

    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Three', 'bizex-tools' ),
        'parent'     => 'footer_opts',
        'icon'   => 'fa fa-copyright',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Option', 'bizex-tools' ) . '</h3>',
            ),
            array(
                'id'    => 'f3_about_title',
                'type'  => 'text',
                'title' => esc_html__('About Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'f3_about_desc',
                'type'  => 'textarea',
                'title' => esc_html__('About Info', 'bizex-tools'),
            ),
            array(
                'id'    => 'f3_contact_title',
                'type'  => 'text',
                'title' => esc_html__('Contact Title', 'bizex-tools'),
            ),
            array(
                'id'     => 'f3_footer_ct',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Contact Info', 'bizex-tools'),
                'fields' => array(
                    
                    array(
                        'id'    => 'info_icon',
                        'type'  => 'icon',
                        'title' => esc_html__('Footer Info Icon', 'bizex-tools'),
                    ),
                    array(
                        'id'    => 'info_text',
                        'type'  => 'text',
                        'title' => esc_html__('Footer Info Text', 'bizex-tools'),
                    ),
                
                ),
            ),


        ),
    ) );
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Footer Four', 'bizex-tools' ),
        'parent'     => 'footer_opts',
        'icon'   => 'fa fa-copyright',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => '<h3>' . esc_html__( 'Footer Option', 'bizex-tools' ) . '</h3>',
            ),
            array(
                'id'    => 'footer_bg_4',
                'type'  => 'media',
                'title' => esc_html__('Footer Background', 'bizex-tools'),
            ),
            
            
            array(
                'id'     => 'f4_footer_ct',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Contact Info', 'bizex-tools'),
                'fields' => array(
                    
                    array(
                        'id'    => 'info_icon',
                        'type'  => 'icon',
                        'title' => esc_html__('Footer Info Icon', 'bizex-tools'),
                    ),
                    array(
                        'id'    => 'info_text',
                        'type'  => 'text',
                        'title' => esc_html__('Footer Info Text', 'bizex-tools'),
                    ),
                
                ),
            ),

            array(
                'id'    => 'opening_title_4',
                'type'  => 'text',
                'title' => esc_html__('Opening Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'opening_text_4',
                'type'  => 'textarea',
                'title' => esc_html__('Opening Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'newsletter_title_4',
                'type'  => 'text',
                'title' => esc_html__('Newsletter Title', 'bizex-tools'),
            ),
            array(
                'id'    => 'newsletter_info_4',
                'type'  => 'textarea',
                'title' => esc_html__('Newsletter Info', 'bizex-tools'),
            ),
            array(
                'id'    => 'newsletter_shortcode',
                'type'  => 'textarea',
                'title' => esc_html__('Newsletter Shortcode', 'bizex-tools'),
            ),

            array(
                'id'     => 'footer_social_icon_4',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Footer Social Icon', 'bizex-tools'),
                'fields' => array(
                    
                    array(
                        'id'    => 'icon',
                        'type'  => 'icon',
                        'title' => esc_html__('Icon', 'bizex-tools'),
                    ),
                    array(
                        'id'    => 'link',
                        'type'  => 'text',
                        'title' => esc_html__('Link', 'bizex-tools'),
                    ),
                
                ),
            ),
            array(
                'id'     => 'footer_app_store',
                'type'   => 'repeater',
                'title'  => esc_html__('Add Footer App Store', 'bizex-tools'),
                'fields' => array(
                    
                    array(
                        'id'    => 'app_img',
                        'type'  => 'media',
                        'title' => esc_html__('App Image', 'bizex-tools'),
                    ),
                    array(
                        'id'    => 'app_link',
                        'type'  => 'text',
                        'title' => esc_html__('Link', 'bizex-tools'),
                    ),
                    
                
                ),
            ),
            array(
                'id'    => 'footer_menu_title',
                'type'  => 'text',
                'title' => esc_html__('Footer Link Title', 'bizex-tools'),
            ),
        ),
    ) );
    

    // Backup section
    CSF::createSection( $prefix . '_theme_options', array(
        'title'  => esc_html__( 'Backup Export', 'bizex-tools' ),
        'id'     => 'backup_options',
        'icon'   => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        ),
    ) );




}