<?php
/*
 * Theme Metabox
 * @package bizex-tools
 * @since 1.0.0
 * */

if ( !defined( 'ABSPATH' ) ) {
    exit(); // exit if access directly
}

if ( class_exists( 'CSF' ) ) {

    $prefix = 'bizex';

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'bizex_page_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Page Options',
        'post_type' => array('plan', 'page', 'post'),
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Header',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Header Option', 'bizex-tools' ),
            ),

            array(
                'id'      => 'onepage-nav',
                'type'    => 'checkbox',
                'title'   => 'Enable One Page Menu?',
                'label'   => 'Enable One Page Menu? Then Yes, Please do it.',
                'default' => false // or false
            ),

            array(
                'id'      => 'page_logo',
                'title'   => esc_html__( 'Page Header Logo', 'bizex-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Logo Here', 'bizex-tools' ),
            ),
            array(
                'id'      => 'page_logo_v2',
                'title'   => esc_html__( 'Page Header Logo V2', 'bizex-tools' ),
                'type'    => 'media',
                'library' => 'image',
                'desc'    => esc_html__( 'Upload Logo Here', 'bizex-tools' ),
            ),

            array(
                'id'      => 'header_layouts',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Header Navigation Style', 'bizex-tools' ),
                'options'     => array(
                    ''    => 'Select Header Style',
                    'header-style-one'    => 'Header Style 1',
                    'header-style-two'    => 'Header Style 2',
                    'header-style-three'  => 'Header Style 3',
                    'header-style-four'  => 'Header Style 4',
                ),
                'default' => '',
            ),
            
            array(
                'id'      => 'ap_custom_menu',
                'type'    => 'checkbox',
                'title'   => 'Onepage Menu',
                'label'   => 'If You Want to Display Onepage Menu Then click to check the box',
                'default' => false // or false
            ),

        ),
    ) );

    // Breadcrumb Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Breadcrumb',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Breadcrumb Option', 'bizex-tools' ),
            ),
            
            array(
                'id'      => 'pg_shape_1',
                'type'    => 'media',
                'title'   => esc_html__('Page Shape 1', 'bizex-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            array(
                'id'      => 'pg_shape_2',
                'type'    => 'media',
                'title'   => esc_html__('Page Shape 2', 'bizex-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            
            array(
                'id'      => 'br_custom_title',
                'type'    => 'text',
                'title'   => esc_html__('Custom Title', 'bizex-tools'),
                'desc'    => esc_html__('If you Do not Show Page Title thene type Custom Title Here', 'bizex-tools'),
                'dependency' => array( 'is_active_breadcrumb', '==', 'true' ) 
            ),
            
        )
    ) );
    

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'Footer',
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Option', 'bizex-tools' ),
            ),

            array(
                'id'      => 'footers_layout',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Footer Style', 'bizex-tools' ),
                'options'     => array(
                    'disable'             => 'Select Footer',
                    'footer-style-one'    => 'Footer Style 1',
                    'footer-style-two'    => 'Footer Style 2',
                    'footer-style-three'  => 'Footer Style 3',
                    'footer-style-four'   => 'Footer Style 4',
                ),
                'default' => '',
            ),
            

        ),
    ) );

     /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'bizex_pricing_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Pricing Options',
        'post_type' => 'bizex_pricing',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'bizex Pricing Table ',
        'fields' => array(
            array(
                'id'      => 'populer_item',
                'type'    => 'checkbox',
                'title'   => 'Select Populer Item',
                'label'   => 'If you want to Populer Item then please check the box',
                'default' => false // or false
            ),
            array(
                'id'    => 'offer_text',
                'type'  => 'text',
                'title' => esc_html__( 'Offer Text', 'bizex-tools' ),
            ),
            array(
                'id'    => 'currency',
                'type'  => 'text',
                'title' => esc_html__( 'Currency', 'bizex-tools' ),
                'default' => '$',
            ),
            array(
                'id'    => 'monthly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Price ', 'bizex-tools' ),
            ),
            array(
                'id'    => 'yearly_price',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Price ', 'bizex-tools' ),
            ),
            array(
                'id'    => 'mon_period',
                'type'  => 'text',
                'title' => esc_html__( 'Monthly Period ', 'bizex-tools' ),
                'default' => esc_html__( '/ Monthly', 'bizex-tools' ),
            ),
            array(
                'id'    => 'yr_period',
                'type'  => 'text',
                'title' => esc_html__( 'Yearly Period ', 'bizex-tools' ),
                'default' => esc_html__( '/ Yearly', 'bizex-tools' ),
            ),
            array(
                'id'         => 'pricing_lists',
                'type'       => 'group',
                'title'      => 'Add Pricing List Item',
                'fields'     => array(
                    
                    array(
                        'id'    => 'list-item',
                        'type'  => 'text',
                        'title' => esc_html__( 'Pricing List Item', 'bizex-tools' ),
                    ),
                    array(
                        'id'      => 'exclude-in-package',
                        'title'   => esc_html__( 'Exclude In This Package', 'bizex-tools' ),
                        'type'    => 'switcher',
                        'default' => false,
                    ),
                )

            ),
            array(
                'id'    => 'pricing_btn',
                'type'  => 'link',
                'title' => esc_html__( 'Pricing Button', 'bizex-tools' ),
            ),
            array(
                'id'    => 'pricing_txt',
                'type'  => 'text',
                'title' => esc_html__( 'Pricing Text', 'bizex-tools' ),
            ),

        ),
    ) );

    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_metabox = 'bizex_service_meta';

    CSF::createMetabox( $post_metabox, array(
        'title'     => 'Service Options',
        'post_type' => 'service',
    ) );

    // Header Section
    CSF::createSection( $post_metabox, array(
        'title'  => 'bizex Service ',
        'fields' => array(
            
            array(
                'id'    => 'service_img_icon',
                'type'  => 'media',
                'title' => esc_html__( 'Service Icon Image', 'bizex-tools' ),
            ),
            array(
                'id'          => 'service-style',
                'type'        => 'select',
                'title'       => 'Select',
                'options'     => array(
                  'style-one'  => 'Style One',
                  'style-two'  => 'Style Two',
                ),
              ),
              array(
                'id'    => 'sub_cate_name',
                'type'  => 'TEXT',
                'title' => esc_html__( 'Sub Title Name', 'bizex-tools' ),
            ),
        ),
    ) );


    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $cate_metabox = 'bizex_cate_meta';

    CSF::createTaxonomyOptions( $cate_metabox, array(
        'taxonomy'  => 'category',
        'data_type' => 'serialize',
    ) );

     // Header Section
     CSF::createSection( $cate_metabox, array(
        'title'  => 'Category Icon',
        'fields' => array(
            array(
                'id'      => 'icon_name',
                'type'    => 'text',
                'title'   => 'Type Icon Name',
            ),
        ),
    ) );


    /*-------------------------------------
    Page Options
    -------------------------------------*/
    $post_format_metabox = 'bizex_post_format_meta';

    CSF::createMetabox( $post_format_metabox, array(
        'title'     => 'Post Video',
        'post_type' => 'post',
		'post_formats' => 'video',
		'data_type'          => 'serialize',
		'context'            => 'advanced',
		'priority'           => 'default',
    ) );

     // Header Section
     CSF::createSection( $post_format_metabox, array(
        'title'  => 'Category Icon',
        'fields' => array(
            array(
                'id'      => 'video_link',
                'type'    => 'text',
                'title'   => esc_html__('Video Link', 'bizex-tools'),
                'desc'    => esc_html__('Enter Video Link Here', 'bizex-tools'),
            ),
        ),
    ) );


    
    

} //endif
