<?php

function ae_drop_posts($post_type){
  $args = array(
    'numberposts' => -1,
    'post_type'   => $post_type
  );

  $posts = get_posts( $args );        
  $list = array();
  foreach ($posts as $cpost){
  //  print_r($cform);
      $list[$cpost->ID] = $cpost->post_title;
  }
  return $list;
}

function get_wp_image($source){
  if (isset($source)){
      $image =  wp_get_attachment_image( $source['id'], 'full' );
  }
  return $image;

}

function king_menu_select_choices() {
  $menus = wp_get_nav_menus();
  $items = array();
  $i     = 0;
  foreach ( $menus as $menu ) {
      if ( $i == 0 ) {
          $default = $menu->slug;
          $i ++;
      }
      $items[ $menu->slug ] = $menu->name;
  }

  return $items;
}

function ae_drop_cat($tax) {

  $categories_obj = get_categories('taxonomy='.$tax.'');
  $categories = array();

  foreach ($categories_obj as $pn_cat) {
      $categories[$pn_cat->cat_ID] = $pn_cat->cat_name;
  }
  return $categories;         
}

function client_ratings($count){
  $out = '';
  for ($i=0; $i<$count; $i++) {
      $out.= '<li><i class="fas fa-star"></i></li>';
  }
  return $out;
}

function get_that_link($link){

  $url = $link['url'] ? 'href='.esc_url($link['url']). '' : '';
  $ext = $link['is_external'] ? 'target= _blank' : '';
  $nofollow = $link['nofollow'] ? 'rel="nofollow"' : '';
  $link = $url.' '.$ext.' '.$nofollow;
  return $link;
}

function get_that_image($source){
  if ($source){
      $image = '<img src="'. esc_url( $source['url'] ).'" alt="'.get_bloginfo( 'name' ).'">';
  }
  return $image;
}

/**
 * All Category List
 */
function bizex_blog_category (){
  $terms = get_terms( array(
      'taxonomy'    => 'category',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->slug]  = [$post->name];
  }
  return $cat_list;
}

/**
 * All Category List
 */
function bizex_service_category (){
  $terms = get_terms( array(
      'taxonomy'    => 'services_cate',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->slug]  = [$post->name];
  }
  return $cat_list;
}

function bizex_post_category (){
  $terms = get_terms( array(
      'taxonomy'    => 'projects_cate',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->slug]  = [$post->name];
  }
  return $cat_list;
}

function bizex_project_slug (){
  $terms = get_terms( array(
      'taxonomy'    => 'projects_cate',
      'hide_empty'  => true
  ) );

  $cat_list = [];
  foreach($terms as $post) {
  $cat_list[$post->term_id]  = [$post->name];
  }
  return $cat_list;
}

/**
 * Tag List
 */
if ( ! function_exists( 'bizex_item_tag_lists' ) ) {
  function bizex_item_tag_lists(  $type = '', $query_args = array() ) {

    $options = array();

    switch( $type ) {

      case 'pages':
      case 'page':
      $pages = get_pages( $query_args );

      if ( !empty($pages) ) {
        foreach ( $pages as $page ) {
          $options[$page->post_title] = $page->ID;
        }
      }
      break;

      case 'posts':
      case 'post':
      $posts = get_posts( $query_args );

      if ( !empty($posts) ) {
        foreach ( $posts as $post ) {
          $options[$post->post_title] = lcfirst($post->ID);
        }
      }
      break;

      case 'tags':
      case 'tag':

      if (isset($query_args['taxonomies']) && taxonomy_exists($query_args['taxonomies'])) {
        $tags = get_terms( $query_args['taxonomies'] );
          if ( !is_wp_error($tags) && !empty($tags) ) {
            foreach ( $tags as $tag ) {
              $options[$tag->name] = $tag->term_id;
          }
        }
      }
      break;
    }

    return $options;

  }
}

/**
 * Post Time Ago
 */
function bizex_ready_time_ago(){
  return human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) );
}

function bizex_category_pl(){
  $catgorys = get_the_category();
  foreach( $catgorys as $key => $category):
      ?>
      <a class="cat" href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
        <?php echo esc_html($category->cat_name); ?>
      </a>
  <?php endforeach;
}

function bizex_menu_selector() {
  $menus = wp_get_nav_menus();
  $items = array();
  $i     = 0;
  foreach ( $menus as $menu ) {
      if ( $i == 0 ) {
          $default = $menu->slug;
          $i ++;
      }
      $items[ $menu->slug ] = $menu->name;
  }
  return $items;
}


/**
 * Post Social Share
 *
 * @return void
 */
function bizex_post_share() {

  $permalink = get_permalink( get_the_ID() );
  $title     = get_the_title();
?>
<span><?php esc_html_e( 'Share:', 'bizex-tools' );?></span>
<ul>
  <li><a class="fb" onClick="window.open('http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>','Facebook','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://www.facebook.com/sharer.php?u=<?php echo esc_url( $permalink ); ?>"><?php esc_html_e( 'facebook', 'bizex-tools' );?></a></li>

  <li><a class="tw" onClick="window.open('http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Twitter share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><?php esc_html_e( 'twitter', 'bizex-tools' );?></a></li>

  <li><a class="ln" onClick="window.open('https://www.linkedin.com/cws/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo esc_attr( $title ); ?>','Linkedin share','width=600,height=300,left='+(screen.availWidth/2-300)+',top='+(screen.availHeight/2-150)+''); return false;" href="http://twitter.com/share?url=<?php echo esc_url( $permalink ); ?>&amp;text=<?php echo str_replace( " ", "%20", $title ); ?>"><?php esc_html_e( 'linkedin', 'bizex-tools' );?></a></li>

  <li><a class="pt" href='javascript:void((function()%7Bvar%20e=document.createElement(&apos;script&apos;);e.setAttribute(&apos;type&apos;,&apos;text/javascript&apos;);e.setAttribute(&apos;charset&apos;,&apos;UTF-8&apos;);e.setAttribute(&apos;src&apos;,&apos;http://assets.pinterest.com/js/pinmarklet.js?r=&apos;+Math.random()*99999999);document.body.appendChild(e)%7D)());'><?php esc_html_e( 'pinterest', 'bizex-tools' );?></a></li>
</ul>
<?php 
}

/**
 * Get Menu List
 *
 * @return void
 */
function bizex_get_nav_menu(){

  $menus = array(
      '' => esc_html__('Default', 'bizex')
  );

  $obj_menus = wp_get_nav_menus();

  foreach ($obj_menus as $obj_menu){
      $menus[$obj_menu->term_id] = $obj_menu->name;
  }

  return $menus;
}


/**
 * Add Contact Method User
 */
function bizex_user_social_link( $methode ) {
    $methode['facebook']  = esc_html__( 'Facebook', 'bizex-tools' );
    $methode['twitter']   = esc_html__( 'Twitter', 'bizex-tools' );
    $methode['linkedin']  = esc_html__( 'Linkedin', 'bizex-tools' );
    $methode['instagram'] = esc_html__( 'Instagram', 'bizex-tools' );
    $methode['pinterest'] = esc_html__( 'Pinterest', 'bizex-tools' );
    $methode['youtube']   = esc_html__( 'YouTube', 'bizex-tools' );
  return $methode;
}
add_filter('user_contactmethods', 'bizex_user_social_link');


/**
 * Authore
 */
function bizex_authore_info() {
  
  global $post;
  if(is_object($post)):

  $theme_author_markup = '';
  // Get author's display name
  $display_name = get_the_author_meta( 'display_name', $post->post_author );

  // If display name is not available then use nickname as display name
  if ( empty( $display_name ) )
  $display_name = get_the_author_meta( 'nickname', $post->post_author );

  // Get author's biographical information or description
  $user_description   = get_the_author_meta( 'user_description', $post->post_author );
  
  $user_facebook      = get_the_author_meta('facebook', $post->post_author);
  $user_twitter       = get_the_author_meta('twitter', $post->post_author);
  $user_linkedin      = get_the_author_meta('linkedin', $post->post_author);
  $user_instagram     = get_the_author_meta('instagram', $post->post_author);
  $user_pinterest     = get_the_author_meta('pinterest', $post->post_author);
  $user_youtube       = get_the_author_meta('youtube', $post->post_author);

  // Get link to the author archive page
  $user_posts = get_author_posts_url( get_the_author_meta( 'ID' , $post->post_author));
  if ( ! empty( $display_name ) )
  // Author avatar - - the number 90 is the px size of the image.
  $theme_author_markup .= '<div class="inner-img">' . get_avatar( get_the_author_meta('ID') , 160 ) . '</div>';
  $theme_author_markup .= '<div class="inner-text headline pera-content">';
  $theme_author_markup .= '<h4>' . $display_name . '</h4>';
  $theme_author_markup .= '<p>' . get_the_author_meta( 'description' ). '</p>';
  $theme_author_markup .= '<ul class="inner-social">';


// Check if author has Twitter in their profile

  if ( ! empty( $user_facebook ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_facebook .'" target="_blank" rel="nofollow" class="fb_aut" title="Facebook"><i class="fab fa-facebook-f"></i> </a></li>';
  }

    
  if ( ! empty( $user_twitter ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_twitter .'" target="_blank" rel="nofollow" class="twi_aut" title="Twitter"><i class="fab fa-twitter"></i> </a></li>';
  }

if ( ! empty( $user_instagram ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_instagram .'" target="_blank" rel="nofollow" class="inst_aut" title="Instagram"><i class="fab fa-instagram"></i> </a></li>';
  }

if ( ! empty( $user_pinterest ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_pinterest .'" target="_blank" rel="nofollow" class="pint_aut" title="Pinterest"><i class="fab fa-pinterest-p"></i> </a></li>';
  }

  if ( ! empty( $user_youtube ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_youtube .'" target="_blank" rel="nofollow" class="you_aut" title="Youtube"><i class="fab fa-youtube"></i> </a></li>';
  }

  if ( ! empty( $user_linkedin ) ) {
      $theme_author_markup .= ' <li><a href="' . $user_linkedin .'" target="_blank" rel="nofollow" class="link_aut" title="linkedin"><i class="fab fa-linkedin-in"></i> </a></li>';
  }

  $theme_author_markup .= '</ul>';
  $theme_author_markup .= '</div>';

  // Pass all this info to post content 
  echo '<div class="bz-blog-author d-flex align-items-center">' . $theme_author_markup . '</div>';
endif;
}


/**
 * Authore Avater
 */
function bizex_post_author_avatars($size) {
  echo get_avatar(get_the_author_meta('email'), $size);
}

add_action('genesis_entry_header', 'bizex_post_author_avatars');


// Override Elementor Section Advance Tab

add_action( 'elementor/element/after_section_end', function( $element, $section_id, $args ) {
  /** @var \Elementor\Element_Base $element */
  if ( 'section' === $element->get_name() && 'section_custom_css_pro' === $section_id ) {

      $element->start_controls_section(
          'sticky_section',
          [
              'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
              'label' => __( 'Cando Settings', 'cando' ),
          ]
      );

      $element->add_control(
          'header_sticky',
          [
              'label'        =>   __( 'Sticky Section', 'cando' ),
              'type'         => \Elementor\Controls_Manager::SWITCHER,
              'label_on'     =>   __( 'Yes', 'cando' ),
              'label_off'    =>   __( 'No', 'cando' ),
              'return_value' => 'cando-sticky-header',
              'default'      => '',
              'prefix_class' => '',
          ]
      );
      $element->add_group_control(
          \Elementor\Group_Control_Background::get_type(),
          [
              'name' => 'sticky_bg',
              'label' => __( 'Main BG', 'cando' ),
              'types' => [ 'classic', 'gradient' ],
              'show_label' => true,
              'condition' => [
                  'header_sticky' => 'cando-sticky-header'
              ],
              'selector' => '{{WRAPPER}}.cando-sticky-header.sticky-on',
          ]
      );
      $element->end_controls_section();
      $element->start_controls_section(
          '_section_position',
          [
              'label' => __( 'Positioning', 'cando' ),
              'tab' => \Elementor\Controls_Manager::TAB_ADVANCED,
          ]
      );

      $element->add_responsive_control(
          '_element_width',
          [
              'label' => __( 'Width', 'cando' ),
              'type' => \Elementor\Controls_Manager::SELECT,
              'default' => '',
              'options' => [
                  '' => __( 'Default', 'cando' ),
                  'inherit' => __( 'Full Width', 'cando' ) . ' (100%)',
                  'auto' => __( 'Inline', 'cando' ) . ' (auto)',
                  'initial' => __( 'Custom', 'cando' ),
              ],
              'selectors_dictionary' => [
                  'inherit' => '100%',
              ],
              'prefix_class' => 'elementor-widget%s__width-',
              'selectors' => [
                  '{{WRAPPER}}' => 'width: {{VALUE}}; max-width: {{VALUE}}',
              ],
          ]
      );

      $element->add_responsive_control(
          '_element_custom_width',
          [
              'label' => __( 'Custom Width', 'cando' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'max' => 1000,
                      'step' => 1,
                  ],
                  '%' => [
                      'max' => 100,
                      'step' => 1,
                  ],
              ],
              'condition' => [
                  '_element_width' => 'initial',
              ],
              'device_args' => [
                  \Elementor\Controls_Stack::RESPONSIVE_TABLET => [
                      'condition' => [
                          '_element_width_tablet' => [ 'initial' ],
                      ],
                  ],
                  \Elementor\Controls_Stack::RESPONSIVE_MOBILE => [
                      'condition' => [
                          '_element_width_mobile' => [ 'initial' ],
                      ],
                  ],
              ],
              'size_units' => [ 'px', '%', 'vw' ],
              'selectors' => [
                  '{{WRAPPER}}' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}}',
              ],
          ]
      );

      $element->add_responsive_control(
          '_element_vertical_align',
          [
              'label' => __( 'Vertical Align', 'cando' ),
              'type' => \Elementor\Controls_Manager::CHOOSE,
              'options' => [
                  'flex-start' => [
                      'title' => __( 'Start', 'cando' ),
                      'icon' => 'eicon-v-align-top',
                  ],
                  'center' => [
                      'title' => __( 'Center', 'cando' ),
                      'icon' => 'eicon-v-align-middle',
                  ],
                  'flex-end' => [
                      'title' => __( 'End', 'cando' ),
                      'icon' => 'eicon-v-align-bottom',
                  ],
              ],
              'condition' => [
                  '_element_width!' => '',
                  '_position' => '',
              ],
              'selectors' => [
                  '{{WRAPPER}}' => 'align-self: {{VALUE}}',
              ],
          ]
      );

      $element->add_control(
          '_position_description',
          [
              'raw' => '<strong>' . __( 'Please note!', 'cando' ) . '</strong> ' . __( 'Custom positioning is not considered best practice for responsive web design and should not be used too frequently.', 'cando' ),
              'type' => \Elementor\Controls_Manager::RAW_HTML,
              'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
              'render_type' => 'ui',
              'condition' => [
                  '_position!' => '',
              ],
          ]
      );

      $element->add_control(
          '_position',
          [
              'label' => __( 'Position', 'cando' ),
              'type' => \Elementor\Controls_Manager::SELECT,
              'default' => '',
              'options' => [
                  '' => __( 'Default', 'cando' ),
                  'absolute' => __( 'Absolute', 'cando' ),
                  'fixed' => __( 'Fixed', 'cando' ),
              ],
              'prefix_class' => 'elementor-',
              'frontend_available' => true,
          ]
      );

      $start = is_rtl() ? __( 'Right', 'cando' ) : __( 'Left', 'cando' );
      $end = ! is_rtl() ? __( 'Right', 'cando' ) : __( 'Left', 'cando' );

      $element->add_control(
          '_offset_orientation_h',
          [
              'label' => __( 'Horizontal Orientation', 'cando' ),
              'type' => \Elementor\Controls_Manager::CHOOSE,
              'toggle' => false,
              'default' => 'start',
              'options' => [
                  'start' => [
                      'title' => $start,
                      'icon' => 'eicon-h-align-left',
                  ],
                  'end' => [
                      'title' => $end,
                      'icon' => 'eicon-h-align-right',
                  ],
              ],
              'classes' => 'elementor-control-start-end',
              'render_type' => 'ui',
              'condition' => [
                  '_position!' => '',
              ],
          ]
      );

      $element->add_responsive_control(
          '_offset_x',
          [
              'label' => __( 'Offset', 'cando' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => -1000,
                      'max' => 1000,
                      'step' => 1,
                  ],
                  '%' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vw' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vh' => [
                      'min' => -200,
                      'max' => 200,
                  ],
              ],
              'default' => [
                  'size' => '0',
              ],
              'size_units' => [ 'px', '%', 'vw', 'vh' ],
              'selectors' => [
                  'body:not(.rtl) {{WRAPPER}}' => 'left: {{SIZE}}{{UNIT}}',
                  'body.rtl {{WRAPPER}}' => 'right: {{SIZE}}{{UNIT}}',
              ],
              'condition' => [
                  '_offset_orientation_h!' => 'end',
                  '_position!' => '',
              ],
          ]
      );

      $element->add_responsive_control(
          '_offset_x_end',
          [
              'label' => __( 'Offset', 'cando' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => -1000,
                      'max' => 1000,
                      'step' => 0.1,
                  ],
                  '%' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vw' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vh' => [
                      'min' => -200,
                      'max' => 200,
                  ],
              ],
              'default' => [
                  'size' => '0',
              ],
              'size_units' => [ 'px', '%', 'vw', 'vh' ],
              'selectors' => [
                  'body:not(.rtl) {{WRAPPER}}' => 'right: {{SIZE}}{{UNIT}}',
                  'body.rtl {{WRAPPER}}' => 'left: {{SIZE}}{{UNIT}}',
              ],
              'condition' => [
                  '_offset_orientation_h' => 'end',
                  '_position!' => '',
              ],
          ]
      );

      $element->add_control(
          '_offset_orientation_v',
          [
              'label' => __( 'Vertical Orientation', 'cando' ),
              'type' => \Elementor\Controls_Manager::CHOOSE,
              'toggle' => false,
              'default' => 'start',
              'options' => [
                  'start' => [
                      'title' => __( 'Top', 'cando' ),
                      'icon' => 'eicon-v-align-top',
                  ],
                  'end' => [
                      'title' => __( 'Bottom', 'cando' ),
                      'icon' => 'eicon-v-align-bottom',
                  ],
              ],
              'render_type' => 'ui',
              'condition' => [
                  '_position!' => '',
              ],
          ]
      );

      $element->add_responsive_control(
          '_offset_y',
          [
              'label' => __( 'Offset', 'cando' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => -1000,
                      'max' => 1000,
                      'step' => 1,
                  ],
                  '%' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vh' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vw' => [
                      'min' => -200,
                      'max' => 200,
                  ],
              ],
              'size_units' => [ 'px', '%', 'vh', 'vw' ],
              'default' => [
                  'size' => '0',
              ],
              'selectors' => [
                  '{{WRAPPER}}' => 'top: {{SIZE}}{{UNIT}}',
              ],
              'condition' => [
                  '_offset_orientation_v!' => 'end',
                  '_position!' => '',
              ],
          ]
      );

      $element->add_responsive_control(
          '_offset_y_end',
          [
              'label' => __( 'Offset', 'cando' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'range' => [
                  'px' => [
                      'min' => -1000,
                      'max' => 1000,
                      'step' => 1,
                  ],
                  '%' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vh' => [
                      'min' => -200,
                      'max' => 200,
                  ],
                  'vw' => [
                      'min' => -200,
                      'max' => 200,
                  ],
              ],
              'size_units' => [ 'px', '%', 'vh', 'vw' ],
              'default' => [
                  'size' => '0',
              ],
              'selectors' => [
                  '{{WRAPPER}}' => 'bottom: {{SIZE}}{{UNIT}}',
              ],
              'condition' => [
                  '_offset_orientation_v' => 'end',
                  '_position!' => '',
              ],
          ]
      );

      $element->end_controls_section();
  }
}, 10, 3 );

// Override Elementor Heading Elements

add_action( 'elementor/element/heading/section_title_style/before_section_start', function( $element, $args ) {
  /** @var \Elementor\Element_Base $element */
  $element->start_controls_section(
      'text_style',
      [
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'label' => __( 'Cando Settings', 'cando' ),
      ]
  );
  $element->add_control(
      'text_gra',
      [
          'label' => __( 'Text Gradient', 'cando' ),
          'type' => \Elementor\Controls_Manager::HEADING,
      ]
  );
  $element->add_control(
      'text_transparent',
      [
          'label'        =>   __( 'Transparent', 'cando' ),
          'type'         => \Elementor\Controls_Manager::SWITCHER,
          'label_on'     =>   __( 'Yes', 'cando' ),
          'label_off'    =>   __( 'No', 'cando' ),
          'return_value' => 'cando-text-gradient',
          'default'      => 'false',
          'prefix_class' => '',
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'text_gradient',
          'label' => __( 'Text Gradient', 'cando' ),
          'types' => [  'gradient' ],
          'show_label' => true,
          'separator' => 'after',
          'condition' => [
              'text_transparent' => 'cando-text-gradient'
          ],
          'selector' => '{{WRAPPER}}.cando-text-gradient .elementor-heading-title',
      ]
  );
  $element->add_control(
      'text_sr',
      [
          'label' => __( 'Text Stroke', 'cando' ),
          'type' => \Elementor\Controls_Manager::HEADING,
      ]
  );
  $element->add_control(
      'text_str',
      [
          'label'        =>   __( 'Turn On Stroke', 'cando' ),
          'type'         => \Elementor\Controls_Manager::SWITCHER,
          'label_on'     =>   __( 'Yes', 'cando' ),
          'label_off'    =>   __( 'No', 'cando' ),
          'return_value' => 'cando-text-stroke',
          'default'      => 'false',
          'prefix_class' => '',
      ]
  );
  $element->add_control(
      's_fill_color',
      [
          'label' => __( 'Fill Color', 'cando' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
              'text_str' => 'cando-text-stroke'
          ],
          'selectors' => [
              '{{WRAPPER}}.cando-text-stroke .elementor-heading-title' => '-webkit-text-fill-color: {{VALUE}}',
          ],
      ]
  );
  $element->add_responsive_control(
      's_width',
      [
          'label' => __( 'Stroke Width', 'appilo' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px'],
          'range' => [
              'px' => [
                  'min' => .5,
                  'max' => 100,
                  'step' => .5,
              ],
          ],
          'selectors' => [
              '{{WRAPPER}}.cando-text-stroke .elementor-heading-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
          ],
          'condition' => [
              'text_str' => 'cando-text-stroke'
          ],
      ]
  );
  $element->add_control(
      's_text_color',
      [
          'label' => __( 'Stroke Color', 'cando' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
              'text_str' => 'cando-text-stroke'
          ],
          'selectors' => [
              '{{WRAPPER}}.cando-text-stroke .elementor-heading-title' => '-webkit-text-stroke-color: {{VALUE}}',
          ],
      ]
  );
  $element->end_controls_section();
}, 10, 2 );

// Override Elementor Counter Elements

add_action( 'elementor/element/counter/section_number/before_section_start', function( $element, $args ) {
  /** @var \Elementor\Element_Base $element */
  $element->start_controls_section(
      'counter_style',
      [
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'label' => __( 'Suffix Style', 'cando' ),
      ]
  );
  $element->add_control(
      'suffix_clr',
      [
          'label' => __( 'Text Color', 'cando' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
              '{{WRAPPER}} .elementor-counter-number-suffix' => 'color: {{VALUE}}',
          ],
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
          'name' => 'suffix_typography',
          'label' => __( 'Typography', 'cando' ),
          'selector' => '{{WRAPPER}} .elementor-counter-number-suffix',
      ]
  );
  $element->end_controls_section();
}, 10, 2 );

// Override Elementor Icon Elements

add_action( 'elementor/element/button/section_style/before_section_start', function( $element, $args ) {
  /** @var \Elementor\Element_Base $element */
  $element->start_controls_section(
      'aatext_style',
      [
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'label' => __( 'Cnado Settings', 'appilo' ),
      ]
  );

  $element->start_controls_tabs( 'button_style' );
  $element->start_controls_tab(
      'button_normal',
      [
          'label' => __( 'Normal', 'appilo' ),
      ]
  );
  $element->add_control(
      'atext_gra',
      [
          'label' => __( 'Button Background', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btn_bg',
          'label' => __( 'Button Background', 'appilo' ),
          'types' => [  'gradient' ],
          'show_label' => true,
          'separator' => 'after',
          'selector' => '{{WRAPPER}} .elementor-button',
      ]
  );
  $element->end_controls_tab();

  $element->start_controls_tab(
      'button_hover',
      [
          'label' => __( 'Hover', 'appilo' ),
      ]
  );

  $element->add_control(
      'afatext_gra',
      [
          'label' => __( 'Hover Background', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btnh_bg',
          'label' => __( 'Button Background', 'appilo' ),
          'types' => [  'gradient' ],
          'show_label' => true,
          'separator' => 'after',
          'selector' => '{{WRAPPER}} .elementor-button:hover, {{WRAPPER}} .elementor-button:focus',
      ]
  );
  $element->end_controls_tab();

  $element->end_controls_tabs();

  $element->end_controls_section();
}, 10, 2 );

// Override Elementor Icon Elements

add_action( 'elementor/element/icon/section_style_icon/before_section_start', function( $element, $args ) {
  /** @var \Elementor\Element_Base $element */
  $element->start_controls_section(
      'aatext_style',
      [
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'label' => __( 'Cando Settings', 'appilo' ),
      ]
  );
  $element->add_control(
      'icon_light_box',
      [
          'label'        =>   __( 'Turn On LightBox', 'cando' ),
          'type'         => \Elementor\Controls_Manager::SWITCHER,
          'label_on'     =>   __( 'Yes', 'cando' ),
          'label_off'    =>   __( 'No', 'cando' ),
          'return_value' => 'cando-icon-lightbox',
          'default'      => 'false',
          'prefix_class' => '',
      ]
  );
  $element->add_control(
      'icon_gradient',
      [
          'label'        =>   __( 'Turn On Gradient', 'cando' ),
          'type'         => \Elementor\Controls_Manager::SWITCHER,
          'label_on'     =>   __( 'Yes', 'cando' ),
          'label_off'    =>   __( 'No', 'cando' ),
          'return_value' => 'cando-icon-gradient',
          'default'      => 'false',
          'prefix_class' => '',
      ]
  );
  $element->start_controls_tabs( 'button_style' );

  $element->start_controls_tab(
      'button_normal',
      [
          'label' => __( 'Normal', 'appilo' ),
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_control(
      'atext_grai',
      [
          'label' => __( 'Color', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btn_bgi',
          'label' => __( 'Icon Color', 'appilo' ),
          'types' => [  'gradient' ],
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
          'show_label' => true,
          'separator' => 'after',
          'selector' => '{{WRAPPER}}.cando-icon-gradient .elementor-icon i',
      ]
  );
  $element->add_control(
      'atext_gra',
      [
          'label' => __( 'Background', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btn_bg',
          'label' => __( 'Background', 'appilo' ),
          'types' => [  'gradient' ],
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
          'show_label' => true,
          'separator' => 'after',
          'selector' => '{{WRAPPER}}.cando-icon-gradient .elementor-icon',
      ]
  );
  $element->end_controls_tab();

  $element->start_controls_tab(
      'button_hover',
      [
          'label' => __( 'Hover', 'appilo' ),
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_control(
      'atext_graih',
      [
          'label' => __( 'Color', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btn_bgih',
          'label' => __( 'Icon Color', 'appilo' ),
          'types' => [  'gradient' ],
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
          'show_label' => true,
          'separator' => 'after',
          'selector' => '{{WRAPPER}}.cando-icon-gradient .elementor-icon:hover i',
      ]
  );
  $element->add_control(
      'afatext_gra',
      [
          'label' => __( 'Background', 'appilo' ),
          'type' => \Elementor\Controls_Manager::HEADING,
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
      ]
  );
  $element->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
          'name' => 'btnh_bg',
          'label' => __( 'Button Background', 'appilo' ),
          'types' => [  'gradient' ],
          'show_label' => true,
          'condition' => [
              'icon_gradient' => 'cando-icon-gradient'
          ],
          'separator' => 'after',
          'selector' => '{{WRAPPER}}.cando-icon-gradient .elementor-icon:hover',
      ]
  );
  $element->end_controls_tab();

  $element->end_controls_tabs();

  $element->end_controls_section();
}, 10, 2 );

function get_service_meta($opt)
    {
        $options = get_post_meta(get_the_ID(), '_candopm', 'true');
        if (isset($options[$opt])) {
            return $options[$opt];
        }
    }