<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Why_Choose_Us extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-why-choose-us-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Why Choose Us', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'info_icon', [
				'label' => esc_html__( 'Info Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'infoboxs',
			[
				'label' => esc_html__( 'Add Info Box Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Subtitle-Typography',
                'label' => 'Subtitle Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title h2',
            ]
        );
        /*Big-Title*/
        $this->add_control(
            '--Big-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Big Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Big-Title-Color',
            [
                'label' => esc_html__( 'Big Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-top-content .title-bg' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Big-Title-Typography',
                'label' => 'Big Title Typography',
                'selector' => '{{WRAPPER}} .bzx-section-top-content .title-bg',
            ]
        );

        /*Info-Box*/
        $this->add_control(
            '--Info-Box-Style-Heading--',
            [
                'label' => esc_html__( 'Info Box Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Number-Color',
            [
                'label' => esc_html__( 'Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-wc-steps-item .step-serial' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Number-Typography',
                'label' => 'Number Typography',
                'selector' => '{{WRAPPER}} .bzx-wc-steps-item .step-serial',
            ]
        );
        $this->add_control(
            'Info-Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-wc-steps-item .step-text-wrap h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Info-Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bzx-wc-steps-item .step-text-wrap h3',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-wc-steps-item .step-text-wrap p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bzx-wc-steps-item .step-text-wrap p',
            ]
        );
        $this->add_control(
            'Box-Bottom-Border-Color',
            [
                'label' => esc_html__( 'Box Bottom Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-wc-steps-item' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-why-choose-us" class="bzx-why-choose-us-section position-relative">
		<div class="container">
			<div class="bzx-section-top-content position-relative d-flex justify-content-between align-items-center">
                <?php if(!empty($settings['big_title'])):?>
				    <span class="title-bg position-absolute" data-parallax='{"x" : -100}'><?php echo wp_kses($settings['big_title'], true)?>    </span>
                <?php endif;?>
				<div class="bzx-section-title bzx-headline pera-content position-relative">
                    <?php if(!empty($settings['sub_title'])):?>
                        <div class="subtitle text-uppercase">
                            <?php echo wp_kses($settings['sub_title'], true)?>
                        </div> 
                    <?php endif;?>
					<?php if(!empty($settings['title'])):?>
					    <h2 data-splitting><?php echo wp_kses($settings['title'], true)?></h2>
                    <?php endif;?>
				</div>
			</div>
		</div>
		<div class="bzx-why-choose-us-content">
			<div class="bzx-why-choose-us-wrap d-flex">
                <?php if(!empty($settings['image']['url'])):?>
                    <div class="bzx-why-choose-us-img wow slideInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <img src="<?php echo esc_url($settings['image']['url']);?>" alt="">
                    </div>
                <?php endif;?>
				<div class="bzx-why-choose-us-steps-wrap">
					<div class="bzx-why-choose-us-steps d-flex">
						<?php foreach($settings['infoboxs'] as $item):?>
						<div class="bzx-wc-steps-item position-relative wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1500ms">
                            <?php if(!empty($item['info_icon']['url'])):?>
                                <div class="step-icon position-absolute">
                                    <img src="<?php echo esc_url($item['info_icon']['url']);?>" alt="">
                                </div>
                            <?php endif;?>
                            <?php if(!empty($item['count'])):?>
                                <div class="step-serial">
                                    <?php echo esc_html($item['count']);?>
                                </div>
                            <?php endif;?>
							<div class="step-text-wrap bzx-headline pera-content">
								<h3><?php echo esc_html($item['title']);?></h3>
								<p><?php echo wp_kses($item['description'], true);?></p>
							</div>
						</div>
                        <?php endforeach;?>
					</div>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Why_Choose_Us() );