<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'authore_1', [
				'label' => esc_html__( 'Authore 1', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'authore_2', [
				'label' => esc_html__( 'Authore 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Authore', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 1,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Authore Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Authore Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
        
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '--Feedback-Heading--',
            [
                'label' => esc_html__( 'Feedback Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Feedback-Color',
            [
                'label' => esc_html__( 'Feedback Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-item .bz-testimonial-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Feedback-Typography',
                'label' => 'Feedback Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-item .bz-testimonial-text',
            ]
        );

        $this->add_control(
            '--Author-Heading--',
            [
                'label' => esc_html__( 'Author Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Author-Color',
            [
                'label' => esc_html__( 'Author Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-nav-item.slick-current.slick-active.slick-center h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Author-Typography',
                'label' => 'Author Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-nav-item.slick-current.slick-active.slick-center h3',
            ]
        );


        $this->add_control(
            '--Designation-Heading--',
            [
                'label' => esc_html__( 'Designation Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__( 'Designation Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-nav-item.slick-current.slick-active.slick-center span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-nav-item.slick-current.slick-active.slick-center span',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-BG-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-testimonial-nav-item.slick-current.slick-active.slick-center',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="bz-testimonial-content position-relative">
        <?php if(!empty($authore_1['url'])):?>
            <span class="bz-testimonial-shape position-absolute"><img src="<?php echo esc_url($authore_1['url']);?>" alt=""></span>
        <?php endif;?>
        <?php if(!empty($authore_2['url'])):?>
            <span class="bz-testimonial-shape2 position-absolute"><img src="<?php echo esc_url($authore_2['url']);?>" alt=""></span>
        <?php endif;?>
        <span class="bz-quote-icon position-absolute"><i class="fas fa-quote-right"></i></span>
        <div class="bz-testimonial-slider-for">
            <?php foreach($testimonials as $item):?>
            <div class="bz-testimonial-item-area">
                <div class="bz-testimonial-item text-center position-relative">
                    <div class="bz-testimonial-img position-absolute">
                        <img src="<?php echo esc_url($item['authore']['url']);?>" alt="">
                    </div>
                    <div class="bz-testimonial-rate ul-li">
                        <ul>
                            <?php for($i = 0; $i < $item['rating']; $i++):?>
                                <li><i class="fas fa-star"></i></li>
                            <?php endfor;?>
                        </ul>
                    </div>
                    <div class="bz-testimonial-text">
                        <?php echo wp_kses( $item['feedback'], true );?>
                    </div>
                </div>
            </div>
            <?php endforeach;?>
        </div>
        <div class="bz-testimonial-slider-nav">
            <?php foreach($testimonials as $item):?>
            <div class="bz-testimonial-nav-item text-center headline">
                <h3><?php echo wp_kses( $item['name'], true );?></h3>
                <span><?php echo wp_kses( $item['designation'], true );?></span>
            </div>
            <?php endforeach;?>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial() );