<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial_v2 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-v2-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Authore', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 1,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Authore Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Authore Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
        $this->add_control(
			'big-text', [
				'label' => esc_html__( 'Big Text', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Quote-Color',
            [
                'label' => esc_html__( 'Quote Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Comment-Color',
            [
                'label' => esc_html__( 'Comment Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Comment-Typography',
                'label' => 'Comment Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-text',
            ]
        );
        $this->add_control(
            'Name-Color',
            [
                'label' => esc_html__( 'Name Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Name-Typography',
                'label' => 'Name Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-text',
            ]
        );
        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__( 'Designation Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-author .bz-author-name-degi span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bz-testimonial-items-2 .bz-testimonial-author .bz-author-name-degi span',
            ]
        );

        /*Big-Text*/
        $this->add_control(
            '--Big-Text-Heading--',
            [
                'label' => esc_html__( 'Big Text Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Big-Text-Color',
            [
                'label' => esc_html__( 'Big Text Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-bottom-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Big-Text-Typography',
                'label' => 'Big Text Typography',
                'selector' => '{{WRAPPER}} .bz-bottom-title',
            ]
        );
        $this->add_control(
            'Big-Text-Special-Color',
            [
                'label' => esc_html__( 'Big Text Special Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-testimonial-section-2 .bz-bottom-title span' => 'color: {{VALUE}}',
                ],
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div id="bz-testimonial-2" class="bz-testimonial-section-2 position-relative">
        <?php if(!empty($shape['url'])):?>
        <span class="bz-testimonial-shape position-absolute"><img src="<?php echo esc_url($shape['url']);?>" alt=""></span>
        <?php endif;?>
        <div class="bz-testimonial-slider-area-2 position-relative">
            <div class="container">
                <div class="bz-testimonial-slider-2">
                    <?php foreach($testimonials as $item):?>
                    <div class="bz-slider-item">
                        <div class="bz-testimonial-items-2 text-center position-relative">
                            <div class="bz-testimonial-icon">
                                <i class="fas fa-quote-right"></i>
                            </div>
                            <div class="bz-testimonial-text">
                                <?php echo wp_kses( $item['feedback'], true );?>
                            </div>
                            <div class="bz-testimonial-rate ul-li">
                                <ul>
                                    <?php for($i = 0; $i < $item['rating']; $i++):?>
                                        <li><i class="fas fa-star"></i></li>
                                    <?php endfor;?>
                                </ul>
                            </div>
                            <div class="bz-testimonial-author">
                                <div class="bz-author-img">
                                    <img src="<?php echo esc_url($item['authore']['url']);?>" alt="">
                                </div>
                                <div class="bz-author-name-degi headline">
                                    <h3><?php echo wp_kses( $item['name'], true );?></h3>
                                    <span><?php echo wp_kses( $item['designation'], true );?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
                <div class="carousel_nav">
                    <button type="button" class="testi-left_arrow"><i class="far fa-arrow-left"></i></button>
                    <button type="button" class="testi-right_arrow"><i class="far fa-arrow-right"></i></button>
                </div>
            </div>
        </div>
        <?php if(!empty($settings['big-text'])):?>
            <div class="bz-bottom-title position-absolute text-uppercase"><?php echo wp_kses( $settings['big-text'], true );?></div>
        <?php endif;?>
        <?php if(!empty($settings['btn_label'])):?>
        <div class="bz-testimonial-btn position-absolute">
            <div class="bz-btn-2 text-uppercase">
                <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?> <i class="fas fa-long-arrow-right"></i></a>
            </div>
        </div>
        <?php endif;?>
    </div>    
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial_v2() );