<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial_v6 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-testimonial2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Five', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'member_name',
            [
                'label' => __( 'Name', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Shantel Nugent', 'cando' ),
            ]
        );
        $repeater->add_control(
            'member_designation',
            [
                'label' => __( 'Designation', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Business Man', 'cando' ),
            ]
        );
        $repeater->add_control(
            'member_info',
            [
                'label' => __( 'Comment', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( '<span>"</span> There are many variations of passages of
													Lorem Ipsum available but the majority have
													suffered alteration in some form, by injected
													humour, or randomised words which don\'t
												look even slightly believable.', 'cando' ),
            ]
        );
        $repeater->add_control(
            'team_url',
            [
                'label' => __( 'Link', 'cando' ),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $repeater->add_control(
            'member_photo', [
                'label' => __( 'Photo', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'member_list',
            [
                'label' => __( 'Client List', 'cando' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],

                ],
                'title_field' => '{{{ member_name }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'shape1', [
                'label' => __( 'Shape 1', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape2', [
                'label' => __( 'Shape 2', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape3', [
                'label' => __( 'Shape 3', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial_content .testimonial_text .testimonial_meta h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_fonts',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial_content .testimonial_text .testimonial_meta h4',
            ]
        );
        $this->add_control(
            'des_color',
            [
                'label' => __( 'Designation Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial_content .testimonial_text .testimonial_meta span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'des_fonts',
                'label' => __( 'Designation Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial_content .testimonial_text .testimonial_meta span',
            ]
        );
        $this->add_control(
            'inf_color',
            [
                'label' => __( 'Info Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial_content .testimonial_text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'inf_fonts',
                'label' => __( 'Info Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial_content .testimonial_text p',
            ]
        );
        $this->add_control(
            'social_bg',
            [
                'label' => __( 'Box BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_socials_bg',
                'label' => __( 'Team Social BG', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .testimonial_content',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
        $settings = $this->get_settings_for_display();
        echo '<!-- Start of testimonil section
        ============================================= -->
        <section id="can-testiomial-2" class="can-testiomial-section-2">
                <div class="can-testiomial-slider">
                    <div id="testimonial_slide" class="carousel slide" data-ride="carousel" >
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="testimonial_indicator relative-position">
                                    <ol class="carousel-indicators">';
                                $loop = 0;
                                $i = -1;
                                if ( $settings['member_list'] ) {
                                    foreach ($settings['member_list'] as $members) {
                                        $loop++;
                                        $i++;
                                        if ($loop == 1){
                                            $class = 'active';
                                        } else {
                                            $class = '';
                                        }
                                    echo'<li data-target="#testimonial_slide" data-slide-to="'.$i.'" class="'.$class.'">
                                            '.get_that_image( $members['member_photo'] ).'
                                        </li>';
                                        }
                                    }
                                echo'</ol>
                                </div>
                                <a class="carousel-control-prev" href="#testimonial_slide" role="button" data-slide="prev"></a>
                                <a class="carousel-control-next" href="#testimonial_slide" role="button" data-slide="next"></a>
                                <!-- /carosel arrow -->
                            </div>
                            <div class="col-lg-8">
                                <div class="carousel_preview position-relative">
                                    <span class="carousel-bg-item-1 position-absolute">'.get_that_image( $settings['shape2'] ).'</span>
                                    <span class="carousel-bg-item-2 position-absolute">'.get_that_image( $settings['shape3'] ).'</span>
                                    <div class="carousel-inner">';
                                            $loop2 = 0;
                                if ( $settings['member_list'] ) {
                                    foreach ($settings['member_list'] as $members) {
                                        $loop2++;
                                        if ($loop2 == 1){
                                            $class2 = 'active';
                                        } else {
                                            $class2 = '';
                                        }
                                    echo'<div class="carousel-item '.$class2.'">
                                            <div class="testimonial_content position-relative">
                                                <div class="testimonial_img position-relative float-left">
                                                    <div class="testimonial_img_wrap">
                                                        '.get_that_image( $members['member_photo'] ).'
                                                    </div>
                                                    <div class="qt-icon">
                                                        '.get_that_image( $settings['shape1'] ).'
                                                    </div>
                                                </div>
                                                <div class="testimonial_text relative-position pera-content">
                                                    <p>'.$members['member_info'].'</p>
                                                    <div class="testimonial_meta headline">
                                                        <h4><a '.get_that_link($members['team_url']).'>'.$members['member_name'].'</a></h4>
                                                        <span>'.$members['member_designation'].'</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>';
                                    }
                                }
                            echo'</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>		
    <!-- End of testimonil section
        ============================================= -->';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial_v6() );