<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial_v5 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-testimonial1';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Five', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'member_name',
            [
                'label' => __( 'Name', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Patrick Reed', 'cando' ),
            ]
        );
        $repeater->add_control(
            'member_designation',
            [
                'label' => __( 'Designation', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'UI/UX Desinger.', 'cando' ),
            ]
        );
        $repeater->add_control(
            'member_info',
            [
                'label' => __( 'Comment', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum is simply dummy text of the printing and
                                typesetting industry. Lorem Ipsum has been industrys
                                standard dummy text ever since 1500s, when unknown
                                printer took a galley of type and scrambled it to make
                                specimen book electronic typesetting.', 'cando' ),
            ]
        );
        $repeater->add_control(
            'team_url',
            [
                'label' => __( 'Link', 'cando' ),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $repeater->add_control(
            'member_photo', [
                'label' => __( 'Photo', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'feedback',
            [
                'label' => __( 'Feedback', 'niobis' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
            ]
        );
        $this->add_control(
            'member_list',
            [
                'label' => __( 'Client List', 'cando' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Patrick Reed', 'cando' ),
                    ],

                ],
                'title_field' => '{{{ member_name }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-img-text .testimonial-author-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_fonts',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial-img-text .testimonial-author-text h3',
            ]
        );
        $this->add_control(
            'des_color',
            [
                'label' => __( 'Designation Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-img-text .testimonial-author-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'des_fonts',
                'label' => __( 'Designation Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial-img-text .testimonial-author-text span',
            ]
        );
        $this->add_control(
            'inf_color',
            [
                'label' => __( 'Info Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-img-text .testimonial-quote-rate p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'inf_fonts',
                'label' => __( 'Info Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .testimonial-img-text .testimonial-quote-rate p',
            ]
        );
        $this->add_control(
            'social_bg',
            [
                'label' => __( 'Box BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_socials_bg',
                'label' => __( 'Team Social BG', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .testimonial-img-text',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
	    $settings = $this->get_settings_for_display();
    echo '<!-- Start of testimonial section
	============================================= -->
	<section id="can-testimonial" class="can-testimonial-section">
			<div class="can-testimonial-content-1">
                <div class="testimonial-slider-wrap">';
        if ( $settings['member_list'] ) {
            foreach ($settings['member_list'] as $members) {
            echo'<div class="testimonial-img-text">
                            <div class="testimonial-img-author clearfix">
                                <div class="testimonial-img position-relative float-left">
                                    '.get_that_image( $members['member_photo'] ).'
                                    <span class="quote-sign">"</span>
                                </div>
                                <div class="testimonial-author-text position-relative headline">
                                    <h3><a '.get_that_link($members['team_url']).'>'.$members['member_name'].'</a></h3>
                                    <span>'.$members['member_designation'].'</span>
                                </div>
                            </div>
                            <div class="testimonial-quote-rate pera-content ul-li">
                                <p>'.$members['member_info'].'</p>
                                <ul>
                                   '.client_ratings($members['feedback']['size']).'
                                </ul>
                            </div>
                        </div>';
                    }
                }
            echo'</div>
		</div>
	</section>
<!-- End of testimonial section
	============================================= -->';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial_v5() );