<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial_v4 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-v4-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Four', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Authore', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Authore Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Authore Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
       
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Quote-Icon-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-testimonial-item .testimonial-icon i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Quote Icon Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        $this->add_control(
            'Comment-Color',
            [
                'label' => esc_html__( 'Comment Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-testimonial-item .testimonial-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Comment-Typography',
                'label' => 'Comment Typography',
                'selector' => '{{WRAPPER}} .bizx-testimonial-item .testimonial-text',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Name-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-testimonial-item .testimonial-author .author-text h3',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Name Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Name-Typography',
                'label' => 'Name Typography',
                'selector' => '{{WRAPPER}} .bizx-testimonial-item .testimonial-author .author-text h3',
            ]
        );

        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__( 'Designation Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-testimonial-item .testimonial-author .author-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bizx-testimonial-item .testimonial-author .author-text span',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Slide-Nav-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-testimonial-slider .slick-dots li:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Slide Nav Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
        <div class="bizx-testimonial-slider-area">
            <div class="bizx-testimonial-slider">
                <?php foreach($settings['testimonials'] as $item):?>
                <div class="bizx-testimonial-item">
                    <div class="testimonial-icon">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <div class="testimonial-text">
                        <?php echo wp_kses($item['feedback'], true);?>
                    </div>
                    <div class="testimonial-author d-flex align-items-center">
                        <div class="author-img">
                            <img src="<?php echo esc_url($item['authore']['url']);?>" alt="">
                        </div>
                        <div class="author-text headline">
                            <h3><?php echo esc_html($item['name']);?></h3>
                            <span><?php echo esc_html($item['designation']);?></span>
                        </div>
                    </div>
                </div>
                <?php endforeach;?>
            </div>
        </div>
    </div> 
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial_v4() );