<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Testimonial_v3 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-testimonial-v3-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Three', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'authore_quote', [
				'label' => esc_html__( 'Authore Quote', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'authore', [
				'label' => esc_html__( 'Authore', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'feedback', [
				'label' => esc_html__( 'Feedback', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'name', [
				'label' => esc_html__( 'Authore Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Authore Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label' => esc_html__( 'Add Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => esc_html__( 'Sub Title Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__( 'Title Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-section-title h2',
			]
		);

        /*Big-Title*/
        $this->add_control(
            '--Big-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Big Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Big-Title-Color',
            [
                'label' => esc_html__( 'Big Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-top-content .title-bg' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Big_text_typography',
                'label' => esc_html__( 'Big Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-section-top-content .title-bg',
			]
		);

        /*Testimonial*/
        $this->add_control(
            '--Testimonial-Style-Heading--',
            [
                'label' => esc_html__( 'Testimonial Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Testimonial-Title-Color',
            [
                'label' => esc_html__( 'Testimonial Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-testimonial-item .testi-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'fdb_typography',
                'label' => esc_html__( 'Testimonial Feedback Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-testimonial-item .testi-text',
			]
		);
        $this->add_control(
            'Author-Color',
            [
                'label' => esc_html__( 'Author Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-testimonial-item .testi-author .author-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'auth_typography',
                'label' => esc_html__( 'Author Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-testimonial-item .testi-author .author-text h3',
			]
		);
        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__( 'Designation Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-testimonial-item .testi-author .author-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desig_typography',
                'label' => esc_html__( 'Designation Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-testimonial-item .testi-author .author-text span',
			]
		);
        $this->add_control(
            'Border-Border-Color',
            [
                'label' => esc_html__( 'Border Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-testimonial-item' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-testimonial" class="bzx-testimonial-section">
		<div class="container">
			<div class="bzx-section-top-content position-relative d-flex justify-content-between align-items-center">
                <?php if(!empty($settings['big_title'])):?>
				    <span class="title-bg position-absolute" data-parallax='{"x" : -100}'><?php echo wp_kses($settings['big_title'], true)?>    </span>
                <?php endif;?>
				<div class="bzx-section-title bzx-headline pera-content position-relative">
                    <?php if(!empty($settings['sub_title'])):?>
					<div class="subtitle text-uppercase">
                        <?php echo wp_kses($settings['sub_title'], true)?>
					</div> 
                    <?php endif;?>

                    <?php if(!empty($settings['title'])):?>
					    <h2 data-splitting><?php echo wp_kses($settings['title'], true)?></h2>
                    <?php endif;?>

				</div>
				<div class="bzx-project-carousel bzx-carousel-btn text-uppercase">
					<div class="carousel_nav text-center position-relative">
						<button type="button" class="bzx_testi_left_arrow text-uppercase"><i class="far fa-long-arrow-left"></i></button>
						<button type="button" class="bzx_testi_right_arrow text-uppercase"><i class="far fa-long-arrow-right"></i></button>
					</div>
				</div>
			</div>
			<div class="bzx-testimonial-content">
				<div class="bzx-testimonial-slider">
					<?php foreach($settings['testimonials'] as $item):?>
					<div class="bzx-slider-item">
						<div class="bzx-testimonial-item">
                            <?php if(!empty($item['authore_quote']['url'])):?>
							<div class="testi-icon">
								<img src="<?php echo esc_url($item['authore_quote']['url']);?>" alt="">
							</div>
                            <?php endif;?>
							<div class="testi-text">
								<?php echo wp_kses($item['feedback'], true);?>
							</div>
							<div class="testi-author d-flex align-items-center bzx-headline pera-content">
                                <?php if(!empty($item['authore']['url'])):?>
								<div class="author-img">
									<img src="<?php echo esc_url($item['authore']['url']);?>" alt="">
								</div>
                                <?php endif;?>
								<div class="author-text">
									<h3><?php echo esc_html($item['name']);?></h3>
									<span><?php echo esc_html($item['designation']);?></span>
								</div>
							</div>
						</div>
					</div>
                    <?php endforeach;?>
				</div>
			</div>
		</div>
	</section>  
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Testimonial_v3() );