<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Team extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-team--id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Team Carousel Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
        $this->add_control(
			'member_img', [
				'label' => esc_html__( 'Member Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
        $this->add_control(
			'member_name', [
				'label' => esc_html__( 'Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
        $this->add_control(
			'single_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		
        $repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'social_1', [
				'label' => esc_html__( 'Social Icon', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_1_link', [
				'label' => esc_html__( 'Social Icon Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'social_icons',
			[
				'label' => esc_html__( 'Add Social Icon', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __('Section Style', 'appilo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Name-Color',
            [
                'label' => esc_html__('Name Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Name-Typography',
                'label' => 'Name Typography',
                'selector' => '{{WRAPPER}} .bz-team-items .bz-team-text h3',
            ]
        );
        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__('Designation Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-text .bz-team-degi' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bz-team-items .bz-team-text .bz-team-degi',
            ]
        );

        $this->add_control(
            'Icon-Color',
            [
                'label' => esc_html__('Icon Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-social li' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        if ( ! empty( $settings['single_link']['url'] ) ) {
            $this->add_link_attributes( 'single_link', $settings['single_link'] );
        }    
    ?>
    <div class="bz-team-items bz__item-tw">
        <div class="bz-team-img position-relative">
            <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'member_img' );?>
            <div class="bz-team-social position-absolute ul-li">
                <ul>
                <?php foreach($settings['social_icons'] as $item):?>
                        <li><a href="<?php echo esc_url($item['social_1_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_1'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                    <?php endforeach;?>
                </ul>
            </div>
        </div>
        <div class="bz-team-text text-center headline  position-relative">
            <h3><a <?php echo $this->get_render_attribute_string( 'single_link' ); ?>><?php echo esc_html($settings['member_name']);?></a></h3>
            <span class="bz-team-degi text-uppercase"><?php echo esc_html($settings['designation']);?></span>
            <?php if(!empty($settings['arrow_icon']['url'])):?>
            <a class="team_arrow position-absolute" <?php echo $this->get_render_attribute_string( 'single_link' ); ?>><img src="<?php echo esc_url($settings['arrow_icon']['url']);?>" alt=""></a>
            <?php endif;?>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Team() );